/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.UTF16;

public class UnknownCharacterSet
implements CharacterSet {
    public static HashMap map;
    private CharsetEncoder encoder;
    private byte[] charinfo = new byte[65536];
    private StringBuffer supplementary = new StringBuffer(2);
    private static final byte GOOD = 1;
    private static final byte BAD = 2;

    private UnknownCharacterSet(Charset charset) {
        this.encoder = charset.newEncoder();
    }

    public static synchronized UnknownCharacterSet makeCharSet(Charset charset) {
        UnknownCharacterSet c2;
        if (map == null) {
            map = new HashMap(10);
        }
        if ((c2 = (UnknownCharacterSet)map.get(charset)) == null) {
            c2 = new UnknownCharacterSet(charset);
            map.put(charset, c2);
        }
        return c2;
    }

    public final boolean inCharset(int c2) {
        if (c2 <= 127) {
            return true;
        }
        if (c2 <= 65535) {
            if (this.charinfo[c2] == 1) {
                return true;
            }
            if (this.charinfo[c2] == 2) {
                return false;
            }
            if (this.encoder.canEncode((char)c2)) {
                this.charinfo[c2] = 1;
                return true;
            }
            this.charinfo[c2] = 2;
            return false;
        }
        this.supplementary.setCharAt(0, UTF16.highSurrogate(c2));
        this.supplementary.setCharAt(1, UTF16.lowSurrogate(c2));
        return this.encoder.canEncode(this.supplementary);
    }
}

