/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.UTF16;

public class BuggyCharacterSet
implements CharacterSet {
    private static HashMap map;
    private CharsetEncoder encoder;
    private byte[] charinfo = new byte[65536];
    private static final byte GOOD = 1;
    private static final byte BAD = 2;

    private BuggyCharacterSet(Charset charset) {
        this.encoder = charset.newEncoder();
    }

    public static synchronized BuggyCharacterSet makeCharSet(Charset charset) {
        BuggyCharacterSet c2;
        if (map == null) {
            map = new HashMap(10);
        }
        if ((c2 = (BuggyCharacterSet)map.get(charset)) == null) {
            c2 = new BuggyCharacterSet(charset);
            map.put(charset, c2);
        }
        return c2;
    }

    public final boolean inCharset(int c2) {
        if (c2 <= 127) {
            return true;
        }
        try {
            if (c2 <= 65535) {
                if (this.charinfo[c2] == 1) {
                    return true;
                }
                if (this.charinfo[c2] == 2) {
                    return false;
                }
                this.charinfo[c2] = 2;
                char[] cc = new char[]{(char)c2};
                this.encoder.encode(CharBuffer.wrap(cc));
                this.charinfo[c2] = 1;
                return true;
            }
            char[] ss = new char[]{UTF16.highSurrogate(c2), UTF16.lowSurrogate(c2)};
            this.encoder.encode(CharBuffer.wrap(ss));
            return true;
        }
        catch (CharacterCodingException ex) {
            return false;
        }
    }
}

