/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StandardErrorHandler
implements ErrorHandler {
    private ErrorListener errorListener;
    private Writer errorOutput;
    private int errorCount = 0;

    public StandardErrorHandler(ErrorListener listener) {
        this.errorListener = listener;
    }

    public void setErrorOutput(Writer writer) {
        this.errorOutput = writer;
    }

    public void warning(SAXParseException e2) {
        if (this.errorListener != null) {
            try {
                ++this.errorCount;
                this.errorListener.warning(new TransformerException(e2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void error(SAXParseException e2) throws SAXException {
        this.reportError(e2, false);
    }

    public void fatalError(SAXParseException e2) throws SAXException {
        this.reportError(e2, true);
        throw e2;
    }

    protected void reportError(SAXParseException e2, boolean isFatal) {
        block8: {
            ++this.errorCount;
            if (this.errorListener != null) {
                try {
                    ExpressionLocation loc = new ExpressionLocation(e2.getSystemId(), e2.getLineNumber(), e2.getColumnNumber());
                    XPathException err = new XPathException("Error reported by XML parser", loc, e2);
                    err.setErrorCode("SXXP0003");
                    if (isFatal) {
                        this.errorListener.fatalError(err);
                        break block8;
                    }
                    this.errorListener.error(err);
                }
                catch (Exception err) {}
            } else {
                try {
                    if (this.errorOutput == null) {
                        this.errorOutput = new PrintWriter(System.err);
                    }
                    String errcat = isFatal ? "Fatal error" : "Error";
                    this.errorOutput.write(errcat + " reported by XML parser: " + e2.getMessage() + '\n');
                    this.errorOutput.write("  URL:    " + e2.getSystemId() + '\n');
                    this.errorOutput.write("  Line:   " + e2.getLineNumber() + '\n');
                    this.errorOutput.write("  Column: " + e2.getColumnNumber() + '\n');
                    this.errorOutput.flush();
                }
                catch (Exception e22) {
                    System.err.println(e2);
                    System.err.println(e22);
                    e22.printStackTrace();
                }
            }
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }
}

