/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

public final class BitSet {
    private long[] bits;
    private static final byte[] nextBitTable = new byte[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    private BitSet(int nbits) {
        if (nbits > 0) {
            this.bits = new long[nbits + 63 >> 6];
        }
    }

    private BitSet(BitSet s) {
        this(BitSet.size(s));
        if (BitSet.size(s) > 0) {
            System.arraycopy(s.bits, 0, this.bits, 0, this.bits.length);
        }
    }

    public static BitSet and(BitSet a2, BitSet b2) {
        if (BitSet.isEmpty(a2) || BitSet.isEmpty(b2)) {
            return null;
        }
        int minsize = BitSet.size(a2) < BitSet.size(b2) ? BitSet.size(a2) : BitSet.size(b2);
        int minlen = minsize >> 6;
        BitSet t = new BitSet(minsize);
        for (int i = 0; i < minlen; ++i) {
            t.bits[i] = a2.bits[i] & b2.bits[i];
        }
        return t;
    }

    private void reset(BitSet r) {
        int minlen = (BitSet.size(this) < BitSet.size(r) ? BitSet.size(this) : BitSet.size(r)) >> 6;
        for (int i = 0; i < minlen; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (r.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static BitSet or(BitSet a2, BitSet b2) {
        BitSet t;
        block6: {
            int i;
            int minlen;
            block5: {
                if (BitSet.isEmpty(a2)) {
                    return b2;
                }
                if (BitSet.isEmpty(b2)) {
                    return a2;
                }
                minlen = (BitSet.size(a2) < BitSet.size(b2) ? BitSet.size(a2) : BitSet.size(b2)) >> 6;
                int maxlen = (BitSet.size(a2) > BitSet.size(b2) ? BitSet.size(a2) : BitSet.size(b2)) >> 6;
                t = new BitSet(maxlen << 6);
                for (i = 0; i < minlen; ++i) {
                    t.bits[i] = a2.bits[i] | b2.bits[i];
                }
                if (a2.bits == null || a2.bits.length <= minlen) break block5;
                for (i = a2.bits.length - 1; i >= minlen; --i) {
                    t.bits[i] = a2.bits[i];
                }
                break block6;
            }
            if (b2.bits == null || b2.bits.length <= minlen) break block6;
            for (i = b2.bits.length - 1; i >= minlen; --i) {
                t.bits[i] = b2.bits[i];
            }
        }
        return t;
    }

    private void set(BitSet s) {
        if (BitSet.size(s) > BitSet.size(this)) {
            long[] b2 = new long[BitSet.size(s) >> 6];
            if (this.bits != null) {
                System.arraycopy(this.bits, 0, b2, 0, this.bits.length);
            }
            this.bits = b2;
        }
        if (s != null && s.bits != null) {
            for (int i = s.bits.length - 1; i >= 0; --i) {
                int n = i;
                this.bits[n] = this.bits[n] | s.bits[i];
            }
        }
    }

    public static BitSet set(BitSet target, BitSet s) {
        if (BitSet.size(s) > 0) {
            if (target == null) {
                target = new BitSet(BitSet.size(s));
            }
            target.set(s);
        }
        return target;
    }

    public static BitSet reset_set(BitSet target, BitSet r, BitSet s) {
        if (target != null) {
            target.reset(r);
        }
        if (s != null) {
            if (target == null) {
                target = new BitSet(BitSet.size(s));
            }
            target.set(s);
        }
        return target;
    }

    public static BitSet xor(BitSet a2, BitSet b2) {
        BitSet t;
        block6: {
            int i;
            int minlen;
            block5: {
                if (BitSet.isEmpty(a2)) {
                    return b2;
                }
                if (BitSet.isEmpty(b2)) {
                    return a2;
                }
                minlen = (BitSet.size(a2) < BitSet.size(b2) ? BitSet.size(a2) : BitSet.size(b2)) >> 6;
                int maxlen = (BitSet.size(a2) > BitSet.size(b2) ? BitSet.size(a2) : BitSet.size(b2)) >> 6;
                t = new BitSet(maxlen << 6);
                for (i = 0; i < minlen; ++i) {
                    t.bits[i] = a2.bits[i] ^ b2.bits[i];
                }
                if (a2.bits == null || a2.bits.length <= minlen) break block5;
                for (i = a2.bits.length - 1; i >= minlen; --i) {
                    t.bits[i] = a2.bits[i];
                }
                break block6;
            }
            if (b2.bits == null || b2.bits.length <= minlen) break block6;
            for (i = b2.bits.length - 1; i >= minlen; --i) {
                t.bits[i] = b2.bits[i];
            }
        }
        return t;
    }

    public static boolean isEmpty(BitSet b2) {
        return b2 == null || b2.isEmpty();
    }

    private boolean isEmpty() {
        if (this.bits != null) {
            for (int i = this.bits.length - 1; i >= 0; --i) {
                if (this.bits[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    private static int size(BitSet s) {
        return s != null && s.bits != null ? s.bits.length << 6 : 0;
    }

    private boolean get(int index) {
        assert (index >= 0);
        int i = index >> 6;
        return this.bits != null && i < this.bits.length && (this.bits[i] & 1L << (index & 0x3F)) != 0L;
    }

    public static boolean get(BitSet b2, int index) {
        return b2 != null && b2.get(index);
    }

    public static BitSet set(BitSet target, int index, boolean value) {
        assert (index >= 0);
        int i = index >> 6;
        if (index >= BitSet.size(target)) {
            if (target == null) {
                target = new BitSet(index + 1);
            }
            long[] b2 = new long[i + 1];
            if (target.bits != null) {
                System.arraycopy(target.bits, 0, b2, 0, target.bits.length);
            }
            target.bits = b2;
        }
        if (value) {
            int n = i;
            target.bits[n] = target.bits[n] | 1L << (index & 0x3F);
        } else {
            int n = i;
            target.bits[n] = target.bits[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return target;
    }

    public static BitSet copy(BitSet s) {
        return s != null && !s.isEmpty() ? new BitSet(s) : null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BitSet)) {
            return false;
        }
        return BitSet.equals(this, (BitSet)obj);
    }

    public static boolean equals(BitSet a2, BitSet b2) {
        int i;
        int minlen = (BitSet.size(a2) < BitSet.size(b2) ? BitSet.size(a2) : BitSet.size(b2)) >> 6;
        for (i = 0; i < minlen; ++i) {
            if (a2.bits[i] == b2.bits[i]) continue;
            return false;
        }
        if (a2 != null && a2.bits != null) {
            for (i = a2.bits.length - 1; i >= minlen; --i) {
                if (a2.bits[i] == 0L) continue;
                return false;
            }
        }
        if (b2 != null && b2.bits != null) {
            for (i = b2.bits.length - 1; i >= minlen; --i) {
                if (b2.bits[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.bits != null) {
            for (int i = this.bits.length - 1; i >= 0; --i) {
                h2 = (int)((long)h2 ^ this.bits[i]);
            }
        }
        return h2;
    }

    public static int and_count(BitSet a2, BitSet b2) {
        int minlen = (BitSet.size(a2) < BitSet.size(b2) ? BitSet.size(a2) : BitSet.size(b2)) >> 6;
        int sum = 0;
        for (int i = 0; i < minlen; ++i) {
            sum += BitSet.bitCount(a2.bits[i] & b2.bits[i]);
        }
        return sum;
    }

    public static int count(BitSet s) {
        int sum = 0;
        if (s != null && s.bits != null) {
            for (int i = s.bits.length - 1; i >= 0; --i) {
                sum += BitSet.bitCount(s.bits[i]);
            }
        }
        return sum;
    }

    private static int bitCount(long val) {
        val -= (val & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        val = (val & 0x3333333333333333L) + (val >>> 2 & 0x3333333333333333L);
        val = val + (val >>> 4) & 0xF0F0F0F0F0F0F0FL;
        val += val >>> 8;
        val += val >>> 16;
        return (int)val + (int)(val >>> 32) & 0xFF;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder("{");
        if (this.bits != null) {
            int n = this.bits.length << 6;
            for (int i = 0; i < n; ++i) {
                if ((this.bits[i >> 6] & 1L << (i & 0x3F)) == 0L) continue;
                if (b2.length() > 1) {
                    b2.append(", ");
                }
                b2.append(i);
            }
        }
        b2.append('}');
        return b2.toString();
    }

    public static int nextSetBitOld(BitSet s, int i) {
        assert (i >= 0);
        if (s != null && s.bits != null) {
            int n = s.bits.length << 6;
            while (i < n) {
                if ((s.bits[i >> 6] & 1L << (i & 0x3F)) != 0L) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int nextSetBit(BitSet s, int i) {
        int n;
        int j;
        assert (i >= 0);
        if (s != null && s.bits != null && (j = i >> 6) < (n = s.bits.length)) {
            long value = s.bits[j];
            value &= (1L << (i & 0x3F)) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            while (true) {
                if (value != 0L) {
                    if ((value & 0xFFFFFFFFL) != 0L) {
                        if ((value & 0xFFFFL) != 0L) {
                            if ((value & 0xFFL) != 0L) {
                                return nextBitTable[(int)(value & 0xFFL)] + (j << 6);
                            }
                            return nextBitTable[(int)(value >> 8 & 0xFFL)] + 8 + (j << 6);
                        }
                        if ((value & 0xFF0000L) != 0L) {
                            return nextBitTable[(int)(value >> 16 & 0xFFL)] + 16 + (j << 6);
                        }
                        return nextBitTable[(int)(value >> 24 & 0xFFL)] + 24 + (j << 6);
                    }
                    if ((value & 0xFFFF00000000L) != 0L) {
                        if ((value & 0xFF00000000L) != 0L) {
                            return nextBitTable[(int)(value >> 32 & 0xFFL)] + 32 + (j << 6);
                        }
                        return nextBitTable[(int)(value >> 40 & 0xFFL)] + 40 + (j << 6);
                    }
                    if ((value & 0xFF000000000000L) != 0L) {
                        return nextBitTable[(int)(value >> 48 & 0xFFL)] + 48 + (j << 6);
                    }
                    return nextBitTable[(int)(value >> 56 & 0xFFL)] + 56 + (j << 6);
                }
                if (++j >= n) break;
                value = s.bits[j];
            }
        }
        return -1;
    }
}

