/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import macromedia.asc.embedding.avmplus.RuntimeConstants;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.Context;
import macromedia.asc.util.Names;
import macromedia.asc.util.Namespaces;

public abstract class Builder {
    public static final boolean removeBuilderNames = true;
    protected ObjectValue objectValue;
    public int contextId;
    private Names names;
    public QName classname;
    public String pkgname = "";
    public int var_offset;
    public int method_offset;
    public int method_count;
    public int reg_offset;
    public int temp_reg = -1;
    public boolean is_intrinsic;
    public boolean is_dynamic;
    public boolean is_final;
    public int local_method_count;

    protected Builder() {
    }

    public abstract void build(Context var1, ObjectValue var2);

    public void addNames(Names names) {
        if (names != null) {
            this.getNamesAndCreate().putAll(names);
        }
    }

    public Names getNames() {
        return this.objectValue.getNames();
    }

    private Names getNamesAndCreate() {
        return this.objectValue.getNamesAndCreate();
    }

    public void clearNames() {
    }

    public void UnaryOperator(Context cx, ObjectValue ob, TypeValue type, int call_seq, int slot_id) {
        cx.statics.pushExpectedSlotID(slot_id);
        this.CHECK_SLOT_INDEX(slot_id, ob.addMethodSlot(cx, type));
        ob.getSlot(cx, slot_id).attrs(call_seq, RuntimeConstants.getUnaryOp(slot_id));
    }

    public void UnaryOverload(Context cx, ObjectValue ob, int slot_id, TypeValue type, TypeValue opd_type, int call_seq, int over_id) {
        cx.statics.pushExpectedSlotID(over_id);
        this.CHECK_SLOT_INDEX(over_id, ob.addSlotOverload(cx, slot_id, type, opd_type));
        ob.getSlot(cx, over_id).attrs(call_seq, RuntimeConstants.getUnaryOp(over_id));
    }

    public void BinaryOperator(Context cx, ObjectValue ob, TypeValue type, int slot_id) {
        cx.statics.pushExpectedSlotID(slot_id);
        this.CHECK_SLOT_INDEX(slot_id, ob.addMethodSlot(cx, type));
        ob.getSlot(cx, slot_id).attrs(12, RuntimeConstants.getBinaryOp(slot_id));
    }

    public void BinaryOverload(Context cx, ObjectValue ob, int slot_id, TypeValue type, TypeValue lhs_type, TypeValue rhs_type, int over_id) {
        cx.statics.pushExpectedSlotID(over_id);
        this.CHECK_SLOT_INDEX(over_id, ob.addSlotOverload(cx, slot_id, type, lhs_type, rhs_type));
        ob.getSlot(cx, over_id).attrs(12, RuntimeConstants.getBinaryOp(over_id));
    }

    public int ExplicitGet(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, boolean is_final, boolean is_override, int expected_id) {
        return this.ExplicitGet(cx, ob, name, ns, type, is_final, is_override, expected_id, -1, -1);
    }

    public int ExplicitGet(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, boolean is_final, boolean is_override) {
        return this.ExplicitGet(cx, ob, name, ns, type, is_final, is_override, -1, -1, -1);
    }

    public int ExplicitGet(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, boolean is_final, boolean is_override, int expected_id, int method_id, int var_id) {
        int slot_id = ob.addMethodSlot(cx, type);
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineName(cx, -79, name, ns, slot_id);
        ob.getSlot(cx, slot_id).attrs(18, method_id);
        return slot_id;
    }

    public int ExplicitGet(Context cx, ObjectValue ob, String name, Namespaces namespaces, TypeValue type, boolean is_final, boolean is_override) {
        return this.ExplicitGet(cx, ob, name, namespaces, type, is_final, is_override, -1, -1, -1);
    }

    public int ExplicitGet(Context cx, ObjectValue ob, String name, Namespaces namespaces, TypeValue type, boolean is_final, boolean is_override, int expected_id, int method_id, int var_id) {
        int slot_id = ob.addMethodSlot(cx, type);
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineNames(cx, -79, name, namespaces, slot_id);
        Slot slot = ob.getSlot(cx, slot_id);
        slot.attrs(18, method_id);
        slot.setFinal(is_final);
        slot.setOverride(is_override);
        return slot_id;
    }

    public int ExplicitSet(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, boolean is_final, boolean is_override, int expected_id) {
        return this.ExplicitSet(cx, ob, name, ns, type, is_final, is_override, expected_id, -1, -1);
    }

    public int ExplicitSet(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, boolean is_final, boolean is_override, int expected_id, int method_id) {
        return this.ExplicitSet(cx, ob, name, ns, type, is_final, is_override, expected_id, method_id, -1);
    }

    public int ExplicitSet(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, boolean is_final, boolean is_override, int expected_id, int method_id, int var_id) {
        int slot_id = ob.addMethodSlot(cx, type);
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineName(cx, -99, name, ns, slot_id);
        Slot slot = ob.getSlot(cx, slot_id);
        slot.attrs(18, method_id);
        slot.setFinal(is_final);
        slot.setOverride(is_override);
        return slot_id;
    }

    public int ExplicitSet(Context cx, ObjectValue ob, String name, Namespaces namespaces, TypeValue type, boolean is_final, boolean is_override, int expected_id) {
        return this.ExplicitSet(cx, ob, name, namespaces, type, is_final, is_override, expected_id, -1, -1);
    }

    public int ExplicitSet(Context cx, ObjectValue ob, String name, Namespaces namespaces, TypeValue type, boolean is_final, boolean is_override, int expected_id, int method_id, int var_id) {
        int slot_id = ob.addMethodSlot(cx, type);
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineNames(cx, -99, name, namespaces, slot_id);
        Slot slot = ob.getSlot(cx, slot_id);
        slot.attrs(18, method_id);
        slot.setFinal(is_final);
        slot.setOverride(is_override);
        return slot_id;
    }

    public int ExplicitVar(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, int expected_id) {
        return this.ExplicitVar(cx, ob, name, ns, type, expected_id, -1, -1);
    }

    public int ExplicitVar(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, int expected_id, int method_id, int var_id) {
        int slot_id = ob.addVariableSlot(cx, type, var_id);
        ob.getSlot(cx, slot_id).addType(type.getDefaultTypeInfo());
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineName(cx, -79, name, ns, slot_id);
        ob.defineName(cx, -99, name, ns, slot_id);
        ob.getSlot(cx, slot_id).attrs(18, method_id);
        if (var_id >= 0) {
            this.Name(cx, -112, name, ns);
        }
        return slot_id;
    }

    public int ExplicitVar(Context cx, ObjectValue ob, String name, Namespaces namespaces, TypeValue type, int expected_id) {
        return this.ExplicitVar(cx, ob, name, namespaces, type, expected_id, -1, -1);
    }

    public int ExplicitVar(Context cx, ObjectValue ob, String name, Namespaces namespaces, TypeValue type, int expected_id, int method_id, int var_id) {
        int slot_id = ob.addVariableSlot(cx, type, var_id);
        ob.getSlot(cx, slot_id).addType(type.getDefaultTypeInfo());
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineNames(cx, -79, name, namespaces, slot_id);
        ob.defineNames(cx, -99, name, namespaces, slot_id);
        ob.getSlot(cx, slot_id).attrs(18, method_id);
        if (var_id >= 0) {
            for (ObjectValue n : namespaces) {
                this.Name(cx, -112, name, n);
            }
        }
        return slot_id;
    }

    public int ImplicitVar(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, int expected_id) {
        return this.ImplicitVar(cx, ob, name, ns, type, expected_id, -1, -1);
    }

    public int ImplicitVar(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, int expected_id, int method_id, int var_id) {
        cx.statics.pushExpectedSlotID(expected_id);
        int slot_id = ob.addVariableSlot(cx, type, var_id);
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineName(cx, -79, name, ns, slot_id);
        ob.defineName(cx, -99, name, ns, slot_id);
        ob.getSlot(cx, slot_id).attrs(18, method_id);
        return slot_id;
    }

    public void ImplicitCall(Context cx, ObjectValue ob, int slot_id, TypeValue type, int call_seq, int method_id, int expected_id) {
        cx.statics.pushExpectedSlotID(expected_id);
        int implied_id = ob.addSlotImplicit(cx, slot_id, -133, type);
        this.CHECK_SLOT_INDEX(expected_id, implied_id);
        ob.getSlot(cx, implied_id).attrs(call_seq, method_id);
        ob.getSlot(cx, implied_id).setGetter(false);
    }

    public int ExplicitCall(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, boolean is_final, boolean is_override, int expected_id) {
        return this.ExplicitCall(cx, ob, name, ns, type, is_final, is_override, expected_id, -1, -1);
    }

    public int ExplicitCall(Context cx, ObjectValue ob, String name, ObjectValue ns, TypeValue type, boolean is_final, boolean is_override, int expected_id, int method_id, int var_id) {
        TypeValue functionType = cx.useStaticSemantics() ? cx.functionType() : type;
        int slot_id = ob.addMethodSlot(cx, functionType);
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineName(cx, -133, name, ns, slot_id);
        Slot slot = ob.getSlot(cx, slot_id);
        ob.getSlot(cx, slot_id).attrs(18, method_id);
        slot.setFinal(is_final);
        slot.setOverride(is_override);
        slot.setGetter(false);
        this.Name(cx, -133, name, ns);
        return slot_id;
    }

    public int ExplicitCall(Context cx, ObjectValue ob, String name, Namespaces namespaces, TypeValue type, boolean is_final, boolean is_override, int expected_id, int method_id, int var_id) {
        TypeValue functionType = cx.useStaticSemantics() ? cx.functionType() : type;
        int slot_id = ob.addMethodSlot(cx, functionType);
        this.CHECK_SLOT_INDEX(expected_id, slot_id);
        ob.defineNames(cx, -79, name, namespaces, slot_id);
        Slot slot = ob.getSlot(cx, slot_id);
        ob.getSlot(cx, slot_id).attrs(18, method_id);
        slot.setFinal(is_final);
        slot.setOverride(is_override);
        slot.setGetter(false);
        if (method_id >= 0) {
            for (ObjectValue n : namespaces) {
                this.Name(cx, -133, name, n);
            }
        }
        return slot_id;
    }

    public void ImplicitConstruct(Context cx, ObjectValue ob, int slot_id, TypeValue type, int call_seq, int method_id, int expected_id) {
        int implied_id = ob.addSlotImplicit(cx, slot_id, -92, type);
        this.CHECK_SLOT_INDEX(expected_id, implied_id);
        ob.getSlot(cx, implied_id).attrs(call_seq, method_id);
        ob.getSlot(cx, implied_id).setGetter(false);
    }

    public int Variable(Context cx, ObjectValue ob) {
        return ob.addVar(cx);
    }

    public int Method(Context cx, ObjectValue ob, String name, Namespaces namespaces, boolean is_intrinsic) {
        if (this.is_intrinsic || is_intrinsic) {
            return -1;
        }
        return cx.getEmitter().GetMethodId(name, namespaces);
    }

    public int GetMethodId(Context cx, String name, Namespaces namespaces) {
        if (this.getNames() != null) {
            for (ObjectValue ns : namespaces) {
                Slot s;
                int slot_id = this.objectValue.getSlotIndex(cx, -79, name, ns);
                if (slot_id <= 0 || (s = this.objectValue.getSlot(cx, slot_id)).getMethodID() == -1 || s.declaredBy != this.objectValue) continue;
                return s.getMethodID();
            }
        }
        ++this.local_method_count;
        return this.local_method_count;
    }

    public void Name(Context cx, int kind, String name, ObjectValue qualifier) {
        int type = Names.getTypeFromKind(kind);
        if (type == 3 || type == 2) {
            return;
        }
        this.getNamesAndCreate().putMask(name, qualifier, type);
    }

    public final void CHECK_SLOT_INDEX(int a2, int b2) {
        if (a2 != -1 && a2 != b2) assert (false);
    }

    public void InheritCall(Context cx, ObjectValue ob, String name, ObjectValue ns, Slot explicitSlot, Slot implicitSlot) {
        ob.addSlot(explicitSlot);
        ob.addSlot(implicitSlot);
        ob.defineName(cx, -79, name, ns, explicitSlot.id);
        this.Name(cx, -79, name, ns);
        this.Name(cx, -133, name, ns);
    }

    public void InheritGet(Context cx, ObjectValue ob, String name, ObjectValue ns, Slot slot) {
        ob.addSlot(slot);
        ob.defineName(cx, -79, name, ns, slot.id);
        this.Name(cx, -79, name, ns);
    }

    public void InheritSet(Context cx, ObjectValue ob, String name, ObjectValue ns, Slot slot) {
        ob.addSlot(slot);
        ob.defineName(cx, -99, name, ns, slot.id);
        this.Name(cx, -99, name, ns);
    }

    public void InheritVar(Context cx, ObjectValue ob, String name, ObjectValue ns, Slot slot) {
        ob.addSlot(slot);
        ob.defineName(cx, -79, name, ns, slot.id);
        ob.defineName(cx, -99, name, ns, slot.id);
        if (slot.getVarIndex() >= 0) {
            this.Name(cx, -112, name, ns);
        }
    }

    public boolean hasRegisterOffset() {
        return true;
    }
}

