/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashSet;
import java.util.ListIterator;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CommentNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InputBuffer;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralVectorNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.Scanner;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.Token;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.UsePragmaNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.IntList;
import macromedia.asc.util.ObjectList;

public final class Parser {
    private static final boolean debug = false;
    private static final String PUBLIC = "public".intern();
    private static final String PRIVATE = "private".intern();
    private static final String PROTECTED = "protected".intern();
    private static final String ASTERISK = "*".intern();
    private static final String DEFAULT = "default".intern();
    private static final String AS3 = "AS3".intern();
    public static final String CONFIG = "CONFIG".intern();
    private static final String GET = "get".intern();
    private static final String NAMESPACE = "namespace".intern();
    private static final String SET = "set".intern();
    private static final String VEC = "vec".intern();
    private static final String VECTOR = "Vector".intern();
    private static final String __AS3__ = "__AS3__".intern();
    private static final int abbrevIfElse_mode = -71;
    private static final int abbrevDoWhile_mode = -115;
    private static final int abbrevFunction_mode = -78;
    private static final int abbrev_mode = -135;
    private static final int full_mode = -136;
    private static final int allowIn_mode = -137;
    private static final int noIn_mode = -138;
    private static int[] binary_precedence;
    private static BitSet XMLTokenSet;
    private static BitSet StatementTokenSet;
    private int nextToken;
    private Context ctx;
    private NodeFactory nodeFactory;
    private boolean create_doc_info;
    private boolean save_comment_nodes;
    public Scanner scanner;
    private String encoding;
    public ObjectList<Node> comments = new ObjectList();
    public IntList block_kind_stack = new IntList();
    public String current_class_name = null;
    private boolean within_package;
    private boolean parsing_include = false;
    public ObjectList<HashSet<String>> config_namespaces = new ObjectList();
    private boolean is_xmllist = false;

    private void init_BitSets() {
        if (XMLTokenSet != null) {
            return;
        }
        StatementTokenSet = new BitSet(134);
        XMLTokenSet = new BitSet(134);
        StatementTokenSet.set(101);
        StatementTokenSet.set(35);
        StatementTokenSet.set(81);
        StatementTokenSet.set(102);
        StatementTokenSet.set(70);
        StatementTokenSet.set(115);
        StatementTokenSet.set(77);
        StatementTokenSet.set(116);
        StatementTokenSet.set(66);
        StatementTokenSet.set(61);
        StatementTokenSet.set(98);
        StatementTokenSet.set(105);
        StatementTokenSet.set(109);
        StatementTokenSet.set(29);
        StatementTokenSet.set(129);
        XMLTokenSet.set(117);
        XMLTokenSet.set(59);
        XMLTokenSet.set(60);
        XMLTokenSet.set(61);
        XMLTokenSet.set(62);
        XMLTokenSet.set(63);
        XMLTokenSet.set(64);
        XMLTokenSet.set(65);
        XMLTokenSet.set(66);
        XMLTokenSet.set(67);
        XMLTokenSet.set(68);
        XMLTokenSet.set(69);
        XMLTokenSet.set(70);
        XMLTokenSet.set(71);
        XMLTokenSet.set(72);
        XMLTokenSet.set(73);
        XMLTokenSet.set(74);
        XMLTokenSet.set(75);
        XMLTokenSet.set(76);
        XMLTokenSet.set(77);
        XMLTokenSet.set(78);
        XMLTokenSet.set(79);
        XMLTokenSet.set(80);
        XMLTokenSet.set(81);
        XMLTokenSet.set(82);
        XMLTokenSet.set(83);
        XMLTokenSet.set(84);
        XMLTokenSet.set(85);
        XMLTokenSet.set(86);
        XMLTokenSet.set(87);
        XMLTokenSet.set(88);
        XMLTokenSet.set(89);
        XMLTokenSet.set(90);
        XMLTokenSet.set(91);
        XMLTokenSet.set(92);
        XMLTokenSet.set(93);
        XMLTokenSet.set(94);
        XMLTokenSet.set(95);
        XMLTokenSet.set(96);
        XMLTokenSet.set(97);
        XMLTokenSet.set(98);
        XMLTokenSet.set(99);
        XMLTokenSet.set(100);
        XMLTokenSet.set(101);
        XMLTokenSet.set(102);
        XMLTokenSet.set(103);
        XMLTokenSet.set(104);
        XMLTokenSet.set(105);
        XMLTokenSet.set(106);
        XMLTokenSet.set(107);
        XMLTokenSet.set(108);
        XMLTokenSet.set(109);
        XMLTokenSet.set(110);
        XMLTokenSet.set(111);
        XMLTokenSet.set(112);
        XMLTokenSet.set(113);
        XMLTokenSet.set(114);
        XMLTokenSet.set(115);
        XMLTokenSet.set(116);
    }

    private final boolean inXMLTokenSet(int id) {
        return XMLTokenSet.get(-id);
    }

    private final boolean inStatementTokenSet(int id) {
        return StatementTokenSet.get(-id);
    }

    private void init_binary_precedence() {
        if (binary_precedence != null) {
            return;
        }
        binary_precedence = new int[134];
        Parser.binary_precedence[17] = 1;
        Parser.binary_precedence[49] = 2;
        Parser.binary_precedence[12] = 2;
        Parser.binary_precedence[39] = 2;
        Parser.binary_precedence[34] = 2;
        Parser.binary_precedence[23] = 2;
        Parser.binary_precedence[47] = 2;
        Parser.binary_precedence[11] = 2;
        Parser.binary_precedence[38] = 2;
        Parser.binary_precedence[33] = 2;
        Parser.binary_precedence[50] = 2;
        Parser.binary_precedence[16] = 2;
        Parser.binary_precedence[8] = 2;
        Parser.binary_precedence[44] = 2;
        Parser.binary_precedence[56] = 2;
        Parser.binary_precedence[58] = 2;
        Parser.binary_precedence[27] = 3;
        Parser.binary_precedence[37] = 4;
        Parser.binary_precedence[10] = 5;
        Parser.binary_precedence[36] = 6;
        Parser.binary_precedence[31] = 7;
        Parser.binary_precedence[9] = 8;
        Parser.binary_precedence[51] = 9;
        Parser.binary_precedence[5] = 9;
        Parser.binary_precedence[52] = 9;
        Parser.binary_precedence[6] = 9;
        Parser.binary_precedence[53] = 10;
        Parser.binary_precedence[54] = 10;
        Parser.binary_precedence[45] = 10;
        Parser.binary_precedence[48] = 10;
        Parser.binary_precedence[86] = 10;
        Parser.binary_precedence[88] = 10;
        Parser.binary_precedence[60] = 10;
        Parser.binary_precedence[84] = 10;
        Parser.binary_precedence[46] = 11;
        Parser.binary_precedence[55] = 11;
        Parser.binary_precedence[57] = 11;
        Parser.binary_precedence[2] = 12;
        Parser.binary_precedence[42] = 12;
        Parser.binary_precedence[22] = 13;
        Parser.binary_precedence[7] = 13;
        Parser.binary_precedence[15] = 13;
    }

    private void clearUnusedBuffers() {
        this.comments.clear();
        this.scanner.clearUnusedBuffers();
        this.scanner = null;
        this.comments = null;
    }

    Node error(int errCode) {
        return this.error(ParseError.syntax, errCode, "", "", -1);
    }

    private Node error(ParseError kind, int errCode, String arg1) {
        return this.error(kind, errCode, arg1, "", -1);
    }

    private Node error(ParseError kind, int errCode, String arg1, String arg2) {
        return this.error(kind, errCode, arg1, arg2, -1);
    }

    private Node error(ParseError kind, int errCode, String arg1, String arg2, int pos) {
        String origin = this.scanner.input.origin;
        StringBuilder out = new StringBuilder();
        if (ContextStatics.useSanityStyleErrors) {
            out.append("code=" + errCode + "; arg1=" + arg1 + "; arg2=" + arg2);
        } else {
            String msg = this.ctx.shellErrorString(errCode);
            int nextLoc = Context.replaceStringArg(out, msg, 0, arg1);
            if ((nextLoc = Context.replaceStringArg(out, msg, nextLoc, arg2)) != -1) {
                out.append(msg.substring(nextLoc, msg.length()));
            }
        }
        if (pos < 0) {
            pos = this.scanner.input.positionOfMark();
        }
        int lineno = this.scanner.input.getLnNum(pos);
        int column = this.scanner.input.getColPos(pos);
        if (kind == ParseError.syntax || kind == ParseError.EOS) {
            this.ctx.localizedError(origin, lineno, column, out.toString(), this.scanner.input.getLineText(pos), errCode);
        } else {
            this.ctx.localizedError(origin, lineno, column, out.toString(), "", errCode);
        }
        return null;
    }

    private void skiperror(ParseError e2) {
        switch (e2) {
            case catch_parameter: {
                do {
                    this.getNextToken();
                } while (this.nextToken != -14 && this.nextToken != -1);
                break;
            }
            case XML: 
            case EOS: {
                do {
                    this.getNextToken();
                } while (this.nextToken != -1);
                break;
            }
            case syntax: 
            case expression: {
                while (this.nextToken != -13 && this.nextToken != -14 && this.nextToken != -35 && this.nextToken != -40 && this.nextToken != -29 && this.nextToken != -30 && this.nextToken != -17 && this.nextToken != -26 && this.nextToken != -1) {
                    this.getNextToken();
                }
                break;
            }
        }
    }

    private void skiperror(int tokenId) {
        while (true) {
            if (this.nextToken == tokenId) {
                if (tokenId != -40) break;
                this.block_kind_stack.clear();
                for (int size = this.block_kind_stack.size(); size > 0; --size) {
                    this.block_kind_stack.add(-134);
                }
                break;
            }
            if (this.nextToken == -1 || this.nextToken == -26 && tokenId != -40) break;
            if (this.nextToken == -35 && tokenId != -40) {
                this.scanner.retract();
                break;
            }
            if (this.nextToken == -40) {
                this.scanner.retract();
                break;
            }
            this.getNextToken();
        }
    }

    private void init(Context cx, String origin, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack) {
        this.ctx = cx;
        this.nextToken = -133;
        this.create_doc_info = emit_doc_info;
        this.within_package = false;
        this.save_comment_nodes = save_comment_nodes;
        this.nodeFactory = cx.getNodeFactory();
        this.nodeFactory.createDefaultDocComments(emit_doc_info);
        if (block_kind_stack != null) {
            this.block_kind_stack.addAll(block_kind_stack);
        } else {
            this.block_kind_stack.add(-133);
        }
        cx.parser = this;
        cx.setOrigin(origin);
        this.init_binary_precedence();
        this.init_BitSets();
    }

    public Parser(Context cx, InputStream in, String origin) {
        this(cx, in, origin, null);
    }

    public Parser(Context cx, InputStream in, String origin, String encoding) {
        this.init(cx, origin, false, false, null);
        this.scanner = new Scanner(cx, in, encoding, origin);
        this.encoding = encoding;
    }

    public Parser(Context cx, InputStream in, String origin, boolean emit_doc_info, boolean save_comment_nodes) {
        this(cx, in, origin, null, emit_doc_info, save_comment_nodes, null);
    }

    public Parser(Context cx, InputStream in, String origin, String encoding, boolean emit_doc_info, boolean save_comment_nodes) {
        this(cx, in, origin, encoding, emit_doc_info, save_comment_nodes, null);
    }

    public Parser(Context cx, InputStream in, String origin, String encoding, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack) {
        this.init(cx, origin, emit_doc_info, save_comment_nodes, block_kind_stack);
        this.scanner = new Scanner(cx, in, encoding, origin, save_comment_nodes | emit_doc_info);
        this.encoding = encoding;
    }

    public Parser(Context cx, InputStream in, String origin, String encoding, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack, boolean is_include) {
        this(cx, in, origin, encoding, emit_doc_info, save_comment_nodes, block_kind_stack);
        this.parsing_include = is_include;
    }

    public Parser(Context cx, String in, String origin) {
        this.init(cx, origin, false, false, null);
        this.scanner = new Scanner(cx, in, origin, false);
    }

    public Parser(Context cx, String in, String origin, boolean emit_doc_info, boolean save_comment_nodes) {
        this(cx, in, origin, emit_doc_info, save_comment_nodes, null);
    }

    public Parser(Context cx, String in, String origin, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack) {
        this.init(cx, origin, emit_doc_info, save_comment_nodes, block_kind_stack);
        this.scanner = new Scanner(cx, in, origin, save_comment_nodes | emit_doc_info);
    }

    public Parser(Context cx, String in, String origin, boolean emit_doc_info, boolean save_comment_nodes, IntList block_kind_stack, boolean is_include) {
        this(cx, in, origin, emit_doc_info, save_comment_nodes, block_kind_stack);
        this.parsing_include = is_include;
    }

    public Parser(Context cx, InputBuffer inputBuffer, String origin, boolean emit_doc_info) {
        this.init(cx, origin, emit_doc_info, false, null);
        this.scanner = new Scanner(cx, inputBuffer);
    }

    private final void shift() {
        this.nextToken = -133;
    }

    public final int match(int expectedTokenClass) {
        int result;
        int lt = this.lookahead();
        if (lt == expectedTokenClass) {
            this.shift();
            return lt;
        }
        if (lt == -134) {
            int result2 = this.nextToken;
            this.shift();
            return result2;
        }
        if (expectedTokenClass == -1) {
            if (this.ctx.errorCount() == 0) {
                this.error(1087);
            }
            this.skiperror(-1);
            result = this.nextToken;
            this.shift();
        } else {
            this.error(ParseError.EOS, 1084, Token.getTokenClassName(expectedTokenClass), this.scanner.getCurrentTokenTextOrTypeText(this.nextToken));
            this.skiperror(expectedTokenClass);
            result = this.nextToken;
            if (this.nextToken != -1) {
                this.shift();
            }
        }
        return result;
    }

    private final boolean lookaheadSemicolon(int mode) {
        int lt = this.lookahead();
        return lt == -26 || lt == -1 || lt == -40 || lt == mode || this.scanner.followsLineTerminator();
    }

    private final int matchSemicolon(int mode) {
        int result = -134;
        int lt = this.lookahead();
        if (lt == -26) {
            this.shift();
            result = -26;
        } else if (lt == -1 || lt == -40 || this.scanner.followsLineTerminator()) {
            result = -26;
        } else if ((mode == -71 || mode == -115) && lt == mode) {
            result = -26;
        } else if (lt != -134) {
            if (mode == -78) {
                this.error(1158);
                this.skiperror(-35);
            } else {
                this.error(ParseError.syntax, 1086, this.scanner.getCurrentTokenTextOrTypeText(this.nextToken));
                this.skiperror(-26);
            }
        }
        return result;
    }

    private final int matchNoninsertableSemicolon(int mode) {
        switch (this.lookahead()) {
            case -26: {
                this.shift();
            }
            case -40: 
            case -1: {
                return -26;
            }
        }
        if ((mode == -71 || mode == -115) && this.lookahead() == mode) {
            return -26;
        }
        this.error(ParseError.syntax, 1086, this.scanner.getCurrentTokenTextOrTypeText(this.nextToken));
        this.skiperror(-26);
        return -134;
    }

    private final void getNextToken() {
        int tok = this.scanner.nexttoken(true);
        while (tok == -131 || tok == -130 || tok == -129) {
            if (this.save_comment_nodes && (!this.ctx.scriptAssistParsing || tok != -129)) {
                CommentNode newComment = this.nodeFactory.comment(this.scanner.getCurrentTokenText(), tok, this.scanner.input.positionOfMark());
                this.comments.push_back(newComment);
            }
            if (tok == -129 && this.create_doc_info) break;
            tok = this.scanner.nexttoken(false);
        }
        this.nextToken = tok;
    }

    private final void changeLookahead(int tok) {
        this.nextToken = tok;
    }

    private final int lookahead() {
        if (this.nextToken == -133) {
            this.getNextToken();
        }
        return this.nextToken;
    }

    private IdentifierNode parseIdentifier() {
        String name = this.parseIdentifierString();
        IdentifierNode result = this.nodeFactory.identifier(name, false, this.scanner.input.positionOfMark());
        return result;
    }

    public String parseIdentifierString() {
        String result = null;
        int lt = this.lookahead();
        switch (lt) {
            case -79: {
                this.shift();
                result = GET;
                break;
            }
            case -99: {
                this.shift();
                result = SET;
                break;
            }
            case -89: {
                this.shift();
                result = NAMESPACE;
                break;
            }
            case -117: {
                this.shift();
                result = this.scanner.getCurrentTokenText().intern();
                break;
            }
            default: {
                result = -117 == this.match(-117) ? this.scanner.getCurrentTokenText().intern() : "expected identifer";
            }
        }
        return result;
    }

    private IdentifierNode parsePropertyIdentifier() {
        int pos = this.scanner.input.positionOfMark();
        String name = this.parsePropertyIdentifierString();
        IdentifierNode result = this.nodeFactory.identifier(name, false, pos);
        return result;
    }

    private String parsePropertyIdentifierString() {
        String result = null;
        int lt = this.lookahead();
        switch (lt) {
            case -68: {
                this.shift();
                result = DEFAULT;
                break;
            }
            case -79: {
                this.shift();
                result = GET;
                break;
            }
            case -99: {
                this.shift();
                result = SET;
                break;
            }
            case -89: {
                this.shift();
                result = NAMESPACE;
                break;
            }
            case -117: {
                this.shift();
                result = this.scanner.getCurrentTokenText().intern();
                break;
            }
            default: {
                if (Features.HAS_WILDCARDSELECTOR && (lt == -15 || lt == -16)) {
                    result = ASTERISK;
                    if (lt == -15) {
                        this.shift();
                        break;
                    }
                    this.changeLookahead(-49);
                    break;
                }
                result = -117 == this.match(-117) ? this.scanner.getCurrentTokenText().intern() : "expected property identifier";
            }
        }
        return result;
    }

    private IdentifierNode parseQualifier() {
        IdentifierNode result;
        switch (this.lookahead()) {
            case -97: {
                this.shift();
                result = this.nodeFactory.identifier(PUBLIC, false, this.scanner.input.positionOfMark());
                break;
            }
            case -95: {
                this.shift();
                result = this.nodeFactory.identifier(PRIVATE, false, this.scanner.input.positionOfMark());
                break;
            }
            case -96: {
                this.shift();
                result = this.nodeFactory.identifier(PROTECTED, false, this.scanner.input.positionOfMark());
                break;
            }
            default: {
                result = this.parsePropertyIdentifier();
            }
        }
        return result;
    }

    private IdentifierNode parseSimpleQualifiedIdentifier() {
        IdentifierNode result = null;
        boolean is_attr = false;
        if (Features.HAS_ATTRIBUTEIDENTIFIERS && this.lookahead() == -28) {
            this.shift();
            is_attr = true;
        }
        if (is_attr && this.lookahead() == -29) {
            MemberExpressionNode men = this.parseBrackets(null);
            GetExpressionNode gen = men.selector instanceof GetExpressionNode ? (GetExpressionNode)men.selector : null;
            result = this.nodeFactory.qualifiedExpression(null, gen.expr, gen.expr.pos());
        } else {
            IdentifierNode first = this.parseQualifier();
            if (Features.HAS_QUALIFIEDIDENTIFIERS && this.lookahead() == -25) {
                this.shift();
                MemberExpressionNode temp = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(first));
                if (this.lookahead() == -29) {
                    MemberExpressionNode men = this.parseBrackets(null);
                    GetExpressionNode gen = men.selector instanceof GetExpressionNode ? (GetExpressionNode)men.selector : null;
                    result = this.nodeFactory.qualifiedExpression(temp, gen.expr, gen.expr.pos());
                } else {
                    QualifiedIdentifierNode qualid = this.nodeFactory.qualifiedIdentifier(temp, this.parsePropertyIdentifierString(), this.scanner.input.positionOfMark());
                    assert (this.config_namespaces.size() > 0);
                    if (this.config_namespaces.last().contains(first.name)) {
                        qualid.is_config_name = true;
                    }
                    result = qualid;
                    result.setOrigTypeToken(-25);
                }
            } else {
                result = first;
            }
        }
        result.setAttr(is_attr);
        return result;
    }

    private IdentifierNode parseExpressionQualifiedIdentifier() {
        boolean is_attr = false;
        if (Features.HAS_ATTRIBUTEIDENTIFIERS && this.lookahead() == -28) {
            this.shift();
            is_attr = true;
        }
        Node first = this.parseParenExpression();
        this.match(-25);
        QualifiedIdentifierNode result = this.nodeFactory.qualifiedIdentifier(first, this.parsePropertyIdentifierString(), this.scanner.input.positionOfMark());
        result.setAttr(is_attr);
        return result;
    }

    private IdentifierNode parseQualifiedIdentifier() {
        IdentifierNode result = Features.HAS_EXPRESSIONQUALIFIEDIDS && this.lookahead() == -13 ? this.parseExpressionQualifiedIdentifier() : this.parseSimpleQualifiedIdentifier();
        return result;
    }

    private Node parsePrimaryExpression() {
        Node result;
        int lt = this.lookahead();
        int pos = this.scanner.input.positionOfMark();
        switch (lt) {
            case -93: {
                this.shift();
                result = this.nodeFactory.literalNull(pos);
                break;
            }
            case -108: {
                this.shift();
                result = this.nodeFactory.literalBoolean(true, pos);
                break;
            }
            case -74: {
                this.shift();
                result = this.nodeFactory.literalBoolean(false, pos);
                break;
            }
            case -95: {
                this.shift();
                result = this.nodeFactory.identifier(PRIVATE, false, pos);
                break;
            }
            case -97: {
                this.shift();
                result = this.nodeFactory.identifier(PUBLIC, false, pos);
                break;
            }
            case -96: {
                this.shift();
                result = this.nodeFactory.identifier(PROTECTED, false, pos);
                break;
            }
            case -118: {
                this.shift();
                result = this.nodeFactory.literalNumber(this.scanner.getCurrentTokenText(), pos);
                break;
            }
            case -120: {
                boolean[] is_single_quoted = new boolean[1];
                this.shift();
                String enclosedText = this.scanner.getCurrentStringTokenText(is_single_quoted);
                result = this.nodeFactory.literalString(enclosedText, pos, is_single_quoted[0]);
                break;
            }
            case -104: {
                this.shift();
                result = this.nodeFactory.thisExpression(pos);
                break;
            }
            case -13: {
                result = this.parseParenExpressionList();
                break;
            }
            case -29: {
                result = this.parseArrayLiteral();
                break;
            }
            case -35: {
                result = this.parseObjectLiteral();
                break;
            }
            case -78: {
                this.shift();
                IdentifierNode first = null;
                if (this.lookahead() == -117) {
                    first = this.parseIdentifier();
                }
                result = this.parseFunctionCommon(first);
                break;
            }
            case -94: {
                if (this.within_package) {
                    this.error(1037);
                    result = this.nodeFactory.error(pos, 1037);
                } else {
                    this.error(ParseError.syntax, 1083, this.scanner.getCurrentTokenTextOrTypeText(this.nextToken));
                    result = this.nodeFactory.error(pos, 1083);
                }
                this.skiperror(-35);
                this.skiperror(-40);
                break;
            }
            case -76: 
            case -71: 
            case -63: {
                this.error(ParseError.syntax, 1083, this.scanner.getCurrentTokenTextOrTypeText(this.nextToken));
                this.skiperror(-35);
                this.skiperror(-40);
                result = this.nodeFactory.error(this.scanner.input.positionOfMark(), 1083);
                break;
            }
            case -124: 
            case -45: {
                result = Features.HAS_XMLLITERALS ? this.parseXMLLiteral() : this.parseTypename();
                break;
            }
            case -119: {
                if (Features.HAS_REGULAREXPRESSIONS) {
                    this.shift();
                    result = this.nodeFactory.literalRegExp(this.scanner.getCurrentTokenText(), pos);
                    break;
                }
                result = this.parseTypename();
                break;
            }
            default: {
                result = this.parseTypename();
            }
        }
        return result;
    }

    private LiteralXMLNode parseXMLLiteral() {
        Node first;
        this.is_xmllist = false;
        LiteralXMLNode result = null;
        int pos = this.scanner.input.positionOfMark();
        if (this.lookahead() == -124) {
            this.shift();
            first = this.nodeFactory.list(null, this.nodeFactory.literalString(this.scanner.getCurrentTokenText(), pos));
        } else {
            this.scanner.pushState();
            first = this.parseXMLElement();
            this.scanner.popState();
        }
        if (first != null) {
            ListNode list = this.nodeFactory.list(null, first, pos);
            result = this.nodeFactory.literalXML(list, this.is_xmllist, this.scanner.input.positionOfMark());
        }
        return result;
    }

    Node parseXMLElement() {
        Node result;
        boolean is_xmllist = false;
        this.match(-45);
        if (this.lookahead() == -53) {
            is_xmllist = true;
            result = this.nodeFactory.list(null, this.nodeFactory.literalString("", 0));
        } else {
            result = this.nodeFactory.list(null, this.nodeFactory.literalString("<", 0));
            result = this.parseXMLName(result);
            result = this.parseXMLAttributes(result);
        }
        if (this.lookahead() == -53) {
            this.shift();
            if (!is_xmllist) {
                result = this.concatXML(result, this.nodeFactory.literalString(">", 0));
            }
            result = this.parseXMLElementContent(result);
            if (this.lookahead() == -1) {
                this.error(1100);
                return this.nodeFactory.error(this.scanner.input.positionOfMark(), 1100);
            }
            this.match(-127);
            if (this.lookahead() == -53) {
                if (!is_xmllist) {
                    this.ctx.error(this.scanner.input.positionOfMark(), 1110);
                }
            } else {
                result = this.concatXML(result, this.nodeFactory.literalString("</", 0));
                result = this.parseXMLName(result);
                result = this.concatXML(result, this.nodeFactory.literalString(">", 0));
            }
            this.match(-53);
        } else {
            this.match(-126);
            result = this.concatXML(result, this.nodeFactory.literalString("/>", 0));
        }
        this.is_xmllist = is_xmllist;
        return result;
    }

    Node concatXML(Node left, Node right) {
        Node tmpLeft = left;
        if (left instanceof ListNode && ((ListNode)left).size() == 1) {
            tmpLeft = ((ListNode)left).items.first();
        }
        if (tmpLeft instanceof LiteralStringNode && right instanceof LiteralStringNode) {
            return this.nodeFactory.literalString(((LiteralStringNode)tmpLeft).value + ((LiteralStringNode)right).value, left.pos());
        }
        if (left instanceof BinaryExpressionNode && right instanceof LiteralStringNode) {
            BinaryExpressionNode leftBinary = (BinaryExpressionNode)left;
            if (leftBinary.op == -42 && leftBinary.rhs instanceof LiteralStringNode) {
                return this.nodeFactory.binaryExpression(-42, leftBinary.lhs, this.nodeFactory.literalString(((LiteralStringNode)leftBinary.rhs).value + ((LiteralStringNode)right).value), leftBinary.pos());
            }
        }
        return this.nodeFactory.binaryExpression(-42, left, right);
    }

    Node parseXMLName(Node first) {
        Node result;
        int lt = this.lookahead();
        if (lt == -35) {
            this.shift();
            this.scanner.pushState();
            result = this.concatXML(first, this.parseExpressionList(-137));
            this.match(-40);
            this.scanner.popState();
        } else {
            if (this.inXMLTokenSet(lt) || lt == -24) {
                this.shift();
                result = this.concatXML(first, this.nodeFactory.literalString(this.scanner.getCurrentTokenTextOrTypeText(lt), this.scanner.input.positionOfMark()));
            } else {
                this.error(ParseError.syntax, 1104, "invalid xml name");
                this.skiperror(ParseError.XML);
                result = this.nodeFactory.error(this.scanner.input.positionOfMark(), 1110);
            }
            lt = this.lookahead();
            while (true) {
                String separator_text;
                if (lt == -18) {
                    separator_text = ".";
                } else if (lt == -2) {
                    separator_text = "-";
                } else {
                    if (lt != -24) break;
                    separator_text = ":";
                }
                this.shift();
                lt = this.lookahead();
                if (this.inXMLTokenSet(lt)) {
                    result = this.concatXML(result, this.nodeFactory.literalString(separator_text, 0));
                    result = this.concatXML(result, this.nodeFactory.literalString(this.scanner.getCurrentTokenTextOrTypeText(lt), this.scanner.input.positionOfMark()));
                    this.shift();
                    lt = this.lookahead();
                    continue;
                }
                this.error(1110);
                this.skiperror(ParseError.XML);
                result = this.nodeFactory.error(this.scanner.input.positionOfMark(), 1110);
            }
        }
        return result;
    }

    Node parseXMLAttributes(Node first) {
        Node result = first;
        int lt = this.lookahead();
        while (lt != -53 && lt != -126 && lt != -1) {
            result = this.concatXML(result, this.nodeFactory.literalString(" ", 0));
            result = this.parseXMLAttribute(result);
            lt = this.lookahead();
        }
        return result;
    }

    Node parseXMLAttribute(Node first) {
        Node result = this.parseXMLName(first);
        if (this.lookahead() == -49) {
            this.shift();
            Node value = null;
            boolean single_quote = false;
            if (this.lookahead() == -120) {
                boolean[] is_single_quoted = new boolean[1];
                this.shift();
                String enclosedText = this.scanner.getCurrentStringTokenText(is_single_quoted);
                value = this.nodeFactory.literalString(enclosedText, this.scanner.input.positionOfMark(), is_single_quoted[0]);
                single_quote = is_single_quoted[0];
            } else if (this.lookahead() == -35) {
                this.shift();
                this.scanner.pushState();
                ListNode expr = this.parseExpressionList(-137);
                value = this.nodeFactory.invoke("[[ToXMLAttrString]]", this.nodeFactory.argumentList(null, expr), 0);
                this.match(-40);
                this.scanner.popState();
            } else {
                this.error(1205);
            }
            result = this.concatXML(result, this.nodeFactory.literalString(single_quote ? "='" : "=\"", 0));
            result = this.concatXML(result, value);
            result = this.concatXML(result, this.nodeFactory.literalString(single_quote ? "'" : "\"", 0));
        }
        return result;
    }

    Node parseXMLElementContent(Node first) {
        Node result = first;
        this.scanner.pushState();
        this.scanner.state = 29;
        while (this.lookahead() != -127 && this.lookahead() != -1) {
            int lt = this.lookahead();
            if (lt == -35) {
                this.shift();
                this.scanner.pushState();
                Node expr = this.parseExpressionList(-137);
                expr = this.nodeFactory.invoke("[[ToXMLString]]", this.nodeFactory.argumentList(null, expr), 0);
                result = this.concatXML(result, expr);
                this.match(-40);
                this.scanner.popState();
            } else if (lt == -45) {
                this.scanner.state = 0;
                result = this.concatXML(result, this.parseXMLElement());
            } else if (lt == -124) {
                result = this.concatXML(result, this.nodeFactory.literalString(this.scanner.getCurrentTokenTextOrTypeText(this.match(-124)), this.scanner.input.positionOfMark()));
            } else if (lt == -125) {
                result = this.concatXML(result, this.nodeFactory.literalString(this.scanner.getCurrentTokenTextOrTypeText(this.match(-125)), this.scanner.input.positionOfMark()));
            } else {
                this.error(1110);
                this.skiperror(-40);
                this.scanner.popState();
                return result;
            }
            this.scanner.state = 29;
        }
        this.scanner.popState();
        return result;
    }

    private Node parseParenExpression() {
        this.match(-13);
        int mark = this.scanner.input.positionOfMark();
        Node result = this.parseAssignmentExpression(-137);
        result.setPosition(mark);
        this.match(-14);
        return result;
    }

    private ListNode parseParenExpressionList() {
        this.match(-13);
        ListNode result = this.parseExpressionList(-137);
        this.match(-14);
        return result;
    }

    private Node parsePrimaryExpressionOrExpressionQualifiedIdentifier() {
        Node result;
        if (this.lookahead() == -13) {
            ListNode first = this.parseParenExpressionList();
            result = first;
            if (Features.HAS_EXPRESSIONQUALIFIEDIDS && this.lookahead() == -25) {
                this.shift();
                if (first == null || first.size() != 1) {
                    result = this.error(1082);
                    this.skiperror(ParseError.expression);
                } else {
                    result = this.nodeFactory.qualifiedIdentifier(first.items.last(), this.parseIdentifierString(), this.scanner.input.positionOfMark());
                    result = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(result));
                }
            }
        } else {
            result = this.parsePrimaryExpression();
        }
        return result;
    }

    private FunctionCommonNode parseFunctionCommon(IdentifierNode first) {
        StatementListNode third = null;
        boolean saved_has_arguments = this.nodeFactory.has_arguments;
        boolean saved_has_rest = this.nodeFactory.has_rest;
        boolean saved_has_dxns = this.nodeFactory.has_dxns;
        this.nodeFactory.has_arguments = false;
        this.nodeFactory.has_rest = false;
        this.nodeFactory.has_dxns = false;
        boolean is_ctor = false;
        if (this.ctx.statics.es4_nullability && this.block_kind_stack.last() == -64 && first != null && first.name.equals(this.current_class_name)) {
            is_ctor = true;
        }
        this.block_kind_stack.add(-78);
        FunctionSignatureNode second = is_ctor ? this.parseConstructorSignature() : this.parseFunctionSignature();
        DefaultXMLNamespaceNode saved_dxns = this.nodeFactory.dxns;
        if (this.lookahead() == -35) {
            third = this.parseBlock();
            if (third == null) {
                third = this.nodeFactory.statementList(null, null);
            }
        } else {
            this.matchSemicolon(-78);
        }
        FunctionCommonNode result = this.nodeFactory.functionCommon(this.ctx, first, second, third, first != null ? first.pos() : second.pos());
        result.default_dxns = this.nodeFactory.has_dxns ? null : saved_dxns;
        this.nodeFactory.has_arguments = saved_has_arguments;
        this.nodeFactory.has_rest = saved_has_rest;
        this.nodeFactory.has_dxns = saved_has_dxns;
        this.block_kind_stack.removeLast();
        return result;
    }

    private Node parseObjectLiteral() {
        ArgumentListNode first = null;
        int pos = this.scanner.input.positionOfMark();
        this.match(-35);
        if (this.lookahead() == -40) {
            this.shift();
        } else {
            while (true) {
                Node t;
                if ((t = this.parseLiteralField()) != null) {
                    first = this.nodeFactory.argumentList(first, t);
                }
                if (this.lookahead() != -17) break;
                this.shift();
            }
            this.match(-40);
        }
        LiteralObjectNode result = this.nodeFactory.literalObject(first, pos);
        return result;
    }

    private Node parseLiteralField() {
        ListNode l = null;
        Node first = this.parseFieldOrConfigName();
        if (first.isConfigurationName() && this.lookahead() != -24) {
            l = this.nodeFactory.list(null, first);
            first = this.parseFieldOrConfigName();
        }
        this.match(-24);
        Node second = this.parseAssignmentExpression(-137);
        Node result = this.nodeFactory.literalField(first, second);
        if (l != null) {
            result = this.nodeFactory.list(l, result);
        }
        return result;
    }

    private Node parseFieldOrConfigName() {
        Node result;
        int lt = this.lookahead();
        if (Features.HAS_NONIDENTFIELDNAMES && lt == -120) {
            boolean[] is_single_quoted = new boolean[1];
            this.shift();
            String enclosedText = this.scanner.getCurrentStringTokenText(is_single_quoted);
            result = this.nodeFactory.literalString(enclosedText, this.scanner.input.positionOfMark(), is_single_quoted[0]);
        } else if (Features.HAS_NONIDENTFIELDNAMES && lt == -118) {
            this.shift();
            result = this.nodeFactory.literalNumber(this.scanner.getCurrentTokenText(), this.scanner.input.positionOfMark());
        } else if (Features.HAS_NONIDENTFIELDNAMES && lt == -13) {
            result = this.parseParenExpression();
        } else {
            IdentifierNode ident = this.parseIdentifier();
            assert (this.config_namespaces.size() > 0);
            if (this.config_namespaces.last().contains(ident.name) && this.lookahead() == -25) {
                this.shift();
                QualifiedIdentifierNode qualid = this.nodeFactory.qualifiedIdentifier(ident, this.parseIdentifierString(), this.scanner.input.positionOfMark());
                qualid.is_config_name = true;
                result = qualid;
            } else {
                result = ident;
            }
        }
        return result;
    }

    private LiteralArrayNode parseArrayLiteral() {
        ArgumentListNode initializer_list = null;
        int pos = this.scanner.input.positionOfMark();
        this.match(-29);
        if (-30 != this.lookahead()) {
            initializer_list = this.parseElementList(true);
        }
        LiteralArrayNode result = this.nodeFactory.literalArray(initializer_list, pos);
        this.match(-30);
        return result;
    }

    private LiteralVectorNode parseVectorLiteral() {
        ArgumentListNode initializer_list = null;
        int pos = this.scanner.input.positionOfMark();
        this.match(-45);
        ListNode type_list = this.parseTypeExpressionList();
        Node vector_type = this.nodeFactory.applyTypeExpr(this.nodeFactory.identifier("Vector", false, pos), type_list, pos);
        this.match(-53);
        this.match(-29);
        if (-30 != this.lookahead()) {
            initializer_list = this.parseElementList(false);
        }
        this.match(-30);
        LiteralVectorNode result = this.nodeFactory.literalVector(vector_type, initializer_list, pos);
        return result;
    }

    private ArgumentListNode parseElementList(boolean allow_empty) {
        ArgumentListNode result = null;
        while (true) {
            Node t;
            if ((t = this.parseLiteralElement(allow_empty)) != null) {
                result = this.nodeFactory.argumentList(result, t);
            }
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    private Node parseLiteralElement(boolean allow_empty) {
        Node result;
        int lt = this.lookahead();
        if (lt == -17 && allow_empty) {
            result = this.nodeFactory.emptyElement(this.scanner.input.positionOfMark());
        } else if (lt == -30) {
            result = null;
        } else {
            Node first = this.parseAssignmentExpression(-137);
            lt = this.lookahead();
            if (first.isConfigurationName() && lt != -17 && lt != -30) {
                ListNode list = this.nodeFactory.list(null, first);
                result = this.nodeFactory.list(list, this.parseAssignmentExpression(-137));
            } else {
                result = first;
            }
        }
        return result;
    }

    private Node parseSuperExpression() {
        int pos = this.scanner.input.positionOfMark();
        this.shift();
        Node first = null;
        if (this.lookahead() == -13) {
            first = this.parseParenExpression();
        }
        SuperExpressionNode result = this.nodeFactory.superExpression(first, pos);
        return result;
    }

    private final int precedence(int token, int mode) {
        if (token == -84 && mode == -138) {
            return 0;
        }
        int prec = binary_precedence[-token];
        return prec;
    }

    private Node parseBinaryExpression(int mode, int prec) {
        int p1;
        Node result = this.parseUnaryExpression();
        int op = this.lookahead();
        int p2 = p1 = this.precedence(op, mode);
        while (p1 >= prec) {
            while (p2 == p1) {
                this.shift();
                Node t = this.parseBinaryExpression(mode, p1 + 1);
                result = this.nodeFactory.binaryExpression(op, result, t);
                op = this.lookahead();
                p2 = this.precedence(op, mode);
            }
            --p1;
        }
        return result;
    }

    private Node parsePostfixExpression() {
        Node first;
        int lt = this.lookahead();
        switch (lt) {
            case -117: 
            case -99: 
            case -97: 
            case -96: 
            case -95: 
            case -89: 
            case -79: 
            case -68: 
            case -28: 
            case -15: {
                first = this.parseAttributeExpression();
                lt = this.lookahead();
                if (lt != -43 && lt != -3 || this.lookaheadSemicolon(-136)) break;
                first = this.parsePostfixIncrement(first);
                break;
            }
            case -120: 
            case -119: 
            case -118: 
            case -108: 
            case -104: 
            case -93: 
            case -78: 
            case -74: 
            case -35: 
            case -29: 
            case -13: {
                first = this.parsePrimaryExpressionOrExpressionQualifiedIdentifier();
                break;
            }
            case -101: {
                first = this.parseSuperExpression();
                break;
            }
            case -92: {
                first = this.parseShortNewExpression();
                if (first instanceof LiteralVectorNode) break;
                first = this.lookahead() == -13 ? this.parseArguments(first) : this.nodeFactory.callExpression(first, null);
                first = this.nodeFactory.newExpression(first);
                if (this.lookaheadSemicolon(-136) || this.lookahead() != -43 && this.lookahead() != -3) break;
                first = this.parsePostfixIncrement(first);
                break;
            }
            default: {
                first = this.parseFullNewSubexpression();
                if (this.lookahead() != -13) break;
                first = this.parseArguments(first);
            }
        }
        Node result = this.parseFullPostfixExpressionPrime(first);
        return result;
    }

    private Node parsePostfixIncrement(Node first) {
        Node result;
        int lt = this.lookahead();
        if (lt == -43 || lt == -3) {
            this.shift();
            result = this.nodeFactory.postfixExpression(lt, first, this.scanner.input.positionOfMark());
        } else {
            result = this.error(1080);
            this.skiperror(ParseError.syntax);
        }
        return result;
    }

    private Node parseFullPostfixExpressionPrime(Node first) {
        Node result = first;
        int lt = this.lookahead();
        if (lt == -18 || lt == -29 || lt == -21 || Features.HAS_DESCENDOPERATORS && lt == -19) {
            first = this.parsePropertyOperator(first);
            result = this.parseFullPostfixExpressionPrime(first);
        } else if (lt == -13) {
            first = this.parseArguments(first);
            result = this.parseFullPostfixExpressionPrime(first);
        } else if (!(this.lookaheadSemicolon(-136) || lt != -43 && lt != -3)) {
            first = this.parsePostfixIncrement(first);
            result = this.parseFullPostfixExpressionPrime(first);
        }
        return result;
    }

    private Node parseAttributeExpression() {
        IdentifierNode ident = this.parseSimpleQualifiedIdentifier();
        MemberExpressionNode first = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(ident));
        int lt = this.lookahead();
        Node result = lt == -18 || lt == -29 || lt == -19 || lt == -13 || lt == -28 ? this.parseAttributeExpressionPrime(first) : first;
        return result;
    }

    private Node parseAttributeExpressionPrime(Node first) {
        int lt = this.lookahead();
        Node result = lt == -18 || lt == -19 || lt == -29 || lt == -21 ? this.parseAttributeExpressionPrime(this.parsePropertyOperator(first)) : (lt == -13 ? this.parseAttributeExpressionPrime(this.parseArguments(first)) : first);
        return result;
    }

    private Node parseFullNewExpression() {
        this.shift();
        Node first = this.parseFullNewSubexpression();
        Node result = this.nodeFactory.newExpression(this.parseArguments(first));
        return result;
    }

    private Node parseFullNewSubexpression() {
        Node result;
        switch (this.lookahead()) {
            case -92: {
                Node first = this.parseFullNewExpression();
                if (first instanceof LiteralVectorNode) {
                    result = first;
                    break;
                }
                result = this.parseFullNewSubexpressionPrime(first);
                break;
            }
            case -101: {
                Node first = this.parseSuperExpression();
                first = this.parsePropertyOperator(first);
                result = this.parseFullNewSubexpressionPrime(first);
                break;
            }
            case -13: {
                Node first = this.parsePrimaryExpressionOrExpressionQualifiedIdentifier();
                result = this.parseFullNewSubexpressionPrime(first);
                break;
            }
            case -117: 
            case -99: 
            case -97: 
            case -96: 
            case -95: 
            case -89: 
            case -79: 
            case -68: 
            case -28: 
            case -15: {
                MemberExpressionNode first = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(this.parseQualifiedIdentifier()));
                result = this.parseFullNewSubexpressionPrime(first);
                break;
            }
            default: {
                Node first = this.parsePrimaryExpression();
                result = this.parseFullNewSubexpressionPrime(first);
            }
        }
        return result;
    }

    private Node parseFullNewSubexpressionPrime(Node first) {
        Node result = first;
        int lt = this.lookahead();
        if (lt == -18 || lt == -29 || lt == -21 || Features.HAS_DESCENDOPERATORS && lt == -19 || lt == -28) {
            first = this.parsePropertyOperator(first);
            result = this.parseFullNewSubexpressionPrime(first);
        }
        return result;
    }

    private Node parseShortNewExpression() {
        this.match(-92);
        Node result = -45 == this.lookahead() ? this.parseVectorLiteral() : this.parseShortNewSubexpression();
        return result;
    }

    private Node parseShortNewSubexpression() {
        Node result;
        if (this.lookahead() == -92) {
            result = this.parseShortNewExpression();
            if (this.lookahead() == -13) {
                result = this.parseArguments(result);
            }
            result = this.nodeFactory.newExpression(result);
        } else {
            result = this.parseFullNewSubexpression();
        }
        return result;
    }

    private Node parsePropertyOperator(Node first) {
        Node result = null;
        int lt = this.lookahead();
        if (lt == -18) {
            this.shift();
            if (this.lookahead() == -13) {
                this.shift();
                result = this.nodeFactory.filterOperator(first, this.parseExpressionList(-137), first.pos());
                this.match(-14);
            } else {
                result = this.nodeFactory.memberExpression(first, this.nodeFactory.getExpression(this.parseQualifiedIdentifier()));
            }
        } else if (lt == -29) {
            result = this.parseBrackets(first);
        } else if (lt == -19) {
            this.shift();
            GetExpressionNode selector = this.nodeFactory.getExpression(this.parseQualifiedIdentifier());
            selector.setMode(-19);
            result = this.nodeFactory.memberExpression(first, selector);
        } else if (lt == -21) {
            result = this.parseTemplatizedTypeExpression(first);
        }
        return result;
    }

    private MemberExpressionNode parseBrackets(Node first) {
        ArgumentListNode second;
        this.match(-29);
        if (this.lookahead() == -30) {
            this.error(1099);
            second = null;
        } else {
            second = this.parseArgumentsWithRest(-137);
            second.is_bracket_selector = true;
        }
        this.match(-30);
        MemberExpressionNode result = this.nodeFactory.indexedMemberExpression(first, this.nodeFactory.getExpression(second));
        return result;
    }

    private Node parseArguments(Node first) {
        this.match(-13);
        ArgumentListNode args = this.lookahead() == -14 ? null : this.parseArgumentsWithRest(-137);
        this.match(-14);
        Node result = this.nodeFactory.callExpression(first, args);
        return result;
    }

    private ArgumentListNode parseArgumentsWithRest(int mode) {
        ArgumentListNode result = null;
        while (true) {
            Node t = null;
            if (this.lookahead() == -20) {
                this.shift();
                t = this.nodeFactory.restExpression(this.parseAssignmentExpression(-137));
            } else {
                t = this.parseAssignmentExpression(mode);
            }
            if (t != null) {
                result = this.nodeFactory.argumentList(result, t);
            }
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    private Node parseUnaryExpression() {
        Node result = null;
        int op = this.lookahead();
        switch (op) {
            case -69: {
                this.shift();
                this.lookahead();
                result = this.nodeFactory.unaryExpression(op, this.parsePostfixExpression(), this.scanner.input.positionOfMark());
                break;
            }
            case -110: 
            case -43: 
            case -42: 
            case -41: 
            case -4: 
            case -3: {
                this.shift();
                this.lookahead();
                result = this.nodeFactory.unaryExpression(op, this.parseUnaryExpression(), this.scanner.input.positionOfMark());
                break;
            }
            case -113: {
                this.shift();
                int la = this.lookahead();
                int pos = this.scanner.input.positionOfMark();
                result = la == -17 || la == -26 || la == -14 ? this.nodeFactory.unaryExpression(op, this.nodeFactory.literalNumber("0", pos), pos) : this.nodeFactory.unaryExpression(op, this.parseUnaryExpression(), pos);
                break;
            }
            case -2: {
                this.shift();
                if (this.lookahead() == -121) {
                    this.shift();
                    LiteralNumberNode lit = this.nodeFactory.literalNumber(this.scanner.getCurrentTokenText(), this.scanner.input.positionOfMark());
                    result = this.nodeFactory.unaryExpression(op, lit, this.scanner.input.positionOfMark());
                    break;
                }
                result = this.nodeFactory.unaryExpression(op, this.parseUnaryExpression(), this.scanner.input.positionOfMark());
                break;
            }
            default: {
                result = this.parsePostfixExpression();
            }
        }
        return result;
    }

    private Node parseConditionalExpression(int mode) {
        Node first;
        Node result = first = this.parseBinaryExpression(mode, 4);
        if (this.lookahead() == -27) {
            this.shift();
            Node second = this.parseAssignmentExpression(mode);
            this.match(-24);
            Node third = this.parseAssignmentExpression(mode);
            result = this.nodeFactory.conditionalExpression(first, second, third);
        }
        return result;
    }

    private Node parseNonAssignmentExpression(int mode) {
        Node first;
        Node result = first = this.parseBinaryExpression(mode, 4);
        if (this.lookahead() == -27) {
            this.shift();
            Node second = this.parseNonAssignmentExpression(mode);
            this.match(-24);
            Node third = this.parseNonAssignmentExpression(mode);
            result = this.nodeFactory.conditionalExpression(first, second, third);
        }
        return result;
    }

    private Node parseAssignmentExpression(int mode) {
        Node first = this.parseConditionalExpression(mode);
        Node result = this.parseAssignmentExpressionSuffix(mode, first);
        return result;
    }

    private Node parseAssignmentExpressionSuffix(int mode, Node first) {
        Node result = first;
        int lt = this.lookahead();
        switch (lt) {
            case -38: 
            case -33: 
            case -11: {
                if (!Features.HAS_LOGICALASSIGNMENT) break;
            }
            case -58: 
            case -56: 
            case -50: 
            case -49: 
            case -47: 
            case -44: 
            case -39: 
            case -34: 
            case -23: 
            case -16: 
            case -12: 
            case -8: {
                this.shift();
                Node third = this.parseAssignmentExpression(mode);
                result = this.nodeFactory.assignmentExpression(first, lt, third);
            }
        }
        return result;
    }

    private ListNode parseExpressionList(int mode) {
        ListNode result = null;
        while (true) {
            Node t;
            if ((t = this.parseAssignmentExpression(mode)) != null) {
                result = this.nodeFactory.list(result, t);
            }
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    private ListNode parseListExpressionPrime(int mode, ListNode list) {
        ListNode result = list;
        while (this.lookahead() == -17) {
            this.shift();
            Node t = this.parseAssignmentExpression(mode);
            this.nodeFactory.list(list, t);
        }
        return result;
    }

    private IdentifierNode parseNonAttributeQualifiedExpression() {
        IdentifierNode result = this.lookahead() == -13 ? this.parseExpressionQualifiedIdentifier() : this.parseSimpleQualifiedIdentifier();
        return result;
    }

    private Node parseSimpleTypeIdentifier() {
        MemberExpressionNode result = null;
        while (true) {
            IdentifierNode t;
            if ((t = this.parseNonAttributeQualifiedExpression()) != null) {
                int pos = t.pos();
                result = this.nodeFactory.memberExpression(result, this.nodeFactory.getExpression((Node)t, pos), pos);
            }
            if (this.lookahead() != -18) break;
            this.shift();
        }
        return result;
    }

    private final Node parseTemplatizedTypeExpression(Node first) {
        this.shift();
        Node result = this.nodeFactory.applyTypeExpr(first, this.parseTypeExpressionList(), this.scanner.input.positionOfMark());
        int lt = this.lookahead();
        switch (lt) {
            case -58: {
                this.changeLookahead(-56);
                break;
            }
            case -57: {
                this.changeLookahead(-55);
                break;
            }
            case -55: {
                this.changeLookahead(-53);
                break;
            }
            case -56: {
                this.changeLookahead(-54);
                break;
            }
            case -54: {
                this.changeLookahead(-49);
                break;
            }
            default: {
                this.match(-53);
            }
        }
        return result;
    }

    private Node parseTypename() {
        Node first;
        Node result = first = this.parseSimpleTypeIdentifier();
        if (this.lookahead() == -21) {
            result = this.parseTemplatizedTypeExpression(first);
        }
        return result;
    }

    private ListNode parseTypenameList() {
        ListNode result = null;
        while (true) {
            Node t;
            if ((t = this.parseTypename()) != null) {
                result = this.nodeFactory.list(result, t);
            }
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    private Node parseTypeExpression(int mode) {
        TypeExpressionNode result;
        if (this.ctx.dialect(7) && this.nextToken == -117 && this.scanner.getCurrentTokenText().equals("Object")) {
            this.match(-117);
            result = null;
        } else {
            Node first = this.parseTypename();
            boolean is_nullable = true;
            boolean is_explicit = false;
            int lt = this.lookahead();
            if (lt == -4) {
                this.shift();
                is_nullable = false;
                is_explicit = true;
            } else if (lt == -27) {
                this.shift();
                is_nullable = true;
                is_explicit = true;
            }
            result = this.nodeFactory.typeExpression(first, is_nullable, is_explicit, -1);
        }
        return result;
    }

    private Node parseStatement(int mode) {
        Node result;
        int lt = this.lookahead();
        switch (lt) {
            case -101: {
                result = this.parseSuperStatement(mode);
                break;
            }
            case -35: {
                StatementListNode sln = this.parseBlock();
                result = sln;
                break;
            }
            case -129: 
            case -122: 
            case -29: {
                result = this.parseMetaData();
                break;
            }
            case -81: {
                result = this.parseIfStatement(mode);
                break;
            }
            case -102: {
                result = this.parseSwitchStatement();
                break;
            }
            case -70: {
                result = this.parseDoStatement();
                this.matchSemicolon(mode);
                break;
            }
            case -115: {
                result = this.parseWhileStatement(mode);
                break;
            }
            case -77: {
                result = this.parseForStatement(mode);
                break;
            }
            case -116: {
                result = this.parseWithStatement(mode);
                break;
            }
            case -66: {
                result = this.parseContinueStatement();
                this.matchSemicolon(mode);
                break;
            }
            case -61: {
                result = this.parseBreakStatement();
                this.matchSemicolon(mode);
                break;
            }
            case -98: {
                result = this.parseReturnStatement();
                this.matchSemicolon(mode);
                break;
            }
            case -105: {
                result = this.parseThrowStatement();
                this.matchSemicolon(mode);
                break;
            }
            case -109: {
                result = this.parseTryStatement();
                break;
            }
            default: {
                result = this.parseLabeledOrExpressionStatement(mode);
                if (result.isLabeledStatement()) break;
                this.matchSemicolon(mode);
            }
        }
        return result;
    }

    private Node parseSubstatement(int mode) {
        Node result;
        int lt = this.lookahead();
        if (lt == -26) {
            this.shift();
            result = this.nodeFactory.emptyStatement();
        } else if (lt == -112) {
            result = this.parseVariableDefinition(null, mode);
            this.matchSemicolon(mode);
        } else {
            result = this.parseAnnotatedSubstatementsOrStatement(mode);
        }
        return result;
    }

    private Node parseSuperStatement(int mode) {
        Node result;
        this.shift();
        SuperExpressionNode first = this.nodeFactory.superExpression(null, this.scanner.input.positionOfMark());
        if (this.lookahead() == -13) {
            CallExpressionNode call = (CallExpressionNode)this.parseArguments(first);
            if (this.lookaheadSemicolon(mode)) {
                result = this.nodeFactory.superStatement(call);
                this.matchSemicolon(mode);
            } else {
                if (call == null || call.args == null || call.args.size() != 1) {
                    this.error(1079);
                } else {
                    first.expr = (Node)call.args.items.get(0);
                }
                Node t = this.parseFullPostfixExpressionPrime(first);
                result = this.nodeFactory.expressionStatement(this.parseListExpressionPrime(mode, this.nodeFactory.list(null, t)));
                this.matchSemicolon(mode);
            }
        } else if (this.lookahead() == -18 || this.lookahead() == -29) {
            Node t = this.parseFullPostfixExpressionPrime(first);
            if (this.lookahead() == -49) {
                t = this.parseAssignmentExpressionSuffix(mode, t);
            }
            result = this.nodeFactory.expressionStatement(this.parseListExpressionPrime(mode, this.nodeFactory.list(null, t)));
            this.matchSemicolon(mode);
        } else {
            this.error(ParseError.EOS, 1084, Token.getTokenClassName(-13), this.scanner.getCurrentTokenTextOrTypeText(this.lookahead()));
            result = this.nodeFactory.error(1084);
            this.skiperror(-26);
        }
        return result;
    }

    private Node parseLabeledOrExpressionStatement(int mode) {
        Node result;
        ListNode first = this.parseExpressionList(-137);
        if (this.lookahead() == -24) {
            if (!first.isLabel()) {
                this.error(1078);
            }
            this.shift();
            result = this.nodeFactory.labeledStatement(first, this.parseSubstatement(mode));
        } else {
            result = this.nodeFactory.expressionStatement(first);
        }
        return result;
    }

    private StatementListNode parseBlock() {
        return this.parseBlock(null);
    }

    private StatementListNode parseBlock(AttributeListNode first) {
        this.match(-35);
        StatementListNode result = this.parseDirectives(first, null);
        this.match(-40);
        return result;
    }

    public MetaDataNode parseMetaData() {
        MetaDataNode result;
        int pos = this.scanner.input.positionOfMark();
        if (this.lookahead() == -129) {
            this.shift();
            ListNode list = this.nodeFactory.list(null, this.nodeFactory.literalString(this.scanner.getCurrentTokenText(), pos));
            LiteralXMLNode first = this.nodeFactory.literalXML(list, false, pos);
            MemberExpressionNode x = this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(first), pos);
            result = this.nodeFactory.docComment(this.nodeFactory.literalArray(this.nodeFactory.argumentList(null, x), pos), pos);
        } else {
            result = this.lookahead() == -122 ? this.nodeFactory.metaData(this.nodeFactory.literalArray(this.nodeFactory.argumentList(null, this.parseXMLLiteral())), pos) : this.nodeFactory.metaData(this.parseArrayLiteral(), pos);
        }
        return result;
    }

    private Node parseIfStatement(int mode) {
        this.shift();
        ListNode first = this.parseParenExpressionList();
        Node second = this.parseSubstatement(-71);
        Node third = null;
        if (this.lookahead() == -71) {
            this.shift();
            third = this.parseSubstatement(mode);
        }
        Node result = this.nodeFactory.ifStatement(first, second, third);
        return result;
    }

    private Node parseSwitchStatement() {
        this.shift();
        ListNode first = this.parseParenExpressionList();
        this.match(-35);
        StatementListNode second = this.parseCaseStatements();
        this.match(-40);
        SwitchStatementNode result = this.nodeFactory.switchStatement(first, second);
        return result;
    }

    private Node parseCaseLabel() {
        CaseLabelNode result = null;
        int lt = this.lookahead();
        if (lt == -62) {
            this.shift();
            result = this.nodeFactory.caseLabel(this.parseExpressionList(-137), this.scanner.input.positionOfMark());
        } else if (lt == -68) {
            this.shift();
            result = this.nodeFactory.caseLabel(null, this.scanner.input.positionOfMark());
        } else {
            this.error(1077);
            this.skiperror(-40);
        }
        this.match(-24);
        return result;
    }

    private StatementListNode parseCaseStatements() {
        StatementListNode result = null;
        int lt = this.lookahead();
        if (lt != -40 && lt != -1) {
            result = this.nodeFactory.statementList(null, this.parseCaseLabel());
            lt = this.lookahead();
            while (lt != -40 && lt != -1) {
                Node t = lt == -62 || lt == -68 ? this.parseCaseLabel() : this.parseDirective(null, -136);
                result = this.nodeFactory.statementList(result, t);
                lt = this.lookahead();
            }
        }
        return result;
    }

    private Node parseDoStatement() {
        this.shift();
        Node first = this.parseSubstatement(-115);
        this.match(-115);
        DoStatementNode result = this.nodeFactory.doStatement(first, this.parseParenExpressionList());
        return result;
    }

    private Node parseWhileStatement(int mode) {
        this.shift();
        ListNode first = this.parseParenExpressionList();
        Node second = this.parseSubstatement(mode);
        WhileStatementNode result = this.nodeFactory.whileStatement(first, second);
        return result;
    }

    private Node parseForStatement(int mode) {
        Node result;
        boolean is_each = false;
        this.shift();
        if (this.lookahead() == -117) {
            this.shift();
            if (!this.scanner.getCurrentTokenText().equals("each")) {
                this.error(1076);
            }
            is_each = true;
        }
        this.match(-13);
        int lt = this.lookahead();
        Node first = lt == -26 ? null : (lt == -65 || lt == -112 ? this.parseVariableDefinition(null, -138) : (is_each ? this.nodeFactory.list(null, this.parsePostfixExpression()) : this.parseExpressionList(-138)));
        if (this.lookahead() == -84) {
            if (first instanceof VariableDefinitionNode && ((VariableDefinitionNode)first).list.size() > 1) {
                this.error(1200);
            } else if (first instanceof ListNode && ((ListNode)first).size() > 1) {
                this.error(1200);
            }
            this.match(-84);
            ListNode second = this.parseExpressionList(-137);
            this.match(-14);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.forInStatement(is_each, first, second, this.parseSubstatement(mode), pos);
        } else if (this.lookahead() == -24) {
            this.match(-84);
            this.skiperror(-35);
            result = this.parseSubstatement(mode);
        } else {
            if (is_each) {
                this.error(1075);
            }
            this.match(-26);
            ListNode second = this.lookahead() == -26 ? null : this.parseExpressionList(-137);
            this.match(-26);
            ListNode third = this.lookahead() == -14 ? null : this.parseExpressionList(-137);
            this.match(-14);
            int pos = this.scanner.input.positionOfMark();
            result = this.nodeFactory.forStatement(first, second, third, this.parseSubstatement(mode), false, pos);
        }
        return result;
    }

    private Node parseWithStatement(int mode) {
        int pos = this.scanner.input.positionOfMark();
        this.shift();
        ListNode first = this.parseParenExpressionList();
        WithStatementNode result = this.nodeFactory.withStatement(first, this.parseSubstatement(mode), pos);
        return result;
    }

    private Node parseContinueStatement() {
        IdentifierNode first = null;
        this.shift();
        if (!this.lookaheadSemicolon(-136)) {
            first = this.parseIdentifier();
        }
        ContinueStatementNode result = this.nodeFactory.continueStatement(first, this.scanner.input.positionOfMark());
        return result;
    }

    private Node parseBreakStatement() {
        IdentifierNode first = null;
        this.shift();
        if (!this.lookaheadSemicolon(-136)) {
            first = this.parseIdentifier();
        }
        BreakStatementNode result = this.nodeFactory.breakStatement(first, this.scanner.input.positionOfMark());
        return result;
    }

    private Node parseReturnStatement() {
        ListNode first = null;
        this.shift();
        if (!this.lookaheadSemicolon(-136)) {
            first = this.parseExpressionList(-137);
        }
        ReturnStatementNode result = this.nodeFactory.returnStatement(first, this.scanner.input.positionOfMark());
        return result;
    }

    private Node parseThrowStatement() {
        ThrowStatementNode result;
        int pos = this.scanner.input.positionOfMark();
        this.shift();
        this.lookahead();
        if (this.scanner.followsLineTerminator()) {
            this.error(ParseError.syntax, 1196, "", "", pos);
            result = this.nodeFactory.throwStatement(null, pos);
        } else {
            result = this.nodeFactory.throwStatement(this.parseExpressionList(-137), pos);
        }
        return result;
    }

    private Node parseTryStatement() {
        TryStatementNode result;
        this.shift();
        StatementListNode first = this.parseBlock();
        if (this.lookahead() == -63) {
            StatementListNode second = this.parseCatchClauses();
            result = this.lookahead() == -76 ? this.nodeFactory.tryStatement(first, second, this.parseFinallyClause()) : this.nodeFactory.tryStatement(first, second, null);
        } else if (this.lookahead() == -76) {
            StatementListNode catchClause = this.nodeFactory.statementList(null, this.nodeFactory.catchClause(null, this.nodeFactory.statementList(null, this.nodeFactory.throwStatement(null, 0))));
            result = this.nodeFactory.tryStatement(first, catchClause, this.parseFinallyClause());
        } else {
            this.error(1073);
            this.skiperror(-26);
            result = null;
        }
        return result;
    }

    private StatementListNode parseCatchClauses() {
        StatementListNode result = this.nodeFactory.statementList(null, this.parseCatchClause());
        while (this.lookahead() == -63) {
            result = this.nodeFactory.statementList(result, this.parseCatchClause());
        }
        return result;
    }

    private Node parseCatchClause() {
        this.shift();
        this.match(-13);
        ParameterNode first = this.parseParameter();
        this.match(-14);
        CatchClauseNode result = this.nodeFactory.catchClause(first, this.parseBlock());
        return result;
    }

    private FinallyClauseNode parseFinallyClause() {
        this.shift();
        FinallyClauseNode result = this.nodeFactory.finallyClause(this.parseBlock());
        return result;
    }

    private Node parseDirective(AttributeListNode first, int mode) {
        Node result = null;
        try {
            int lt = this.lookahead();
            switch (lt) {
                case -26: {
                    this.matchNoninsertableSemicolon(mode);
                    result = this.nodeFactory.emptyStatement();
                    break;
                }
                case -87: {
                    if (!Features.HAS_INTERFACEDEFINITIONS) {
                        result = this.parseAnnotatedDirectiveOrStatement(mode);
                        break;
                    }
                }
                case -112: 
                case -111: 
                case -89: 
                case -85: 
                case -83: 
                case -78: 
                case -65: 
                case -64: {
                    result = this.parseAnnotatableDirectiveOrPragmaOrInclude(first, mode);
                    break;
                }
                case -68: {
                    this.shift();
                    if (this.match(-117) == -117 && !this.scanner.getCurrentTokenText().equals("xml") && this.lookahead() == -89) {
                        this.error(1072);
                    }
                    this.match(-89);
                    this.match(-49);
                    result = this.nodeFactory.defaultXMLNamespace(this.parseNonAssignmentExpression(-137), 0);
                    break;
                }
                default: {
                    result = this.parseAnnotatedDirectiveOrStatement(mode);
                    break;
                }
            }
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    private Node parseAnnotatedDirectiveOrStatement(int mode) {
        Node result = null;
        int lt = this.lookahead();
        if (this.inStatementTokenSet(lt)) {
            result = this.parseStatement(mode);
        } else {
            Node temp;
            if (Features.HAS_SQUAREBRACKETATTRS && lt == -29) {
                this.shift();
                temp = this.parseAssignmentExpression(-137);
                this.match(-30);
            } else {
                temp = this.parseLabeledOrExpressionStatement(mode);
            }
            if (temp.isLabeledStatement()) {
                result = temp;
            } else {
                String directiveString = this.scanner.getCurrentTokenTextOrTypeText(this.nextToken);
                if (this.lookaheadSemicolon(mode) && !temp.isConfigurationName()) {
                    boolean is_attribute_keyword;
                    this.matchSemicolon(mode);
                    result = temp;
                    if (temp instanceof ExpressionStatementNode) {
                        temp = ((ExpressionStatementNode)temp).expr;
                    }
                    if (is_attribute_keyword = this.checkAttribute(temp)) {
                        this.error(ParseError.syntax, 1071, this.which_attribute(temp), directiveString);
                    }
                } else if (temp.isAttribute()) {
                    AttributeListNode first;
                    ExpressionStatementNode estmt = null;
                    if (temp instanceof ExpressionStatementNode) {
                        estmt = (ExpressionStatementNode)temp;
                        temp = estmt.expr;
                    }
                    boolean is_attribute_keyword = this.checkAttribute(temp);
                    switch (this.lookahead()) {
                        case -117: 
                        case -108: 
                        case -97: 
                        case -96: 
                        case -95: 
                        case -74: {
                            first = this.nodeFactory.attributeList(temp, this.parseAttributeList());
                            break;
                        }
                        default: {
                            first = this.nodeFactory.attributeList(temp, null);
                        }
                    }
                    lt = this.lookahead();
                    switch (lt) {
                        case -129: 
                        case -112: 
                        case -111: 
                        case -89: 
                        case -87: 
                        case -83: 
                        case -78: 
                        case -65: 
                        case -64: {
                            result = this.parseAnnotatableDirectiveOrPragmaOrInclude(first, mode);
                            break;
                        }
                        default: {
                            if (temp.isConfigurationName() && lt == -35) {
                                result = this.parseAnnotatableDirectiveOrPragmaOrInclude(first, mode);
                                break;
                            }
                            if (lt == -94) {
                                this.error(1198);
                                result = this.parsePackageDefinition();
                                break;
                            }
                            if (is_attribute_keyword || first.size() > 1) {
                                this.error(ParseError.syntax, 1071, this.which_attribute(temp), directiveString);
                                this.skiperror(-26);
                                break;
                            }
                            if (temp.isConfigurationName()) {
                                result = estmt;
                                break;
                            }
                            result = estmt;
                            break;
                        }
                    }
                } else if (this.ctx.errorCount() == 0) {
                    this.matchSemicolon(mode);
                }
            }
        }
        return result;
    }

    private Node parseAnnotatedSubstatementsOrStatement(int mode) {
        Node result = null;
        if (this.inStatementTokenSet(this.lookahead())) {
            result = this.parseStatement(mode);
        } else {
            Node t = this.parseLabeledOrExpressionStatement(mode);
            if (t.isLabeledStatement()) {
                result = t;
                if (this.lookahead() == -26) {
                    this.shift();
                }
            } else if (this.lookaheadSemicolon(mode)) {
                this.matchSemicolon(mode);
                result = t;
            } else if (t.isAttribute()) {
                this.error(1008);
            } else {
                this.match(-26);
            }
        }
        return result;
    }

    private Node parseAnnotatableDirectiveOrPragmaOrInclude(AttributeListNode first, int mode) {
        Node result = null;
        int lt = this.lookahead();
        switch (lt) {
            case -112: 
            case -65: {
                result = this.parseVariableDefinition(first, mode);
                this.matchSemicolon(mode);
                break;
            }
            case -78: {
                result = this.parseFunctionDefinition(first);
                break;
            }
            case -64: {
                result = this.parseClassDefinition(first, mode);
                break;
            }
            case -87: {
                result = this.parseInterfaceDefinition(first, mode);
                break;
            }
            case -89: {
                result = this.parseNamespaceDefinition(first);
                this.matchSemicolon(mode);
                break;
            }
            case -83: {
                result = this.parseImportDirective(first);
                this.matchSemicolon(mode);
                break;
            }
            case -111: {
                result = this.parseUseDirective(first);
                this.matchSemicolon(mode);
                break;
            }
            case -85: {
                result = this.parseIncludeDirective();
                this.matchSemicolon(mode);
                break;
            }
            case -35: {
                StatementListNode stmts = this.parseBlock();
                stmts.config_attrs = first;
                result = stmts;
                this.matchSemicolon(mode);
                break;
            }
            default: {
                this.error(1069);
                this.skiperror(-26);
            }
        }
        return result;
    }

    public StatementListNode parseDirectives(AttributeListNode first, StatementListNode list) {
        Node t;
        int lt;
        StatementListNode result = null;
        while ((lt = this.lookahead()) != -40 && lt != -1 && (t = this.parseDirective(first, -135)) != null) {
            if (t instanceof StatementListNode) {
                StatementListNode sln = (StatementListNode)t;
                if (sln.config_attrs == null && !sln.has_pragma) {
                    if (list == null) {
                        list = sln;
                        continue;
                    }
                    list.items.addAll(sln.items);
                    continue;
                }
                list = this.nodeFactory.statementList(list, t);
                continue;
            }
            list = this.nodeFactory.statementList(list, t);
        }
        result = list;
        return result;
    }

    private Node parseUseDirective(AttributeListNode first) {
        Node result = null;
        this.shift();
        if (this.lookahead() == -89) {
            this.shift();
            result = this.nodeFactory.useDirective(first, this.parseNonAssignmentExpression(-137));
        } else if (this.lookahead() == -85) {
            result = this.parseIncludeDirective();
        } else if (this.ctx.statics.es4_numerics) {
            result = this.nodeFactory.pragma(this.parsePragmaItemList(-137), this.scanner.input.positionOfMark());
        } else {
            this.error(1043);
        }
        return result;
    }

    private Node parsePragmaItem(int mode) {
        Node argument;
        IdentifierNode id = this.parseIdentifier();
        int lt = this.lookahead();
        int pos = this.scanner.input.positionOfMark();
        if (lt == -17 || this.lookaheadSemicolon(mode)) {
            argument = null;
        } else if (lt == -108) {
            this.shift();
            argument = this.nodeFactory.literalBoolean(true, pos);
        } else if (lt == -74) {
            this.shift();
            argument = this.nodeFactory.literalBoolean(false, pos);
        } else if (lt == -118) {
            this.shift();
            argument = this.nodeFactory.literalNumber(this.scanner.getCurrentTokenText(), pos);
        } else if (lt == -120) {
            boolean[] is_single_quoted = new boolean[1];
            this.shift();
            String enclosedText = this.scanner.getCurrentStringTokenText(is_single_quoted);
            argument = this.nodeFactory.literalString(enclosedText, pos, is_single_quoted[0]);
        } else {
            argument = this.parseIdentifier();
        }
        UsePragmaNode result = this.nodeFactory.usePragma(id, argument, this.scanner.input.positionOfMark());
        return result;
    }

    private ListNode parsePragmaItemList(int mode) {
        ListNode result = null;
        while (true) {
            Node t;
            if ((t = this.parsePragmaItem(mode)) != null) {
                result = this.nodeFactory.list(result, t);
            }
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseIncludeDirective() {
        IncludeDirectiveNode result;
        this.shift();
        boolean[] is_single_quoted = new boolean[1];
        String filespec = null;
        if (this.lookahead() == -120) {
            this.shift();
            filespec = this.scanner.getCurrentStringTokenText(is_single_quoted).trim();
        } else {
            this.match(-120);
        }
        CompilerHandler.FileInclude incl = null;
        if (this.ctx.handler != null) {
            incl = this.ctx.handler.findFileInclude(this.ctx.path(), filespec);
        }
        InputStream in = null;
        String text = null;
        String fixed_filespec = null;
        String parentPath = null;
        if (incl == null) {
            File inc_file = new File(filespec = filespec.replace('/', File.separatorChar));
            fixed_filespec = inc_file.isAbsolute() ? inc_file.getAbsolutePath() : (this.ctx.path() == null ? "" : this.ctx.path()) + File.separator + filespec;
            try {
                fixed_filespec = new File(fixed_filespec).getCanonicalPath();
            }
            catch (IOException ex) {
                fixed_filespec = new File(fixed_filespec).getAbsolutePath();
            }
            parentPath = fixed_filespec.substring(0, fixed_filespec.lastIndexOf(File.separator));
            if (!this.ctx.scriptAssistParsing) {
                try {
                    in = new BufferedInputStream(new FileInputStream(fixed_filespec));
                }
                catch (FileNotFoundException ex) {
                    this.error(ParseError.syntax, 1068, fixed_filespec);
                    return null;
                }
            }
        } else {
            fixed_filespec = incl.fixed_filespec;
            parentPath = incl.parentPath;
            in = incl.in;
            text = incl.text;
        }
        if (this.ctx.statics.includePaths.contains(fixed_filespec)) {
            this.error(ParseError.syntax, 1112, fixed_filespec);
            try {
                in.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return null;
        }
        this.ctx.statics.includePaths.push_back(fixed_filespec);
        String oldCtxPathSpec = this.ctx.path();
        this.ctx.setPath(parentPath);
        LiteralStringNode first = this.nodeFactory.literalString(fixed_filespec, this.scanner.input.positionOfMark(), is_single_quoted[0]);
        ProgramNode second = null;
        if (!this.ctx.scriptAssistParsing) {
            Context cx = new Context(this.ctx.statics);
            try {
                Parser p = null;
                if (in != null) {
                    p = new Parser(cx, in, fixed_filespec, this.encoding, this.create_doc_info, this.save_comment_nodes, this.block_kind_stack, true);
                    p.config_namespaces = this.config_namespaces;
                    second = p.parseProgram();
                } else {
                    p = new Parser(cx, text, fixed_filespec, this.create_doc_info, this.save_comment_nodes, this.block_kind_stack, true);
                    p.config_namespaces = this.config_namespaces;
                    second = p.parseProgram();
                }
            }
            finally {
                this.ctx.setPath(oldCtxPathSpec);
                this.ctx.statics.includePaths.removeLast();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
            result = this.nodeFactory.includeDirective(cx, first, second);
        } else {
            result = this.nodeFactory.includeDirective(this.ctx, first, second);
        }
        return result;
    }

    private boolean checkAttribute(Node node) {
        int token_id = this.block_kind_stack.last();
        if (token_id != -134 && token_id != -64 && token_id != -87) {
            if (node.hasAttribute("private")) {
                this.ctx.error(node.pos(), 1013);
            } else if (node.hasAttribute("protected")) {
                this.ctx.error(node.pos(), 1150);
            } else if (node.hasAttribute("static")) {
                this.ctx.error(node.pos(), 1012);
            } else if (token_id != -94 && token_id != -133 && node.hasAttribute("internal")) {
                this.ctx.error(node.pos(), 1115);
            } else if (token_id != -94 && node.hasAttribute("public")) {
                this.ctx.error(node.pos(), 1114);
            }
        }
        if (node.hasAttribute("prototype")) {
            this.ctx.error(node.pos(), 1194);
        }
        return node.hasAttribute("static") || node.hasAttribute("public") || node.hasAttribute("private") || node.hasAttribute("protected") || node.hasAttribute("internal") || node.hasAttribute("native") || node.hasAttribute("final") || node.hasAttribute("override") || node.hasAttribute("prototype");
    }

    private String which_attribute(Node t) {
        Node t1;
        if (t.isList() && (t1 = (Node)((ListNode)t).items.get(0)).isMemberExpression()) {
            MemberExpressionNode m1 = (MemberExpressionNode)t1;
            IdentifierNode t2 = m1.selector.getIdentifier();
            if (t2 != null) {
                return t2.toIdentifierString();
            }
        }
        if (t.hasAttribute("static")) {
            return "static";
        }
        if (t.hasAttribute("public")) {
            return "public";
        }
        if (t.hasAttribute("private")) {
            return "private";
        }
        if (t.hasAttribute("protected")) {
            return "protected";
        }
        if (t.hasAttribute("internal")) {
            return "internal";
        }
        if (t.hasAttribute("native")) {
            return "native";
        }
        if (t.hasAttribute("final")) {
            return "final";
        }
        if (t.hasAttribute("override")) {
            return "override";
        }
        if (t.hasAttribute("prototype")) {
            return "prototype";
        }
        return "<unknown>";
    }

    private AttributeListNode parseAttributeList() {
        AttributeListNode result = null;
        while (true) {
            int lt = this.lookahead();
            Node t = null;
            int pos = this.scanner.input.positionOfMark();
            switch (lt) {
                case -108: {
                    this.shift();
                    t = this.nodeFactory.literalBoolean(true, pos);
                    break;
                }
                case -74: {
                    this.shift();
                    t = this.nodeFactory.literalBoolean(false, pos);
                    break;
                }
                case -95: {
                    this.shift();
                    t = this.nodeFactory.identifier(PRIVATE, false, pos);
                    if (this.lookahead() != -25) break;
                    this.shift();
                    t = this.nodeFactory.qualifiedIdentifier(t, this.parseIdentifierString(), this.scanner.input.positionOfMark());
                    break;
                }
                case -96: {
                    this.shift();
                    t = this.nodeFactory.identifier(PROTECTED, false, pos);
                    if (this.lookahead() != -25) break;
                    this.shift();
                    t = this.nodeFactory.qualifiedIdentifier(t, this.parseIdentifierString(), this.scanner.input.positionOfMark());
                    break;
                }
                case -97: {
                    this.shift();
                    t = this.nodeFactory.identifier(PUBLIC, false, pos);
                    if (this.lookahead() != -25) break;
                    this.shift();
                    t = this.nodeFactory.qualifiedIdentifier(t, this.parseIdentifierString(), this.scanner.input.positionOfMark());
                    break;
                }
                case -29: {
                    t = this.parseArrayLiteral();
                    break;
                }
                case -117: {
                    t = this.parseSimpleTypeIdentifier();
                    break;
                }
                default: {
                    t = null;
                }
            }
            if (t == null) break;
            this.checkAttribute(t);
            result = this.nodeFactory.attributeList(t, result);
        }
        return result;
    }

    private Node parseImportDirective(AttributeListNode first) {
        PackageNameNode third = null;
        int stmtPos = this.scanner.input.positionOfMark();
        this.shift();
        PackageNameNode second = this.parsePackageName(true);
        if (this.lookahead() == -49) {
            third = this.parsePackageName(true);
        }
        ImportDirectiveNode result = this.nodeFactory.importDirective(first, second, third, stmtPos, this.ctx);
        return result;
    }

    private Node parseVariableDefinition(AttributeListNode first, int mode) {
        int lt = this.lookahead();
        int kind = -112;
        if (lt == -65) {
            kind = -65;
            this.shift();
        } else if (lt == -112) {
            this.shift();
        }
        ListNode t = this.parseVariableBindingList(first, kind, mode);
        VariableDefinitionNode result = this.nodeFactory.variableDefinition(first, kind, t);
        return result;
    }

    private ListNode parseVariableBindingList(AttributeListNode attrs, int kind, int mode) {
        ListNode result = null;
        while (true) {
            Node t;
            if ((t = this.parseVariableBinding(attrs, kind, mode)) != null) {
                result = this.nodeFactory.list(result, t);
            }
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    private Node parseVariableBinding(AttributeListNode attrs, int kind, int mode) {
        TypedIdentifierNode first = this.parseTypedIdentifier(mode);
        Node second = this.parseVariableInitialization(mode);
        VariableBindingNode result = this.nodeFactory.variableBinding(attrs, kind, first, second);
        return result;
    }

    private Node parseVariableInitialization(int mode) {
        Node result = null;
        if (this.lookahead() == -49) {
            this.shift();
            Node t = this.parseAssignmentExpression(mode);
            if (this.lookahead() == -17 || this.lookaheadSemicolon(mode) || this.ctx.scriptAssistParsing && this.lookahead() == -84) {
                result = t;
            }
        }
        return result;
    }

    private TypedIdentifierNode parseTypedIdentifier(int mode) {
        IdentifierNode first = this.parseIdentifier();
        Node second = null;
        boolean no_anno = true;
        if (this.lookahead() == -24) {
            this.shift();
            no_anno = false;
            int lt = this.lookahead();
            if (lt == -15 || lt == -16) {
                if (lt == -15) {
                    this.shift();
                } else {
                    this.changeLookahead(-49);
                }
                if (this.ctx.scriptAssistParsing) {
                    second = this.nodeFactory.identifier(ASTERISK, false);
                }
            } else if (!this.errorIfNextTokenIsKeywordInsteadOfTypeExpression()) {
                second = this.parseTypeExpression(mode);
            }
        }
        TypedIdentifierNode result = this.nodeFactory.typedIdentifier(first, second);
        result.no_anno = no_anno;
        return result;
    }

    private Node parseFunctionDefinition(AttributeListNode first) {
        this.shift();
        FunctionNameNode second = this.parseFunctionName();
        FunctionCommonNode third = this.parseFunctionCommon(second.identifier);
        FunctionDefinitionNode result = this.nodeFactory.functionDefinition(this.ctx, first, second, third);
        return result;
    }

    private FunctionNameNode parseFunctionName() {
        FunctionNameNode result;
        int lt = this.lookahead();
        if (lt == -79) {
            this.shift();
            result = this.lookahead() == -13 ? this.nodeFactory.functionName(-133, this.nodeFactory.identifier(GET, false, this.scanner.input.positionOfMark())) : this.nodeFactory.functionName(-79, this.parseIdentifier());
        } else if (lt == -99) {
            this.shift();
            result = this.lookahead() == -13 ? this.nodeFactory.functionName(-133, this.nodeFactory.identifier(SET, false, this.scanner.input.positionOfMark())) : this.nodeFactory.functionName(-99, this.parseIdentifier());
        } else {
            result = this.nodeFactory.functionName(-133, this.parseIdentifier());
        }
        return result;
    }

    private Node parseResultSignature(boolean[] no_anno, boolean[] void_anno) {
        Node result = null;
        no_anno[0] = true;
        void_anno[0] = false;
        if (this.lookahead() == -24) {
            no_anno[0] = false;
            this.shift();
            int lt = this.lookahead();
            if (lt == -15) {
                this.shift();
                if (this.ctx.scriptAssistParsing) {
                    result = this.nodeFactory.identifier(ASTERISK, false, this.scanner.input.positionOfMark());
                }
            } else if (lt == -16) {
                this.changeLookahead(-49);
            } else if (lt == -113) {
                this.shift();
                void_anno[0] = true;
            } else {
                this.errorIfNextTokenIsKeywordInsteadOfTypeExpression();
                result = this.parseTypeExpression(-137);
            }
        }
        return result;
    }

    private FunctionSignatureNode parseFunctionSignature() {
        boolean[] no_anno = new boolean[1];
        boolean[] void_anno = new boolean[1];
        this.match(-13);
        ParameterListNode first = this.parseParameters();
        this.match(-14);
        Node second = this.parseResultSignature(no_anno, void_anno);
        FunctionSignatureNode result = this.nodeFactory.functionSignature(first, second, this.scanner.input.positionOfMark());
        result.no_anno = no_anno[0];
        result.void_anno = void_anno[0];
        return result;
    }

    private FunctionSignatureNode parseConstructorSignature() {
        FunctionSignatureNode result;
        boolean[] no_anno = new boolean[1];
        boolean[] void_anno = new boolean[1];
        this.match(-13);
        ParameterListNode first = this.parseParameters();
        this.match(-14);
        ListNode second = this.parseConstructorInitializer(no_anno, void_anno);
        if (void_anno[0]) {
            result = this.nodeFactory.functionSignature(first, null, this.scanner.input.positionOfMark());
            result.no_anno = false;
            result.void_anno = true;
        } else {
            result = this.nodeFactory.constructorSignature(first, second, this.scanner.input.positionOfMark());
            result.no_anno = true;
            result.void_anno = false;
        }
        return result;
    }

    private ListNode parseConstructorInitializer(boolean[] no_anno, boolean[] void_anno) {
        ListNode result = null;
        no_anno[0] = true;
        void_anno[0] = false;
        if (this.lookahead() == -24) {
            this.shift();
            if (this.lookahead() == -113) {
                this.shift();
                no_anno[0] = false;
                void_anno[0] = true;
                return null;
            }
            result = this.parseInitializerList();
            if (this.lookahead() == -101) {
                result = this.nodeFactory.list(result, this.parseSuperInitializer());
            }
        }
        return result;
    }

    private Node parseSuperInitializer() {
        this.shift();
        SuperStatementNode result = null;
        SuperExpressionNode first = this.nodeFactory.superExpression(null, this.scanner.input.positionOfMark());
        Node n = this.parseArguments(first);
        if (!(n instanceof CallExpressionNode)) {
            this.ctx.internalError("Internal error in parseSuperInitializer()");
        }
        result = this.nodeFactory.superStatement((CallExpressionNode)n);
        return result;
    }

    private ListNode parseInitializerList() {
        ListNode result = null;
        while (this.lookahead() != -101) {
            Node t = this.parseInitializer();
            if (t != null) {
                result = this.nodeFactory.list(result, t);
            }
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    private Node parseInitializer() {
        Node result = null;
        IdentifierNode first = this.parseIdentifier();
        if (this.lookahead() != -49) {
            this.ctx.error(first.pos(), 1069);
        }
        Node second = this.parseVariableInitialization(-137);
        result = this.nodeFactory.assignmentExpression(first, -49, second);
        return result;
    }

    private ParameterListNode parseParameters() {
        ParameterListNode result = null;
        if (this.lookahead() != -14) {
            result = this.parseParameterList();
        }
        return result;
    }

    private ParameterListNode parseParameterList() {
        ParameterListNode result = null;
        while (true) {
            if (this.lookahead() == -20) {
                result = this.nodeFactory.parameterList(result, this.parseRestParameter());
                break;
            }
            ParameterNode t = this.parseParameter();
            if (this.lookahead() == -49) {
                this.shift();
                t.init = this.parseNonAssignmentExpression(-137);
            }
            result = this.nodeFactory.parameterList(result, t);
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    private ParameterNode parseRestParameter() {
        ParameterNode first = null;
        this.shift();
        int lt = this.lookahead();
        if (lt == -65 || lt == -117 || lt == -79 || lt == -99) {
            first = this.parseParameter();
        }
        RestParameterNode result = this.nodeFactory.restParameter(first, this.scanner.input.positionOfMark());
        return result;
    }

    private ParameterNode parseParameter() {
        Node third = null;
        boolean no_anno = true;
        int first = -112;
        if (Features.HAS_CONSTPARAMETERS && this.lookahead() == -65) {
            first = -65;
            this.shift();
        }
        IdentifierNode second = this.parseIdentifier();
        if (this.lookahead() == -24) {
            no_anno = false;
            this.shift();
            if (this.lookahead() == -15) {
                this.shift();
                second.setOrigTypeToken(-15);
            } else if (this.lookahead() == -16) {
                this.changeLookahead(-49);
                second.setOrigTypeToken(-16);
            } else if (!this.errorIfNextTokenIsKeywordInsteadOfTypeExpression()) {
                third = this.parseTypeExpression(-137);
            }
        }
        ParameterNode result = this.nodeFactory.parameter(first, second, third);
        result.no_anno = no_anno;
        return result;
    }

    private boolean errorIfNextTokenIsKeywordInsteadOfTypeExpression() {
        int lt = this.lookahead();
        if (lt == -113) {
            this.error(ParseError.syntax, 1135, Token.getTokenClassName(lt));
            this.match(-113);
            return true;
        }
        if (lt != -117 && this.inXMLTokenSet(lt)) {
            this.error(ParseError.syntax, 1135, Token.getTokenClassName(lt));
            lt = this.lookahead();
            if (this.inXMLTokenSet(lt)) {
                this.shift();
            } else {
                this.match(lt);
            }
            return true;
        }
        if (this.ctx.dialect(8) && lt == -117 && this.scanner.getCurrentTokenText().equals("Object")) {
            this.error(1179);
            return true;
        }
        return false;
    }

    private Node parseClassDefinition(AttributeListNode attrs, int mode) {
        this.shift();
        if (this.block_kind_stack.last() != -94 && this.block_kind_stack.last() != -133) {
            this.error(1131);
        }
        this.block_kind_stack.add(-64);
        ClassNameNode first = this.parseClassName();
        String temp_class_name = this.current_class_name;
        this.current_class_name = first.ident.name;
        if (first.pkgname != null) {
            this.nodeFactory.startPackage(this.ctx, null, first.pkgname);
        }
        this.nodeFactory.StartClassDefs();
        InheritanceNode second = this.parseInheritance();
        StatementListNode third = this.parseBlock();
        if (third == null) {
            third = this.nodeFactory.statementList(null, null);
        }
        ClassDefinitionNode result = this.nodeFactory.classDefinition(this.ctx, attrs, first.ident, second, third, first.non_nullable);
        this.block_kind_stack.removeLast();
        this.current_class_name = temp_class_name;
        if (first.pkgname != null) {
            this.nodeFactory.finishPackage(this.ctx, null);
        }
        return result;
    }

    private ClassNameNode parseClassName() {
        ClassNameNode result;
        IdentifierNode first = this.parseIdentifier();
        if (Features.HAS_COMPOUNDCLASSNAMES) {
            PackageIdentifiersNode list = null;
            while (this.lookahead() == -18) {
                this.shift();
                list = this.nodeFactory.packageIdentifiers(list, first, true);
                first = this.parseIdentifier();
            }
            PackageNameNode pkgname = list != null ? this.nodeFactory.packageName(list) : null;
            result = this.nodeFactory.className(pkgname, first);
        } else {
            result = this.nodeFactory.className(null, first);
        }
        if (this.ctx.statics.es4_nullability) {
            if (this.lookahead() == -4) {
                this.shift();
                result.non_nullable = true;
            } else if (this.lookahead() == -27) {
                this.shift();
            }
        }
        return result;
    }

    private InheritanceNode parseInheritance() {
        InheritanceNode result = null;
        Node first = null;
        ListNode second = null;
        if (this.lookahead() == -73) {
            this.shift();
            first = this.parseTypename();
        }
        if (this.lookahead() == -82) {
            this.shift();
            second = this.parseTypenameList();
        }
        if (first != null || second != null) {
            result = this.nodeFactory.inheritance(first, second);
        }
        return result;
    }

    private ListNode parseTypeExpressionList() {
        ListNode result = null;
        while (true) {
            Node t;
            if ((t = this.parseTypeExpression(-137)) != null) {
                result = this.nodeFactory.list(result, t);
            }
            if (this.lookahead() != -17) break;
            this.shift();
        }
        return result;
    }

    private Node parseInterfaceDefinition(AttributeListNode attrs, int mode) {
        this.shift();
        this.block_kind_stack.add(-87);
        ClassNameNode first = this.parseClassName();
        if (first.pkgname != null) {
            this.nodeFactory.startPackage(this.ctx, null, first.pkgname);
        }
        ListNode second = null;
        if (this.lookahead() == -73) {
            this.shift();
            second = this.parseTypenameList();
        }
        StatementListNode third = this.parseBlock();
        InterfaceDefinitionNode result = this.nodeFactory.interfaceDefinition(this.ctx, attrs, first.ident, second, third);
        this.block_kind_stack.removeLast();
        if (first.pkgname != null) {
            this.nodeFactory.finishPackage(this.ctx, null);
        }
        return result;
    }

    private NamespaceDefinitionNode parseNamespaceDefinition(AttributeListNode first) {
        NamespaceDefinitionNode result;
        this.shift();
        IdentifierNode second = this.parseIdentifier();
        if (first != null && first.items.size() == 1 && first.hasAttribute("config")) {
            result = this.nodeFactory.configNamespaceDefinition(null, second, -1);
            assert (this.config_namespaces.size() > 0);
            this.config_namespaces.last().add(result.name.name);
        } else {
            Node third = null;
            if (this.lookahead() == -49) {
                this.shift();
                if (this.ctx.statics.es4_nullability) {
                    if (this.lookahead() == -120) {
                        boolean[] is_single_quoted = new boolean[1];
                        this.shift();
                        String enclosedText = this.scanner.getCurrentStringTokenText(is_single_quoted);
                        third = this.nodeFactory.literalString(enclosedText, this.scanner.input.positionOfMark(), is_single_quoted[0]);
                    } else {
                        third = this.parseSimpleTypeIdentifier();
                    }
                } else {
                    third = this.parseAssignmentExpression(-137);
                }
            }
            result = this.nodeFactory.namespaceDefinition(first, second, third);
        }
        return result;
    }

    public static UseDirectiveNode generateAs3UseDirective(Context ctx) {
        NodeFactory nodeFactory = ctx.getNodeFactory();
        IdentifierNode as3Identifier = nodeFactory.identifier(AS3, false);
        ReferenceValue referenceValue = new ReferenceValue(ctx, null, AS3, ctx.AS3Namespace());
        referenceValue.setIsAttributeIdentifier(false);
        as3Identifier.ref = referenceValue;
        return nodeFactory.useDirective(null, nodeFactory.memberExpression(null, nodeFactory.getExpression(as3Identifier)));
    }

    private PackageDefinitionNode parsePackageDefinition() {
        boolean has_packagename;
        if (this.within_package) {
            this.error(1037);
        }
        this.within_package = true;
        this.nodeFactory.dxns = null;
        this.block_kind_stack.add(-94);
        this.shift();
        assert (this.config_namespaces.size() > 0);
        HashSet conf_ns = new HashSet(this.config_namespaces.last().size());
        conf_ns.addAll(this.config_namespaces.last());
        this.config_namespaces.push_back(conf_ns);
        PackageNameNode first = null;
        boolean bl = has_packagename = this.lookahead() != -35;
        if (has_packagename) {
            first = this.parsePackageName(false);
        }
        PackageDefinitionNode result = this.nodeFactory.startPackage(this.ctx, null, first);
        UseDirectiveNode as3UseDirective = Parser.generateAs3UseDirective(this.ctx);
        ObjectList<UseDirectiveNode> useDirectives = null;
        if (!this.ctx.statics.use_namespaces.isEmpty()) {
            useDirectives = new ObjectList<UseDirectiveNode>();
            for (String u : this.ctx.statics.use_namespaces) {
                useDirectives.add(this.nodeFactory.useDirective(null, this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(this.nodeFactory.identifier(u)))));
            }
        }
        ImportDirectiveNode importDirective = null;
        if (this.ctx.statics.es4_vectors) {
            PackageIdentifiersNode pin = this.nodeFactory.packageIdentifiers(null, this.nodeFactory.identifier(__AS3__, false), true);
            pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VEC, false), true);
            pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VECTOR, false), true);
            importDirective = this.nodeFactory.importDirective(null, this.nodeFactory.packageName(pin), null, this.ctx);
        }
        result = this.nodeFactory.finishPackage(this.ctx, this.parseBlock());
        if (this.ctx.dialect(10) && result != null) {
            result.statements.items.add(1, as3UseDirective);
        }
        if (!has_packagename && this.ctx.statics.es4_vectors && result != null) {
            result.statements.items.add(1, importDirective);
        }
        if (useDirectives != null && result != null) {
            for (UseDirectiveNode u : useDirectives) {
                result.statements.items.add(1, u);
            }
        }
        if (has_packagename && this.ctx.statics.es4_vectors && result != null) {
            result.statements.items.add(1, importDirective);
        }
        this.block_kind_stack.removeLast();
        this.config_namespaces.pop_back();
        this.within_package = false;
        return result;
    }

    public StatementListNode parseConfigValues() {
        StatementListNode configs = null;
        String config_code = this.ctx.getConfigVarCode();
        if (config_code != null) {
            Scanner orig = this.scanner;
            InputBuffer orig_input = this.scanner.input;
            int orig_nextToken = this.nextToken;
            this.scanner = new Scanner(this.ctx, config_code, "");
            this.scanner.input.report_pos = false;
            configs = this.parseDirectives(null, null);
            this.scanner = orig;
            this.scanner.input = orig_input;
            this.ctx.input = orig_input;
            this.nextToken = orig_nextToken;
        }
        return configs;
    }

    private PackageNameNode parsePackageName(boolean isDefinition) {
        PackageNameNode result;
        if (this.lookahead() == -120) {
            boolean[] is_single_quoted = new boolean[1];
            this.shift();
            String enclosedText = this.scanner.getCurrentStringTokenText(is_single_quoted);
            LiteralStringNode first = this.nodeFactory.literalString(enclosedText, this.scanner.input.positionOfMark(), is_single_quoted[0]);
            result = this.nodeFactory.packageName(first);
        } else {
            PackageIdentifiersNode first = this.nodeFactory.packageIdentifiers(null, this.parseIdentifier(), isDefinition);
            while (this.lookahead() == -18) {
                this.shift();
                first = this.nodeFactory.packageIdentifiers(first, this.parsePropertyIdentifier(), isDefinition);
            }
            result = this.nodeFactory.packageName(first);
        }
        return result;
    }

    public ProgramNode parseProgram() {
        StatementListNode first = null;
        StatementListNode second = null;
        StatementListNode configs = null;
        if (!this.parsing_include) {
            this.config_namespaces.push_back(new HashSet());
            this.config_namespaces.last().add(CONFIG);
            configs = this.parseConfigValues();
        }
        while (this.lookahead() == -94 || this.lookahead() == -129) {
            MetaDataNode meta = null;
            if (this.lookahead() == -129 || this.lookahead() == -29 || this.lookahead() == -122) {
                meta = this.parseMetaData();
                second = this.nodeFactory.statementList(second, meta);
            }
            if (this.lookahead() != -94) continue;
            PackageDefinitionNode pkgdef = this.parsePackageDefinition();
            first = this.nodeFactory.statementList(first, pkgdef);
            if (meta != null) {
                meta.def = pkgdef;
                pkgdef.addMetaDataNode(meta);
            }
            if (pkgdef == null) continue;
            second = this.nodeFactory.statementList(second, pkgdef.statements);
        }
        second = this.parseDirectives(null, second);
        if (this.ctx.dialect(10) && !this.parsing_include && second != null) {
            UseDirectiveNode udn = Parser.generateAs3UseDirective(this.ctx);
            second.items.add(0, udn);
        }
        if (!this.ctx.statics.use_namespaces.isEmpty() && !this.parsing_include && second != null) {
            for (String useName : this.ctx.statics.use_namespaces) {
                UseDirectiveNode udn2 = this.nodeFactory.useDirective(null, this.nodeFactory.memberExpression(null, this.nodeFactory.getExpression(this.nodeFactory.identifier(useName))));
                second.items.add(0, udn2);
            }
        }
        if (this.ctx.statics.es4_vectors && !this.parsing_include && second != null) {
            PackageIdentifiersNode pin = this.nodeFactory.packageIdentifiers(null, this.nodeFactory.identifier(__AS3__, false), true);
            pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VEC, false), true);
            pin = this.nodeFactory.packageIdentifiers(pin, this.nodeFactory.identifier(VECTOR, false), true);
            ImportDirectiveNode idn = this.nodeFactory.importDirective(null, this.nodeFactory.packageName(pin), null, this.ctx);
            second.items.add(0, idn);
        }
        ProgramNode result = this.nodeFactory.program(this.ctx, second, this.scanner.input.positionOfMark());
        this.match(-1);
        if (this.ctx.scriptAssistParsing) {
            ListIterator it = this.comments.listIterator();
            while (it.hasNext()) {
                this.ctx.comments.add((Node)it.next());
            }
        }
        this.clearUnusedBuffers();
        if (!this.parsing_include) {
            if (result != null) {
                if (configs != null) {
                    result.statements.items.addAll(0, configs.items);
                }
                NamespaceDefinitionNode configdef = this.nodeFactory.configNamespaceDefinition(null, this.nodeFactory.identifier(CONFIG, false), -1);
                result.statements.items.add(0, configdef);
            }
            this.config_namespaces.pop_back();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseError {
        catch_parameter,
        syntax,
        expression,
        EOS,
        XML;

    }
}

