/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import macromedia.asc.embedding.avmplus.Features;

public class InputBuffer {
    private final String text;
    private int textPos = 0;
    private int textMarkPos = 0;
    private int[] lineMap;
    private int startLineNumber;
    private int startSourcePos;
    public String origin;
    public boolean report_pos = true;
    private int cachedLastLineMapPos = 0;
    private int cachedLastLineMapIndex = 0;

    public InputBuffer(InputStream in, String encoding, String origin) {
        this.text = this.createBuffer(in, encoding);
        this.init(origin, 0, 0);
    }

    public InputBuffer(String in, String origin) {
        this.text = in;
        this.init(origin, 0, 0);
    }

    public InputBuffer(String in, String origin, int startPos, int startLine) {
        this.text = in;
        this.init(origin, startPos, startLine);
        this.startSourcePos = startPos;
        this.startLineNumber = startLine;
    }

    protected InputBuffer() {
        this.text = null;
        this.init(null, 0, 0);
    }

    private void init(String origin, int startPos, int startLine) {
        this.origin = origin;
        this.startSourcePos = startPos;
        this.startLineNumber = startLine;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createBuffer(InputStream in, String encoding) {
        ByteBuffer bb;
        byte[] b2;
        try {
            int i = in.available();
            if (i == 0) {
                return "";
            }
            b2 = new byte[i];
            int len = in.read(b2, 0, i);
            if (len != i) {
                // empty if block
            }
            if (in.read() == -1) {
                // empty if block
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        if (b2.length > 3 && b2[0] == -17 && b2[1] == -69 && b2[2] == -65) {
            encoding = "UTF8";
            bb = ByteBuffer.wrap(b2, 3, b2.length - 3);
        } else if (b2.length > 3 && b2[0] == -1 && b2[1] == -2 || b2[0] == -2 && b2[1] == -1) {
            encoding = "UTF16";
            bb = ByteBuffer.wrap(b2, 3, b2.length - 3);
        } else {
            if (encoding == null) {
                encoding = "UTF8";
            }
            bb = ByteBuffer.wrap(b2);
        }
        Charset cs = null;
        try {
            cs = Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException ex) {
            cs = Charset.defaultCharset();
        }
        CharBuffer cb = cs.decode(bb);
        return cb.toString();
    }

    private void buildLineMap(String src, int max) {
        int line = 0;
        int pos = 0;
        int[] lb = new int[max + 1];
        block0: while (pos < max) {
            lb[line++] = pos;
            do {
                char ch;
                if ((ch = src.charAt(pos)) != '\r' && ch != '\n') continue;
                if (ch == '\r' && pos + 1 < max && src.charAt(pos + 1) == '\n') {
                    pos += 2;
                    continue block0;
                }
                ++pos;
                continue block0;
            } while (++pos < max);
        }
        lb[line++] = pos;
        this.lineMap = new int[line];
        System.arraycopy(lb, 0, this.lineMap, 0, line);
    }

    private int getLineMapIndex(int srcPos) {
        int pos = srcPos - this.startSourcePos;
        if (pos < 0) {
            return 0;
        }
        if (this.lineMap == null) {
            this.buildLineMap(this.text, this.text.length());
        }
        if (pos == this.cachedLastLineMapPos) {
            return this.cachedLastLineMapIndex;
        }
        this.cachedLastLineMapPos = pos;
        int low = 0;
        int high = this.lineMap.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midPos = this.lineMap[mid];
            if (midPos < pos) {
                low = mid + 1;
                continue;
            }
            if (midPos > pos) {
                high = mid - 1;
                continue;
            }
            this.cachedLastLineMapIndex = mid + 1;
            return this.cachedLastLineMapIndex;
        }
        this.cachedLastLineMapIndex = low;
        return this.cachedLastLineMapIndex;
    }

    public int getLnNum(int srcPos) {
        int l = this.getLineMapIndex(srcPos);
        if (l == 0) {
            l = 1;
        }
        return l + this.startLineNumber;
    }

    public final int getLineStartPos(int srcPos) {
        int l = this.getLineMapIndex(srcPos);
        assert (l <= this.lineMap.length) : "line number out of range";
        if (l == 0) {
            l = 1;
        }
        return this.lineMap[l - 1];
    }

    public String source() {
        return this.text;
    }

    public int textMark() {
        this.textMarkPos = this.textPos - 1;
        return this.textMarkPos;
    }

    public int textPos() {
        return this.textPos;
    }

    public int nextchar() {
        if (this.textPos >= this.text.length()) {
            this.textPos = this.text.length() + 1;
            return 0;
        }
        char c2 = this.text.charAt(this.textPos++);
        return c2;
    }

    public void retract() {
        if (this.textPos > 0) {
            --this.textPos;
        }
    }

    private final char javaTypeOfToCharacterClass(int javaClassOf) {
        switch (javaClassOf) {
            case 1: {
                return '\u0001';
            }
            case 2: {
                return '\u0002';
            }
            case 3: {
                return '\u0003';
            }
            case 6: {
                return '\u0004';
            }
            case 8: {
                return '\u0005';
            }
            case 7: {
                return '\u0006';
            }
            case 9: {
                return '\u0007';
            }
            case 10: {
                return '\b';
            }
            case 11: {
                return '\t';
            }
            case 12: {
                return '\n';
            }
            case 13: {
                return '\u000b';
            }
            case 14: {
                return '\f';
            }
            case 15: {
                return '\r';
            }
            case 16: {
                return '\u000e';
            }
            case 19: {
                return '\u000f';
            }
            case 18: {
                return '\u0010';
            }
            case 0: {
                return '\u0011';
            }
            case 4: {
                return '\u0012';
            }
            case 5: {
                return '\u0013';
            }
            case 23: {
                return '\u0014';
            }
            case 20: {
                return '\u0015';
            }
            case 21: {
                return '\u0016';
            }
            case 22: {
                return '\u0017';
            }
            case 29: {
                return '\u0018';
            }
            case 30: {
                return '\u0019';
            }
            case 24: {
                return '\u001a';
            }
            case 25: {
                return '\u001b';
            }
            case 26: {
                return '\u001c';
            }
            case 27: {
                return '\u001d';
            }
            case 28: {
                return '\u001e';
            }
        }
        return '\u0011';
    }

    public char nextcharClass(char c2, boolean advance) {
        int distance = 0;
        if (c2 == '\\' && this.text.charAt(this.textPos) == 'u') {
            int digit;
            int y;
            int thisChar = 0;
            for (y = this.textPos + 1; y < this.textPos + 5 && y < this.text.length() && (digit = Character.digit(this.text.charAt(y), 16)) != -1; ++y) {
                thisChar = (thisChar << 4) + digit;
            }
            if (y == this.textPos + 5 && Character.isDefined((char)thisChar)) {
                c2 = (char)thisChar;
                distance = 5;
            } else {
                distance = 1;
            }
        }
        if (advance) {
            this.textPos += distance;
        }
        return this.javaTypeOfToCharacterClass(Character.getType(c2));
    }

    public int positionOfNext() {
        return this.textPos + this.startSourcePos;
    }

    public int positionOfMark() {
        if (!this.report_pos) {
            return -1;
        }
        if (this.textMarkPos == -1) {
            return this.textMarkPos + this.startSourcePos;
        }
        return this.textMarkPos + this.startSourcePos;
    }

    private boolean has_escape(String src, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (src.charAt(i) != '\\') continue;
            return true;
        }
        return false;
    }

    private boolean has_u_escape(String src, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (src.charAt(i) != '\\' || i >= to || src.charAt(i + 1) != 'u') continue;
            return true;
        }
        return false;
    }

    private String escapeUnicode(String src, int from, int to) {
        if (!this.has_u_escape(src, from, to)) {
            return src.substring(from, to);
        }
        int len = to - from;
        StringBuilder buf = new StringBuilder(len);
        for (int i = from; i < to; ++i) {
            char c2 = src.charAt(i);
            if (c2 == '\\' && i < to && src.charAt(i + 1) == 'u') {
                int digit;
                int y;
                int thisChar = 0;
                for (y = i + 2; y < i + 6 && y < to + 1 && (digit = Character.digit(src.charAt(y), 16)) != -1; ++y) {
                    thisChar = (thisChar << 4) + digit;
                }
                if (y != i + 6 || !Character.isDefined((char)thisChar)) {
                    c2 = src.charAt(++i);
                } else {
                    c2 = (char)thisChar;
                    i += 5;
                }
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    private String escapeString(String src, int from, int to) {
        if (!this.has_escape(src, from, to)) {
            return src.substring(from, to);
        }
        int len = to - from;
        StringBuilder buf = new StringBuilder(len);
        block16: for (int i = from; i < to; ++i) {
            int c2 = src.charAt(i);
            if (c2 == 92) {
                char c22 = src.charAt(i + 1);
                block0 : switch (c22) {
                    case '\"': 
                    case '\'': {
                        continue block16;
                    }
                    case '\r': {
                        if (src.charAt(i + 2) == '\n') {
                            ++i;
                        }
                    }
                    case '\n': {
                        ++i;
                        continue block16;
                    }
                    case '\\': {
                        c2 = 92;
                        ++i;
                        break;
                    }
                    case 'u': {
                        int digit;
                        int y;
                        int thisChar = 0;
                        for (y = i + 2; y < i + 6 && y < to + 1 && (digit = Character.digit(src.charAt(y), 16)) != -1; ++y) {
                            thisChar = (thisChar << 4) + digit;
                        }
                        if (y != i + 6 || !Character.isDefined((char)thisChar)) {
                            c2 = src.charAt(++i);
                            break;
                        }
                        c2 = (char)thisChar;
                        i += 5;
                        break;
                    }
                    default: {
                        if (Features.PASS_ESCAPES_TO_BACKEND) {
                            c2 = src.charAt(++i);
                            break;
                        }
                        switch (c22) {
                            case 'b': {
                                c2 = 8;
                                ++i;
                                break block0;
                            }
                            case 'f': {
                                c2 = 12;
                                ++i;
                                break block0;
                            }
                            case 'n': {
                                c2 = 10;
                                ++i;
                                break block0;
                            }
                            case 'r': {
                                c2 = 13;
                                ++i;
                                break block0;
                            }
                            case 't': {
                                c2 = 9;
                                ++i;
                                break block0;
                            }
                            case 'v': {
                                c2 = 11;
                                ++i;
                                break block0;
                            }
                            case 'x': {
                                int d2;
                                int d1;
                                if (i + 4 > to || (d1 = Character.digit(src.charAt(i + 2), 16)) == -1 || (d2 = Character.digit(src.charAt(i + 3), 16)) == -1) {
                                    ++i;
                                    c2 = 120;
                                    break block0;
                                }
                                i += 3;
                                c2 = (char)((d1 << 4) + d2);
                                break block0;
                            }
                        }
                        c2 = src.charAt(++i);
                    }
                }
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public String copy() {
        assert (this.textMarkPos >= 0 && this.textPos > this.textMarkPos) : "copy(): negative length copy textMarkPos =" + this.textMarkPos + " textPos = " + this.textPos + "text.length = " + this.text.length();
        return this.text.substring(this.textMarkPos, this.textPos);
    }

    public String copyReplaceStringEscapes(boolean needs_escape) {
        assert (this.textMarkPos >= 0 && this.textPos > this.textMarkPos) : "copyReplaceStringEscapes(boolean): negative length copy textMarkPos =" + this.textMarkPos + " textPos = " + this.textPos;
        if (needs_escape) {
            return this.escapeString(this.text, this.textMarkPos, this.textPos);
        }
        return this.text.substring(this.textMarkPos, this.textPos);
    }

    public String substringReplaceUnicodeEscapes(int begin, int end) {
        int len = end - begin;
        if (len <= 0) {
            return null;
        }
        return this.escapeUnicode(this.text, begin, end);
    }

    public String copyReplaceUnicodeEscapes() {
        assert (this.textMarkPos >= 0 && this.textPos > this.textMarkPos) : "copyReplaceUnicodeEscapes(): negative length copy textMarkPos =" + this.textMarkPos + " textPos = " + this.textPos;
        return this.escapeUnicode(this.text, this.textMarkPos, this.textPos);
    }

    public String copyReplaceUnicodeEscapes(boolean needs_escape) {
        assert (this.textMarkPos >= 0 && this.textPos > this.textMarkPos) : "copyReplaceUnicodeEscapes(boolean): negative length copy textMarkPos =" + this.textMarkPos + " textPos = " + this.textPos;
        if (needs_escape) {
            return this.escapeUnicode(this.text, this.textMarkPos, this.textPos);
        }
        return this.text.substring(this.textMarkPos, this.textPos);
    }

    public char markCharAt(int offset) {
        return this.text.charAt(this.textMarkPos - offset);
    }

    public int markLength() {
        return this.textPos - this.textMarkPos;
    }

    public int getColPos(int srcPos) {
        int start = this.getLineStartPos(srcPos);
        return srcPos - start + 1;
    }

    public String getLineText(int srcPos) {
        int start;
        char c2;
        int i;
        for (i = start = this.getLineStartPos(srcPos); i < this.text.length() && (c2 = this.text.charAt(i)) != '\n' && c2 != '\r' && c2 != '\u0000' && c2 != '\u2028' && c2 != '\u2029'; ++i) {
        }
        return this.text.substring(start, i);
    }

    public static String getLinePointer(int col) {
        StringBuilder padding = new StringBuilder(1 + col);
        for (int i = 0; i < col - 1; ++i) {
            padding.append(".");
        }
        padding.append("^");
        return padding.toString();
    }

    public void clearUnusedBuffers() {
    }
}

