/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import macromedia.abc.ByteArrayPool;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.MultiNamePool;
import macromedia.abc.NSPool;
import macromedia.abc.NSSPool;
import macromedia.asc.util.IntList;

final class IndexHistory {
    public static final int cp_int = 0;
    public static final int cp_uint = 1;
    public static final int cp_double = 2;
    public static final int cp_decimal = 3;
    public static final int cp_string = 4;
    public static final int cp_ns = 5;
    public static final int cp_nsset = 6;
    public static final int cp_mn = 7;
    public int total;
    public int duplicate;
    public int totalBytes;
    public int duplicateBytes;
    private ConstantPool[] pools;
    private int[] poolSizes;
    private int[] map;
    private boolean hasDecimal;
    private ByteArrayPool intP;
    private ByteArrayPool uintP;
    private ByteArrayPool doubleP;
    private ByteArrayPool decimalP;
    private ByteArrayPool stringP;
    private ByteArrayPool nsP;
    private ByteArrayPool nssP;
    private ByteArrayPool mnP;
    private BytecodeBuffer in_ns;
    private BytecodeBuffer in_nsset;
    private BytecodeBuffer in_mn;
    private boolean disableDebuggingInfo = false;

    IndexHistory(ConstantPool[] pools, boolean poolHasDecimal) {
        this.pools = pools;
        this.poolSizes = new int[pools.length];
        this.hasDecimal = poolHasDecimal;
        int size = 0;
        int preferredSize = 0;
        int length = pools.length;
        for (int i = 0; i < length; ++i) {
            this.poolSizes[i] = i == 0 ? 0 : size;
            size += pools[i].size();
            preferredSize += pools[i].mnEnd - pools[i].strEnd;
        }
        this.map = new int[size];
        this.in_ns = new BytecodeBuffer(preferredSize);
        this.in_nsset = new BytecodeBuffer(preferredSize);
        this.in_mn = new BytecodeBuffer(preferredSize);
        this.intP = new ByteArrayPool();
        this.uintP = new ByteArrayPool();
        this.doubleP = new ByteArrayPool();
        if (this.hasDecimal) {
            this.decimalP = new ByteArrayPool();
        }
        this.stringP = new ByteArrayPool();
        this.nsP = new NSPool();
        this.nssP = new NSSPool();
        this.mnP = new MultiNamePool();
        this.total = 0;
        this.duplicate = 0;
        this.totalBytes = 0;
        this.duplicateBytes = 0;
    }

    void disableDebugging() {
        this.disableDebuggingInfo = true;
    }

    public int getIndex(int poolIndex, int kind, int index) {
        if (index == 0) {
            return 0;
        }
        int newIndex = this.calculateIndex(poolIndex, kind, index);
        if (this.map[newIndex] == 0) {
            this.decodeOnDemand(poolIndex, kind, index, newIndex);
        }
        return this.map[newIndex];
    }

    public void writeTo(BytecodeBuffer b2) {
        this.intP.writeTo(b2);
        this.uintP.writeTo(b2);
        this.doubleP.writeTo(b2);
        if (this.hasDecimal) {
            this.decimalP.writeTo(b2);
        }
        this.stringP.writeTo(b2);
        this.nsP.writeTo(b2);
        this.nssP.writeTo(b2);
        this.mnP.writeTo(b2);
    }

    private final int calculateIndex(int poolIndex, int kind, int oldIndex) {
        int index = this.poolSizes[poolIndex];
        if (kind > 0) {
            index += this.pools[poolIndex].intpositions.length == 0 ? 0 : this.pools[poolIndex].intpositions.length - 1;
        }
        if (kind > 1) {
            index += this.pools[poolIndex].uintpositions.length == 0 ? 0 : this.pools[poolIndex].uintpositions.length - 1;
        }
        if (kind > 2) {
            index += this.pools[poolIndex].doublepositions.length == 0 ? 0 : this.pools[poolIndex].doublepositions.length - 1;
        }
        if (this.hasDecimal && kind > 3) {
            index += this.pools[poolIndex].decimalpositions.length == 0 ? 0 : this.pools[poolIndex].decimalpositions.length - 1;
        }
        if (kind > 4) {
            index += this.pools[poolIndex].strpositions.length == 0 ? 0 : this.pools[poolIndex].strpositions.length - 1;
        }
        if (kind > 5) {
            index += this.pools[poolIndex].nspositions.length == 0 ? 0 : this.pools[poolIndex].nspositions.length - 1;
        }
        if (kind > 6) {
            index += this.pools[poolIndex].nsspositions.length == 0 ? 0 : this.pools[poolIndex].nsspositions.length - 1;
        }
        if (kind > 7) {
            index += this.pools[poolIndex].mnpositions.length == 0 ? 0 : this.pools[poolIndex].mnpositions.length - 1;
        }
        return index += oldIndex - 1;
    }

    private final void decodeOnDemand(int poolIndex, int kind, int j, int j2) {
        int pos;
        int end;
        ConstantPool pool = this.pools[poolIndex];
        ByteArrayPool baPool = null;
        BytecodeBuffer poolIn = null;
        int[] positions = null;
        int length = 0;
        int endPos = 0;
        if (kind == 0) {
            positions = pool.intpositions;
            length = positions.length;
            endPos = pool.intEnd;
            baPool = this.intP;
            poolIn = pool.in;
        } else if (kind == 1) {
            positions = pool.uintpositions;
            length = positions.length;
            endPos = pool.uintEnd;
            baPool = this.uintP;
            poolIn = pool.in;
        } else if (kind == 2) {
            positions = pool.doublepositions;
            length = positions.length;
            endPos = pool.doubleEnd;
            baPool = this.doubleP;
            poolIn = pool.in;
        } else if (kind == 3) {
            assert (this.hasDecimal);
            positions = pool.decimalpositions;
            length = positions.length;
            endPos = pool.decimalEnd;
            baPool = this.decimalP;
            poolIn = pool.in;
        } else if (kind == 4) {
            positions = pool.strpositions;
            length = positions.length;
            endPos = pool.strEnd;
            baPool = this.stringP;
            poolIn = pool.in;
        } else if (kind == 5) {
            positions = pool.nspositions;
            length = positions.length;
            endPos = pool.nsEnd;
            baPool = this.nsP;
            poolIn = pool.in;
        } else if (kind == 6) {
            positions = pool.nsspositions;
            length = positions.length;
            endPos = pool.nssEnd;
            baPool = this.nssP;
            poolIn = pool.in;
        } else if (kind == 7) {
            positions = pool.mnpositions;
            length = positions.length;
            endPos = pool.mnEnd;
            baPool = this.mnP;
            poolIn = pool.in;
        }
        int start = positions[j];
        int n = end = j != length - 1 ? positions[j + 1] : endPos;
        if (kind == 5) {
            pos = positions[j];
            int originalPos = poolIn.pos();
            poolIn.seek(pos);
            start = this.in_ns.size();
            int nsKind = poolIn.readU8();
            this.in_ns.writeU8(nsKind);
            switch (nsKind) {
                case 5: {
                    if (this.disableDebuggingInfo) {
                        this.in_ns.writeU32(0L);
                        break;
                    }
                }
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    int index = poolIn.readU32();
                    int newIndex = this.getIndex(poolIndex, 4, index);
                    this.in_ns.writeU32(newIndex);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            poolIn.seek(originalPos);
            end = this.in_ns.size();
            poolIn = this.in_ns;
        } else if (kind == 6) {
            pos = positions[j];
            int originalPos = poolIn.pos();
            poolIn.seek(pos);
            start = this.in_nsset.size();
            int count = poolIn.readU32();
            this.in_nsset.writeU32(count);
            for (int k = 0; k < count; ++k) {
                int index = poolIn.readU32();
                int newIndex = this.getIndex(poolIndex, 5, index);
                this.in_nsset.writeU32(newIndex);
            }
            poolIn.seek(originalPos);
            end = this.in_nsset.size();
            poolIn = this.in_nsset;
        } else if (kind == 7) {
            pos = positions[j];
            int originalPos = poolIn.pos();
            poolIn.seek(pos);
            start = this.in_mn.size();
            int constKind = poolIn.readU8();
            if (constKind != 29) {
                this.in_mn.writeU8(constKind);
            }
            switch (constKind) {
                case 7: 
                case 13: {
                    int namespaceIndex = poolIn.readU32();
                    int newNamespaceIndex = this.getIndex(poolIndex, 5, namespaceIndex);
                    this.in_mn.writeU32(newNamespaceIndex);
                    int nameIndex = poolIn.readU32();
                    int newNameIndex = this.getIndex(poolIndex, 4, nameIndex);
                    this.in_mn.writeU32(newNameIndex);
                    break;
                }
                case 9: 
                case 14: {
                    int nameIndex = poolIn.readU32();
                    int newNameIndex = this.getIndex(poolIndex, 4, nameIndex);
                    this.in_mn.writeU32(newNameIndex);
                    int namespace_set = poolIn.readU32();
                    int newNamespace_set = this.getIndex(poolIndex, 6, namespace_set);
                    this.in_mn.writeU32(newNamespace_set);
                    break;
                }
                case 15: 
                case 16: {
                    int index = poolIn.readU32();
                    int newIndex = this.getIndex(poolIndex, 4, index);
                    this.in_mn.writeU32(newIndex);
                    break;
                }
                case 17: 
                case 18: {
                    break;
                }
                case 27: 
                case 28: {
                    int namespace_set = poolIn.readU32();
                    int newNamespace_set = this.getIndex(poolIndex, 6, namespace_set);
                    this.in_mn.writeU32(newNamespace_set);
                    break;
                }
                case 29: {
                    int i;
                    int nameIndex = poolIn.readU32();
                    int newNameIndex = this.getIndex(poolIndex, 7, nameIndex);
                    int count = poolIn.readU32();
                    IntList newParams = new IntList();
                    for (i = 0; i < count; ++i) {
                        newParams.add(this.getIndex(poolIndex, 7, poolIn.readU32()));
                    }
                    start = this.in_mn.size();
                    this.in_mn.writeU8(constKind);
                    this.in_mn.writeU32(newNameIndex);
                    this.in_mn.writeU32(count);
                    for (i = 0; i < count; ++i) {
                        this.in_mn.writeU32(newParams.at(i));
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            poolIn.seek(originalPos);
            end = this.in_mn.size();
            poolIn = this.in_mn;
        }
        int newIndex = baPool.contains(poolIn, start, end);
        if (newIndex == -1) {
            newIndex = baPool.store(poolIn, start, end);
        } else {
            ++this.duplicate;
            this.duplicateBytes += end - start;
        }
        ++this.total;
        this.totalBytes += end - start;
        if (j != 0) {
            this.map[j2] = newIndex;
        }
    }
}

