/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import macromedia.abc.AbcParser;
import macromedia.abc.BytecodeBuffer;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.semantics.MetaData;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Decimal128;

public class AbcData
implements Externalizable {
    static boolean readCache = true;
    static boolean saveCache = true;
    static final Object serializationLock = new Object();
    private boolean dirty = false;
    private String scriptName;
    private static AbcDataCache instance;
    private NameData[] nameData;
    private transient BinaryMN[] binaryMultinames;
    AbcParser parser;
    Namespace[] namespaces;
    NamespaceSet[] namespaceSets;
    String[] strings;
    int[] ints;
    long[] uints;
    double[] doubles;
    private Decimal128[] decimals;
    private Method[] methods;
    private Metadata[] raw_metadata;
    private transient MetaData[] semantic_metadata;
    private InstanceInfo[] instanceInfos;
    private ClassInfo[] classInfos;
    ScriptInfo[] scriptInfos;

    public static boolean contains(String src_name) {
        return AbcData.getCache().cache.containsKey(src_name);
    }

    public static AbcData getCacheEntry(String src_name) {
        return AbcData.getCache().get(src_name);
    }

    public void finish() {
        if (!this.dirty || !saveCache) {
            AbcData.getCache().remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbcDataCache getCache() {
        Object object = serializationLock;
        synchronized (object) {
            if (null == instance) {
                AbcData.deserializeCache(new File("/tmp/AbcDataCache.ser"));
            }
            return instance;
        }
    }

    private static void deserializeCache(File input) {
        if (null == instance && readCache && input.canRead()) {
            try {
                ObjectInputStream objIn = new ObjectInputStream(new FileInputStream(input));
                instance = (AbcDataCache)objIn.readObject();
                objIn.close();
                instance.file = input;
            }
            catch (InvalidClassException incompatible_serialized_class) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (null == instance) {
            instance = new AbcDataCache(input);
        }
    }

    public static void preload() {
        new Thread(){

            public void run() {
                AbcData.getCache();
            }
        }.start();
    }

    public AbcData(String script_name) {
        this.scriptName = script_name;
        this.dirty = true;
    }

    public boolean isBuilding() {
        return this.dirty;
    }

    public BinaryMN getName(int idx) {
        if (null == this.binaryMultinames[idx]) {
            NameData nd = this.nameData[idx];
            int name_index = 0;
            int name_space = 0;
            boolean ns_is_set = false;
            switch (nd.kind) {
                case 7: 
                case 13: {
                    name_space = nd.params[0];
                    name_index = nd.params[1];
                    ns_is_set = false;
                    this.binaryMultinames[idx] = new BinaryMN(nd.kind, name_index, name_space, ns_is_set, nd.getVersions());
                    break;
                }
                case 29: {
                    name_index = nd.params[0];
                    int count = nd.params.length - 2;
                    assert (count == nd.params[1]);
                    int[] plist = new int[count];
                    for (int i = 0; i < count; ++i) {
                        plist[i] = nd.params[i + 2];
                    }
                    this.binaryMultinames[idx] = new BinaryMN(nd.kind, name_index, plist);
                    break;
                }
                case 9: 
                case 14: {
                    name_index = nd.params[0];
                    name_space = nd.params[1];
                    ns_is_set = true;
                    this.binaryMultinames[idx] = new BinaryMN(nd.kind, name_index, name_space, ns_is_set, nd.getVersions());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected multiname type: " + nd.kind);
                }
            }
        }
        return this.binaryMultinames[idx];
    }

    public void setParser(AbcParser parser) {
        this.parser = parser;
    }

    public Namespace getNamespace(int i) {
        return this.namespaces[i];
    }

    public void addNamespaceSet(int nss_id, int[] namespaces) {
        NamespaceSet nss;
        if (!this.isBuilding()) {
            return;
        }
        assert (this.namespaceSets != null && nss_id < this.namespaceSets.length && null == this.namespaceSets[nss_id]);
        this.namespaceSets[nss_id] = nss = new NamespaceSet(namespaces);
    }

    public NamespaceSet getNamespaceSet(int id) {
        assert (id < this.namespaceSets.length);
        return this.namespaceSets[id];
    }

    public String getString(int i) {
        return this.strings[i];
    }

    public int getInt(int i) {
        return this.ints[i];
    }

    public long getUint(int i) {
        return this.uints[i];
    }

    public double getDouble(int i) {
        return this.doubles[i];
    }

    public Decimal128 getDecimal(int i) {
        return this.decimals[i];
    }

    public Method getMethod(int index) {
        assert (index >= 0 && index < this.methods.length);
        return this.methods[index];
    }

    public MetaData getMetadata(int idx, MetaDataNode metaNode) {
        if (null == this.semantic_metadata[idx]) {
            Metadata m = this.raw_metadata[idx];
            metaNode.setId(m.getName());
            int[] keys = m.keys;
            int[] raw_values = m.values;
            Value[] vals = new Value[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                String value = this.strings[raw_values[i]];
                vals[i] = keys[i] == 0 ? new MetaDataEvaluator.KeylessValue(value) : new MetaDataEvaluator.KeyValuePair(this.strings[keys[i]], value);
            }
            metaNode.setValues(vals);
            this.semantic_metadata[idx] = metaNode.getMetadata();
        }
        return this.semantic_metadata[idx];
    }

    public InstanceInfo getInstanceInfo(int i) {
        return this.instanceInfos[i];
    }

    public int getClassInfoSize() {
        return this.classInfos.length;
    }

    public ClassInfo getClassInfo(int idx) {
        assert (this.classInfos != null && idx >= 0 && idx <= this.classInfos.length);
        return this.classInfos[idx];
    }

    public int getScriptInfoSize() {
        return this.scriptInfos.length;
    }

    public ScriptInfo getScriptInfo(int idx) {
        assert (this.scriptInfos != null && idx >= 0 && idx < this.scriptInfos.length);
        return this.scriptInfos[idx];
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.classInfos);
        out.writeObject(this.doubles);
        out.writeObject(this.instanceInfos);
        out.writeObject(this.ints);
        out.writeObject(this.raw_metadata);
        out.writeObject(this.methods);
        out.writeObject(this.namespaces);
        out.writeObject(this.namespaceSets);
        out.writeObject(this.nameData);
        out.writeObject(this.scriptInfos);
        out.writeObject(this.scriptName);
        out.writeObject(this.strings);
        out.writeObject(this.uints);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.classInfos = (ClassInfo[])in.readObject();
        this.doubles = (double[])in.readObject();
        this.instanceInfos = (InstanceInfo[])in.readObject();
        this.ints = (int[])in.readObject();
        this.raw_metadata = (Metadata[])in.readObject();
        this.semantic_metadata = new MetaData[this.raw_metadata.length];
        this.methods = (Method[])in.readObject();
        this.namespaces = (Namespace[])in.readObject();
        this.namespaceSets = (NamespaceSet[])in.readObject();
        this.nameData = (NameData[])in.readObject();
        this.scriptInfos = (ScriptInfo[])in.readObject();
        this.scriptName = (String)in.readObject();
        this.strings = (String[])in.readObject();
        this.uints = (long[])in.readObject();
        this.dirty = false;
    }

    public void readAbc(byte[] raw_abc) {
        if (!this.isBuilding()) {
            return;
        }
        this.readAbc(new BytecodeBuffer(raw_abc));
    }

    public void readAbc(BytecodeBuffer buf) {
        if (!this.isBuilding()) {
            return;
        }
        int minor_version = buf.readU16();
        buf.readU16();
        this.scanCpool(buf, minor_version >= 17);
        this.scanMethods(buf);
        this.scanMetadata(buf);
        this.scanClasses(buf);
        this.scanScripts(buf);
    }

    void scanCpool(BytecodeBuffer buf, boolean hasDecimal) {
        int i;
        int size = buf.readU32();
        this.ints = new int[size];
        for (i = 1; i < size; ++i) {
            this.ints[i] = buf.readU32();
        }
        size = buf.readU32();
        this.uints = new long[size];
        for (i = 1; i < size; ++i) {
            this.uints[i] = (long)buf.readU32() & 0xFFFFFFFFL;
        }
        size = buf.readU32();
        this.doubles = new double[size];
        for (i = 1; i < size; ++i) {
            this.doubles[i] = buf.readDouble();
        }
        if (hasDecimal) {
            size = buf.readU32();
            this.decimals = new Decimal128[size];
            for (i = 1; i < size; ++i) {
                byte[] rep = buf.readBytes(16);
                this.decimals[i] = new Decimal128(rep);
            }
        }
        size = buf.readU32();
        this.strings = new String[size];
        this.strings[0] = "".intern();
        for (i = 1; i < size; ++i) {
            int length = buf.readU32();
            this.strings[i] = buf.readString(length).intern();
            buf.skip(length);
        }
        size = buf.readU32();
        this.namespaces = new Namespace[size];
        for (i = 1; i < size; ++i) {
            int ns_kind = buf.readU8();
            int name_offset = buf.readU32();
            this.namespaces[i] = new Namespace(name_offset, ns_kind);
        }
        size = buf.readU32();
        this.namespaceSets = new NamespaceSet[size];
        for (i = 1; i < size; ++i) {
            int count = buf.readU32();
            int[] ns_ids = new int[count];
            for (int q = 0; q < count; ++q) {
                ns_ids[q] = buf.readU32();
            }
            this.namespaceSets[i] = new NamespaceSet(ns_ids);
        }
        size = buf.readU32();
        this.nameData = new NameData[size];
        this.binaryMultinames = new BinaryMN[size];
        block16: for (i = 1; i < size; ++i) {
            int kind = buf.readU8();
            switch (kind) {
                case 7: 
                case 13: {
                    this.nameData[i] = new NameData(kind, new int[]{buf.readU32(), buf.readU32()});
                    continue block16;
                }
                case 15: 
                case 16: {
                    this.nameData[i] = new NameData(kind, new int[]{buf.readU32()});
                    continue block16;
                }
                case 9: 
                case 14: {
                    this.nameData[i] = new NameData(kind, new int[]{buf.readU32(), buf.readU32()});
                    continue block16;
                }
                case 27: 
                case 28: {
                    this.nameData[i] = new NameData(kind, new int[]{buf.readU32()});
                    continue block16;
                }
                case 29: {
                    int name_index = buf.readU32();
                    int count = buf.readU32();
                    int[] entries = new int[count + 2];
                    entries[0] = name_index;
                    entries[1] = count;
                    for (int k = 0; k < count; ++k) {
                        entries[k + 2] = buf.readU32();
                    }
                    this.nameData[i] = new NameData(kind, entries);
                    continue block16;
                }
                case 17: 
                case 18: {
                    this.nameData[i] = new NameData(kind, null);
                    continue block16;
                }
                default: {
                    throw new RuntimeException("bad multiname type: " + kind);
                }
            }
        }
    }

    void scanMethods(BytecodeBuffer buf) {
        int methodEntries = buf.readU32();
        this.methods = new Method[methodEntries];
        for (int i = 0; i < methodEntries; ++i) {
            int param_count = buf.readU32();
            int return_type = buf.readU32();
            int[] param_types = new int[param_count];
            for (int j = 0; j < param_count; ++j) {
                param_types[j] = buf.readU32();
            }
            int name_index = buf.readU32();
            int flags = buf.readU8();
            int optional_param_count = (flags & 8) != 0 ? buf.readU32() : 0;
            int[] optional_param_types = new int[optional_param_count];
            int[] optional_param_kinds = new int[optional_param_count];
            for (int q = 0; q < optional_param_count; ++q) {
                optional_param_types[q] = buf.readU32();
                optional_param_kinds[q] = buf.readU8();
            }
            int param_name_count = (flags & 0x80) != 0 ? param_count : 0;
            int[] param_names = new int[param_name_count];
            for (int q = 0; q < param_name_count; ++q) {
                param_names[q] = buf.readU32();
            }
            this.methods[i] = new Method(return_type, param_types, name_index, flags, optional_param_types, optional_param_kinds, param_names);
        }
    }

    void scanMetadata(BytecodeBuffer buf) {
        int metadataEntries = buf.readU32();
        this.raw_metadata = new Metadata[metadataEntries];
        this.semantic_metadata = new MetaData[metadataEntries];
        for (int i = 0; i < metadataEntries; ++i) {
            int j;
            int name_index = buf.readU32();
            int value_count = buf.readU32();
            int[] keys = new int[value_count];
            int[] values = new int[value_count];
            for (j = 0; j < value_count; ++j) {
                keys[j] = buf.readU32();
            }
            for (j = 0; j < value_count; ++j) {
                values[j] = buf.readU32();
            }
            this.raw_metadata[i] = new Metadata(name_index, keys, values);
        }
    }

    void scanClasses(BytecodeBuffer buf) {
        int i;
        int classEntries = buf.readU32();
        this.classInfos = new ClassInfo[classEntries];
        this.instanceInfos = new InstanceInfo[classEntries];
        for (i = 0; i < classEntries; ++i) {
            int name_index = buf.readU32();
            int super_index = buf.readU32();
            int flags = buf.readU8();
            int protected_ns = 0;
            if ((flags & 8) != 0) {
                protected_ns = buf.readU32();
            }
            int interface_count = buf.readU32();
            int[] interfaces = new int[interface_count];
            for (int j = 0; j < interface_count; ++j) {
                interfaces[j] = buf.readU32();
            }
            int init_index = buf.readU32();
            Trait[] itraits = this.scanTraits(buf);
            this.instanceInfos[i] = new InstanceInfo(name_index, super_index, flags, protected_ns, interfaces, init_index, itraits);
        }
        for (i = 0; i < classEntries; ++i) {
            int clinit_index = buf.readU32();
            Trait[] ctraits = this.scanTraits(buf);
            this.classInfos[i] = new ClassInfo(clinit_index, ctraits);
        }
    }

    void scanScripts(BytecodeBuffer buf) {
        int script_count = buf.readU32();
        this.scriptInfos = new ScriptInfo[script_count];
        for (int i = 0; i < script_count; ++i) {
            this.scriptInfos[i] = new ScriptInfo(buf.readU32(), this.scanTraits(buf));
        }
    }

    Trait[] scanTraits(BytecodeBuffer buf) {
        int count = buf.readU32();
        Trait[] result = new Trait[count];
        for (int i = 0; i < count; ++i) {
            int name_index = buf.readU32();
            int kind = buf.readU8();
            int tag = kind & 0xF;
            Trait new_trait = null;
            switch (tag) {
                case 0: 
                case 6: {
                    int slot_id = buf.readU32();
                    int trait_type = buf.readU32();
                    int value_index = buf.readU32();
                    int value_kind = 0;
                    if (value_index > 0) {
                        value_kind = buf.readU8();
                    }
                    new_trait = new Trait(name_index, kind, new int[]{slot_id, trait_type, value_index, value_kind});
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    int disp_id = buf.readU32();
                    int method = buf.readU32();
                    new_trait = new Trait(name_index, kind, new int[]{disp_id, method});
                    break;
                }
                case 4: 
                case 5: {
                    int slot_id = buf.readU32();
                    int class_id = buf.readU32();
                    new_trait = new Trait(name_index, kind, new int[]{slot_id, class_id});
                    break;
                }
            }
            assert (new_trait != null);
            result[i] = new_trait;
            if (!new_trait.hasMetadata()) continue;
            int metadata_count = buf.readU32();
            int[] metadata = new int[metadata_count];
            for (int j = 0; j < metadata_count; ++j) {
                metadata[j] = buf.readU32();
            }
            new_trait.addMetadata(metadata);
        }
        return result;
    }

    public class ScriptInfo
    implements Externalizable {
        int initIndex;
        Trait[] scriptTraits;

        ScriptInfo(int init_index, Trait[] script_traits) {
            this.initIndex = init_index;
            this.scriptTraits = script_traits;
        }

        public int getInitIndex() {
            return this.initIndex;
        }

        public Trait[] getScriptTraits() {
            return this.scriptTraits;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.initIndex = in.readInt();
            this.scriptTraits = (Trait[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.initIndex);
            out.writeObject(this.scriptTraits);
        }
    }

    public class ClassInfo
    implements Externalizable {
        int clinitIndex;
        Trait[] cTraits;

        ClassInfo(int clinit_index, Trait[] ctraits) {
            this.clinitIndex = clinit_index;
            this.cTraits = ctraits;
        }

        public int getClinitIndex() {
            return this.clinitIndex;
        }

        public Trait[] getCTraits() {
            return this.cTraits;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.clinitIndex = in.readInt();
            this.cTraits = (Trait[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.clinitIndex);
            out.writeObject(this.cTraits);
        }
    }

    public class InstanceInfo
    implements Externalizable {
        int nameIndex;
        int superIndex;
        int flags;
        int protectedNs;
        int[] interfaces;
        int initIndex;
        Trait[] iTraits;

        InstanceInfo(int nameIndex, int superIndex, int flags, int protected_ns, int[] interfaces, int init_index, Trait[] itraits) {
            this.nameIndex = nameIndex;
            this.superIndex = superIndex;
            this.flags = flags;
            this.protectedNs = protected_ns;
            this.interfaces = interfaces;
            this.initIndex = init_index;
            this.iTraits = itraits;
        }

        public int getInstanceNameID() {
            return this.nameIndex;
        }

        public int getSuperID() {
            return this.superIndex;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getProtectedNs() {
            return this.protectedNs;
        }

        public int[] getInterfaces() {
            return this.interfaces;
        }

        public int getInitIndex() {
            return this.initIndex;
        }

        public Trait[] getITraits() {
            return this.iTraits;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.nameIndex = in.readInt();
            this.superIndex = in.readInt();
            this.flags = in.readInt();
            this.protectedNs = in.readInt();
            this.interfaces = (int[])in.readObject();
            this.initIndex = in.readInt();
            this.iTraits = (Trait[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.nameIndex);
            out.writeInt(this.superIndex);
            out.writeInt(this.flags);
            out.writeInt(this.protectedNs);
            out.writeObject(this.interfaces);
            out.writeInt(this.initIndex);
            out.writeObject(this.iTraits);
        }
    }

    public class Metadata
    implements Externalizable {
        int nameIndex;
        int[] keys;
        int[] values;

        Metadata(int name_index, int[] keys, int[] values) {
            this.nameIndex = name_index;
            this.keys = keys;
            this.values = values;
            assert (keys.length == values.length);
        }

        public int getDataCount() {
            return this.keys.length;
        }

        public String getName() {
            return AbcData.this.getString(this.nameIndex);
        }

        public String getKey(int idx) {
            assert (idx >= 0 && idx < this.keys.length);
            return AbcData.this.getString(this.keys[idx]);
        }

        public String getValue(int idx) {
            assert (idx >= 0 && idx < this.values.length);
            return AbcData.this.getString(this.values[idx]);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.nameIndex = in.readInt();
            this.keys = (int[])in.readObject();
            this.values = (int[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.nameIndex);
            out.writeObject(this.keys);
            out.writeObject(this.values);
        }
    }

    public class Method
    implements Externalizable {
        private int returnType;
        int[] paramTypes;
        private int nameIndex;
        int flags;
        int[] optionalParamTypes;
        int[] optionalParamKinds;
        int[] paramNames;

        public Method(int return_type, int[] param_types, int name_index, int flags, int[] optional_param_types, int[] optional_param_kinds, int[] param_names) {
            this.returnType = return_type;
            this.paramTypes = param_types;
            this.nameIndex = name_index;
            this.flags = flags;
            this.optionalParamTypes = optional_param_types;
            this.optionalParamKinds = optional_param_kinds;
            this.paramNames = param_names;
        }

        public int getReturnType() {
            return this.returnType;
        }

        public int[] getParamTypes() {
            return this.paramTypes;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public int getFlags() {
            return this.flags;
        }

        public int[] getOptionalParamTypes() {
            return this.optionalParamTypes;
        }

        public int[] getOptionalParamKinds() {
            return this.optionalParamKinds;
        }

        public String[] getParamNames() {
            String[] result = new String[this.paramNames.length];
            for (int i = 0; i < this.paramNames.length; ++i) {
                result[i] = AbcData.this.strings[this.paramNames[i]];
            }
            return result;
        }

        public boolean getNeedsRest() {
            return (this.flags & 4) != 0 || (this.flags & 0x10) != 0;
        }

        public boolean getHasOptional() {
            return (this.flags & 8) != 0;
        }

        public boolean getHasParamNames() {
            return (this.flags & 0x80) != 0;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.returnType = in.readInt();
            this.paramTypes = (int[])in.readObject();
            this.nameIndex = in.readInt();
            this.flags = in.readInt();
            this.optionalParamTypes = (int[])in.readObject();
            this.optionalParamKinds = (int[])in.readObject();
            this.paramNames = (int[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.returnType);
            out.writeObject(this.paramTypes);
            out.writeInt(this.nameIndex);
            out.writeInt(this.flags);
            out.writeObject(this.optionalParamTypes);
            out.writeObject(this.optionalParamKinds);
            out.writeObject(this.paramNames);
        }
    }

    public class NamespaceSet
    implements Externalizable {
        int[] namespaceIds;

        NamespaceSet(int[] nss_ids) {
            this.namespaceIds = nss_ids;
        }

        public int[] getNamespaceIds() {
            return this.namespaceIds;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.namespaceIds = (int[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.namespaceIds);
        }
    }

    public class Namespace
    implements Externalizable {
        int nameOffset;
        public byte nsKind;

        Namespace(int name_offset, int ns_kind) {
            this.nameOffset = name_offset;
            this.nsKind = (byte)ns_kind;
        }

        public String getName() {
            assert (this.nameOffset < AbcData.this.strings.length);
            return AbcData.this.strings[this.nameOffset];
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.nameOffset = in.readInt();
            this.nsKind = in.readByte();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.nameOffset);
            out.writeByte(this.nsKind);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BinaryMN {
        public int kind = 0;
        public int nameID = 0;
        public int nsID = 0;
        public boolean nsIsSet = false;
        public int baseMN;
        public int[] params;
        public Set<Integer> versions;

        BinaryMN(int kind, int name_index, int name_space, boolean ns_is_set, Set<Integer> versions) {
            this.kind = kind;
            this.nameID = name_index;
            this.nsID = name_space;
            this.nsIsSet = ns_is_set;
            this.versions = versions;
        }

        BinaryMN(int kind, int base_name, int[] plist) {
            this.kind = kind;
            this.baseMN = base_name;
            this.params = plist;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NameData
    implements Externalizable {
        int kind = 0;
        int[] params;

        NameData(int kind, int[] params) {
            this.kind = kind;
            this.params = params;
        }

        public int getKind() {
            return this.kind;
        }

        public int[] getParams() {
            return this.params;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.kind = in.readByte();
            this.params = (int[])in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.kind);
            out.writeObject(this.params);
        }

        Set<Integer> getVersions() {
            int[] nss;
            Namespace ns = null;
            ns = 9 == this.kind || 14 == this.kind ? ((nss = AbcData.this.namespaceSets[this.params[1]].namespaceIds).length > 0 ? AbcData.this.namespaces[nss[0]] : null) : AbcData.this.namespaces[this.params[0]];
            switch (this.kind) {
                case 7: 
                case 13: {
                    ns = AbcData.this.namespaces[this.params[0]];
                    break;
                }
                case 9: 
                case 14: {
                    nss = AbcData.this.namespaceSets[this.params[1]].namespaceIds;
                    ns = nss.length > 0 ? AbcData.this.namespaces[nss[0]] : null;
                    break;
                }
                default: {
                    ns = null;
                }
            }
            if (ns != null) {
                String uri = AbcData.this.strings[ns.nameOffset];
                return this.getVersion(uri);
            }
            return null;
        }

        Set<Integer> getVersion(String uri) {
            if (uri.length() == 0) {
                return null;
            }
            int last = uri.codePointAt(uri.length() - 1);
            if (last >= 57344 && last <= 61440) {
                TreeSet<Integer> result = new TreeSet<Integer>();
                result.add(last - 57344);
                return result;
            }
            return null;
        }
    }

    public class Trait
    implements Externalizable {
        int nameIndex;
        int kind;
        int[] data;
        int[] metadata;

        public Trait(int name_index, int kind, int[] data) {
            this.nameIndex = name_index;
            this.kind = kind;
            this.data = data;
        }

        public void addMetadata(int[] metadata) {
            this.metadata = metadata;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public int getAttrs() {
            return this.kind >> 4;
        }

        public int getTag() {
            return this.kind & 0xF;
        }

        public boolean hasMetadata() {
            return (this.getAttrs() & 4) != 0;
        }

        public boolean isConstTrait() {
            return this.getTag() == 6;
        }

        public int[] getMetadata() {
            return this.metadata;
        }

        public int getSlotId() {
            assert (this.getTag() == 0 || this.getTag() == 6 || this.getTag() == 4);
            return this.data[0];
        }

        public int getTypeName() {
            assert (this.getTag() == 0 || this.getTag() == 6);
            return this.data[1];
        }

        public int getValueIndex() {
            assert (this.getTag() == 0 || this.getTag() == 6);
            return this.data[2];
        }

        public int getValueKind() {
            assert (this.getTag() == 0 || this.getTag() == 6);
            return this.data[3];
        }

        public int getDispId() {
            assert (this.getTag() == 1 || this.getTag() == 2 || this.getTag() == 3);
            return this.data[0];
        }

        public int getMethodId() {
            assert (this.getTag() == 1 || this.getTag() == 2 || this.getTag() == 3);
            return this.data[1];
        }

        public int getClassId() {
            assert (this.getTag() == 4);
            return this.data[1];
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.nameIndex = in.readInt();
            this.kind = in.readByte();
            this.data = (int[])in.readObject();
            this.metadata = (int[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.nameIndex);
            out.writeByte(this.kind);
            out.writeObject(this.data);
            out.writeObject(this.metadata);
        }
    }

    private static class AbcDataCache
    implements Externalizable {
        private Map<String, AbcData> cache = new HashMap<String, AbcData>();
        private boolean dirty;
        private File file;

        AbcDataCache(File f2) {
            this.file = f2;
            this.dirty = false;
            if (saveCache) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        instance.flush();
                    }
                });
            }
        }

        public void flush() {
            if (this.dirty) {
                try {
                    ObjectOutputStream objOut = new ObjectOutputStream(new FileOutputStream(this.file));
                    objOut.writeObject(this);
                    objOut.close();
                    this.dirty = false;
                    System.out.println("Serialized AbcDataCache to " + this.file.getCanonicalPath());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        AbcData get(String script_name) {
            if (!this.cache.containsKey(script_name)) {
                this.setDirty();
                this.cache.put(script_name, new AbcData(script_name));
                this.cache.get(script_name).dirty = true;
            }
            return this.cache.get(script_name);
        }

        private void setDirty() {
            this.dirty = true;
        }

        void remove(AbcData data) {
            if (!this.dirty || !saveCache) {
                this.cache.remove(data.scriptName);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cache = (Map)in.readObject();
            this.dirty = false;
            this.file = new File(in.readObject().toString());
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.cache);
            out.writeObject(this.file.getCanonicalPath());
        }
    }
}

