/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoABC;
import flash.swf.tags.EnableDebugger;
import flash.swf.tags.FileAttributes;
import flash.swf.tags.Metadata;
import flash.swf.tags.ProductInfo;
import flash.swf.tags.ScriptLimits;
import flash.swf.tags.SetBackgroundColor;
import flash.swf.types.FlashUUID;
import flash.swf.types.Rect;
import flash.util.Trace;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.graph.Algorithms;
import flex2.compiler.util.graph.DependencyGraph;
import flex2.compiler.util.graph.Vertex;
import flex2.compiler.util.graph.Visitor;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.tools.PreLink;
import flex2.tools.VersionInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMovie
extends Movie {
    private static final String NO_PASSWORD = "NO-PASSWORD";
    protected boolean lazyInit;
    protected String rootClassName;
    protected Map<CompilationUnit, Frame> exportedUnits;
    protected boolean generateLinkReport;
    protected boolean generateSizeReport;
    protected boolean generateRBList;
    protected String linkReport;
    protected String sizeReport;
    protected String rbList;
    private boolean includeInheritanceDependenciesOnly;

    public SimpleMovie(LinkerConfiguration configuration) {
        if (configuration.width() != null) {
            try {
                this.width = Integer.parseInt(configuration.width());
            }
            catch (NumberFormatException nfe) {
                ThreadLocalToolkit.log(new PreLink.CouldNotParseNumber(configuration.width(), "width"));
            }
            this.userSpecifiedWidth = true;
        } else if (configuration.widthPercent() != null) {
            this.width = configuration.defaultWidth();
            this.widthPercent = configuration.widthPercent();
        } else {
            this.width = configuration.defaultWidth();
        }
        if (configuration.height() != null) {
            try {
                this.height = Integer.parseInt(configuration.height());
            }
            catch (NumberFormatException nfe) {
                ThreadLocalToolkit.log(new PreLink.CouldNotParseNumber(configuration.height(), "height"));
            }
            this.userSpecifiedHeight = true;
        } else if (configuration.heightPercent() != null) {
            this.height = configuration.defaultHeight();
            this.heightPercent = configuration.heightPercent();
        } else {
            this.height = configuration.defaultHeight();
        }
        this.size = new Rect(this.width * 20, this.height * 20);
        if (configuration.scriptLimitsSet()) {
            this.scriptLimits = new ScriptLimits(configuration.getScriptRecursionLimit(), configuration.getScriptTimeLimit());
        }
        this.framerate = configuration.getFrameRate();
        this.version = configuration.getSwfVersion();
        this.bgcolor = new SetBackgroundColor(configuration.backgroundColor());
        if (configuration.debug()) {
            this.enableDebugger = new EnableDebugger(NO_PASSWORD);
            this.uuid = new FlashUUID();
        }
        if (this.version >= 8) {
            this.fileAttributes = new FileAttributes();
            boolean bl = this.fileAttributes.actionScript3 = this.version >= 9;
            if (configuration.useNetwork()) {
                this.fileAttributes.useNetwork = true;
                this.fileAttributes.actionScript3 = this.version >= 9;
            }
            this.fileAttributes.useDirectBlit = configuration.getUseDirectBlit();
            this.fileAttributes.useGPU = configuration.getUseGpu();
            String metadataStr = configuration.getMetadata();
            if (metadataStr != null) {
                this.metadata = new Metadata();
                this.metadata.xml = metadataStr;
                this.fileAttributes.hasMetadata = true;
            }
        }
        long build = 0L;
        byte majorVersion = 0;
        byte minorVersion = 0;
        try {
            majorVersion = (byte)Integer.parseInt(VersionInfo.FLEX_MAJOR_VERSION);
            minorVersion = (byte)Integer.parseInt(VersionInfo.FLEX_MINOR_VERSION);
            build = Long.parseLong(VersionInfo.getBuild());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.productInfo = new ProductInfo(3, 6, majorVersion, minorVersion, build, System.currentTimeMillis());
        this.pageTitle = configuration.pageTitle();
        this.lazyInit = configuration.lazyInit();
        this.rootClassName = SimpleMovie.formatSymbolClassName(configuration.getRootClassName());
        if (this.rootClassName == null) {
            this.rootClassName = SimpleMovie.formatSymbolClassName(configuration.getMainDefinition());
        }
        this.exportedUnits = new LinkedHashMap<CompilationUnit, Frame>();
        this.includeInheritanceDependenciesOnly = configuration.getIncludeInheritanceDependenciesOnly();
    }

    protected static String formatSymbolClassName(String className) {
        return className == null ? null : className.replace(':', '.');
    }

    public void generate(List<CompilationUnit> units) throws LinkerException {
        DependencyGraph<CompilationUnit> dependencies = this.extractCompilationUnitInfo(units);
        Frame frame = new Frame();
        this.frames = new ArrayList();
        this.frames.add(frame);
        this.exportDependencies(dependencies, frame);
        this.topLevelClass = SimpleMovie.formatSymbolClassName(this.rootClassName);
        if (ThreadLocalToolkit.errorCount() > 0) {
            throw new LinkerException.LinkingFailed();
        }
    }

    private DependencyGraph<CompilationUnit> extractCompilationUnitInfo(List<CompilationUnit> units) {
        DependencyGraph<CompilationUnit> dependencies = new DependencyGraph<CompilationUnit>();
        CompilationUnit main = null;
        int length = units.size();
        for (int i = 0; i < length; ++i) {
            CompilationUnit u = units.get(i);
            Source s = u.getSource();
            String path = s.getName();
            if (!u.isRoot()) {
                dependencies.put(path, u);
                dependencies.addVertex(new Vertex(path));
                continue;
            }
            main = u;
        }
        if (main != null) {
            dependencies.put(main.getSource().getName(), main);
            dependencies.addVertex(new Vertex(main.getSource().getName()));
        }
        return dependencies;
    }

    protected void exportUnitOnFrame(CompilationUnit u, Frame frame, boolean lazy) {
        if (u == null || u.getSource().isInternal()) {
            return;
        }
        if (u.hasAssets()) {
            Iterator<Map.Entry<String, AssetInfo>> it = u.getAssets().iterator();
            while (it.hasNext()) {
                Map.Entry<String, AssetInfo> entry = it.next();
                String className = entry.getKey();
                AssetInfo assetInfo = entry.getValue();
                DefineTag tag = assetInfo.getDefineTag();
                if (Trace.dependency) {
                    Trace.trace(u.getSource().getName() + " depends on symbolClass " + className);
                }
                frame.addSymbolClass(SimpleMovie.formatSymbolClassName(className), tag);
                if (tag.name == null) continue;
                frame.addExport(tag);
            }
            List<DefineFont> fonts = u.getAssets().getFonts();
            if (fonts != null) {
                for (DefineFont font : fonts) {
                    frame.addFont(font);
                }
            }
        }
        DoABC tag = null;
        String name = NameFormatter.nameFromSource(u.getSource());
        tag = u.getSource().isEntryPoint() || !lazy ? new DoABC(name, 0) : new DoABC(name, 1);
        tag.abc = u.getByteCodes();
        frame.doABCs.add(tag);
        this.exportedUnits.put(u, frame);
    }

    private void exportDependencies(final DependencyGraph<CompilationUnit> dependencies, final Frame frame) {
        Set cycles = Algorithms.detectCycles(dependencies);
        if (cycles.size() == 0) {
            Algorithms.topologicalSort(dependencies, new Visitor<Vertex<String, CompilationUnit>>(){

                @Override
                public void visit(Vertex<String, CompilationUnit> v) {
                    String fileName = v.getWeight();
                    CompilationUnit u = (CompilationUnit)dependencies.get(fileName);
                    SimpleMovie.this.exportUnitOnFrame(u, frame, SimpleMovie.this.lazyInit);
                }
            });
        } else {
            ThreadLocalToolkit.logError("The following forms a cycle in the dependency graph: " + cycles.toString());
        }
    }

    public static int getCodeHash(Frame f2) {
        int h2 = f2.symbolClass.hashCode();
        for (DoABC doABC : f2.doABCs) {
            for (int i = 0; i < doABC.abc.length; ++i) {
                h2 += doABC.abc[i] * 1000003;
            }
        }
        return h2 & 0xFFFFFF;
    }

    public List<CompilationUnit> getExportedUnits() {
        return new ArrayList<CompilationUnit>(this.exportedUnits.keySet());
    }

    public List<CompilationUnit> getExportedUnitsByFrame(Frame f2) {
        ArrayList<CompilationUnit> a2 = new ArrayList<CompilationUnit>();
        for (CompilationUnit u : this.exportedUnits.keySet()) {
            Frame frame = this.exportedUnits.get(u);
            if (f2 != frame) continue;
            a2.add(u);
        }
        return a2;
    }

    public String getLinkReport() {
        return this.linkReport;
    }

    public String getSizeReport() {
        return this.sizeReport;
    }

    public void setSizeReport(String report) {
        this.sizeReport = report;
    }

    public String getRBList() {
        return this.rbList;
    }

    public boolean getInheritanceDependenciesOnly() {
        return this.includeInheritanceDependenciesOnly;
    }
}

