/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flash.localization.LocalizationManager;
import flash.swf.Movie;
import flex2.compiler.CompilationUnit;
import flex2.compiler.common.Configuration;
import flex2.compiler.io.FileUtil;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.ConsoleApplication;
import flex2.linker.FlexMovie;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.linker.PostLink;
import flex2.linker.SimpleMovie;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkerAPI {
    public static Movie link(List<CompilationUnit> units, PostLink postLink, Configuration configuration) throws LinkerException {
        LocalizationManager l10n;
        FlexMovie movie = new FlexMovie(configuration);
        movie.topLevelClass = FlexMovie.formatSymbolClassName(configuration.getRootClassName());
        movie.generate(units);
        if (ThreadLocalToolkit.getBenchmark() != null) {
            l10n = ThreadLocalToolkit.getLocalizationManager();
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString(new Linking()));
        }
        LinkerAPI.generateReports(configuration, movie);
        if (postLink != null) {
            postLink.run(movie);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                l10n = ThreadLocalToolkit.getLocalizationManager();
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString(new Optimizing()));
            }
        }
        return movie;
    }

    private static void generateReports(LinkerConfiguration linkerConfiguration, SimpleMovie movie) {
        String fileName;
        if (linkerConfiguration.generateLinkReport() && linkerConfiguration.getLinkReportFileName() != null) {
            fileName = linkerConfiguration.getLinkReportFileName();
            try {
                FileUtil.writeFile(fileName, movie.getLinkReport());
            }
            catch (Exception ex) {
                ThreadLocalToolkit.log(new LinkerException.UnableToWriteLinkReport(fileName));
            }
        }
        if (linkerConfiguration.generateRBList() && linkerConfiguration.getRBListFileName() != null) {
            fileName = linkerConfiguration.getRBListFileName();
            try {
                FileUtil.writeFile(linkerConfiguration.getRBListFileName(), movie.getRBList());
            }
            catch (Exception ex) {
                ThreadLocalToolkit.log(new LinkerException.UnableToWriteResourceBundleList(fileName));
            }
        }
    }

    public static ConsoleApplication linkConsole(List<CompilationUnit> units, PostLink postLink, Configuration configuration) throws LinkerException {
        LocalizationManager l10n;
        ConsoleApplication app = new ConsoleApplication(configuration);
        app.generate(units);
        if (ThreadLocalToolkit.getBenchmark() != null) {
            l10n = ThreadLocalToolkit.getLocalizationManager();
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString(new Linking()));
        }
        if (postLink != null) {
            postLink.run(app);
            if (ThreadLocalToolkit.getBenchmark() != null) {
                l10n = ThreadLocalToolkit.getLocalizationManager();
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString(new Optimizing()));
            }
        }
        return app;
    }

    public static class Optimizing
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -455358216852519658L;
    }

    public static class Linking
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -6272039409403031493L;
    }
}

