/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util.graph;

import flex2.compiler.util.graph.Edge;
import flex2.compiler.util.graph.Vertex;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<VertexWeight, EdgeWeight> {
    private int counter;
    private Vertex<VertexWeight, EdgeWeight> root;
    private Set<Vertex<VertexWeight, EdgeWeight>> vertices = new HashSet<Vertex<VertexWeight, EdgeWeight>>(300);
    private Set<Edge<VertexWeight, EdgeWeight>> edges = new HashSet<Edge<VertexWeight, EdgeWeight>>(300);

    public Vertex<VertexWeight, EdgeWeight> getRoot() {
        return this.root;
    }

    public Set<Vertex<VertexWeight, EdgeWeight>> getVertices() {
        return this.vertices;
    }

    public Set<Edge<VertexWeight, EdgeWeight>> getEdges() {
        return this.edges;
    }

    public void clear() {
        this.counter = 0;
        this.root = null;
        this.vertices.clear();
        this.edges.clear();
    }

    public void addVertex(Vertex<VertexWeight, EdgeWeight> v) {
        if (this.vertices.size() == 0) {
            this.root = v;
        }
        v.id = this.counter++;
        this.vertices.add(v);
    }

    public void removeVertex(Vertex<VertexWeight, EdgeWeight> v) {
        Set<Edge<VertexWeight, EdgeWeight>> s;
        this.vertices.remove(v);
        if (v == this.root) {
            Iterator<Vertex<VertexWeight, EdgeWeight>> i = this.vertices.iterator();
            Vertex<VertexWeight, EdgeWeight> vertex = this.root = i.hasNext() ? i.next() : null;
        }
        if ((s = v.getEmanatingEdges()) != null) {
            for (Edge<VertexWeight, EdgeWeight> e2 : s) {
                Vertex<VertexWeight, EdgeWeight> h2 = e2.getHead();
                h2.removeIncidentEdge(e2);
                h2.removePredecessor(v);
                this.edges.remove(e2);
            }
        }
        if ((s = v.getIncidentEdges()) != null) {
            for (Edge<VertexWeight, EdgeWeight> e2 : s) {
                Vertex<VertexWeight, EdgeWeight> t = e2.getTail();
                t.removeEmanatingEdge(e2);
                t.removeSuccessor(v);
                this.edges.remove(e2);
            }
        }
        this.normalize();
    }

    public void addEdge(Edge<VertexWeight, EdgeWeight> e2) {
        this.edges.add(e2);
    }

    public void normalize() {
        this.counter = 0;
        for (Vertex<VertexWeight, EdgeWeight> name : this.vertices) {
            ++this.counter;
            name.id = name.id;
        }
    }
}

