/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util.graph;

import flex2.compiler.util.graph.Graph;
import flex2.compiler.util.graph.Vertex;
import flex2.compiler.util.graph.Visitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Algorithms {
    public static <VertexWeight, EdgeWeight> boolean isCyclic(Graph<VertexWeight, EdgeWeight> g2) {
        ConnectednessCounter counter = new ConnectednessCounter();
        Algorithms.topologicalSort(g2, counter);
        return counter.count != g2.getVertices().size();
    }

    public static <VertexWeight, EdgeWeight> Set<Vertex<VertexWeight, EdgeWeight>> detectCycles(Graph<VertexWeight, EdgeWeight> g2) {
        ConnectednessCounter counter = new ConnectednessCounter(g2.getVertices());
        Algorithms.topologicalSort(g2, counter);
        return counter.remained;
    }

    public static <VertexWeight, EdgeWeight> void topologicalSort(Graph<VertexWeight, EdgeWeight> g2, Visitor<Vertex<VertexWeight, EdgeWeight>> visitor) {
        int[] inDegree = new int[g2.getVertices().size()];
        Vertex[] vertices = new Vertex[inDegree.length];
        Iterator<Vertex<VertexWeight, EdgeWeight>> i = g2.getVertices().iterator();
        while (i.hasNext()) {
            Vertex<VertexWeight, EdgeWeight> v;
            vertices[v.id] = v = i.next();
            inDegree[v.id] = v.inDegrees();
        }
        LinkedList queue = new LinkedList();
        int length = vertices.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (inDegree[i2] != 0) continue;
            queue.add(vertices[i2]);
        }
        while (!queue.isEmpty()) {
            Vertex v = (Vertex)queue.removeFirst();
            if (visitor != null) {
                visitor.visit(v);
            }
            if (v.getSuccessors() == null) continue;
            for (Vertex head : v.getSuccessors()) {
                int n = head.id;
                inDegree[n] = inDegree[n] - 1;
                if (inDegree[head.id] != 0) continue;
                queue.add(head);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectednessCounter<VertexWeight, EdgeWeight>
    implements Visitor<Vertex<VertexWeight, EdgeWeight>> {
        private int count;
        private Set<Vertex<VertexWeight, EdgeWeight>> remained;

        private ConnectednessCounter() {
            this.count = 0;
        }

        private ConnectednessCounter(Set<Vertex<VertexWeight, EdgeWeight>> vertices) {
            this.remained = new HashSet<Vertex<VertexWeight, EdgeWeight>>(vertices);
        }

        @Override
        public void visit(Vertex<VertexWeight, EdgeWeight> v) {
            ++this.count;
            this.remained.remove(v);
        }
    }
}

