/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.QName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNameList
extends ArrayList<QName> {
    private static final long serialVersionUID = 3181098469098102598L;
    private QName key = new QName();

    public QNameList() {
    }

    public QNameList(int size) {
        super(size);
    }

    @Override
    public void add(int index, QName obj) {
        if (!this.contains(obj)) {
            super.add(index, obj);
        }
    }

    @Override
    public boolean add(QName obj) {
        if (!this.contains(obj)) {
            return super.add(obj);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends QName> c2) {
        if (c2 != null) {
            boolean result = false;
            int k = 0;
            for (QName qName : c2) {
                if (this.contains(qName)) continue;
                super.add(index + k, qName);
                result = true;
                ++k;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends QName> c2) {
        if (c2 != null) {
            boolean result = false;
            for (QName qName : c2) {
                if (this.contains(qName)) continue;
                super.add(qName);
                result = true;
            }
            return result;
        }
        return false;
    }

    public boolean contains(String ns, String name) {
        this.key.setNamespace(ns);
        this.key.setLocalPart(name);
        return this.contains(this.key);
    }

    public QName first() {
        return this.size() == 0 ? null : (QName)this.get(0);
    }

    public QName last() {
        return this.size() == 0 ? null : (QName)this.get(this.size() - 1);
    }

    public Set<String> getStringSet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>(this.size());
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            set.add(((QName)this.get(i)).toString());
        }
        assert (set.size() == this.size());
        return set;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(20 * this.size());
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            sb.append(((QName)this.get(i)).toString());
            if (i >= s - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }
}

