/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.Name;

public final class QName
extends Name {
    public static final String DEFAULT_NAMESPACE = "";
    private String namespaceURI;
    private String fullName;
    private String preferredPrefix;

    QName() {
        this(DEFAULT_NAMESPACE, DEFAULT_NAMESPACE);
    }

    public QName(String qname) {
        int index = qname.indexOf(":");
        if (index == -1) {
            this.namespaceURI = DEFAULT_NAMESPACE;
            this.localPart = qname;
        } else {
            this.namespaceURI = qname.substring(0, index);
            this.localPart = qname.substring(index + 1);
        }
        this.fullName = qname;
    }

    public QName(String namespaceURI, String localPart) {
        assert (namespaceURI != null) : "Null namespace";
        this.namespaceURI = namespaceURI;
        this.localPart = localPart;
    }

    public QName(String namespaceURI, String localPart, String preferredPrefix) {
        this(namespaceURI, localPart);
        this.preferredPrefix = preferredPrefix;
    }

    public QName(QName qName) {
        assert (qName.namespaceURI != null) : "Null namespace";
        this.namespaceURI = qName.namespaceURI;
        this.localPart = qName.localPart;
        this.fullName = qName.fullName;
        this.preferredPrefix = qName.preferredPrefix;
    }

    public String getNamespace() {
        return this.namespaceURI;
    }

    public void setNamespace(String namespaceURI) {
        assert (namespaceURI != null) : "Null namespace";
        this.namespaceURI = namespaceURI;
    }

    public String getPreferredPrefix() {
        return this.preferredPrefix;
    }

    public boolean equals(String namespaceURI, String localPart) {
        assert (namespaceURI != null) : "Null namespace";
        boolean result = this.namespaceURI.equals(namespaceURI) && this.localPart.equals(localPart);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QName) {
            QName qName = (QName)obj;
            return this.equals(qName.namespaceURI, qName.localPart);
        }
        return false;
    }

    public int hashCode() {
        int result = this.namespaceURI.length() != 0 ? this.namespaceURI.hashCode() ^ super.hashCode() : super.hashCode();
        return result;
    }

    public String toString() {
        if (this.namespaceURI.length() == 0) {
            return this.localPart;
        }
        if (this.fullName != null) {
            return this.fullName;
        }
        StringBuilder b2 = new StringBuilder(this.namespaceURI.length() + this.localPart.length() + 1);
        b2.append(this.namespaceURI).append(':').append(this.localPart);
        this.fullName = b2.toString();
        return this.fullName;
    }
}

