/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.ThreadLocalToolkit;
import java.util.HashMap;
import java.util.Map;

public final class MimeMappings {
    public static final String MXML = "text/mxml";
    public static final String AS = "text/as";
    public static final String FXG = "text/fxg";
    public static final String ABC = "application/x-actionscript-bytecode";
    public static final String CSS = "text/css";
    public static final String PROPERTIES = "text/properties";
    public static final String JPEG = "image/jpeg";
    public static final String JPG = "image/jpg";
    public static final String PNG = "image/png";
    public static final String GIF = "image/gif";
    public static final String SVG = "image/svg";
    public static final String SVG_XML = "image/svg-xml";
    public static final String MP3 = "audio/mpeg";
    public static final String FLASH = "application/x-shockwave-flash";
    public static final String XML = "text/xml";
    public static final String TTF = "application/x-font-truetype";
    public static final String TTC = "application/x-font-truetype-collection";
    public static final String OTF = "application/x-font-opentype";
    public static final String FONT = "application/x-font";
    public static final String DFONT = "application/x-dfont";
    public static final String PBJ = "application/x-pbj";
    public static final String TIFF = "image/tiff";
    public static final String SKIN = "skin";
    private Map<String, Object> mimeMappings = new HashMap<String, Object>();
    private static MimeMappings statics = new MimeMappings();

    public MimeMappings() {
        this.set(MXML, ".mxml");
        this.set(AS, ".as");
        this.set(FXG, ".fxg");
        this.set(ABC, ".abc");
        this.set(CSS, ".css");
        this.set(PROPERTIES, ".properties");
        this.set(JPEG, new String[]{".jpg", ".jpeg"});
        this.set(JPG, new String[]{".jpg", ".jpeg"});
        this.set(PNG, ".png");
        this.set(GIF, ".gif");
        this.set(SVG, new String[]{".svg", ".svgz"});
        this.set(MP3, ".mp3");
        this.set(FLASH, ".swf");
        this.set(XML, ".xml");
        this.set(TTF, ".ttf");
        this.set(TTC, ".ttc");
        this.set(OTF, ".otf");
        this.set(DFONT, ".dfont");
        this.set(PBJ, ".pbj");
        this.set(TIFF, new String[]{".tiff", ".tif"});
    }

    public void set(String mimeType, String[] extensions) {
        this.mimeMappings.put(mimeType, extensions);
    }

    public void set(String mimeType, String extension) {
        this.mimeMappings.put(mimeType, extension);
    }

    public void add(String mimeType, String[] extensions) {
        if (extensions == null) {
            return;
        }
        Object value = this.mimeMappings.get(mimeType);
        String[] a2 = null;
        if (value instanceof String[]) {
            String[] old = (String[])value;
            a2 = new String[old.length + extensions.length];
            System.arraycopy(old, 0, a2, 0, old.length);
            System.arraycopy(extensions, 0, a2, a2.length, extensions.length);
        } else if (value instanceof String) {
            a2 = new String[1 + extensions.length];
            a2[0] = (String)value;
            System.arraycopy(extensions, 0, a2, 1, extensions.length);
        } else {
            a2 = new String[extensions.length];
            System.arraycopy(extensions, 0, a2, 0, extensions.length);
        }
        this.mimeMappings.put(mimeType, a2);
    }

    public void add(String mimeType, String extension) {
        if (extension == null) {
            return;
        }
        Object value = this.mimeMappings.get(mimeType);
        String[] a2 = null;
        if (value instanceof String[]) {
            String[] old = (String[])value;
            a2 = new String[old.length + 1];
            System.arraycopy(old, 0, a2, 0, old.length);
            a2[a2.length - 1] = extension;
            this.mimeMappings.put(mimeType, a2);
        } else if (value instanceof String) {
            a2 = new String[]{(String)value, extension};
            this.mimeMappings.put(mimeType, a2);
        } else {
            this.mimeMappings.put(mimeType, extension);
        }
    }

    public void remove(String mimeType) {
        this.mimeMappings.remove(mimeType);
    }

    public String findMimeType(String name) {
        for (String mimeType : this.mimeMappings.keySet()) {
            int elen;
            int nlen;
            Object value = this.mimeMappings.get(mimeType);
            if (value instanceof String[]) {
                String[] extensions = (String[])value;
                int size = extensions.length;
                for (int j = 0; j < size; ++j) {
                    int elen2;
                    int nlen2 = name.length();
                    if (nlen2 <= (elen2 = extensions[j].length()) || !name.regionMatches(true, nlen2 - elen2, extensions[j], 0, elen2)) continue;
                    return mimeType;
                }
                continue;
            }
            if (!(value instanceof String) || (nlen = name.length()) <= (elen = ((String)value).length()) || !name.regionMatches(true, nlen - elen, (String)value, 0, elen)) continue;
            return mimeType;
        }
        return null;
    }

    public String findExtension(String mimeType) {
        Object value = this.mimeMappings.get(mimeType);
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeType(String name) {
        MimeMappings mappings = ThreadLocalToolkit.getMimeMappings();
        if (mappings == null) {
            MimeMappings mimeMappings = statics;
            synchronized (mimeMappings) {
                return statics.findMimeType(name);
            }
        }
        return mappings.findMimeType(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExtension(String mimeType) {
        MimeMappings mappings = ThreadLocalToolkit.getMimeMappings();
        if (mappings == null) {
            MimeMappings mimeMappings = statics;
            synchronized (mimeMappings) {
                return statics.findExtension(mimeType);
            }
        }
        return mappings.findExtension(mimeType);
    }
}

