/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ManifestParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void parse(String namespaceURI, VirtualFile file, NameMappings mappings) {
        if (file == null) {
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(file.getInputStream());
        }
        catch (FileNotFoundException ex) {
            return;
        }
        catch (IOException ex) {
            ThreadLocalToolkit.logError(file.getNameForReporting(), ex.getMessage());
            return;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse((InputStream)in, (DefaultHandler)new Parser(file.getName(), mappings, namespaceURI));
        Object var7_9 = null;
        if (in == null) return;
        try {
            ((InputStream)in).close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (Exception ex) {
                ThreadLocalToolkit.logError(file.getNameForReporting(), ex.getMessage());
                Object var7_10 = null;
                if (in == null) return;
                try {
                    ((InputStream)in).close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static class ManifestError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 7519143031979293680L;
        public final String fileName;
        public final int line;
        public final String message;

        public ManifestError(String fileName, int line, String message) {
            this.fileName = fileName;
            this.line = line;
            this.message = message;
        }
    }

    public static class DuplicateComponentDefinition
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1072579721984054648L;
        public final String fileName;
        public final int line;
        public final String tag;

        public DuplicateComponentDefinition(String fileName, int line, String tag) {
            this.fileName = fileName;
            this.line = line;
            this.tag = tag;
        }
    }

    public static class InvalidClassName
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1805088670961745449L;
        public final String fileName;
        public final int line;
        public final String tag;

        public InvalidClassName(String fileName, int line, String tag) {
            this.fileName = fileName;
            this.line = line;
            this.tag = tag;
        }
    }

    public static class UndefinedClass
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 982393613817885400L;
        public final String fileName;
        public final int line;
        public final String tag;

        public UndefinedClass(String fileName, int line, String tag) {
            this.fileName = fileName;
            this.line = line;
            this.tag = tag;
        }
    }

    private static class Parser
    extends DefaultHandler {
        private String fileName;
        private NameMappings mappings;
        private String namespaceURI;
        private Locator locator;

        Parser(String fileName, NameMappings mappings, String namespaceURI) {
            this.fileName = fileName;
            this.mappings = mappings;
            this.namespaceURI = namespaceURI;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("component")) {
                String lookupOnlyStr;
                String id = attributes.getValue("id");
                String className = attributes.getValue("class");
                if (className == null) {
                    ThreadLocalToolkit.log(new UndefinedClass(this.fileName, this.locator.getLineNumber(), id));
                    return;
                }
                if ("*".equals(className)) {
                    ThreadLocalToolkit.log(new InvalidClassName(this.fileName, this.locator.getLineNumber(), id));
                } else {
                    assert (className.indexOf(58) == -1 && className.indexOf(47) == -1) : this.fileName + ": " + className;
                    className = NameFormatter.toColon(className);
                }
                if (id == null) {
                    id = NameFormatter.retrieveClassName(className);
                }
                boolean lookupOnly = (lookupOnlyStr = attributes.getValue("lookupOnly")) == null ? false : Boolean.valueOf(lookupOnlyStr);
                boolean added = this.mappings.addClass(this.namespaceURI, id, className);
                if (!added) {
                    ThreadLocalToolkit.log(new DuplicateComponentDefinition(this.fileName, this.locator.getLineNumber(), id));
                    return;
                }
                if (lookupOnly) {
                    this.mappings.addLookupOnly(this.namespaceURI, className);
                }
            }
        }

        public void warning(SAXParseException e2) {
            ThreadLocalToolkit.log(new ManifestError(this.fileName, e2.getLineNumber(), e2.getMessage()));
        }

        public void error(SAXParseException e2) {
            ThreadLocalToolkit.log(new ManifestError(this.fileName, e2.getLineNumber(), e2.getMessage()));
        }

        public void fatalError(SAXParseException e2) throws SAXParseException {
            ThreadLocalToolkit.log(new ManifestError(this.fileName, e2.getLineNumber(), e2.getMessage()));
            throw e2;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

