/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import java.util.SortedMap;
import java.util.TreeMap;

public class LineNumberMap {
    private String oldName;
    private String newName;
    private final SortedMap<Range, Integer> map;
    private final Range lookup;

    public LineNumberMap(String name, String newName) {
        this.oldName = name;
        this.newName = newName;
        this.map = new TreeMap<Range, Integer>();
        this.lookup = new Range(0, 1);
    }

    public LineNumberMap(String name) {
        this(name, name);
    }

    public final void setNewName(String newName) {
        this.newName = newName;
    }

    public final String getOldName() {
        return this.oldName;
    }

    public final String getNewName() {
        return this.newName;
    }

    public final void put(int oldStart, int newStart, int extent) {
        this.map.put(new Range(newStart, extent), new Integer(newStart - oldStart));
    }

    public int get(int newLine) {
        this.lookup.start = newLine;
        Integer delta = (Integer)this.map.get(this.lookup);
        return delta == null ? 0 : newLine - delta;
    }

    private final class Range
    implements Comparable {
        private int start;
        private int extent;

        Range(int start, int extent) {
            this.start = start;
            this.extent = extent;
        }

        public final int compareTo(Object o) {
            if (!(o instanceof Range)) {
                throw new IllegalArgumentException("argument must be Range");
            }
            Range e2 = (Range)o;
            return this.start < e2.start ? -1 : (this.start + this.extent > e2.start + e2.extent ? 1 : 0);
        }

        public String toString() {
            return "Range: start = " + this.start + ", extent = " + this.extent;
        }
    }
}

