/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flash.localization.LocalizationManager;
import flex2.compiler.CompilerException;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.util.ThreadLocalToolkit;

public class CompilerMessage
extends CompilerException
implements ILocalizableMessage {
    private static final long serialVersionUID = 3500487484906739205L;
    public String level;
    public String path;
    public int line;
    public int column;
    private Exception detailEx;
    private boolean isPathAvailable;

    public CompilerMessage(String level, String path, int line, int col) {
        this.level = level;
        this.path = path;
        this.line = line;
        this.column = col;
        this.isPathAvailable = true;
    }

    public CompilerMessage(String level, String path, int line, int col, Throwable rootCause) {
        super(rootCause);
        this.level = level;
        this.path = path;
        this.line = line;
        this.column = col;
        this.isPathAvailable = true;
        if (rootCause instanceof Exception) {
            this.detailEx = (Exception)rootCause;
        }
    }

    public String getLevel() {
        return this.level;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public Exception getExceptionDetail() {
        return this.detailEx;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null) {
            return msg;
        }
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        if (l10n == null) {
            return null;
        }
        return l10n.getLocalizedTextString(this);
    }

    public String toString() {
        return this.getMessage();
    }

    public boolean isPathAvailable() {
        return this.isPathAvailable;
    }

    protected void noPath() {
        this.isPathAvailable = false;
    }

    public static class CompilerInfo
    extends CompilerMessage {
        private static final long serialVersionUID = 7011676633916976231L;

        public CompilerInfo() {
            super("info", null, -1, -1);
        }

        public CompilerInfo(Throwable rootCause) {
            super("info", null, -1, -1, rootCause);
        }
    }

    public static class CompilerWarning
    extends CompilerMessage {
        private static final long serialVersionUID = -6415139860097981650L;

        public CompilerWarning() {
            super("warning", null, -1, -1);
        }

        public CompilerWarning(Throwable rootCause) {
            super("warning", null, -1, -1, rootCause);
        }
    }

    public static class CompilerError
    extends CompilerMessage {
        private static final long serialVersionUID = -4267301959263918376L;

        public CompilerError() {
            super("error", null, -1, -1);
        }

        public CompilerError(Throwable rootCause) {
            super("error", null, -1, -1, rootCause);
        }
    }
}

