/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Benchmark {
    public static final String PRECOMPILE = "precompile";
    public static final String POSTCOMPILE = "postcompile";
    private long start = 0L;
    private long begin = 0L;
    private long timeFilter = 0L;
    private Map<String, Long> startTimes;
    private Map<String, Long> durations;

    public void start() {
        this.begin = this.start = System.currentTimeMillis();
    }

    public void benchmark(String message) {
        long currentTime = System.currentTimeMillis();
        if (this.start != 0L) {
            ThreadLocalToolkit.log(new BenchmarkText(message, currentTime - this.start));
        }
        this.start = currentTime;
        if (this.begin == 0L) {
            this.begin = currentTime;
        }
    }

    public void benchmark2(String message) {
        this.benchmark2(message, false);
    }

    public void benchmark2(String message, boolean ignoreTimeFilter) {
        long currentTime = System.currentTimeMillis();
        if (this.start != 0L) {
            long duration = currentTime - this.start;
            if (ignoreTimeFilter || duration >= this.timeFilter) {
                ThreadLocalToolkit.log(new BenchmarkTotalText(message, duration, currentTime - this.begin));
            }
        }
        this.start = currentTime;
        if (this.begin == 0L) {
            this.begin = currentTime;
        }
    }

    public void setTimeFilter(long timeFilter) {
        this.timeFilter = timeFilter;
    }

    public long getTimeFilter() {
        return this.timeFilter;
    }

    public void totalTime() {
        ThreadLocalToolkit.log(new TotalTime(System.currentTimeMillis() - this.begin));
    }

    public boolean hasStarted(String id) {
        boolean result = false;
        if (this.startTimes != null) {
            result = this.startTimes.containsKey(id);
        }
        return result;
    }

    public long getTime(String id) {
        Long duration;
        long result = -1L;
        if (this.durations != null && (duration = this.durations.get(id)) != null) {
            result = duration;
        }
        return result;
    }

    public final long stopTime(String id) {
        return this.stopTime(id, true);
    }

    public final long stopTime(String id, boolean reset) {
        long currentTime = System.currentTimeMillis();
        Long startTimeObject = this.startTimes.remove(id);
        if (startTimeObject == null) {
            throw new IllegalStateException("Call startTime before calling stopTime");
        }
        long startTime = startTimeObject;
        long duration = currentTime - startTime;
        ThreadLocalToolkit.log(new BenchmarkID(id, duration));
        if (reset) {
            this.startTime(id);
        }
        if (this.durations == null) {
            this.durations = new HashMap<String, Long>();
        }
        this.durations.put(id, duration);
        return duration;
    }

    public final void startTime(String id) {
        if (this.startTimes == null) {
            this.startTimes = new HashMap<String, Long>();
        }
        this.startTimes.put(id, new Long(System.currentTimeMillis()));
    }

    public final long peakMemoryUsage() {
        return this.peakMemoryUsage(true);
    }

    public final long peakMemoryUsage(boolean display) {
        MemoryUsage mem = this.getMemoryUsageInBytes();
        long mbHeapUsed = mem.heap / 0x100000L;
        long mbNonHeapUsed = mem.nonHeap / 0x100000L;
        if (display && mem.heap != 0L && mem.nonHeap != 0L) {
            ThreadLocalToolkit.log(new MemoryUsage(mbHeapUsed, mbNonHeapUsed));
        }
        return mbHeapUsed + mbNonHeapUsed;
    }

    public final long peakMemoryUsageInBytes() {
        return this.peakMemoryUsage(true);
    }

    public final long peakMemoryUsageInBytes(boolean display) {
        MemoryUsage mem = this.getMemoryUsageInBytes();
        if (display && mem.heap != 0L && mem.nonHeap != 0L) {
            ThreadLocalToolkit.log(mem);
        }
        return mem.total;
    }

    public MemoryUsage getMemoryUsageInBytes() {
        long heapUsed = 0L;
        long nonHeapUsed = 0L;
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Class<?> mfCls = Class.forName("java.lang.management.ManagementFactory", true, contextClassLoader);
            Class<?> mpCls = Class.forName("java.lang.management.MemoryPoolMXBean", true, contextClassLoader);
            Class<?> memCls = Class.forName("java.lang.management.MemoryUsage", true, contextClassLoader);
            Class<?> typeCls = Class.forName("java.lang.management.MemoryType", true, contextClassLoader);
            Class[] emptyCls = new Class[]{};
            Object[] emptyObj = new Object[]{};
            Method getMemPoolMeth = mfCls.getMethod("getMemoryPoolMXBeans", emptyCls);
            Method getPeakUsageMeth = mpCls.getMethod("getPeakUsage", emptyCls);
            Method getTypeMeth = mpCls.getMethod("getType", emptyCls);
            Field heapField = typeCls.getField("HEAP");
            Method getUsedMeth = memCls.getMethod("getUsed", emptyCls);
            List list = (List)getMemPoolMeth.invoke(null, emptyObj);
            for (Object memPoolObj : list) {
                Object memUsageObj = getPeakUsageMeth.invoke(memPoolObj, emptyObj);
                Object memTypeObj = getTypeMeth.invoke(memPoolObj, emptyObj);
                Long used = (Long)getUsedMeth.invoke(memUsageObj, emptyObj);
                if (heapField.get(typeCls) == memTypeObj) {
                    heapUsed += used.longValue();
                    continue;
                }
                nonHeapUsed += used.longValue();
            }
            this.resetPeakMemoryUsage();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return new MemoryUsage(heapUsed, nonHeapUsed);
    }

    private void resetPeakMemoryUsage() {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Class<?> mfCls = Class.forName("java.lang.management.ManagementFactory", true, contextClassLoader);
            Class<?> mpCls = Class.forName("java.lang.management.MemoryPoolMXBean", true, contextClassLoader);
            Class[] emptyCls = new Class[]{};
            Object[] emptyObj = new Object[]{};
            Method getMemPoolMeth = mfCls.getMethod("getMemoryPoolMXBeans", emptyCls);
            Method resetPeakUsageMeth = mpCls.getMethod("resetPeakUsage", emptyCls);
            List list = (List)getMemPoolMeth.invoke(null, emptyObj);
            for (Object memPoolObj : list) {
                resetPeakUsageMeth.invoke(memPoolObj, emptyObj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void captureMemorySnapshot() {
    }

    public static class MemoryUsage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -6475223071208094608L;
        public long heap;
        public long nonHeap;
        public long total;

        public MemoryUsage(long heap, long nonHeap) {
            this.heap = heap;
            this.nonHeap = nonHeap;
            this.total = heap + nonHeap;
        }

        public void add(MemoryUsage mem) {
            this.heap += mem.heap;
            this.nonHeap += mem.nonHeap;
            this.total += mem.total;
        }

        public void subtract(MemoryUsage mem) {
            this.heap -= mem.heap;
            this.nonHeap -= mem.nonHeap;
            this.total -= mem.total;
        }
    }

    public static class TotalTime
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -4183269812522994075L;
        public final long time;

        public TotalTime(long time) {
            this.time = time;
        }
    }

    public static class BenchmarkID
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -8665059678509053629L;
        public final String id;
        public final long duration;

        public BenchmarkID(String id, long duration) {
            this.id = id;
            this.duration = duration;
        }
    }

    public static class BenchmarkTotalText
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 4446977969005129123L;
        public final String message;
        public final long time;
        public final long total;

        public BenchmarkTotalText(String message, long time, long total) {
            this.message = message;
            this.time = time;
            this.total = total;
        }
    }

    public static class BenchmarkText
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -8135623655978440213L;
        public final String message;
        public final long time;

        public BenchmarkText(String message, long time) {
            this.message = message;
            this.time = time;
        }
    }
}

