/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;

public abstract class AbstractLogger
implements Logger {
    public boolean initialized = false;
    protected String INFO;
    protected String WARNING;
    protected String ERROR;
    protected String COL;
    protected String RECOMPILE;
    protected String REASON;
    protected String INCLUDEUPDATED;
    protected String INCLUDEAFFECTED;
    private LocalizationManager localizationManager;

    public void init(LocalizationManager l10n) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (l10n != null) {
            this.INFO = l10n.getLocalizedTextString("flex2.compiler.util.AbstractLogger.Info");
            this.WARNING = l10n.getLocalizedTextString("flex2.compiler.util.AbstractLogger.Warning");
            this.ERROR = l10n.getLocalizedTextString("flex2.compiler.util.AbstractLogger.Error");
            this.COL = l10n.getLocalizedTextString("flex2.compiler.util.AbstractLogger.col");
            this.RECOMPILE = l10n.getLocalizedTextString("flex2.compiler.util.AbstractLogger.Recompile");
            this.REASON = l10n.getLocalizedTextString("flex2.compiler.util.AbstractLogger.Reason");
            this.INCLUDEAFFECTED = this.INCLUDEUPDATED = l10n.getLocalizedTextString("flex2.compiler.util.AbstractLogger.IncludeUpdated");
        }
        if (this.INFO == null) {
            this.INFO = "Info";
        }
        if (this.WARNING == null) {
            this.WARNING = "Warning";
        }
        if (this.ERROR == null) {
            this.ERROR = "Error";
        }
        if (this.COL == null) {
            this.COL = "col";
        }
        if (this.RECOMPILE == null) {
            this.RECOMPILE = "Recompile";
        }
        if (this.REASON == null) {
            this.REASON = "Reason";
        }
        if (this.INCLUDEUPDATED == null) {
            this.INCLUDEAFFECTED = this.INCLUDEUPDATED = "Updated";
        }
    }

    public String formatPrefix(LocalizationManager l10n, ILocalizableMessage m) {
        this.init(l10n);
        StringBuilder prefix = new StringBuilder();
        if (m.getPath() != null) {
            prefix.append(m.getPath());
            if (m.getLine() != -1) {
                prefix.append('(');
                prefix.append(m.getLine());
                prefix.append(")");
                if (m.getColumn() != -1) {
                    prefix.append(": ");
                    prefix.append(this.COL);
                    prefix.append(": ");
                    prefix.append(m.getColumn());
                }
            }
            prefix.append(": ");
        }
        if (m.getLevel() == "error") {
            prefix.append(this.ERROR);
            prefix.append(": ");
        } else if (m.getLevel() == "warning") {
            prefix.append(this.WARNING);
            prefix.append(": ");
        } else if (m.getLevel() != "info") assert (false) : "Unhandled ILocalizableMessage type";
        return prefix.toString();
    }

    protected String formatExceptionDetail(ILocalizableMessage m, LocalizationManager loc) {
        String exText = null;
        Exception ex = m.getExceptionDetail();
        if (ex != null) {
            if (ex instanceof ILocalizableMessage) {
                exText = loc.getLocalizedTextString(m.getExceptionDetail());
            } else {
                exText = ex.getMessage();
                if (exText == null) {
                    exText = ex.getClass().getName();
                }
            }
        }
        exText = exText == null ? "" : ": " + exText;
        return exText;
    }

    public void setLocalizationManager(LocalizationManager mgr) {
        this.localizationManager = mgr;
    }

    public LocalizationManager getLocalizationManager() {
        return this.localizationManager;
    }
}

