/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.Frame;
import flash.swf.tags.FrameLabel;
import flex2.compiler.CompilationUnit;
import flex2.compiler.swc.Swc;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.graph.Visitor;
import flex2.linker.CULinkable;
import flex2.linker.DependencyWalker;
import flex2.linker.FlexMovie;
import flex2.linker.Linkable;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcMovie
extends SimpleMovie {
    private Set<String> externs;
    private Set<String> includes;
    private Set<String> unresolved;
    private SortedSet<String> resourceBundles;

    public SwcMovie(LinkerConfiguration linkerConfiguration) {
        super(linkerConfiguration);
        this.externs = new HashSet<String>(linkerConfiguration.getExterns());
        this.includes = new LinkedHashSet<String>(linkerConfiguration.getIncludes());
        this.unresolved = new HashSet<String>(linkerConfiguration.getUnresolved());
        this.generateLinkReport = linkerConfiguration.generateLinkReport();
        this.generateRBList = linkerConfiguration.generateRBList();
        this.resourceBundles = new TreeSet<String>(linkerConfiguration.getResourceBundles());
    }

    @Override
    public void generate(List<CompilationUnit> units) throws LinkerException {
        LinkedList<CULinkable> linkables = new LinkedList<CULinkable>();
        Iterator<CompilationUnit> it = units.iterator();
        while (it.hasNext()) {
            linkables.add(new CULinkable(it.next()));
        }
        this.frames = new ArrayList();
        try {
            if (this.getInheritanceDependenciesOnly() && this.rootClassName != null) {
                this.includes.add(this.rootClassName);
            }
            DependencyWalker.LinkState state = new DependencyWalker.LinkState(linkables, this.externs, this.includes, this.unresolved);
            final Frame frame = new Frame();
            DependencyWalker.traverse(null, state, true, true, this.getInheritanceDependenciesOnly(), new Visitor<Linkable>(){

                @Override
                public void visit(Linkable o) {
                    CULinkable l = (CULinkable)o;
                    SwcMovie.this.exportUnitOnFrame(l.getUnit(), frame, true);
                }
            });
            this.frames.add(frame);
            if (Swc.FNORD) {
                frame.label = new FrameLabel();
                frame.label.label = Integer.toString(SimpleMovie.getCodeHash(frame));
            }
            if (this.generateLinkReport) {
                this.linkReport = DependencyWalker.dump(state);
            }
            if (this.generateRBList) {
                this.rbList = FlexMovie.dumpRBList(this.resourceBundles);
            }
            if (this.unresolved.size() != 0) {
                for (String u : this.unresolved) {
                    if (this.externs.contains(u)) continue;
                    ThreadLocalToolkit.log(new LinkerException.UndefinedSymbolException(u));
                }
            }
            this.topLevelClass = SwcMovie.formatSymbolClassName(this.rootClassName);
        }
        catch (LinkerException e2) {
            ThreadLocalToolkit.log(e2);
        }
    }
}

