/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.Tag;
import flash.swf.TagDecoder;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoABC;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.swc.catalog.CatalogReader;
import flex2.compiler.util.NameFormatter;
import flex2.linker.SimpleMovie;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcLibrary {
    protected final Swc swc;
    protected final String path;
    protected List<SwcScript> scripts;
    protected Map<String, SwcScript> name2script;
    protected Map<String, DefineTag> def2symbol;
    protected boolean parsed;
    private Set<String> externs;
    private String location = null;
    private Set<String> metadata;
    protected Map<String, Digest> digests = new HashMap<String, Digest>();

    public SwcLibrary(Swc swc, String path) {
        this.swc = swc;
        this.path = path;
        this.scripts = new LinkedList<SwcScript>();
        this.parsed = false;
        this.name2script = new HashMap<String, SwcScript>();
        this.externs = new HashSet<String>();
        this.metadata = new HashSet<String>();
    }

    public Swc getSwc() {
        return this.swc;
    }

    public String getPath() {
        return this.path;
    }

    public String getSwcLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.swc.getLocation();
    }

    public long getSwcCreationTime() {
        return this.swc.getLastModified();
    }

    public void clear() {
        this.scripts = null;
        this.def2symbol = null;
    }

    public Set<String> getExterns() {
        return this.externs;
    }

    public SwcScript addScript(String name, Set<String> defs, SwcDependencySet deps, long modtime, Long signatureChecksum) {
        SwcScript script = new SwcScript(this, name, defs, deps, modtime, signatureChecksum);
        this.scripts.add(script);
        this.name2script.put(script.getName(), script);
        assert (name != null && name.length() > 0);
        return script;
    }

    public Iterator<SwcScript> getScriptIterator() {
        return this.scripts.iterator();
    }

    public DefineTag getSymbol(String name) {
        DefineTag result = null;
        if (this.def2symbol != null) {
            name = name.replace(':', '.');
            result = this.def2symbol.get(name);
        }
        return result;
    }

    protected SwcScript getScript(DoABC doABC) {
        assert (doABC.code == 82);
        return this.name2script.get(doABC.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void parse() {
        Movie movie;
        block19: {
            IOException ioException2222;
            Object var7_8;
            InputStream inputStream;
            VirtualFile swcFile;
            block18: {
                if (this.parsed) {
                    return;
                }
                swcFile = this.swc.getArchive().getFile(this.path);
                if (swcFile == null) {
                    throw new SwcException.CatalogNotFound();
                }
                movie = new Movie();
                MovieDecoder movieDecoder = new MovieDecoder(movie);
                inputStream = null;
                inputStream = swcFile.getInputStream();
                TagDecoder tagDecoder = new TagDecoder(inputStream);
                tagDecoder.parse(movieDecoder);
                var7_8 = null;
                if (inputStream == null) break block18;
                try {
                    inputStream.close();
                }
                catch (IOException ioException2222) {
                    // empty catch block
                }
            }
            swcFile.close();
            {
                break block19;
                catch (IOException e2) {
                    var7_8 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ioException2222) {
                            // empty catch block
                        }
                    }
                    swcFile.close();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioException2222) {
                        // empty catch block
                    }
                }
                swcFile.close();
                throw throwable;
            }
        }
        int c1 = 0;
        this.def2symbol = new HashMap<String, DefineTag>();
        for (Frame frame : movie.frames) {
            int c2;
            for (DoABC doABC : frame.doABCs) {
                SwcScript script = this.getScript(doABC);
                script.setABC(doABC.abc);
            }
            for (Map.Entry<String, Tag> e3 : frame.symbolClass.class2tag.entrySet()) {
                String className = e3.getKey();
                DefineTag tag = (DefineTag)e3.getValue();
                this.def2symbol.put(className, tag);
            }
            if (!Swc.FNORD) continue;
            if (frame.label != null) {
                try {
                    c1 = Integer.parseInt(frame.label.label);
                }
                catch (Exception e4) {
                    // empty catch block
                }
            }
            if (c1 == (c2 = SimpleMovie.getCodeHash(frame))) continue;
            this.location = " " + this.swc.getLocation();
        }
        this.parsed = true;
    }

    void getSymbolClasses(String def, Set<String> symbolClasses) {
        DefineTag t = this.getSymbol(def);
        HashSet<Tag> visited = new HashSet<Tag>();
        this.getReferencedSymbolClasses(t, symbolClasses, visited);
    }

    void getReferencedSymbolClasses(Tag t, Set<String> symbolClasses, HashSet<Tag> visited) {
        if (t != null && !visited.contains(t)) {
            visited.add(t);
            Iterator<Tag> i = t.getReferences();
            while (i != null && i.hasNext()) {
                Tag r = i.next();
                if (r != null) {
                    for (String className : this.def2symbol.keySet()) {
                        if (this.def2symbol.get(className) != r) continue;
                        symbolClasses.add(NameFormatter.toColon(className));
                    }
                }
                this.getReferencedSymbolClasses(r, symbolClasses, visited);
            }
        }
    }

    public Set<String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Set<String> metadata) {
        this.metadata = metadata;
    }

    public void addMetadata(Collection<String> metadata) {
        this.metadata.addAll(metadata);
    }

    public Digest getDigest(String hashType, boolean isSigned) {
        if (hashType == null) {
            throw new NullPointerException("hashType may not be null");
        }
        return this.digests.get(CatalogReader.createDigestHashValue(hashType, isSigned));
    }

    public void setDigest(Digest digest) {
        if (digest == null) {
            throw new NullPointerException("setDigest:  digest may not be null");
        }
        this.digests.put(CatalogReader.createDigestHashValue(digest.getType(), digest.isSigned()), digest);
    }

    public Map<String, Digest> getDigests() {
        return this.digests;
    }

    public void setDigests(Map<String, Digest> digests) {
        this.digests = digests;
    }
}

