/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.Trace;
import flex2.compiler.io.VirtualZipFile;
import flex2.compiler.io.ZipFileHolder;
import flex2.compiler.swc.SwcDynamicArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipFile;
import flex2.compiler.util.MimeMappings;
import java.io.File;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;

public class SwcLazyReadArchive
extends SwcDynamicArchive {
    private ZipFileHolder zipFileHolder;

    public SwcLazyReadArchive(String path) {
        super(path);
    }

    public SwcLazyReadArchive(OutputStream out, String path) {
        super(out, path);
    }

    public void load() {
        assert (this.files == null);
        this.files = new HashMap();
        try {
            File file = new File(this.path);
            ZipFile zipFile = new ZipFile(file);
            this.zipFileHolder = new ZipFileHolder(zipFile, this.path);
            Enumeration<ZipEntry> e2 = zipFile.getEntries();
            while (e2.hasMoreElements()) {
                ZipEntry ze = e2.nextElement();
                String name = ze.getName();
                VirtualZipFile f2 = new VirtualZipFile(this.zipFileHolder, MimeMappings.getMimeType(name), this.path + "$" + name, name);
                this.files.put(name, f2);
            }
        }
        catch (SwcException.UnknownZipFormat e3) {
            throw new SwcException.NotASwcFile(this.path);
        }
        catch (SwcException e4) {
            throw e4;
        }
        catch (Exception e5) {
            if (Trace.error) {
                e5.printStackTrace();
            }
            throw new SwcException.FilesNotRead(e5.getMessage());
        }
    }

    public void close() {
        this.zipFileHolder.close();
    }
}

