/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcDirectoryArchive
implements SwcArchive {
    private final String dir;
    private Set<String> fileList;

    public SwcDirectoryArchive(String path) {
        this.dir = path;
    }

    @Override
    public String getLocation() {
        return this.dir;
    }

    @Override
    public void load() {
        String swcPath = this.filePath(Swc.CATALOG_XML);
        File c2 = new File(swcPath);
        if (!c2.exists()) {
            throw new SwcException.NotASwcDirectory(this.dir);
        }
        this.fileList = new HashSet<String>();
        this.readFiles(this.fileList, "", new File(this.dir));
    }

    private void readFiles(Set<String> s, String current, File f2) {
        if (f2.isDirectory()) {
            File[] files = FileUtils.listFiles(f2);
            for (int i = 0; i < files.length; ++i) {
                String relpath = FileUtils.addPathComponents(current, files[i].getName(), File.separatorChar);
                File absFile = new File(this.filePath(relpath));
                this.readFiles(s, relpath, absFile);
            }
        } else {
            s.add(current.replace(File.separatorChar, '/'));
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void close() {
    }

    @Override
    public Map<String, VirtualFile> getFiles() {
        if (this.fileList == null) {
            this.load();
        }
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        for (String filename : this.fileList) {
            map.put(filename, new RelativeLocalFile(new File(this.filePath(filename)), this.dir + "$" + filename));
        }
        return map;
    }

    @Override
    public VirtualFile getFile(String path) {
        if (this.fileList == null) {
            this.load();
        }
        if (this.fileList.contains(path)) {
            return new RelativeLocalFile(new File(this.filePath(path)), this.dir + "$" + path);
        }
        return null;
    }

    public boolean exists(String path) {
        if (this.fileList == null) {
            this.load();
        }
        return this.fileList.contains(path);
    }

    private String filePath(String path) {
        return FileUtils.addPathComponents(this.dir, path, File.separatorChar);
    }

    @Override
    public void putFile(VirtualFile file) {
        this.makeDirectory();
        try {
            File tmp = new File(this.filePath(file.getName() + ".tmp"));
            tmp = FileUtils.getAbsoluteFile(tmp);
            if (tmp == null) {
                throw new SwcException.FileNotWritten(file.getName(), "");
            }
            tmp.getParentFile().mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            FileUtil.streamOutput(file.getInputStream(), out);
            ((OutputStream)out).close();
            File f2 = new File(this.filePath(file.getName()));
            FileUtils.renameFile(tmp, f2);
            if (this.fileList == null) {
                this.fileList = new HashSet<String>();
            }
            this.fileList.add(file.getName());
        }
        catch (SwcException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new SwcException.FileNotWritten(file.getName(), e3.getMessage());
        }
    }

    @Override
    public void putFile(String path, byte[] data, long lastModified) {
        this.makeDirectory();
        try {
            File tmp = new File(this.filePath(path + ".tmp"));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
            File f2 = new File(this.filePath(path));
            FileUtils.renameFile(tmp, f2);
            if (this.fileList == null) {
                this.fileList = new HashSet<String>();
            }
            this.fileList.add(path);
        }
        catch (Exception e2) {
            if (Trace.error) {
                e2.printStackTrace();
            }
            throw new SwcException.FileNotWritten(path, e2.getMessage());
        }
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    private void makeDirectory() {
        File d2 = new File(this.dir);
        if (d2.exists() && !d2.isDirectory()) {
            throw new SwcException.NotADirectory(this.dir);
        }
        if (!d2.exists()) {
            try {
                d2.mkdirs();
            }
            catch (Exception e2) {
                if (Trace.error) {
                    e2.printStackTrace();
                }
                throw new SwcException.DirectoryNotCreated(this.dir);
            }
        }
        if (!d2.exists() || !d2.isDirectory()) {
            throw new SwcException.DirectoryNotCreated(this.dir);
        }
    }

    private static class RelativeLocalFile
    extends LocalFile {
        private String name;

        public RelativeLocalFile(File f2, String name) {
            super(f2);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

