/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.StatesGenerator;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.AtClear;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.DocumentInfo;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MovieClip;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Reparent;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.mxml.rep.Vector;
import flex2.compiler.mxml.rep.decl.PropertyDeclaration;
import flex2.compiler.mxml.rep.init.EventInitializer;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.mxml.rep.init.NamedInitializer;
import flex2.compiler.mxml.rep.init.ValueInitializer;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.IteratorList;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SetExpressionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatesModel {
    public final DocumentInfo info;
    public final MxmlDocument document;
    public final StandardDefs standardDefs;
    public final Map<String, State> states;
    public final Map<String, SharedObject> sharedObjects;
    public final Set<Object> initializedModels;
    public final List<String> earlyInitObjects;
    private Map<String, List<ReparentInfo>> reparentNodes;
    private Collection<Model> statefulModels;
    private final Set<String> statesDefined;
    private static final String _FACTORY = "_factory".intern();
    private static final String ADDITEMS = "AddItems".intern();
    private static final String DESTINATION = "destination".intern();
    private static final String DESTRUCTIONPOLICY = "destructionPolicy".intern();
    private static final String HANDLERFUNCTION = "handlerFunction".intern();
    private static final String INITIALIZEFROMOBJECT = "initializeFromObject".intern();
    private static final String ISARRAY = "isArray".intern();
    private static final String ISBASEVALUEDATABOUND = "isBaseValueDataBound".intern();
    private static final String ISSTYLE = "isStyle".intern();
    private static final String ITEMSFACTORY = "itemsFactory".intern();
    private static final String LESS_THAN = "<";
    private static final String NAME = "name".intern();
    private static final String OVERRIDES = "overrides".intern();
    private static final String ORIGINALHANDLERFUNCTION = "originalHandlerFunction".intern();
    private static final String POSITION = "position".intern();
    private static final String PROPERTYNAME = "propertyName".intern();
    private static final String RELATIVETO = "relativeTo".intern();
    private static final String SETPROPERTY = "SetProperty".intern();
    private static final String SETSTYLE = "SetStyle".intern();
    private static final String SETEVENTHANDLER = "SetEventHandler".intern();
    private static final String STATE = "State".intern();
    private static final String STATEGROUPS = "stateGroups".intern();
    private static final String TARGET = "target".intern();
    private static final String UNDEFINED = "undefined".intern();
    private static final String VALUE = "value".intern();
    private static final String VALUEFACTORY = "valueFactory".intern();
    private static final String VECTORCLASS = "vectorClass".intern();

    public StatesModel(MxmlDocument doc, DocumentInfo info, StandardDefs defs) {
        this.info = info;
        this.document = doc;
        this.standardDefs = defs;
        this.states = new HashMap<String, State>();
        this.sharedObjects = new TreeMap<String, SharedObject>();
        this.earlyInitObjects = new ArrayList<String>();
        this.statefulModels = new ArrayList<Model>();
        this.initializedModels = new HashSet<Object>();
        this.statesDefined = new HashSet<String>();
        if (!info.getStateNames().isEmpty() && info.getVersion() >= 4) {
            info.addImportName(NameFormatter.toDot(this.standardDefs.CLASS_STATE), 0);
            info.addInterfaceName(NameFormatter.toDot(this.standardDefs.INTERFACE_ISTATECLIENT2), 0);
        }
    }

    public boolean validateState(String state) {
        boolean isValid = state != null ? this.info.getStateNames().contains(state) : false;
        isValid = !isValid ? this.info.getStateGroups().containsKey(state) : true;
        return isValid;
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    public void setInitialState() {
        if (this.info.getVersion() >= 4) {
            Model root = this.document.getRoot();
            Set<String> states = this.info.getStateNames();
            if (!states.isEmpty() && !root.hasProperty("currentState")) {
                root.setProperty("currentState", (Object)states.iterator().next(), 0);
            }
        }
    }

    public void registerState(Model model, flex2.compiler.mxml.dom.Node node) {
        String name = (String)node.getAttributeValue("", "name");
        if (this.states != null && name != null) {
            if (this.statesDefined.contains(name)) {
                ThreadLocalToolkit.log((CompilerMessage)new DuplicateState(name), this.document.getSourcePath(), model.getXmlLineNumber());
                return;
            }
            State state = this.stateByName(name);
            state.model = model;
            this.statesDefined.add(name);
        }
    }

    public void registerStateSpecificNode(Model model, flex2.compiler.mxml.dom.Node node, Collection<String> includedStates, Collection<String> excludedStates) {
        Type parentType;
        this.statefulModels.add(model);
        Model context = model.getParent();
        if (node.getLocalPart().equals("Reparent")) {
            this.queueReparent(model, node, includedStates, excludedStates, this.getSiblingCount(context));
            return;
        }
        ArrayList<Model> relativeNodes = null;
        String position = null;
        if (context.getType() == this.document.getTypeTable().arrayType || context.getType().getElementType() != null || context instanceof MovieClip) {
            ArrayList siblings = context instanceof MovieClip ? (ArrayList)((MovieClip)context).children() : (ArrayList)((Array)context).getEntries();
            relativeNodes = this.buildRelativeSiblingList(model, siblings, siblings != null ? siblings.size() - 1 : 0);
            position = relativeNodes.isEmpty() ? "first" : "after";
        }
        String parentProperty = null;
        if (context.getType() == this.document.getTypeTable().arrayType || context.getType().getElementType() != null) {
            parentProperty = context.getParentIndex() != null ? context.getParentIndex() : context.getId();
            context = context.getParent();
            model.ensureDeclaration();
        }
        if (model instanceof Array || model instanceof Vector) {
            model.ensureDeclaration();
            model.ensureBindable();
        }
        if (context != null) {
            context.ensureDeclaration();
            context.ensureBindable();
        }
        Collection<String> states = this.consolidateStateNames(includedStates, excludedStates);
        model.setStateSpecific(true);
        model.setStates(states);
        model.setDescriptorInit(false);
        Model destination = context != null && context.getParent() != null ? context : null;
        Type type = parentType = destination != null ? destination.getType() : this.document.getRoot().getType();
        if (this.standardDefs.isItemsComponent(parentType) && parentType.getDefaultProperty().getName() == parentProperty) {
            parentProperty = null;
        }
        if (!this.validateStatefulModelType(model, destination, parentProperty)) {
            return;
        }
        this.constructAddItems(model, destination, parentProperty, context != null ? context.getId() : null, position, relativeNodes, states);
    }

    private boolean processReparentNode(ReparentInfo reparentNode, Model targetModel) {
        Type parentType;
        Model context = reparentNode.model.getParent();
        ArrayList<Model> relativeNodes = null;
        String position = null;
        if (context.getType() == this.document.getTypeTable().arrayType || context.getType().getElementType() != null || context instanceof MovieClip) {
            ArrayList siblings = context instanceof MovieClip ? (ArrayList)((MovieClip)context).children() : (ArrayList)((Array)context).getEntries();
            relativeNodes = this.buildRelativeSiblingList(targetModel, siblings, reparentNode.childIndex - 1);
            position = relativeNodes.isEmpty() ? "first" : "after";
        }
        String parentProperty = null;
        if (context.getType() == this.document.getTypeTable().arrayType || context.getType().getElementType() != null) {
            parentProperty = context.getParentIndex() != null ? context.getParentIndex() : context.getId();
            context = context.getParent();
        }
        if (context != null && context.getIdIsAutogenerated()) {
            this.document.addDeclaration(context.getId(), context.getType().getName(), context.getXmlLineNumber(), true, true, true, true);
        }
        Model destination = context != null && context.getParent() != null ? context : null;
        Type type = parentType = destination != null ? destination.getType() : this.document.getRoot().getType();
        if (this.standardDefs.isItemsComponent(parentType) && parentType.getDefaultProperty().getName() == parentProperty) {
            parentProperty = null;
        }
        if (!this.validateReparentStates(reparentNode.states, reparentNode, targetModel)) {
            return false;
        }
        if (!this.validateReparentType(targetModel, destination, parentProperty, reparentNode)) {
            return false;
        }
        this.constructAddItems(targetModel, destination, parentProperty, context != null ? context.getId() : null, position, relativeNodes, reparentNode.states);
        return true;
    }

    public void applyMetadata() {
        Set<String> states = this.info.getStateNames();
        if (!states.isEmpty()) {
            String metadata = "[States(";
            Iterator<String> iter = states.iterator();
            while (iter.hasNext()) {
                String state = iter.next();
                metadata = metadata + "\"" + state + "\"";
                metadata = metadata + (iter.hasNext() ? ", " : "");
            }
            metadata = metadata + ")]";
            Script script = new Script(metadata);
            this.document.addMetadata(script);
        }
    }

    private void queueReparent(Model model, flex2.compiler.mxml.dom.Node node, Collection<String> includedStates, Collection<String> excludedStates, int childIndex) {
        this.reparentNodes = this.reparentNodes != null ? this.reparentNodes : new HashMap<String, List<ReparentInfo>>();
        ArrayList<ReparentInfo> nodes = this.reparentNodes.get(model.getId());
        nodes = nodes != null ? nodes : new ArrayList<ReparentInfo>();
        Collection<String> states = this.consolidateStateNames(includedStates, excludedStates);
        model.setStates(states);
        nodes.add(new ReparentInfo(model, node, states, childIndex));
        this.reparentNodes.put(model.getId(), nodes);
    }

    private boolean ensureCompatibleAncestors(Model model, Model destination, Collection<String> states, Model startNode) {
        for (Model currentModel = destination; currentModel != null; currentModel = currentModel.getParent()) {
            if (startNode == currentModel) {
                ThreadLocalToolkit.log((CompilerMessage)new CircularReparent(states.iterator().next()), this.document.getSourcePath(), currentModel.getXmlLineNumber());
                return false;
            }
            Collection<String> extraStates = this.checkForExtraStates(currentModel, model, states);
            if (!extraStates.isEmpty()) {
                for (String state : extraStates) {
                    Model reparent = this.getReparentForState(currentModel, state);
                    if (reparent != null) {
                        ArrayList<String> reparentState = new ArrayList<String>();
                        reparentState.add(state);
                        boolean result = this.ensureCompatibleAncestors(model, reparent, reparentState, startNode);
                        if (result) continue;
                        return false;
                    }
                    ThreadLocalToolkit.log((CompilerMessage)new IncompatibleState(state), this.document.getSourcePath(), model.getXmlLineNumber());
                    return false;
                }
            }
            if (currentModel.getParentIndexState() == null) continue;
            String state = states.iterator().next();
            if (states.size() == 1 && state.equals(currentModel.getParentIndexState())) continue;
            ThreadLocalToolkit.log((CompilerMessage)new IncompatibleState(state), this.document.getSourcePath(), model.getXmlLineNumber());
            return false;
        }
        return true;
    }

    private Collection<String> checkForExtraStates(Model ancestor, Model model, Collection<String> states) {
        ArrayList<String> results = new ArrayList<String>();
        if (ancestor.isStateSpecific()) {
            for (String state : states) {
                if (ancestor.hasState(state)) continue;
                results.add(state);
            }
        }
        return results;
    }

    private boolean validateReparentStates(Collection<String> states, ReparentInfo reparentNode, Model target) {
        List<ReparentInfo> list = this.reparentNodes.get(target.getId());
        for (String currentState : states) {
            if (!target.isStateSpecific() || target.hasState(currentState)) {
                ThreadLocalToolkit.log((CompilerMessage)new InvalidReparentState(currentState, target.getId()), this.document.getSourcePath(), reparentNode.model.getXmlLineNumber());
                return false;
            }
            for (ReparentInfo node : list) {
                if (node == reparentNode || !node.states.contains(currentState)) continue;
                ThreadLocalToolkit.log((CompilerMessage)new ConflictingReparentTags(currentState, target.getId()), this.document.getSourcePath(), reparentNode.model.getXmlLineNumber());
                return false;
            }
        }
        return true;
    }

    private boolean validateReparentType(Model targetModel, Model destination, String parentProperty, ReparentInfo reparentNode) {
        Type parentType;
        Type childType = targetModel.getType();
        Type type = parentType = destination != null ? destination.getType() : this.document.getRoot().getType();
        if (this.standardDefs.isContainer(parentType) && this.standardDefs.isIUIComponent(childType) && parentProperty == null) {
            return true;
        }
        if (parentProperty != null || parentType.getDefaultProperty() != null) {
            Style style;
            Property property = parentProperty != null ? parentType.getProperty(parentProperty) : parentType.getDefaultProperty();
            Style style2 = style = parentProperty != null ? parentType.getStyle(parentProperty) : null;
            if (this.standardDefs.isItemsComponent(parentType) && property.getName() == parentType.getDefaultProperty().getName()) {
                return true;
            }
            if (property != null && (property.getType() == this.document.getTypeTable().arrayType || property.getType().getElementType() != null)) {
                Type propertyElementType = property.getElementType();
                if (propertyElementType == null || childType.isAssignableTo(propertyElementType)) {
                    return true;
                }
            } else {
                if (property != null && this.isStatefulCompatibleType(property.getType())) {
                    return true;
                }
                if (style != null && this.isStatefulCompatibleType(style.getType())) {
                    return true;
                }
            }
        }
        ThreadLocalToolkit.log((CompilerMessage)new IncompatibleReparentType(targetModel.getId()), this.document.getSourcePath(), reparentNode.model.getXmlLineNumber());
        return false;
    }

    private boolean validateStatefulModelType(Model targetModel, Model destination, String parentProperty) {
        Style style;
        Type parentType = destination != null ? destination.getType() : this.document.getRoot().getType();
        Property property = parentProperty != null ? parentType.getProperty(parentProperty) : parentType.getDefaultProperty();
        Style style2 = style = parentProperty != null ? parentType.getStyle(parentProperty) : null;
        if (parentType != null && property != null && this.standardDefs.isItemsComponent(parentType) && property.getName() == parentType.getDefaultProperty().getName()) {
            return true;
        }
        if (property != null && !this.isStatefulCompatibleType(property.getType())) {
            ThreadLocalToolkit.log((CompilerMessage)new IncompatibleStatefulNode(), this.document.getSourcePath(), targetModel.getXmlLineNumber());
            return false;
        }
        if (style != null && !this.isStatefulCompatibleType(style.getType())) {
            ThreadLocalToolkit.log((CompilerMessage)new IncompatibleStatefulNode(), this.document.getSourcePath(), targetModel.getXmlLineNumber());
            return false;
        }
        return true;
    }

    private boolean isStatefulCompatibleType(Type type) {
        return type == this.document.getTypeTable().arrayType || type.getElementType() != null || type == this.document.getTypeTable().objectType || type == this.document.getTypeTable().noType;
    }

    private Collection<String> consolidateStateNames(Collection<String> includedStates, Collection<String> excludedStates) {
        Collection<String> states = !includedStates.isEmpty() ? includedStates : this.inverseOf(excludedStates);
        return this.expandStateList(states);
    }

    private Set<String> expandState(String state) {
        HashSet<String> states = new HashSet<String>();
        Map<String, Collection<String>> groupMap = this.info.getStateGroups();
        if (groupMap.containsKey(state)) {
            states.addAll(groupMap.get(state));
        } else {
            states.add(state);
        }
        return states;
    }

    private Set<String> expandStateList(Collection<String> stateList) {
        HashSet<String> expandedStates = new HashSet<String>();
        Map<String, Collection<String>> groupMap = this.info.getStateGroups();
        for (String state : stateList) {
            if (groupMap.containsKey(state)) {
                expandedStates.addAll(groupMap.get(state));
                continue;
            }
            expandedStates.add(state);
        }
        return expandedStates;
    }

    private int getSiblingCount(Model model) {
        if (model.getType() == this.document.getTypeTable().arrayType || model.getType().getElementType() != null || model instanceof MovieClip) {
            ArrayList siblings = model instanceof MovieClip ? (ArrayList)((MovieClip)model).children() : (ArrayList)((Array)model).getEntries();
            return siblings != null ? siblings.size() : 0;
        }
        return 0;
    }

    public boolean processReparents() {
        if (this.reparentNodes != null && !this.reparentNodes.isEmpty()) {
            Iterator<String> iter = this.reparentNodes.keySet().iterator();
            while (iter.hasNext()) {
                List<ReparentInfo> list = this.reparentNodes.get(iter.next());
                for (ReparentInfo node : list) {
                    String target = node.model.getId();
                    PropertyDeclaration decl = this.document.getDeclaration(target);
                    if (decl != null && decl instanceof ValueInitializer) {
                        ValueInitializer initializedDecl = (ValueInitializer)((Object)decl);
                        Model model = (Model)initializedDecl.getValue();
                        if (this.processReparentNode(node, model)) continue;
                        return false;
                    }
                    ThreadLocalToolkit.log((CompilerMessage)new TargetResolutionError(target), this.document.getSourcePath(), node.model.getXmlLineNumber());
                    return false;
                }
            }
        }
        return true;
    }

    public void processStatefulModels() {
        for (Model model : this.statefulModels) {
            this.ensureCompatibleAncestors(model, model.getParent(), model.getStates(), model);
        }
    }

    private ArrayList<Model> buildRelativeSiblingList(Model model, ArrayList siblings, int startIndex) {
        ArrayList<Model> relativeSiblings = new ArrayList<Model>();
        for (int i = startIndex; i > -1; --i) {
            ValueInitializer initializer = (ValueInitializer)siblings.get(i);
            Model sibling = (Model)initializer.getValue();
            Boolean intersects = false;
            if (sibling.isStateSpecific()) {
                for (String state : sibling.getStates()) {
                    if (!model.hasState(state)) continue;
                    intersects = true;
                    break;
                }
            }
            if (!sibling.isStateSpecific() || intersects.booleanValue()) {
                relativeSiblings.add(sibling);
                if (sibling.getIdIsAutogenerated() && !(sibling instanceof Reparent)) {
                    this.document.addDeclaration(sibling.getId(), sibling.getType().getName(), sibling.getXmlLineNumber(), true, true, true, sibling.getBindabilityEnsured());
                }
            }
            if (!sibling.isStateSpecific()) break;
        }
        return relativeSiblings;
    }

    public void registerStateSpecificProperty(Model model, String property, ValueInitializer value, String stateName) {
        this.generatePropertyOverrides(model, property, value, stateName, false);
    }

    public void registerStateSpecificStyle(Model model, String property, ValueInitializer value, String stateName) {
        this.generatePropertyOverrides(model, property, value, stateName, true);
    }

    private void generatePropertyOverrides(Model model, String property, ValueInitializer value, String stateName, Boolean isStyle) {
        Set<String> stateNames = this.expandState(stateName);
        String factory = null;
        if (stateNames.size() > 1 && !(value.getValue() instanceof BindingExpression) && value.hasDefinition() && value.getValue() instanceof Model) {
            Model valueModel = (Model)value.getValue();
            factory = valueModel.getDefinitionName();
            this.sharedObjects.put(valueModel.getDefinitionName(), new SharedObject(valueModel.getDefinitionName(), valueModel.isDeclared(), valueModel));
        }
        Iterator iter = stateNames.iterator();
        while (iter.hasNext()) {
            State state = this.stateByName((String)iter.next());
            if (state == null) continue;
            SetPropertyOverride override = isStyle != false ? new SetStyleOverride(model, property, value, factory) : new SetPropertyOverride(model, property, value, factory);
            this.postProcessBindingInstance(value, override);
            state.addOverride(override, model != null ? model.getXmlLineNumber() : 0);
        }
    }

    public void registerStateSpecificEventHandler(Model model, String event, EventInitializer value, String stateName) {
        Set<String> stateNames = this.expandState(stateName);
        Iterator iter = stateNames.iterator();
        while (iter.hasNext()) {
            State state = this.stateByName((String)iter.next());
            if (state == null) continue;
            SetEventOverride override = new SetEventOverride(model, event, value);
            state.addOverride(override, model != null ? model.getXmlLineNumber() : 0);
        }
    }

    public void registerEarlyInitNode(Model model) {
        this.sharedObjects.put(model.getDefinitionName(), new SharedObject(model.getDefinitionName(), model.isDeclared(), model));
        this.earlyInitObjects.add(model.getDefinitionName());
        model.setEarlyInit(true);
    }

    private void constructAddItems(Model model, Model parent, String parentIndex, String parentId, String position, ArrayList<Model> relativeNodes, Collection<String> statesList) {
        this.sharedObjects.put(model.getDefinitionName(), new SharedObject(model.getDefinitionName(), model.isDeclared(), model));
        boolean isStyle = false;
        if (parent != null && parentIndex != null) {
            isStyle = parent.getType().getStyle(parentIndex) != null;
        }
        boolean isArray = model.getType() == this.document.getTypeTable().arrayType;
        String vectorClassName = null;
        if (model.getParent().getType().getElementType() != null) {
            vectorClassName = NameFormatter.toDot(model.getParent().getType().getName());
        }
        HashSet<String> states = new HashSet<String>(statesList);
        Iterator iter = states.iterator();
        while (iter.hasNext()) {
            State state = this.stateByName((String)iter.next());
            if (state == null) continue;
            AddItemsOverride override = new AddItemsOverride(parent, parentIndex, parentId, model.getDefinitionName(), position, relativeNodes, isStyle, isArray, vectorClassName, model);
            state.addOverride(override, model != null ? model.getXmlLineNumber() : 0);
        }
    }

    private void postProcessBindingInstance(ValueInitializer value, SetPropertyOverride override) {
        if (value.getValue() instanceof BindingExpression) {
            Type type = this.document.getTypeTable().getType(override.getDeclaredType());
            Model model = new Model(this.document, type, null, 0);
            this.document.ensureDeclaration(model);
            model.ensureBindable();
            BindingExpression sourceExpression = (BindingExpression)value.getValue();
            BindingExpression bindingExpression = new BindingExpression(sourceExpression.getSourceExpression(), sourceExpression.xmlLineNumber, this.document);
            bindingExpression.setDestination(model);
            bindingExpression.setDestinationLValue("value");
            bindingExpression.setDestinationProperty("value");
            bindingExpression.setDestinationStyle(null);
            override.setDeclaration(model.getId());
            sourceExpression.setId(-1);
            this.document.removeBindingExpression(sourceExpression);
            try {
                ValueInitializer valueClone = value.clone();
                valueClone.setValue(bindingExpression);
                override.value = valueClone;
            }
            catch (CloneNotSupportedException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private Collection<String> inverseOf(Collection<String> list) {
        TreeSet<String> inverse = new TreeSet<String>();
        Set<String> all = this.info.getStateNames();
        Set<String> expandedList = this.expandStateList(list);
        for (String name : all) {
            if (expandedList.contains(name)) continue;
            inverse.add(name);
        }
        return inverse;
    }

    public State stateByName(String name) {
        State entry = this.states.get(name);
        if (entry == null) {
            entry = new State(name);
            this.states.put(name, entry);
        }
        return entry;
    }

    private Model getReparentForState(Model model, String state) {
        if (this.reparentNodes != null) {
            List<ReparentInfo> list = this.reparentNodes.get(model.getId());
            for (ReparentInfo ri : list) {
                if (!ri.states.contains(state)) continue;
                return ri.model;
            }
        }
        return null;
    }

    public Collection<String> getGroupsForState(String name) {
        ArrayList<String> groups = new ArrayList<String>();
        Map<String, Collection<String>> stateGroups = this.info.getStateGroups();
        for (String groupName : stateGroups.keySet()) {
            if (!stateGroups.get(groupName).contains(name)) continue;
            groups.add(groupName);
        }
        return groups;
    }

    public Iterator<CodeFragmentList> getSubDefinitionIterators() {
        IteratorList iterList = new IteratorList();
        Set<String> states = this.info.getStateNames();
        Iterator<String> iter = states.iterator();
        while (iter.hasNext()) {
            State state = this.stateByName(iter.next());
            if (state == null) continue;
            Iterator<Initializer> eventList = state.getEvents();
            while (eventList.hasNext()) {
                EventInitializer ei = (EventInitializer)eventList.next();
                iterList.add(ei.getDefinitionsIterator());
            }
            for (Override override : state.overrides) {
                ValueInitializer initializer;
                Object rvalue;
                if (!(override instanceof SetPropertyOverride) || !((rvalue = (initializer = ((SetPropertyOverride)override).value).getValue()) instanceof Model) || this.initializedModels.contains(rvalue)) continue;
                iterList.add(initializer.getDefinitionsIterator());
                this.initializedModels.add(rvalue);
            }
        }
        return iterList.toIterator();
    }

    public Iterator<Initializer> getSubInitializerIterators() {
        IteratorList iterList = new IteratorList();
        Set<String> states = this.info.getStateNames();
        Iterator<String> iter = states.iterator();
        while (iter.hasNext()) {
            State state = this.stateByName(iter.next());
            if (state == null) continue;
            iterList.add(state.getEvents());
            ArrayList<ValueInitializer> values = new ArrayList<ValueInitializer>();
            for (Override override : state.overrides) {
                ValueInitializer initializer;
                Object rvalue;
                if (!(override instanceof SetPropertyOverride) || !((rvalue = (initializer = ((SetPropertyOverride)override).value).getValue()) instanceof Model) || this.initializedModels.contains(rvalue)) continue;
                values.add(initializer);
                this.initializedModels.add(rvalue);
            }
            iterList.add(values.iterator());
        }
        return iterList.toIterator();
    }

    public static class DuplicateState
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4393031004536097900L;
        public String state;

        public DuplicateState(String state) {
            this.state = state;
        }
    }

    public static class IncompatibleStatefulNode
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4393031143519097900L;
    }

    public static class CircularReparent
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4393031003519097900L;
        public String state;

        public CircularReparent(String state) {
            this.state = state;
        }
    }

    public static class IncompatibleState
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4393031003501097900L;
        public String state;

        public IncompatibleState(String state) {
            this.state = state;
        }
    }

    public static class MultipleInitializers
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6062583302608912991L;
        public String name;
        public String state;

        public MultipleInitializers(String name, String state) {
            this.name = name;
            this.state = state;
        }
    }

    public static class ConflictingReparentTags
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6062583302608913991L;
        public String name;
        public String target;

        public ConflictingReparentTags(String name, String target) {
            this.name = name;
            this.target = target;
        }
    }

    public static class IncompatibleReparentType
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4395501003501097900L;
        public String target;

        public IncompatibleReparentType(String target) {
            this.target = target;
        }
    }

    public static class InvalidReparentState
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4395501005501097900L;
        public String name;
        public String target;

        public InvalidReparentState(String name, String target) {
            this.name = name;
            this.target = target;
        }
    }

    public static class TargetResolutionError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4029357697637073854L;
        public String name;

        public TargetResolutionError(String name) {
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetEventOverride
    extends Override {
        public Model context;
        public String event;
        public EventInitializer value;
        public Boolean clear;

        public SetEventOverride(Model context, String event, EventInitializer value) {
            this.context = context;
            this.value = value;
            this.event = event;
            this.clear = value.getHandlerText().equals("@Clear()");
            StatesModel.this.info.addImportName(NameFormatter.toDot(this.getDeclaredType()), 0);
        }

        @java.lang.Override
        public void getDefinitionBody(CodeFragmentList list, String indent) {
            String typeName = NameFormatter.retrieveClassName(this.getDeclaredType());
            boolean isDataBound = this.context.hasDataBoundEvent(this.event);
            list.add(indent, "new " + typeName + "().initializeFromObject({", 0);
            indent = indent + StatesGenerator.INDENT;
            if (isDataBound) {
                list.add(indent, "isBaseValueDataBound: true ,", 0);
            }
            Initializer base = this.context.getEventInitializer(this.event);
            if (StatesModel.this.document.getRoot() != this.context) {
                list.add(indent, "target: \"" + this.context.getId() + "\",", 0);
            }
            list.add(indent, "name: \"" + this.event + "\"" + (this.clear == false || base != null ? "," : ""), 0);
            if (base != null) {
                list.add(indent, "originalHandlerFunction: " + base.getValueExpr() + (this.clear == false ? "," : ""), 0);
            }
            if (!this.clear.booleanValue()) {
                list.add(indent, "handlerFunction: " + this.value.getValueExpr(), 0);
            }
            indent = indent.substring(0, indent.length() - StatesGenerator.INDENT.length());
            list.add(indent, "})", 0);
        }

        @java.lang.Override
        public MemberExpressionNode generateDefinitionBody(NodeFactory nodeFactory, HashSet<String> configNamespaces, boolean generateDocComments) {
            Node valueNode;
            IdentifierNode valueIdentifier;
            LiteralFieldNode literalField;
            boolean isDataBound = this.context.hasDataBoundEvent(this.event);
            IdentifierNode seItemsIdentifier = nodeFactory.identifier(SETEVENTHANDLER, false);
            IdentifierNode initObjectIdentifier = nodeFactory.identifier(INITIALIZEFROMOBJECT, false);
            ArgumentListNode spArguments = null;
            Initializer baseValue = this.context.getEventInitializer(this.event);
            if (isDataBound) {
                IdentifierNode isStyleIdentifier = nodeFactory.identifier(ISBASEVALUEDATABOUND, false);
                LiteralBooleanNode value = nodeFactory.literalBoolean(true);
                literalField = nodeFactory.literalField(isStyleIdentifier, value);
                spArguments = nodeFactory.argumentList(spArguments, literalField);
            }
            if (StatesModel.this.document.getRoot() != this.context) {
                IdentifierNode targetIdentifier = nodeFactory.identifier(TARGET, false);
                LiteralStringNode valueNode2 = nodeFactory.literalString(this.context.getId());
                literalField = nodeFactory.literalField(targetIdentifier, valueNode2);
                spArguments = nodeFactory.argumentList(spArguments, literalField);
            }
            IdentifierNode nameIdentifier = nodeFactory.identifier(NAME, false);
            LiteralStringNode nameNode = nodeFactory.literalString(this.event);
            literalField = nodeFactory.literalField(nameIdentifier, nameNode);
            spArguments = nodeFactory.argumentList(spArguments, literalField);
            if (baseValue != null) {
                valueIdentifier = nodeFactory.identifier(ORIGINALHANDLERFUNCTION, false);
                valueNode = baseValue.generateValueExpr(nodeFactory, configNamespaces, generateDocComments);
                literalField = nodeFactory.literalField(valueIdentifier, valueNode);
                spArguments = nodeFactory.argumentList(spArguments, literalField);
            }
            if (!this.clear.booleanValue()) {
                valueIdentifier = nodeFactory.identifier(HANDLERFUNCTION, false);
                valueNode = this.value.generateValueExpr(nodeFactory, configNamespaces, generateDocComments);
                literalField = nodeFactory.literalField(valueIdentifier, valueNode);
                spArguments = nodeFactory.argumentList(spArguments, literalField);
            }
            LiteralObjectNode literalObject = nodeFactory.literalObject(spArguments);
            ArgumentListNode addItemsArgumentList = nodeFactory.argumentList(null, literalObject);
            CallExpressionNode initExpression = (CallExpressionNode)nodeFactory.callExpression(initObjectIdentifier, addItemsArgumentList);
            initExpression.setRValue(false);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression(seItemsIdentifier, null);
            callExpression.is_new = true;
            callExpression.setRValue(false);
            MemberExpressionNode base = nodeFactory.memberExpression(null, callExpression);
            return nodeFactory.memberExpression(base, initExpression);
        }

        @java.lang.Override
        public String getDeclaredType() {
            return StatesModel.this.standardDefs.CLASS_SETEVENTHANDLER;
        }
    }

    public class SetStyleOverride
    extends SetPropertyOverride {
        public SetStyleOverride(Model context, String property, ValueInitializer value, String factory) {
            super(context, property, value, factory);
        }

        public String getDeclaredType() {
            return StatesModel.this.standardDefs.CLASS_SETSTYLE;
        }

        protected String getDeclaredClass() {
            return SETSTYLE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetPropertyOverride
    extends Override {
        public Model context;
        public ValueInitializer value;
        public String property;
        public Boolean clear;
        public String factory;

        public SetPropertyOverride(Model context, String property, ValueInitializer value, String factory) {
            this.value = value;
            this.factory = factory;
            this.property = property;
            this.context = context;
            this.clear = value.getValue() != null && value.getValue() instanceof AtClear;
            StatesModel.this.info.addImportName(NameFormatter.toDot(this.getDeclaredType()), 0);
        }

        @java.lang.Override
        public void getDefinitionBody(CodeFragmentList list, String indent) {
            boolean isDataBound = this.getDeclaredClass() == SETPROPERTY ? this.context.hasDataBoundProperty(this.property) : this.context.hasDataBoundStyle(this.property);
            String typeName = NameFormatter.toDot(this.getDeclaredType());
            String prefix = this.declaration != null ? this.declaration + " = " + typeName + "( " : "";
            String suffix = this.declaration != null ? ")" : "";
            list.add(indent, prefix + "new " + typeName + "().initializeFromObject({", 0);
            indent = indent + StatesGenerator.INDENT;
            if (isDataBound) {
                list.add(indent, "isBaseValueDataBound: true ,", 0);
            }
            if (StatesModel.this.document.getRoot() != this.context) {
                list.add(indent, "target: \"" + this.context.getId() + "\",", 0);
            }
            list.add(indent, "name: \"" + this.property + "\"" + (this.clear == false ? "," : ""), 0);
            if (!this.clear.booleanValue()) {
                if (this.factory != null) {
                    list.add(indent, "valueFactory: " + this.factory + "_factory", 0);
                } else {
                    list.add(indent, "value: " + this.value.getValueExpr(), 0);
                }
            }
            indent = indent.substring(0, indent.length() - StatesGenerator.INDENT.length());
            list.add(indent, "})" + suffix, 0);
        }

        @java.lang.Override
        public MemberExpressionNode generateDefinitionBody(NodeFactory nodeFactory, HashSet<String> configNamespaces, boolean generateDocComments) {
            LiteralFieldNode literalField;
            boolean isDataBound = this.getDeclaredClass() == SETPROPERTY ? this.context.hasDataBoundProperty(this.property) : this.context.hasDataBoundStyle(this.property);
            QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, StatesModel.this.standardDefs.getStatesPackage(), this.getDeclaredClass(), false);
            IdentifierNode initObjectIdentifier = nodeFactory.identifier(INITIALIZEFROMOBJECT, false);
            ArgumentListNode spArguments = null;
            if (isDataBound) {
                IdentifierNode isStyleIdentifier = nodeFactory.identifier(ISBASEVALUEDATABOUND, false);
                LiteralBooleanNode value = nodeFactory.literalBoolean(true);
                literalField = nodeFactory.literalField(isStyleIdentifier, value);
                spArguments = nodeFactory.argumentList(spArguments, literalField);
            }
            if (StatesModel.this.document.getRoot() != this.context) {
                IdentifierNode targetIdentifier = nodeFactory.identifier(TARGET, false);
                LiteralStringNode valueNode = nodeFactory.literalString(this.context.getId());
                literalField = nodeFactory.literalField(targetIdentifier, valueNode);
                spArguments = nodeFactory.argumentList(spArguments, literalField);
            }
            IdentifierNode nameIdentifier = nodeFactory.identifier(NAME, false);
            LiteralStringNode nameNode = nodeFactory.literalString(this.property);
            literalField = nodeFactory.literalField(nameIdentifier, nameNode);
            spArguments = nodeFactory.argumentList(spArguments, literalField);
            if (!this.clear.booleanValue()) {
                if (this.factory != null) {
                    IdentifierNode itemsIdentifier = nodeFactory.identifier(VALUEFACTORY, false);
                    String factorySymbol = (this.factory + _FACTORY).intern();
                    IdentifierNode factoryIdentifier = nodeFactory.identifier(factorySymbol, false);
                    GetExpressionNode factoryExpression = nodeFactory.getExpression(factoryIdentifier);
                    MemberExpressionNode factory = nodeFactory.memberExpression(null, factoryExpression);
                    LiteralFieldNode literalFieldVF = nodeFactory.literalField(itemsIdentifier, factory);
                    spArguments = nodeFactory.argumentList(spArguments, literalFieldVF);
                } else {
                    Node valueNode = null;
                    IdentifierNode valueIdentifier = nodeFactory.identifier(VALUE, false);
                    if (this.value == null || this.value.isBinding()) {
                        IdentifierNode undefinedIdentifier = nodeFactory.identifier(UNDEFINED, false);
                        GetExpressionNode getter = nodeFactory.getExpression(undefinedIdentifier);
                        valueNode = nodeFactory.memberExpression(null, getter);
                    } else {
                        valueNode = this.value.generateValueExpr(nodeFactory, configNamespaces, generateDocComments);
                    }
                    literalField = nodeFactory.literalField(valueIdentifier, valueNode);
                    spArguments = nodeFactory.argumentList(spArguments, literalField);
                }
            }
            LiteralObjectNode literalObject = nodeFactory.literalObject(spArguments);
            ArgumentListNode addItemsArgumentList = nodeFactory.argumentList(null, literalObject);
            CallExpressionNode initExpression = (CallExpressionNode)nodeFactory.callExpression(initObjectIdentifier, addItemsArgumentList);
            initExpression.setRValue(false);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression(qualifiedIdentifier, null);
            callExpression.is_new = true;
            callExpression.setRValue(false);
            MemberExpressionNode base = nodeFactory.memberExpression(null, callExpression);
            MemberExpressionNode expNode = nodeFactory.memberExpression(base, initExpression);
            if (this.declaration != null) {
                ArgumentListNode castArgList2 = nodeFactory.argumentList(null, expNode);
                CallExpressionNode castExpression = (CallExpressionNode)nodeFactory.callExpression(qualifiedIdentifier, castArgList2);
                castExpression.setRValue(false);
                MemberExpressionNode castNode = nodeFactory.memberExpression(null, castExpression);
                ArgumentListNode castArgList = nodeFactory.argumentList(null, castNode);
                IdentifierNode declIdentifier = nodeFactory.identifier(this.declaration);
                SetExpressionNode declSelector = nodeFactory.setExpression(declIdentifier, castArgList, false);
                return nodeFactory.memberExpression(null, declSelector);
            }
            return expNode;
        }

        @java.lang.Override
        public String getDeclaredType() {
            return StatesModel.this.standardDefs.CLASS_SETPROPERTY;
        }

        protected String getDeclaredClass() {
            return SETPROPERTY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReparentInfo {
        public Collection<String> states;
        public Model model;
        public flex2.compiler.mxml.dom.Node node;
        public int childIndex;

        public ReparentInfo(Model model, flex2.compiler.mxml.dom.Node node, Collection<String> states, int childIndex) {
            this.model = model;
            this.node = node;
            this.states = states;
            this.childIndex = childIndex;
        }
    }

    public class SharedObject {
        public String name;
        public boolean isDeclared;
        public Model model;

        public SharedObject(String name, boolean isDeclared, Model model) {
            this.name = name;
            this.isDeclared = isDeclared;
            this.model = model;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddItemsOverride
    extends Override {
        public String context;
        public String propertyName;
        public String factory;
        public Model parent;
        public Model model;
        public String position;
        public ArrayList<Model> relativeNodes;
        public boolean isStyle;
        public boolean isArray;
        public String vectorClassName;

        public AddItemsOverride(Model parent, String propertyName, String context, String factory, String position, ArrayList<Model> relativeNodes, boolean isStyle, boolean isArray, String vectorClassName, Model model) {
            this.parent = parent;
            this.context = context;
            this.factory = factory;
            this.propertyName = propertyName;
            this.position = position;
            this.relativeNodes = relativeNodes;
            this.isStyle = isStyle;
            this.isArray = isArray;
            this.vectorClassName = vectorClassName;
            this.model = model;
            StatesModel.this.info.addImportName(NameFormatter.toDot(this.getDeclaredType()), 0);
        }

        @java.lang.Override
        public void getDefinitionBody(CodeFragmentList list, String indent) {
            String typeName = NameFormatter.retrieveClassName(this.getDeclaredType());
            list.add(indent, "new " + typeName + "().initializeFromObject({", 0);
            indent = indent + StatesGenerator.INDENT;
            if (this.model.getIsTransient()) {
                list.add(indent, "destructionPolicy: \"auto\",", 0);
            }
            list.add(indent, "itemsFactory: " + this.factory + "_factory,", 0);
            if (this.isStyle) {
                list.add(indent, "isStyle: true ,", 0);
            }
            int parentElementCount = 0;
            if (this.model.getParent() != null) {
                if (this.model.getParent().getType() == StatesModel.this.document.getTypeTable().arrayType) {
                    parentElementCount = ((Array)this.model.getParent()).getEntries().size();
                } else if (this.model.getParent().getType().getElementType() != null) {
                    parentElementCount = ((Vector)this.model.getParent()).getEntries().size();
                }
            }
            if (this.isArray && parentElementCount > 1) {
                list.add(indent, "isArray: true ,", 0);
            }
            if (this.vectorClassName != null) {
                list.add(indent, "vectorClass: " + this.vectorClassName + ",", 0);
            }
            String destination = this.parent != null ? "\"" + this.parent.getId() + "\"" : "null";
            list.add(indent, "destination: " + destination + (this.propertyName != null || this.position != null ? "," : ""), 0);
            if (this.propertyName != null) {
                list.add(indent, "propertyName: \"" + this.propertyName + "\"" + (this.position != null ? "," : ""), 0);
            }
            if (this.position != null) {
                list.add(indent, "position: \"" + this.position + "\"" + (this.position != "first" ? "," : ""), 0);
                if (this.position.equals("after") && !this.relativeNodes.isEmpty()) {
                    String siblingList = "";
                    for (int i = 0; i < this.relativeNodes.size(); ++i) {
                        siblingList = siblingList + '\"' + this.relativeNodes.get(i).getId() + '\"';
                        siblingList = siblingList + (i != this.relativeNodes.size() - 1 ? ", " : "");
                    }
                    list.add(indent, "relativeTo: [" + siblingList + "]", 0);
                }
            }
            indent = indent.substring(0, indent.length() - StatesGenerator.INDENT.length());
            list.add(indent, "})", 0);
        }

        @java.lang.Override
        public MemberExpressionNode generateDefinitionBody(NodeFactory nodeFactory, HashSet<String> configNamespaces, boolean generateDocComments) {
            IdentifierNode addItemsIdentifier = nodeFactory.identifier(ADDITEMS, false);
            IdentifierNode initObjectIdentifier = nodeFactory.identifier(INITIALIZEFROMOBJECT, false);
            ArgumentListNode aiArguments = null;
            if (this.model.getIsTransient()) {
                IdentifierNode propIdentifier = nodeFactory.identifier(DESTRUCTIONPOLICY, false);
                LiteralStringNode propNode = nodeFactory.literalString("auto");
                LiteralFieldNode literalField = nodeFactory.literalField(propIdentifier, propNode);
                aiArguments = nodeFactory.argumentList(aiArguments, literalField);
            }
            IdentifierNode itemsIdentifier = nodeFactory.identifier(ITEMSFACTORY, false);
            String factorySymbol = (this.factory + _FACTORY).intern();
            IdentifierNode factoryIdentifier = nodeFactory.identifier(factorySymbol, false);
            GetExpressionNode factoryExpression = nodeFactory.getExpression(factoryIdentifier);
            MemberExpressionNode factory = nodeFactory.memberExpression(null, factoryExpression);
            LiteralFieldNode literalField = nodeFactory.literalField(itemsIdentifier, factory);
            aiArguments = nodeFactory.argumentList(aiArguments, literalField);
            if (this.isStyle) {
                IdentifierNode isStyleIdentifier = nodeFactory.identifier(ISSTYLE, false);
                LiteralBooleanNode value = nodeFactory.literalBoolean(true);
                literalField = nodeFactory.literalField(isStyleIdentifier, value);
                aiArguments = nodeFactory.argumentList(aiArguments, literalField);
            }
            int parentElementCount = 0;
            if (this.model.getParent() != null) {
                if (this.model.getParent().getType() == StatesModel.this.document.getTypeTable().arrayType) {
                    parentElementCount = ((Array)this.model.getParent()).getEntries().size();
                } else if (this.model.getParent().getType().getElementType() != null) {
                    parentElementCount = ((Vector)this.model.getParent()).getEntries().size();
                }
            }
            if (this.isArray && parentElementCount > 1) {
                IdentifierNode isArrayIdentifier = nodeFactory.identifier(ISARRAY, false);
                LiteralBooleanNode value = nodeFactory.literalBoolean(true);
                literalField = nodeFactory.literalField(isArrayIdentifier, value);
                aiArguments = nodeFactory.argumentList(aiArguments, literalField);
            }
            if (this.vectorClassName != null) {
                IdentifierNode vectorClassIdentifier = nodeFactory.identifier(VECTORCLASS, false);
                ApplyTypeExprNode applyTypeExpr = AbstractSyntaxTreeUtil.generateApplyTypeExpr(nodeFactory, this.vectorClassName, this.vectorClassName.indexOf(StatesModel.LESS_THAN));
                MemberExpressionNode typeValue = nodeFactory.memberExpression(null, applyTypeExpr);
                literalField = nodeFactory.literalField(vectorClassIdentifier, typeValue);
                aiArguments = nodeFactory.argumentList(aiArguments, literalField);
            }
            LiteralNullNode valueNode = null;
            IdentifierNode destIdentifier = nodeFactory.identifier(DESTINATION, false);
            valueNode = this.parent != null ? nodeFactory.literalString(this.parent.getId()) : nodeFactory.literalNull();
            literalField = nodeFactory.literalField(destIdentifier, valueNode);
            aiArguments = nodeFactory.argumentList(aiArguments, literalField);
            if (this.propertyName != null) {
                IdentifierNode propIdentifier = nodeFactory.identifier(PROPERTYNAME, false);
                LiteralStringNode propNode = nodeFactory.literalString(this.propertyName);
                literalField = nodeFactory.literalField(propIdentifier, propNode);
                aiArguments = nodeFactory.argumentList(aiArguments, literalField);
            }
            if (this.position != null) {
                IdentifierNode posIdentifier = nodeFactory.identifier(POSITION, false);
                LiteralStringNode posNode = nodeFactory.literalString(this.position);
                literalField = nodeFactory.literalField(posIdentifier, posNode);
                aiArguments = nodeFactory.argumentList(aiArguments, literalField);
                if (this.position.equals("after") && !this.relativeNodes.isEmpty()) {
                    ArgumentListNode relArguments = null;
                    for (int i = 0; i < this.relativeNodes.size(); ++i) {
                        LiteralStringNode sibling = nodeFactory.literalString(this.relativeNodes.get(i).getId());
                        relArguments = nodeFactory.argumentList(relArguments, sibling);
                    }
                    LiteralArrayNode relArray = nodeFactory.literalArray(relArguments);
                    IdentifierNode relIdentifier = nodeFactory.identifier(RELATIVETO, false);
                    literalField = nodeFactory.literalField(relIdentifier, relArray);
                    aiArguments = nodeFactory.argumentList(aiArguments, literalField);
                }
            }
            LiteralObjectNode literalObject = nodeFactory.literalObject(aiArguments);
            ArgumentListNode addItemsArgumentList = nodeFactory.argumentList(null, literalObject);
            CallExpressionNode initExpression = (CallExpressionNode)nodeFactory.callExpression(initObjectIdentifier, addItemsArgumentList);
            initExpression.setRValue(false);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression(addItemsIdentifier, null);
            callExpression.is_new = true;
            callExpression.setRValue(false);
            MemberExpressionNode base = nodeFactory.memberExpression(null, callExpression);
            return nodeFactory.memberExpression(base, initExpression);
        }

        @java.lang.Override
        public String getDeclaredType() {
            return StatesModel.this.standardDefs.CLASS_ADDITEMS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Override {
        public String declaration;

        public void setDeclaration(String declaration) {
            this.declaration = declaration;
        }

        public abstract void getDefinitionBody(CodeFragmentList var1, String var2);

        public abstract MemberExpressionNode generateDefinitionBody(NodeFactory var1, HashSet<String> var2, boolean var3);

        public abstract String getDeclaredType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class State {
        public String name;
        public List<Override> overrides;
        public Model model;

        public State(String name) {
            this.name = name;
            this.overrides = new ArrayList<Override>();
        }

        public void addOverride(Override override, int line) {
            if (!this.previouslyInitialized(override, line)) {
                boolean isArrayOrVectorValue = override instanceof SetPropertyOverride && (((SetPropertyOverride)override).value.getValue() instanceof Array || ((SetPropertyOverride)override).value.getValue() instanceof Vector);
                boolean isAddItems = override instanceof AddItemsOverride;
                if (isArrayOrVectorValue || isAddItems) {
                    this.overrides.add(0, override);
                } else {
                    this.overrides.add(override);
                }
            }
        }

        public void getDefinitionBody(CodeFragmentList list, String indent, List<Override> bindingsQueue) {
            list.add(indent, "new State ({", 0);
            indent = indent + StatesGenerator.INDENT;
            list.add(indent, "name: \"" + this.name + "\",", 0);
            Iterator<Initializer> iter = this.model.getPropertyInitializerIterator(false);
            while (iter.hasNext()) {
                NamedInitializer namedInit;
                String initName;
                Initializer init = iter.next();
                if (!(init instanceof NamedInitializer) || (initName = (namedInit = (NamedInitializer)init).getName()).equals("name") || initName.equals("stateGroups") || initName.equals("overrides")) continue;
                list.add(indent, initName + ": " + namedInit.getValueExpr() + ",", 0);
            }
            Collection<String> groups = StatesModel.this.getGroupsForState(this.name);
            if (!groups.isEmpty()) {
                String groupNames = "";
                Iterator<String> iter2 = groups.iterator();
                while (iter2.hasNext()) {
                    groupNames = groupNames + "'" + iter2.next() + (iter2.hasNext() ? "'," : "'");
                }
                list.add(indent, "stateGroups: [" + groupNames + "],", 0);
            }
            list.add(indent, "overrides: [", 0);
            indent = indent + StatesGenerator.INDENT;
            Iterator<Override> iter3 = this.overrides.iterator();
            while (iter3.hasNext()) {
                Override override = iter3.next();
                override.getDefinitionBody(list, indent);
                if (override.declaration != null) {
                    bindingsQueue.add(override);
                }
                if (!iter3.hasNext()) continue;
                list.add(indent, ",", 0);
            }
            indent = indent.substring(0, indent.length() - StatesGenerator.INDENT.length());
            list.add(indent, "]", 0);
            indent = indent.substring(0, indent.length() - StatesGenerator.INDENT.length());
            list.add(indent, "})", 0);
        }

        public MemberExpressionNode generateDefinitionBody(NodeFactory nodeFactory, HashSet<String> configNamespaces, boolean generateDocComments, List<Override> bindingsQueue) {
            IdentifierNode stateIdentifier = nodeFactory.identifier(STATE, false);
            IdentifierNode nameIdentifier = nodeFactory.identifier(NAME, false);
            IdentifierNode overridesIdentifier = nodeFactory.identifier(OVERRIDES, false);
            ArgumentListNode stateArguments = null;
            LiteralStringNode literalString = nodeFactory.literalString(this.name);
            LiteralFieldNode literalField = nodeFactory.literalField(nameIdentifier, literalString);
            stateArguments = nodeFactory.argumentList(stateArguments, literalField);
            Iterator<Initializer> iter = this.model.getPropertyInitializerIterator(false);
            while (iter.hasNext()) {
                NamedInitializer namedInit;
                String initName;
                Initializer init = iter.next();
                if (!(init instanceof NamedInitializer) || (initName = (namedInit = (NamedInitializer)init).getName()).equals("name") || initName.equals("stateGroups") || initName.equals("overrides")) continue;
                IdentifierNode propIdentifier = nodeFactory.identifier(initName);
                literalField = nodeFactory.literalField(propIdentifier, namedInit.generateValueExpr(nodeFactory, configNamespaces, generateDocComments));
                stateArguments = nodeFactory.argumentList(stateArguments, literalField);
            }
            Collection<String> groups = StatesModel.this.getGroupsForState(this.name);
            if (!groups.isEmpty()) {
                ArgumentListNode groupArguments = null;
                Iterator<Object> iter2 = groups.iterator();
                while (iter2.hasNext()) {
                    LiteralStringNode sibling = nodeFactory.literalString((String)iter2.next());
                    groupArguments = nodeFactory.argumentList(groupArguments, sibling);
                }
                LiteralArrayNode relArray = nodeFactory.literalArray(groupArguments);
                IdentifierNode relIdentifier = nodeFactory.identifier(STATEGROUPS, false);
                literalField = nodeFactory.literalField(relIdentifier, relArray);
                stateArguments = nodeFactory.argumentList(stateArguments, literalField);
            }
            ArgumentListNode overridesArgumentList = null;
            for (Override override : this.overrides) {
                MemberExpressionNode memberExpression = override.generateDefinitionBody(nodeFactory, configNamespaces, generateDocComments);
                overridesArgumentList = nodeFactory.argumentList(overridesArgumentList, memberExpression);
                if (override.declaration == null) continue;
                bindingsQueue.add(override);
            }
            LiteralArrayNode overridesArray = nodeFactory.literalArray(overridesArgumentList);
            literalField = nodeFactory.literalField(overridesIdentifier, overridesArray);
            stateArguments = nodeFactory.argumentList(stateArguments, literalField);
            LiteralObjectNode literalObject = nodeFactory.literalObject(stateArguments);
            ArgumentListNode stateDescriptorArgumentList = nodeFactory.argumentList(null, literalObject);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression(stateIdentifier, stateDescriptorArgumentList);
            callExpression.is_new = true;
            callExpression.setRValue(false);
            return nodeFactory.memberExpression(null, callExpression);
        }

        private boolean previouslyInitialized(Override override, int line) {
            if (this.isPropertyOverride(override)) {
                for (Override current : this.overrides) {
                    Model context;
                    if (override.getDeclaredType() != current.getDeclaredType()) continue;
                    boolean conflict = false;
                    String property = "";
                    if (override instanceof SetPropertyOverride) {
                        context = ((SetPropertyOverride)override).context;
                        property = ((SetPropertyOverride)override).property;
                        conflict = ((SetPropertyOverride)current).property == property && ((SetPropertyOverride)current).context == context;
                    } else if (override instanceof SetEventOverride) {
                        context = ((SetEventOverride)override).context;
                        property = ((SetEventOverride)override).event;
                        boolean bl = conflict = ((SetEventOverride)current).event == property && ((SetEventOverride)current).context == context;
                    }
                    if (!conflict) continue;
                    ThreadLocalToolkit.log((CompilerMessage)new MultipleInitializers(property, this.name), StatesModel.this.document.getSourcePath(), line);
                    return true;
                }
            }
            return false;
        }

        private boolean isPropertyOverride(Override override) {
            return override instanceof SetPropertyOverride || override instanceof SetEventOverride;
        }

        public Iterator<Initializer> getEvents() {
            return this.model != null ? this.model.getEventInitializerIterator() : null;
        }

        public boolean isDeclared() {
            return this.model != null ? this.model.isDeclared() : false;
        }

        public String getId() {
            return this.model != null ? this.model.getId() : null;
        }
    }
}

