/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.DesignLayer;
import flex2.compiler.mxml.rep.EventHandler;
import flex2.compiler.mxml.rep.LineNumberMapped;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.init.DynamicPropertyInitializer;
import flex2.compiler.mxml.rep.init.EffectInitializer;
import flex2.compiler.mxml.rep.init.EventInitializer;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.mxml.rep.init.StaticPropertyInitializer;
import flex2.compiler.mxml.rep.init.StyleInitializer;
import flex2.compiler.mxml.rep.init.ValueInitializer;
import flex2.compiler.util.IteratorList;
import flex2.compiler.util.NameFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.TransformIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model
implements LineNumberMapped {
    private Type type;
    private int xmlLineNumber;
    private String definitionName;
    private String id;
    private boolean idIsAutogenerated = false;
    private boolean isAnonymous = false;
    private MxmlDocument document;
    protected final StandardDefs standardDefs;
    private Model parent;
    private String parentIndex;
    private String parentIndexState;
    private boolean inspectable = false;
    private List<Model> repeaterParents;
    private Map<String, Initializer> properties;
    private Map<String, Initializer> styles;
    private Map<String, Initializer> effects;
    private Map<String, Initializer> events;
    private Collection<String> states;
    public DesignLayer layerParent;
    private boolean described;
    private boolean stateSpecific = false;
    public boolean earlyInit = false;
    private boolean ensureDeclaration = false;
    private boolean ensureBindable = false;
    private boolean descriptorInit = true;
    private boolean isTransient = false;
    public String comment;

    public Model(MxmlDocument document, Type type, int line) {
        this(document, type, null, line);
    }

    public Model(MxmlDocument document, Type type, Model parent, int line) {
        assert (type != null);
        this.document = document;
        this.standardDefs = document.getStandardDefs();
        this.type = type;
        this.parent = parent;
        this.setXmlLineNumber(line);
        document.ensureId(this);
        this.setDefinitionName(this.getId());
    }

    public final boolean isDeclared() {
        return !this.isAnonymous && this.document.isDeclared(this);
    }

    public final StandardDefs getStandardDefs() {
        return this.standardDefs;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getDefinitionName() {
        return this.definitionName;
    }

    public final void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id, boolean idIsAutogenerated) {
        this.id = id;
        this.idIsAutogenerated = idIsAutogenerated;
    }

    public final boolean getIdIsAutogenerated() {
        return this.idIsAutogenerated;
    }

    public final void ensureBindable() {
        this.ensureBindable = true;
    }

    public final boolean getBindabilityEnsured() {
        return this.ensureBindable;
    }

    public final boolean getIsAnonymous() {
        return this.isAnonymous;
    }

    public final void setIsAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public final boolean getIsTransient() {
        return this.isTransient;
    }

    public final void setIsTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public final MxmlDocument getDocument() {
        return this.document;
    }

    public final void setParent(Model parent) {
        this.parent = parent;
    }

    public final Model getParent() {
        return this.parent;
    }

    public final void setParentIndex(String index) {
        this.parentIndex = index;
    }

    public final void setParentIndex(String index, String state) {
        this.parentIndex = index;
        this.parentIndexState = state;
    }

    public final void setParentIndex(int index) {
        this.parentIndex = Integer.toString(index);
    }

    public final String getParentIndex() {
        return this.parentIndex;
    }

    public final String getParentIndexState() {
        return this.parentIndexState;
    }

    @Override
    public final int getXmlLineNumber() {
        return this.xmlLineNumber;
    }

    @Override
    public final void setXmlLineNumber(int xmlLineNumber) {
        this.xmlLineNumber = xmlLineNumber;
    }

    public final boolean getInspectable() {
        return this.inspectable;
    }

    public final void setInspectable(boolean inspectable) {
        this.inspectable = inspectable;
    }

    public final int getRepeaterLevel() {
        return this.getRepeaterParents().size();
    }

    public final List<Model> getRepeaterParents() {
        if (this.repeaterParents == null) {
            this.repeaterParents = new ArrayList<Model>();
            if (this.parent != null) {
                this.repeaterParents.addAll(this.parent.getRepeaterParents());
                if (this.standardDefs.isRepeater(this.parent.getType())) {
                    this.repeaterParents.add(this.parent);
                }
            }
        }
        return this.repeaterParents;
    }

    public void setProperty(String name, Model value) {
        this.setProperty(name, (Object)value, value.getXmlLineNumber());
    }

    public void setProperty(Property property, Object value, int line) {
        StaticPropertyInitializer initializer = new StaticPropertyInitializer(property, value, line, this.standardDefs);
        if (property.isStateSpecific()) {
            this.document.registerStateSpecificProperty(this, property.getName(), initializer, property.getStateName());
        } else {
            (this.properties != null ? this.properties : (this.properties = new LinkedHashMap<String, Initializer>())).put(property.getName(), initializer);
        }
    }

    public void setDynamicProperty(Type type, String name, Object value, String state, int line) {
        DynamicPropertyInitializer initializer = new DynamicPropertyInitializer(type, name, value, line, this.standardDefs);
        if (state != null) {
            this.document.registerStateSpecificProperty(this, name, initializer, state);
        } else {
            (this.properties != null ? this.properties : (this.properties = new LinkedHashMap<String, Initializer>())).put(name, initializer);
        }
    }

    public void setProperty(String name, Object value, int line) {
        Property property = this.type.getProperty(name);
        if (property != null) {
            this.setProperty(property, value, line);
        } else {
            this.setDynamicProperty(this.type.getTypeTable().objectType, name, value, null, line);
        }
    }

    public final boolean hasProperty(String name) {
        return this.getProperties().containsKey(name);
    }

    public boolean hasBindings() {
        return this.bindingsOnly(this.getProperties().values().iterator()).hasNext() || this.bindingsOnly(this.getStyles().values().iterator()).hasNext() || this.bindingsOnly(this.getEffects().values().iterator()).hasNext();
    }

    public boolean hasDataBoundProperty(String name) {
        Initializer initializer = this.getProperties().get(name);
        return initializer != null ? initializer.isBinding() : false;
    }

    public boolean hasDataBoundStyle(String name) {
        Initializer initializer = this.getStyles().get(name);
        return initializer != null ? initializer.isBinding() : false;
    }

    public boolean hasDataBoundEvent(String name) {
        Initializer initializer = this.getEvents().get(name);
        return initializer != null ? initializer.isBinding() : false;
    }

    public boolean hasDataBoundEffect(String name) {
        Initializer initializer = this.getEffects().get(name);
        return initializer != null ? initializer.isBinding() : false;
    }

    public final Iterator<Initializer> getPropertyInitializerIterator() {
        return this.getPropertyInitializerIterator(true);
    }

    public final Iterator<Initializer> getPropertyInitializerIterator(boolean includeBindings) {
        return includeBindings ? this.getProperties().values().iterator() : this.excludeBindings(this.getProperties().values().iterator());
    }

    public boolean isEmpty() {
        return this.properties == null && this.styles == null && this.effects == null && this.events == null;
    }

    public final Map<String, Initializer> getProperties() {
        return this.properties != null ? this.properties : Collections.emptyMap();
    }

    public Object getProperty(String name) {
        ValueInitializer initializer = (ValueInitializer)this.getProperties().get(name);
        return initializer != null ? initializer.getValue() : null;
    }

    public final void setStyle(String name, Object value, int line) {
        Style style = this.type.getStyle(name);
        assert (style != null) : "style '" + name + "' not defined on type '" + this.type.getName() + "'";
        this.setStyle(style, value, line);
    }

    public final void setStyle(Style style, Object value, int line) {
        StyleInitializer styleInitializer = new StyleInitializer(style, value, line, this.standardDefs);
        if (style.isStateSpecific()) {
            this.document.registerStateSpecificStyle(this, style.getName(), styleInitializer, style.getStateName());
        } else {
            (this.styles != null ? this.styles : (this.styles = new LinkedHashMap<String, Initializer>())).put(style.getName(), styleInitializer);
        }
    }

    public final Iterator<Initializer> getStyleInitializerIterator() {
        return this.excludeBindings(this.getStyles().values().iterator());
    }

    public final boolean hasStyle(String name) {
        return this.getStyles().containsKey(name);
    }

    private Map<String, Initializer> getStyles() {
        return this.styles != null ? this.styles : Collections.emptyMap();
    }

    public final void setEffect(String name, Object value, Type effectType, int line) {
        Effect effect = this.type.getEffect(name);
        this.setEffect(effect, value, effectType, line);
    }

    public final void setEffect(Effect effect, Object value, Type effectType, int line) {
        EffectInitializer effectInitializer = new EffectInitializer(effect, value, effectType, line, this.standardDefs);
        if (effect.isStateSpecific()) {
            this.document.registerStateSpecificStyle(this, effect.getName(), effectInitializer, effect.getStateName());
        } else {
            (this.effects != null ? this.effects : (this.effects = new LinkedHashMap<String, Initializer>())).put(effect.getName(), effectInitializer);
        }
    }

    public final Iterator<Initializer> getEffectInitializerIterator() {
        return this.excludeBindings(this.getEffects().values().iterator());
    }

    public final boolean hasEffect(String name) {
        return this.getEffects().containsKey(name);
    }

    public final Map<String, Initializer> getEffects() {
        return this.effects != null ? this.effects : Collections.emptyMap();
    }

    public String getEffectNames() {
        TransformIterator eventNameIter = new TransformIterator(this.getEffectInitializerIterator(), new Transformer(){

            public Object transform(Object object) {
                return TextGen.quoteWord(((EffectInitializer)object).getName());
            }
        });
        return TextGen.toCommaList(eventNameIter);
    }

    public String getEffectEventNames() {
        TransformIterator eventNameIter = new TransformIterator(this.getEffectInitializerIterator(), new Transformer(){

            public Object transform(Object object) {
                return TextGen.quoteWord(((EffectInitializer)object).getEventName());
            }
        });
        return TextGen.toCommaList(eventNameIter);
    }

    public Iterator getStyleAndEffectInitializerIterator() {
        return new IteratorChain(this.getStyleInitializerIterator(), this.getEffectInitializerIterator());
    }

    public final void setEvent(Event event, String text, int line) {
        EventHandler handler;
        if (!event.isStateSpecific()) {
            this.document.addImport(NameFormatter.toDot(event.getType().getName()), line);
            handler = new EventHandler(this, event, text);
        } else {
            handler = new EventHandler(this, event, text, event.getStateName());
        }
        handler.setXmlLineNumber(line);
        EventInitializer eventInitializer = new EventInitializer(handler);
        if (event.isStateSpecific()) {
            this.document.addStateSpecificEventInitializer(eventInitializer);
            this.document.registerStateSpecificEventHandler(this, event.getName(), eventInitializer, event.getStateName());
        } else {
            (this.events != null ? this.events : (this.events = new LinkedHashMap<String, Initializer>())).put(event.getName(), eventInitializer);
        }
    }

    public final Iterator<Initializer> getEventInitializerIterator() {
        return this.getEvents().values().iterator();
    }

    public final boolean hasEvent(String name) {
        return this.getEvents().containsKey(name);
    }

    public final Initializer getEventInitializer(String name) {
        return this.getEvents().get(name);
    }

    private final Map<String, Initializer> getEvents() {
        return this.events != null ? this.events : Collections.emptyMap();
    }

    public Iterator<CodeFragmentList> getSubDefinitionsIterator() {
        IteratorList iterList = new IteratorList();
        Model.addDefinitionIterators(iterList, this.getPropertyInitializerIterator());
        Model.addDefinitionIterators(iterList, this.getStyleInitializerIterator());
        Model.addDefinitionIterators(iterList, this.getEffectInitializerIterator());
        Model.addDefinitionIterators(iterList, this.getEventInitializerIterator());
        return iterList.toIterator();
    }

    protected static void addDefinitionIterators(IteratorList iterList, Iterator<? extends Initializer> initIter) {
        while (initIter.hasNext()) {
            iterList.add(initIter.next().getDefinitionsIterator());
        }
    }

    public Iterator<Initializer> getSubInitializerIterator() {
        IteratorList iterList = new IteratorList();
        iterList.add(this.getPropertyInitializerIterator());
        iterList.add(this.getStyleInitializerIterator());
        iterList.add(this.getEffectInitializerIterator());
        iterList.add(this.getEventInitializerIterator());
        return iterList.toIterator();
    }

    protected Iterator<Initializer> excludeBindings(Iterator<? extends Initializer> iter) {
        return this.bindingFilter(iter, false);
    }

    protected Iterator<Initializer> bindingsOnly(Iterator<? extends Initializer> iter) {
        return this.bindingFilter(iter, true);
    }

    protected Iterator<Initializer> bindingFilter(Iterator<? extends Initializer> iter, final boolean include) {
        return new FilterIterator(iter, new Predicate(){

            public boolean evaluate(Object object) {
                return ((Initializer)object).isBinding() == include;
            }
        });
    }

    public final void setDescribed(boolean described) {
        this.described = described;
    }

    public final boolean isDescribed() {
        return this.described;
    }

    public final void setStateSpecific(boolean stateful) {
        this.stateSpecific = stateful;
    }

    public final boolean isStateSpecific() {
        return this.stateSpecific;
    }

    public final void setEarlyInit(boolean earlyInit) {
        this.earlyInit = earlyInit;
    }

    public final boolean isEarlyInit() {
        return this.earlyInit;
    }

    public final void setStates(Collection<String> states) {
        this.states = states;
    }

    public final Collection<String> getStates() {
        return this.states;
    }

    public final boolean hasState(String state) {
        if (this.states != null) {
            return this.states.contains(state);
        }
        return false;
    }

    public final void ensureDeclaration() {
        this.ensureDeclaration = true;
    }

    public final boolean isDeclarationEnsured() {
        return this.ensureDeclaration;
    }

    public final void setDescriptorInit(boolean descriptorInit) {
        this.descriptorInit = descriptorInit;
    }

    public final boolean isDescriptorInit() {
        return this.descriptorInit;
    }
}

