/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.gen;

import flash.util.StringUtils;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.util.DualModeLineNumberMap;
import flex2.compiler.util.VelocityManager;

public class VelocityUtil
extends VelocityManager.Util {
    private final String path;
    private final boolean debug;
    private final SourceCodeBuffer sourceCodeBuffer;
    private final DualModeLineNumberMap lineNumberMap;

    public VelocityUtil(String path, boolean debug, SourceCodeBuffer sourceCodeBuffer, DualModeLineNumberMap lineNumberMap) {
        this.path = path;
        this.debug = debug;
        this.sourceCodeBuffer = sourceCodeBuffer;
        this.lineNumberMap = lineNumberMap;
    }

    public final String getTemplatePath() {
        return this.path;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final boolean getLineMappingEnabled() {
        return this.lineNumberMap != null && this.sourceCodeBuffer != null;
    }

    public final void mapLines(int origLine, String text) {
        this.mapLines(origLine, text, false);
    }

    public final void mapCompileErrorLines(int origLine, String text) {
        this.mapLines(origLine, text, true);
    }

    public final void mapLines(int origLine, String text, boolean compileOnly) {
        if (this.getLineMappingEnabled() && origLine > 0) {
            this.lineNumberMap.put(origLine, this.sourceCodeBuffer.getLineNumber(), StringUtils.countLines(text) + 1, compileOnly);
        }
    }
}

