/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.analyzer;

import flash.css.StyleParser;
import flash.css.StyleSheet;
import flash.fonts.FontManager;
import flash.util.FileUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.InvalidStateAttributeUsage;
import flex2.compiler.mxml.InvalidStateSpecificValue;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.ParseException;
import flex2.compiler.mxml.Parser;
import flex2.compiler.mxml.Token;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.ArgumentsNode;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BindingNode;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.DeclarationsNode;
import flex2.compiler.mxml.dom.DefinitionNode;
import flex2.compiler.mxml.dom.DesignLayerNode;
import flex2.compiler.mxml.dom.DocumentNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.LayeredNode;
import flex2.compiler.mxml.dom.LibraryNode;
import flex2.compiler.mxml.dom.MetaDataNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.MxmlScanner;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.PrivateNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.dom.ScannerError;
import flex2.compiler.mxml.dom.ScriptNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.StyleNode;
import flex2.compiler.mxml.dom.SyntaxTreeBuilder;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxAnalyzer
extends AnalyzerAdapter {
    private DocumentNode documentNode;

    public SyntaxAnalyzer(CompilationUnit unit, MxmlConfiguration mxmlConfiguration) {
        super(unit, mxmlConfiguration);
    }

    @Override
    public void analyze(Node node) {
        if (node instanceof DocumentNode) {
            this.documentNode = (DocumentNode)node;
        }
        super.analyze(node);
    }

    @Override
    public void analyze(LayeredNode node) {
        this.analyze((Node)node);
    }

    @Override
    public void analyze(CDATANode node) {
    }

    @Override
    public void analyze(StateNode node) {
        String name = (String)node.getAttributeValue("name");
        if (this.getDocumentVersion() >= 4 && name != null && TextParser.isBindingExpression(name)) {
            this.log(node, node.getLineNumber("name"), new CompileTimeAttributeBindingExpressionUnsupported());
        }
        super.analyze(node);
    }

    @Override
    public void analyze(StyleNode node) {
        this.checkForExtraAttributes(StyleNode.attributes, node);
        String source = (String)node.getAttributeValue("source");
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        if (source != null && cdata != null) {
            this.log(node, node.getLineNumber("source"), new IgnoreEmbeddedStylesheet());
        }
        if (source != null) {
            VirtualFile[] sourcePath;
            if (TextParser.isBindingExpression(source)) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile file = this.unit.getSource().resolve(source);
            if (file == null && (sourcePath = this.mxmlConfiguration.getSourcePath()) != null) {
                for (int i = 0; i < sourcePath.length && file == null; ++i) {
                    file = sourcePath[i].resolve(source);
                }
            }
            if (file == null) {
                this.log(node, node.getLineNumber("source"), new StylesheetNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(file);
                cdata = this.parseExternalFile(node, file);
                if (cdata != null) {
                    this.parseStyle(node, file.getName(), file.getLastModified(), cdata);
                }
            }
        } else if (cdata != null) {
            this.parseStyle(node, this.unit.getSource().getName(), this.unit.getSource().getLastModified(), cdata.beginLine);
        }
    }

    @Override
    public void analyze(ScriptNode node) {
        this.checkForExtraAttributes(ScriptNode.attributes, node);
        this.script(node);
    }

    @Override
    public void analyze(MetaDataNode node) {
        this.checkForExtraAttributes(MetaDataNode.attributes, node);
    }

    @Override
    public void analyze(ModelNode node) {
        this.checkForExtraAttributes(ModelNode.attributes, node);
        String source = (String)node.getAttributeValue("source");
        int count = node.getChildCount();
        if (source != null && count > 0) {
            this.log(node, node.getLineNumber("source"), new EmptyTagIfSourceSpecified());
        }
        if (source != null) {
            if (TextParser.isBindingExpression(source)) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile f2 = this.unit.getSource().resolve(source);
            if (f2 == null) {
                this.log(node, node.getLineNumber("source"), new ModelNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(f2);
                Node root = this.parseExternalXML(node, f2);
                if (root != null) {
                    node.setSourceFile(new Node[]{root});
                }
            }
        }
    }

    @Override
    public void analyze(XMLNode node) {
        this.checkForExtraAttributes(XMLNode.attributes, node);
        String source = (String)node.getAttributeValue("source");
        int count = node.getChildCount();
        if (source != null && count > 0) {
            this.log(node, node.getLineNumber("source"), new IgnoreInlineXML());
        }
        if (source != null) {
            if (TextParser.isBindingExpression(source)) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile f2 = this.unit.getSource().resolve(source);
            if (f2 == null) {
                this.log(node, node.getLineNumber("source"), new XMLNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(f2);
                Node root = this.parseExternalXML(node, f2);
                if (root != null) {
                    node.setSourceFile(new Node[]{root});
                }
            }
        }
    }

    @Override
    public void analyze(XMLListNode node) {
        this.checkForExtraAttributes(XMLListNode.attributes, node);
    }

    @Override
    public void analyze(ArrayNode node) {
        this.checkForExtraAttributes(ArrayNode.attributes, node);
        super.analyze(node);
    }

    @Override
    public void analyze(VectorNode node) {
        this.checkForExtraAttributes(VectorNode.attributes, node);
        super.analyze(node);
    }

    @Override
    public void analyze(BindingNode node) {
        String twoWay;
        String destination;
        this.checkForExtraAttributes(BindingNode.attributes, node);
        String source = (String)node.getAttributeValue("source");
        if (source == null || source.trim().length() == 0) {
            this.log(node, (CompilerMessage)new BindingMustHaveSource());
        }
        if ((destination = (String)node.getAttributeValue("destination")) == null || destination.trim().length() == 0) {
            this.log(node, (CompilerMessage)new BindingMustHaveDestination());
        }
        if (source != null && destination != null && source.equals(destination)) {
            this.log(node, (CompilerMessage)new BindingMustHaveUniqueSourceDestination());
        }
        if ((twoWay = (String)node.getAttributeValue("twoWay")) != null && TextParser.isBindingExpression(twoWay)) {
            this.log(node, node.getLineNumber("twoWay"), new CompileTimeAttributeBindingExpressionUnsupported());
        }
    }

    @Override
    public void analyze(ReparentNode node) {
        this.checkForExtraAttributes(ReparentNode.attributes, node);
        String target = (String)node.getAttributeValue("target");
        if (target == null || target.trim().length() == 0) {
            this.log(node, (CompilerMessage)new ReparentMustHaveTarget());
        } else if (TextParser.isBindingExpression(target)) {
            this.log(node, node.getLineNumber("target"), new CompileTimeAttributeBindingExpressionUnsupported());
        }
        String includeIn = (String)node.getAttributeValue("includeIn");
        String excludeFrom = (String)node.getAttributeValue("excludeFrom");
        if (!(includeIn != null && includeIn.trim().length() != 0 || excludeFrom != null && excludeFrom.trim().length() != 0)) {
            this.log(node, (CompilerMessage)new ReparentMustHaveStates());
        }
    }

    @Override
    public void analyze(LibraryNode node) {
        this.checkForExtraAttributes(LibraryNode.attributes, node);
        int i = 0;
        while (i < this.documentNode.getChildCount()) {
            Node nextNode;
            if ((nextNode = (Node)this.documentNode.getChildAt(i++)).getLocalPart() == "mask") continue;
            if (nextNode == node) break;
            this.log(node, node.beginLine, new LibraryMustBeFirstChildOfDocumentError());
            break;
        }
        super.analyze(node);
    }

    @Override
    public void analyze(DeclarationsNode node) {
        this.checkForExtraAttributes(DeclarationsNode.attributes, node);
        super.analyze(node);
    }

    @Override
    public void analyze(DefinitionNode node) {
        this.checkForExtraAttributes(DefinitionNode.attributes, node);
        String definitionName = (String)node.getAttributeValue("name");
        if (definitionName == null || definitionName.trim().length() == 0) {
            this.log(node, node.getLineNumber("name"), new DefinitionMustHaveNameError());
        }
        if (node.getChildCount() != 1) {
            this.log(node, node.beginLine, new DefinitionMustHaveOneChildError(definitionName));
        }
        super.analyze(node);
    }

    @Override
    public void analyze(PrivateNode node) {
        this.checkForExtraAttributes(PrivateNode.attributes, node);
        int i = this.documentNode.getChildCount() - 1;
        while (i >= 0) {
            Node lastNode;
            if ("mask".equals((lastNode = (Node)this.documentNode.getChildAt(i--)).getLocalPart())) continue;
            if (lastNode == node) break;
            this.log(node, node.beginLine, new PrivateMustBeLastChildOfDocumentError());
            break;
        }
    }

    @Override
    public void analyze(StringNode node) {
        this.checkForExtraAttributes(StringNode.attributes, node);
        this.primitive(node);
    }

    @Override
    public void analyze(NumberNode node) {
        this.checkForExtraAttributes(NumberNode.attributes, node);
        this.primitive(node);
    }

    @Override
    public void analyze(IntNode node) {
        this.checkForExtraAttributes(IntNode.attributes, node);
        this.primitive(node);
    }

    @Override
    public void analyze(UIntNode node) {
        this.checkForExtraAttributes(UIntNode.attributes, node);
        this.primitive(node);
    }

    @Override
    public void analyze(BooleanNode node) {
        this.checkForExtraAttributes(BooleanNode.attributes, node);
        this.primitive(node);
    }

    @Override
    public void analyze(RequestNode node) {
        this.checkForExtraAttributes(RequestNode.attributes, node);
        super.analyze(node);
    }

    @Override
    public void analyze(ArgumentsNode node) {
        this.checkForExtraAttributes(ArgumentsNode.attributes, node);
        super.analyze(node);
    }

    @Override
    public void analyze(InlineComponentNode node) {
        this.checkForExtraAttributes(InlineComponentNode.attributes, node);
        if (node.getChildCount() == 0) {
            this.log(node, (CompilerMessage)new InlineComponentMustHaveOneChild());
        }
        super.analyze(node);
    }

    @Override
    public void analyze(DesignLayerNode node) {
        this.checkForExtraAttributes(DesignLayerNode.attributes, node);
        super.analyze(node);
    }

    @Override
    protected void traverse(Node node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = (Node)node.getChildAt(i);
            child.analyze(this);
            if (!(child instanceof DesignLayerNode)) continue;
            List<Token> designInfoChildren = child.getChildren();
            node.replaceNode(i, designInfoChildren);
            i += designInfoChildren.size() - 1;
            if (child.getAttributeValue("id") == null || designInfoChildren.size() != 0) continue;
            this.documentNode.layerDeclarationNodes.add((DesignLayerNode)child);
        }
    }

    @Override
    protected int getDocumentVersion() {
        return this.documentNode != null ? this.documentNode.getVersion() : 0;
    }

    @Override
    protected String getLanguageNamespace() {
        return this.documentNode != null ? this.documentNode.getLanguageNamespace() : null;
    }

    private void checkForExtraAttributes(Set<QName> validAttributes, Node node) {
        Iterator<QName> attributes = node.getAttributeNames();
        while (attributes != null && attributes.hasNext()) {
            QName qname = attributes.next();
            String namespace = qname.getNamespace();
            String localPart = qname.getLocalPart();
            Boolean isScoped = TextParser.isScopedName(localPart);
            if (isScoped.booleanValue()) {
                String[] statefulName = TextParser.analyzeScopedName(localPart);
                QName qName = qname = statefulName != null ? new QName(namespace, statefulName[0]) : qname;
            }
            if (!validAttributes.contains(qname)) {
                if (localPart.equals("includeIn") || localPart.equals("excludeFrom")) {
                    this.log(node, node.getLineNumber(qname), new InvalidStateAttributeUsage(node.getLocalPart()));
                    continue;
                }
                if (this.getDocumentVersion() < 4) {
                    this.log(node, node.getLineNumber(qname), new UnknownAttribute(qname, node.image));
                    continue;
                }
                if (namespace != null && namespace.length() != 0 && !namespace.equals(node.getNamespace()) && !namespace.equals(this.documentNode.getLanguageNamespace())) continue;
                this.log(node, node.getLineNumber(qname), new UnknownAttribute(qname, node.image));
                continue;
            }
            if (!isScoped.booleanValue() || node instanceof DesignLayerNode) continue;
            this.log(node.getLineNumber(qname), (CompilerMessage)new InvalidStateSpecificValue(qname.getLocalPart()));
        }
    }

    private void script(ScriptNode node) {
        String source = (String)node.getAttributeValue("source");
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        if (source != null && cdata != null) {
            this.log(node, node.getLineNumber("source"), new IgnoreInlineScript());
        }
        if (source != null) {
            if (TextParser.isBindingExpression(source)) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile f2 = this.unit.getSource().resolve(source);
            if (f2 == null) {
                this.log(node, node.getLineNumber("source"), new ScriptNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(f2);
                CDATANode n = this.parseExternalFile(node, f2);
                if (n != null) {
                    cdata = n;
                    node.setSourceFile(n);
                }
            }
        }
    }

    private void primitive(PrimitiveNode node) {
        String source = (String)node.getAttributeValue("source");
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        if (source != null && cdata != null) {
            this.log(node, node.getLineNumber("source"), new IgnoreEmbeddedString());
        }
        if (source != null) {
            if (TextParser.isBindingExpression(source)) {
                this.log(node, node.getLineNumber("source"), new CompileTimeAttributeBindingExpressionUnsupported());
                return;
            }
            VirtualFile f2 = this.unit.getSource().resolve(source);
            if (f2 == null) {
                this.log(node, node.getLineNumber("source"), new PrimitiveFileNotFound(source));
            } else {
                this.unit.getSource().addFileInclude(f2);
                CDATANode n = this.parseExternalFile(node, f2);
                if (n != null) {
                    cdata = n;
                    node.setSourceFile(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node parseExternalXML(Node node, VirtualFile f2) {
        BufferedInputStream in = null;
        Node anonymousObject = null;
        in = new BufferedInputStream(f2.getInputStream());
        MxmlScanner s = new MxmlScanner(in, this.mxmlConfiguration.enableRuntimeDesignLayers());
        Parser p = new Parser(s);
        SyntaxTreeBuilder v = new SyntaxTreeBuilder();
        p.setVisitor(v);
        anonymousObject = (Node)p.parseAnonymousObject();
        Object var9_12 = null;
        if (in == null) return anonymousObject;
        try {
            in.close();
            return anonymousObject;
        }
        catch (IOException ex2) {}
        return anonymousObject;
        {
            catch (ScannerError se) {
                this.log(node, (CompilerMessage)new XMLParseProblem1(f2.getName(), se.getLineNumber(), se.getReason()));
                Object var9_13 = null;
                if (in == null) return anonymousObject;
                try {
                    in.close();
                    return anonymousObject;
                }
                catch (IOException ex2) {}
                return anonymousObject;
            }
            catch (ParseException ex) {
                this.log(node, (CompilerMessage)new XMLParseProblem2(f2.getName()));
                Token token = ex.currentToken.next;
                this.logError(node, token.beginLine, ex.getMessage());
                Object var9_14 = null;
                if (in == null) return anonymousObject;
                try {
                    in.close();
                    return anonymousObject;
                }
                catch (IOException ex2) {}
                return anonymousObject;
            }
            catch (IOException ex) {
                this.log(node, (CompilerMessage)new XMLParseProblem3(f2.getName(), ex.getMessage()));
                Object var9_15 = null;
                if (in == null) return anonymousObject;
                try {
                    in.close();
                    return anonymousObject;
                }
                catch (IOException ex2) {}
                return anonymousObject;
            }
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CDATANode parseExternalFile(Node node, VirtualFile f2) {
        String charsetName;
        BufferedInputStream bufferedInputStream;
        CDATANode cdata;
        BufferedReader reader;
        block16: {
            reader = null;
            cdata = null;
            bufferedInputStream = new BufferedInputStream(f2.getInputStream());
            charsetName = null;
            if (!f2.getName().toLowerCase().endsWith(".css")) break block16;
            try {
                charsetName = StyleParser.readCSSCharset(bufferedInputStream);
            }
            catch (StyleParser.StyleSheetInvalidCharset e2) {
                this.log(node, (CompilerMessage)new StyleParser.StyleSheetInvalidCharset(f2.getName(), e2.charsetName));
                CDATANode cDATANode = null;
                Object var12_13 = null;
                if (reader == null) return cDATANode;
                try {
                    reader.close();
                    return cDATANode;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                return cDATANode;
            }
        }
        String bomCharsetName = FileUtils.consumeBOM(bufferedInputStream, null, true);
        if (charsetName == null) {
            charsetName = bomCharsetName;
        }
        reader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, charsetName));
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        String str = null;
        while ((str = reader.readLine()) != null) {
            out.println(str);
        }
        out.flush();
        cdata = new CDATANode();
        cdata.image = buffer.toString().trim();
        Object var12_14 = null;
        if (reader == null) return cdata;
        try {
            reader.close();
            return cdata;
        }
        catch (IOException ex2) {}
        return cdata;
        {
            catch (FileNotFoundException ex) {
                this.log(node, (CompilerMessage)new ExternalFileNotFound(f2.getName()));
                Object var12_15 = null;
                if (reader == null) return cdata;
                try {
                    reader.close();
                    return cdata;
                }
                catch (IOException ex2) {}
                return cdata;
            }
            catch (IOException ex) {
                this.log(node, (CompilerMessage)new ParseFileProblem(f2.getName(), ex.getMessage()));
                Object var12_16 = null;
                if (reader == null) return cdata;
                try {
                    reader.close();
                    return cdata;
                }
                catch (IOException ex2) {}
                return cdata;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void parseStyle(StyleNode node, String stylePath, long lastModified, CDATANode cdata) {
        FontManager fontManager = this.mxmlConfiguration.getFontsConfiguration().getTopLevelManager();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.checkDeprecation(this.mxmlConfiguration.showDeprecationWarnings());
        styleSheet.parse(stylePath, new StringReader(cdata.image), ThreadLocalToolkit.getLogger(), fontManager);
        if (styleSheet.errorsExist()) {
            this.log(node, (CompilerMessage)new StyleSheetParseError(stylePath));
        }
        node.setStyleSheet(styleSheet);
    }

    private void parseStyle(StyleNode node, String enclosingDocumentPath, long lastModified, int startLine) {
        FontManager fontManager = this.mxmlConfiguration.getFontsConfiguration().getTopLevelManager();
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.checkDeprecation(this.mxmlConfiguration.showDeprecationWarnings());
        styleSheet.parse(enclosingDocumentPath, startLine, new StringReader(cdata.image), ThreadLocalToolkit.getLogger(), fontManager);
        if (styleSheet.errorsExist()) {
            this.log(node, (CompilerMessage)new StyleSheetParseError(enclosingDocumentPath));
        }
        node.setStyleSheet(styleSheet);
    }

    public static class ReparentMustHaveStates
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -9048719337863206820L;
    }

    public static class ReparentMustHaveTarget
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 9187442166720946682L;
    }

    public static class PrivateMustBeLastChildOfDocumentError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2883815035659543585L;
    }

    public static class LibraryMustBeFirstChildOfDocumentError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8197039600346556673L;
    }

    public static class DefinitionMustHaveOneChildError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4954341364049052865L;
        public String name;

        public DefinitionMustHaveOneChildError(String name) {
            this.name = name;
        }
    }

    public static class DefinitionMustHaveNameError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2473265116122447983L;
    }

    public static class InlineComponentMustHaveOneChild
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8013015924130843086L;
    }

    public static class StyleSheetParseError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7734934094694932051L;
        public final String stylePath;

        public StyleSheetParseError(String stylePath) {
            this.stylePath = stylePath;
        }
    }

    public static class ParseFileProblem
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2982048188724576242L;
        public final String name;
        public final String message;

        public ParseFileProblem(String name, String message) {
            this.name = name;
            this.message = message;
        }
    }

    public static class ExternalFileNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5308420983986384234L;
        public final String name;

        public ExternalFileNotFound(String name) {
            this.name = name;
        }
    }

    public static class XMLParseProblem3
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 8934855322492753302L;
        public final String name;
        public final String message;

        public XMLParseProblem3(String name, String message) {
            this.name = name;
            this.message = message;
        }
    }

    public static class XMLParseProblem2
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6202816852895893830L;
        public final String name;

        public XMLParseProblem2(String name) {
            this.name = name;
        }
    }

    public static class XMLParseProblem1
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6245404102161978415L;
        public final String name;
        public final int line;
        public final String reason;

        public XMLParseProblem1(String name, int line, String reason) {
            this.name = name;
            this.line = line;
            this.reason = reason;
        }
    }

    public static class PrimitiveFileNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1097562596712781756L;
        public final String source;

        public PrimitiveFileNotFound(String source) {
            this.source = source;
        }
    }

    public static class IgnoreEmbeddedString
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -4800647048554425238L;
    }

    public static class ScriptNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1688968001018529008L;
        public final String source;

        public ScriptNotFound(String source) {
            this.source = source;
        }
    }

    public static class UnknownAttribute
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6364683156804532037L;
        public final QName qname;
        public final String tag;

        public UnknownAttribute(QName qname, String tag) {
            this.qname = qname;
            this.tag = tag;
        }
    }

    public static class BindingMustHaveUniqueSourceDestination
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7116545090937761064L;
    }

    public static class BindingMustHaveDestination
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2060746809575116784L;
    }

    public static class BindingMustHaveSource
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5367924918244642096L;
    }

    public static class XMLNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 632658792662647542L;
        public final String source;

        public XMLNotFound(String source) {
            this.source = source;
        }
    }

    public static class IgnoreInlineXML
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 4976631970422220456L;
    }

    public static class IgnoreInlineScript
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 8940525017916497366L;
    }

    public static class ScalarContentOnlyUnsupportedInExternalModel
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 7778134403904275975L;
    }

    public static class ModelNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5004903591499990705L;
        public final String source;

        public ModelNotFound(String source) {
            this.source = source;
        }
    }

    public static class EmptyTagIfSourceSpecified
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 6683414194026602697L;
    }

    public static class StylesheetNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6265512596325307132L;
        public final String source;

        public StylesheetNotFound(String source) {
            this.source = source;
        }
    }

    public static class CompileTimeAttributeBindingExpressionUnsupported
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3787694300539037935L;
    }

    public static class IgnoreEmbeddedStylesheet
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -663088524822264581L;
    }
}

