/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.swf.builder.tags.ImageShapeBuilder;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.PlaceObject;
import flash.swf.types.FillStyle;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import flex2.compiler.media.MovieTranscoder;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageTranscoder
extends AbstractTranscoder {
    public static final String SMOOTHING = "smoothing";

    public ImageTranscoder(String[] mimeTypes, Class defineTag, boolean cacheTags) {
        super(mimeTypes, defineTag, cacheTags);
    }

    @Override
    public boolean isSupportedAttribute(String attr) {
        return "scaleGridBottom".equals(attr) || "scaleGridLeft".equals(attr) || "scaleGridRight".equals(attr) || "scaleGridTop".equals(attr) || SMOOTHING.equals(attr);
    }

    public abstract ImageInfo getImage(VirtualFile var1, Map<String, Object> var2) throws TranscoderException;

    @Override
    public Transcoder.TranscodingResults doTranscode(PathResolver context, SymbolTable symbolTable, Map<String, Object> args, String className, boolean generateSource) throws TranscoderException {
        Transcoder.TranscodingResults results = new Transcoder.TranscodingResults(this.resolveSource(context, args));
        String newName = (String)args.get("exportSymbol");
        ImageInfo info = this.getImage(results.assetSource, args);
        if (args.containsKey("scaleGridLeft") || args.containsKey("scaleGridRight") || args.containsKey("scaleGridTop") || args.containsKey("scaleGridBottom")) {
            if (args.get("scaleGridLeft") == null || args.get("scaleGridRight") == null || args.get("scaleGridTop") == null || args.get("scaleGridBottom") == null) {
                throw new ScalingGridException();
            }
            results.defineTag = ImageTranscoder.buildSlicedSprite(newName, info, args);
        } else {
            results.defineTag = args.containsKey(SMOOTHING) && Boolean.parseBoolean((String)args.get(SMOOTHING)) ? ImageTranscoder.buildSmoothingSprite(newName, info) : ImageTranscoder.buildBitmap(newName, info);
        }
        if (generateSource) {
            this.generateSource(results, className, args);
        }
        return results;
    }

    private static DefineShape generateSlicedShape(DefineBits refBitmap, Rect r, int width, int height) {
        int slt = r.xMin;
        int srt = r.xMax;
        int stt = r.yMin;
        int sbt = r.yMax;
        DefineShape shape = new DefineShape(83);
        shape.edgeBounds = shape.bounds = new Rect(0, width, 0, height);
        shape.shapeWithStyle = new ShapeWithStyle();
        shape.shapeWithStyle.shapeRecords = new ArrayList();
        shape.shapeWithStyle.fillstyles = new ArrayList();
        shape.shapeWithStyle.linestyles = new ArrayList();
        Matrix tsm = new Matrix();
        tsm.setScale(20.0, 20.0);
        for (int i = 0; i < 9; ++i) {
            FillStyle fs = new FillStyle(66, tsm, refBitmap);
            shape.shapeWithStyle.fillstyles.add(fs);
        }
        int dxa = slt;
        int dxb = srt - slt;
        int dxc = width - srt;
        int dya = stt;
        int dyb = sbt - stt;
        int dyc = height - sbt;
        StyleChangeRecord startStyle = new StyleChangeRecord();
        startStyle.setMove(0, dya);
        shape.shapeWithStyle.shapeRecords.add(startStyle);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, -dya}, {dxa, 0}}, 0, 1);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{dxb, 0}}, 0, 2);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{dxc, 0}, {0, dya}}, 0, 3);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, dyb}}, 0, 6);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, dyc}, {-dxc, 0}}, 0, 9);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{-dxb, 0}}, 0, 8);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{-dxa, 0}, {0, -dyc}}, 0, 7);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, -dyb}}, 0, 4);
        StyleChangeRecord down1Style = new StyleChangeRecord();
        down1Style.setMove(dxa, 0);
        shape.shapeWithStyle.shapeRecords.add(down1Style);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, dya}}, 2, 1);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, dyb}}, 5, 4);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, dyc}}, 8, 7);
        StyleChangeRecord down2Style = new StyleChangeRecord();
        down2Style.setMove(dxa + dxb, 0);
        shape.shapeWithStyle.shapeRecords.add(down2Style);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, dya}}, 3, 2);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, dyb}}, 6, 5);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{0, dyc}}, 9, 8);
        StyleChangeRecord right1Style = new StyleChangeRecord();
        right1Style.setMove(0, dya);
        shape.shapeWithStyle.shapeRecords.add(right1Style);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{dxa, 0}}, 1, 4);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{dxb, 0}}, 2, 5);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{dxc, 0}}, 3, 6);
        StyleChangeRecord right2Style = new StyleChangeRecord();
        right2Style.setMove(0, dya + dyb);
        shape.shapeWithStyle.shapeRecords.add(right2Style);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{dxa, 0}}, 4, 7);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{dxb, 0}}, 5, 8);
        ImageTranscoder.addEdgesWithFill(shape, new int[][]{{dxc, 0}}, 6, 9);
        return shape;
    }

    private static DefineShape generateSmoothingShape(ImageInfo imageInfo) {
        DefineShape shape = new DefineShape(2);
        shape.edgeBounds = shape.bounds = new Rect(0, imageInfo.width * 20, 0, imageInfo.height * 20);
        shape.shapeWithStyle = new ShapeWithStyle();
        shape.shapeWithStyle.shapeRecords = new ArrayList();
        shape.shapeWithStyle.fillstyles = new ArrayList();
        shape.shapeWithStyle.linestyles = new ArrayList();
        Matrix matrix = new Matrix();
        matrix.setScale(20.0, 20.0);
        FillStyle fillStyle = new FillStyle(65, matrix, imageInfo.defineBits);
        shape.shapeWithStyle.fillstyles.add(fillStyle);
        StyleChangeRecord startStyle = new StyleChangeRecord();
        startStyle.setFillStyle1(1);
        startStyle.setMove(imageInfo.width * 20, imageInfo.height * 20);
        shape.shapeWithStyle.shapeRecords.add(startStyle);
        shape.shapeWithStyle.shapeRecords.add(new StraightEdgeRecord(-1 * imageInfo.width * 20, 0));
        shape.shapeWithStyle.shapeRecords.add(new StraightEdgeRecord(0, -1 * imageInfo.height * 20));
        shape.shapeWithStyle.shapeRecords.add(new StraightEdgeRecord(imageInfo.width * 20, 0));
        shape.shapeWithStyle.shapeRecords.add(new StraightEdgeRecord(0, imageInfo.height * 20));
        return shape;
    }

    private static void addEdgesWithFill(DefineShape shape, int[][] coords, int left, int right) {
        StyleChangeRecord scr = new StyleChangeRecord();
        if (left != 0 || right != 0) {
            scr.setFillStyle0(left);
            scr.setFillStyle1(right);
        }
        shape.shapeWithStyle.shapeRecords.add(scr);
        for (int i = 0; i < coords.length; ++i) {
            shape.shapeWithStyle.shapeRecords.add(new StraightEdgeRecord(coords[i][0], coords[i][1]));
        }
    }

    public static DefineBits buildBitmap(String name, ImageInfo imageInfo) {
        return imageInfo.defineBits;
    }

    public static DefineSprite buildSprite(String name, ImageInfo imageInfo) {
        DefineSprite sprite = new DefineSprite(name);
        sprite.tagList.tags.add(imageInfo.defineBits);
        DefineShape ds3 = ImageShapeBuilder.buildImage(imageInfo.defineBits, imageInfo.width, imageInfo.height);
        sprite.tagList.defineShape3(ds3);
        PlaceObject po2 = new PlaceObject(ds3, 1);
        po2.setMatrix(new Matrix());
        sprite.tagList.placeObject2(po2);
        return sprite;
    }

    public static DefineSprite buildSlicedSprite(String name, ImageInfo imageInfo, Map<String, Object> args) throws TranscoderException {
        DefineSprite sprite = new DefineSprite(name);
        MovieTranscoder.defineScalingGrid(sprite, args);
        DefineShape shape = ImageTranscoder.generateSlicedShape(imageInfo.defineBits, sprite.scalingGrid.rect, imageInfo.width * 20, imageInfo.height * 20);
        PlaceObject po = new PlaceObject(shape, 10);
        Matrix tm = new Matrix();
        tm.setScale(1.0, 1.0);
        po.setMatrix(tm);
        sprite.tagList.placeObject(po);
        return sprite;
    }

    public static DefineSprite buildSmoothingSprite(String name, ImageInfo imageInfo) throws TranscoderException {
        DefineSprite sprite = new DefineSprite(name);
        DefineShape shape = ImageTranscoder.generateSmoothingShape(imageInfo);
        PlaceObject placeObject = new PlaceObject(shape, 10);
        Matrix matrix = new Matrix();
        matrix.setScale(1.0, 1.0);
        placeObject.setMatrix(matrix);
        sprite.tagList.placeObject(placeObject);
        return sprite;
    }

    @Override
    public String getAssociatedClass(DefineTag tag) {
        if (tag instanceof DefineBits) {
            StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
            return standardDefs.getCorePackage() + ".BitmapAsset";
        }
        return super.getAssociatedClass(tag);
    }

    public static final class ScalingGridException
    extends TranscoderException {
        private static final long serialVersionUID = -834180976279170821L;
    }

    public static class ImageInfo {
        public DefineBits defineBits;
        public int width;
        public int height;
    }
}

