/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineSound;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.util.Trace;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.NetworkFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityManager;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTranscoder
implements Transcoder {
    private static final String CODEGEN_TEMPLATE_PATH = "flex2/compiler/as3/";
    public static final String SCALE9TOP = "scaleGridTop";
    public static final String SCALE9LEFT = "scaleGridLeft";
    public static final String SCALE9BOTTOM = "scaleGridBottom";
    public static final String SCALE9RIGHT = "scaleGridRight";
    public static final String FONTSTYLE = "fontStyle";
    public static final String FONTWEIGHT = "fontWeight";
    public static final String FONTNAME = "fontName";
    public static final String FONTFAMILY = "fontFamily";
    protected String[] mimeTypes;
    protected Class defineTag;
    protected boolean cacheTags;
    protected Map<String, Transcoder.TranscodingResults> transcodingCache = new HashMap<String, Transcoder.TranscodingResults>();
    public static final String ASSET_TYPE = "flash.display.DisplayObject";

    public AbstractTranscoder(String[] mimeTypes, Class defineTag, boolean cacheTags) {
        this.mimeTypes = mimeTypes;
        this.defineTag = defineTag;
        this.cacheTags = cacheTags;
    }

    @Override
    public boolean isSupported(String mimeType) {
        for (int i = 0; i < this.mimeTypes.length; ++i) {
            if (!this.mimeTypes[i].equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Transcoder.TranscodingResults transcode(PathResolver context, SymbolTable symbolTable, Map<String, Object> args, String className, boolean generateSource) throws TranscoderException {
        for (String attr : args.keySet()) {
            if (attr.startsWith("_") || "source".equalsIgnoreCase(attr) || "mimeType".equalsIgnoreCase(attr) || "exportSymbol".equalsIgnoreCase(attr) || "original".equals(attr) || this.isSupportedAttribute(attr)) continue;
            throw new UnsupportedAttribute(attr, this.getClass().getName());
        }
        String cacheKey = null;
        Transcoder.TranscodingResults results = null;
        if (this.cacheTags) {
            cacheKey = this.getCacheKey(args);
            results = this.transcodingCache.get(cacheKey);
        }
        if (results == null) {
            results = this.doTranscode(context, symbolTable, args, className, generateSource);
            if (this.cacheTags) {
                cacheKey = this.getCacheKey(args);
                this.transcodingCache.put(cacheKey, results);
            }
        } else if (Trace.embed) {
            Trace.trace("Found cached DefineTag for " + cacheKey);
        }
        return results;
    }

    private String getCacheKey(Map<String, Object> args) {
        TreeMap<String, Object> m = new TreeMap<String, Object>(args);
        String key = "" + m.hashCode();
        if (Trace.embed) {
            key = key + "_" + m.toString();
        }
        return key;
    }

    public VirtualFile resolve(PathResolver context, String path) throws TranscoderException {
        VirtualFile f2;
        String p = path;
        if (path.startsWith("file:")) {
            p = p.substring("file:".length());
        }
        if ((f2 = context.resolve(p)) == null) {
            throw new UnableToResolve(path);
        }
        if (f2 instanceof NetworkFile) {
            throw new NetworkTranscodingSource(path);
        }
        return f2;
    }

    public VirtualFile resolveSource(PathResolver context, Map args) throws TranscoderException {
        VirtualFile result = null;
        String resolvedSource = (String)args.get("_resolvedSource");
        if (resolvedSource != null) {
            result = ThreadLocalToolkit.getResolvedPath(resolvedSource);
        }
        if (result == null) {
            String source = (String)args.get("source");
            if (source == null) {
                throw new MissingSource();
            }
            result = this.resolve(context, source);
        }
        return result;
    }

    public abstract Transcoder.TranscodingResults doTranscode(PathResolver var1, SymbolTable var2, Map<String, Object> var3, String var4, boolean var5) throws TranscoderException;

    public abstract boolean isSupportedAttribute(String var1);

    @Override
    public String getAssociatedClass(DefineTag tag) {
        if (tag == null) {
            return null;
        }
        StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
        String cls = null;
        String SKIN_SPRITE = standardDefs.getCorePackage() + ".SpriteAsset";
        if (tag instanceof DefineButton) {
            cls = standardDefs.getCorePackage() + ".ButtonAsset";
        } else if (tag instanceof DefineFont) {
            cls = standardDefs.getCorePackage() + ".FontAsset";
        } else if (tag instanceof DefineText) {
            cls = standardDefs.getCorePackage() + ".TextFieldAsset";
        } else if (tag instanceof DefineSound) {
            cls = standardDefs.getCorePackage() + ".SoundAsset";
        } else if (tag instanceof DefineBits) {
            cls = standardDefs.getCorePackage() + ".BitmapAsset";
        } else if (tag instanceof DefineSprite) {
            cls = standardDefs.getCorePackage() + ".SpriteAsset";
        }
        if (cls != null && (this.defineTag == null || this.defineTag.isAssignableFrom(tag.getClass()))) {
            if (tag instanceof DefineSprite && ((DefineSprite)tag).framecount > 1 && cls.equals(SKIN_SPRITE)) {
                cls = standardDefs.getCorePackage() + ".MovieClipAsset";
            }
            return cls;
        }
        if (this.defineTag == null) {
            if (Trace.embed) {
                Trace.trace("Couldn't find a matching class, so associating " + tag + " with " + SKIN_SPRITE);
            }
            return SKIN_SPRITE;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.transcodingCache.size() != 0) {
            this.transcodingCache = new HashMap<String, Transcoder.TranscodingResults>();
        }
    }

    public void generateSource(Transcoder.TranscodingResults asset, String fullClassName, Map<String, Object> embedMap) throws TranscoderException {
        this.generateSource(asset, fullClassName, embedMap, new HashMap());
    }

    public void generateSource(Transcoder.TranscodingResults asset, String fullClassName, Map<String, Object> embedMap, Map embedProps) throws TranscoderException {
        String baseClassName = this.getAssociatedClass(asset.defineTag);
        String packageName = "";
        String className = fullClassName;
        int dot = fullClassName.lastIndexOf(46);
        if (dot != -1) {
            packageName = fullClassName.substring(0, dot);
            className = fullClassName.substring(dot + 1);
        }
        if (asset.assetSource != null) {
            String path = asset.assetSource.getName().replace('\\', '/');
            embedMap.put("_resolvedSource", path);
            ThreadLocalToolkit.addResolvedPath(path, asset.assetSource);
        }
        try {
            StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
            String templateName = standardDefs.getEmbedClassTemplate();
            Template template = VelocityManager.getTemplate(CODEGEN_TEMPLATE_PATH + templateName);
            if (template == null) {
                throw new TemplateException(templateName);
            }
            VelocityContext velocityContext = VelocityManager.getCodeGenContext();
            velocityContext.put("packageName", packageName);
            velocityContext.put("baseClass", baseClassName);
            if (embedProps.size() != 0) {
                velocityContext.put("assetType", ASSET_TYPE);
            }
            velocityContext.put("embedClass", className);
            velocityContext.put("embedMap", embedMap);
            velocityContext.put("embedProps", embedProps);
            StringWriter stringWriter = new StringWriter();
            template.merge(velocityContext, stringWriter);
            asset.generatedCode = stringWriter.toString();
        }
        catch (Exception e2) {
            if (Trace.error) {
                e2.printStackTrace();
            }
            throw new UnableToGenerateSource(fullClassName);
        }
    }

    public static final class IncompatibleTranscoderParameters
    extends TranscoderException {
        private static final long serialVersionUID = 5674351726161323512L;
        public String param1;
        public String param2;

        public IncompatibleTranscoderParameters(String param1, String param2) {
            this.param1 = param1;
            this.param2 = param2;
        }
    }

    public static class EmbedRequiresCodegen
    extends TranscoderException {
        private static final long serialVersionUID = -1154861048587818696L;
        public String source;
        public String className;

        public EmbedRequiresCodegen(String source, String className) {
            this.source = source;
            this.className = className;
        }
    }

    public static class ExceptionWhileTranscoding
    extends TranscoderException {
        private static final long serialVersionUID = 3747245123304883388L;
        public String exception;

        public ExceptionWhileTranscoding(Exception exception) {
            this.exception = exception.getMessage();
        }
    }

    public static class UnableToReadSource
    extends TranscoderException {
        private static final long serialVersionUID = 157159356418747799L;
        public String source;

        public UnableToReadSource(String source) {
            this.source = source;
        }
    }

    public static class UnableToGenerateSource
    extends TranscoderException {
        private static final long serialVersionUID = 5252588163882319246L;
        public String className;

        public UnableToGenerateSource(String className) {
            this.className = className;
        }
    }

    public static class MissingSource
    extends TranscoderException {
        private static final long serialVersionUID = -3672019858278058644L;
    }

    public static class NetworkTranscodingSource
    extends TranscoderException {
        private static final long serialVersionUID = 1258842409489634129L;
        public String url;

        public NetworkTranscodingSource(String url) {
            this.url = url;
        }
    }

    public static class UnableToResolve
    extends TranscoderException {
        private static final long serialVersionUID = 3955870312641262226L;
        public String source;

        public UnableToResolve(String source) {
            this.source = source;
        }
    }

    public static class UnsupportedAttribute
    extends TranscoderException {
        private static final long serialVersionUID = -5367245871779383272L;
        public String attribute;
        public String mimeType;
        public String className;

        public UnsupportedAttribute(String attribute, String className) {
            this.attribute = attribute;
            this.className = className;
        }
    }

    public static class SourceException
    extends TranscoderException {
        private static final long serialVersionUID = -6720698044756027846L;
        public String className;

        public SourceException(String className) {
            this.className = className;
        }
    }

    public static class TemplateException
    extends TranscoderException {
        private static final long serialVersionUID = 5180630712564309116L;
        public String templateName;

        public TemplateException(String templateName) {
            this.templateName = templateName;
        }
    }
}

