/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flash.util.FileUtils;
import flex2.compiler.io.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InMemoryFile
implements VirtualFile {
    private byte[] bytes;
    private String name;
    private String mimeType;
    private long lastModified;

    public InMemoryFile(InputStream stream, long size, String name, String mimeType, long lastModified) throws IOException {
        this(FileUtils.toByteArray(stream, (int)size), name, mimeType, lastModified);
    }

    public InMemoryFile(InputStream stream, String name, String mimeType, long lastModified) {
        this(FileUtils.toByteArray(stream), name, mimeType, lastModified);
    }

    public InMemoryFile(byte[] data, String name, String mimeType, long lastModified) {
        this.bytes = data;
        this.name = name;
        this.mimeType = mimeType;
        this.lastModified = lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForReporting() {
        return this.name;
    }

    public String getURL() {
        return "memory://" + this.name;
    }

    public String getParent() {
        return null;
    }

    public boolean isDirectory() {
        return false;
    }

    public long size() {
        return this.bytes.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] toByteArray() throws IOException {
        return this.bytes;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public VirtualFile resolve(String relative) {
        return null;
    }

    public void close() {
        this.bytes = null;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof InMemoryFile) {
            if (this == object) {
                result = true;
            } else {
                InMemoryFile otherInMemoryFile = (InMemoryFile)object;
                if (this.name.equals(otherInMemoryFile.name) && this.lastModified == otherInMemoryFile.lastModified && this.bytes.length == otherInMemoryFile.bytes.length) {
                    result = true;
                }
            }
        }
        return result;
    }

    public int hashCode() {
        return (int)((long)this.name.hashCode() + this.lastModified + (long)this.bytes.length);
    }

    public boolean isTextBased() {
        return false;
    }

    public String toString() {
        return this.name;
    }
}

