/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flex2.compiler.Source;
import flex2.compiler.abc.MetaData;
import flex2.compiler.css.StyleConflictException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Styles {
    private static final String FORMAT = "format";
    private static final String COLOR = "Color";
    private static final String INHERIT = "inherit";
    private static final String YES = "yes";
    private Map<String, MetaData> declMap;
    private Map<String, Source> locationMap;

    public Styles(int preferredSize) {
        this.declMap = new HashMap<String, MetaData>(preferredSize);
        this.locationMap = new HashMap<String, Source>(preferredSize);
    }

    public Styles() {
        this(16);
    }

    public int size() {
        return this.declMap.size();
    }

    public void addStyle(String name, MetaData md, Source source) throws StyleConflictException {
        if (Styles.isInherit(md) ? this.isNonInheritingStyle(name) : this.isInheritingStyle(name)) {
            throw new StyleConflictException(name, this.locationMap.get(name));
        }
        this.declMap.put(name, md);
        this.locationMap.put(name, source);
    }

    public void addStyles(Styles styles) throws StyleConflictException {
        for (Map.Entry<String, MetaData> e2 : styles.declMap.entrySet()) {
            String name = e2.getKey();
            this.addStyle(name, e2.getValue(), styles.getLocation(name));
        }
    }

    public Source getLocation(String name) {
        return this.locationMap.get(name);
    }

    public MetaData getStyle(String name) {
        return this.declMap.get(name);
    }

    public boolean isInheritingStyle(String name) {
        MetaData md = this.getStyle(name);
        return md != null && Styles.isInherit(md);
    }

    public boolean isNonInheritingStyle(String name) {
        MetaData md = this.getStyle(name);
        return md != null && !Styles.isInherit(md);
    }

    private static boolean isInherit(MetaData md) {
        String inherit = md.getValue(INHERIT);
        return inherit != null && YES.equals(inherit);
    }

    public Iterator<String> getStyleNames() {
        return this.declMap.keySet().iterator();
    }

    public Set<String> getInheritingStyles() {
        HashSet<String> result = new HashSet<String>();
        Iterator<String> iterator = this.getStyleNames();
        while (iterator.hasNext()) {
            String styleName = iterator.next();
            if (!this.isInheritingStyle(styleName)) continue;
            result.add(styleName);
        }
        return result;
    }

    public void clear() {
        this.declMap.clear();
    }
}

