/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.config;

import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;

public class SystemPropertyConfigurator {
    public static void load(ConfigurationBuffer buffer, String prefix) throws ConfigurationException {
        try {
            Properties props = System.getProperties();
            Enumeration<?> e2 = props.propertyNames();
            while (e2.hasMoreElements()) {
                String propname = (String)e2.nextElement();
                if (!propname.startsWith(prefix + ".")) {
                    String value = System.getProperty(propname);
                    buffer.setToken(propname, value);
                    continue;
                }
                String varname = propname.substring(prefix.length() + 1);
                if (!buffer.isValidVar(varname)) continue;
                String value = System.getProperty(propname);
                LinkedList<String> args = new LinkedList<String>();
                StringTokenizer t = new StringTokenizer(value, ",");
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    args.add(token);
                }
                buffer.setVar(varname, args, "system properties", -1);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

