/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flash.localization.LocalizationManager;
import flash.util.FileUtils;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.common.MetadataConfiguration;
import flex2.compiler.common.RuntimeSharedLibrarySettingsConfiguration;
import flex2.compiler.config.AdvancedConfigurationInfo;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.LinkerConfiguration;
import flex2.tools.LicensesConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.ObjectList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements LinkerConfiguration,
Cloneable {
    protected ConfigurationPathResolver configResolver;
    private static Map<String, String> aliases = null;
    private String width = null;
    private String widthPercent = null;
    private String height = null;
    private String heightPercent = null;
    private String pageTitle = null;
    private String rootClassName;
    private String mainDefinition;
    private SortedSet<String> resourceBundles = new TreeSet<String>();
    private Set<String> unresolved = new HashSet<String>();
    private static final String DEFAULT_FRAMEWORK = "halo";
    private String framework = "halo";
    private boolean benchmark = false;
    private int benchmarkCompilerDetails;
    private long benchmarkTimeFilter;
    private CompilerConfiguration compilerConfiguration;
    private String debugPassword;
    private int backgroundColor = 5272190;
    private int frameRate = 24;
    private int scriptLimit = 60;
    private int scriptRecursionLimit = 1000;
    private boolean scriptLimitsSet = false;
    private int defaultWidth = 500;
    private int defaultHeight = 375;
    private Set<String> externs = new HashSet<String>();
    private FramesConfiguration frames;
    public boolean generateFrameLoader = true;
    private Set<String> includes = new LinkedHashSet<String>();
    private boolean lazyInit = false;
    private String linkReportFileName = null;
    private String sizeReportFileName = null;
    private MetadataConfiguration metadataConfiguration;
    private LicensesConfiguration licensesConfiguration;
    private RuntimeSharedLibrarySettingsConfiguration rslSettingsConfiguration;
    private String metadata = null;
    private String rbListFileName = null;
    private List<String> rslList = new LinkedList<String>();
    private boolean useNetwork;
    private List<RslPathInfo> rslPathInfoList;
    private Set<String> loadedRsls;
    private boolean staticLinkRsl = true;
    private String staticLinkRslSource;
    private boolean verifyDigests = true;
    private boolean removeUnusedRSLs = true;
    private boolean includeInheritanceDependenciesOnly = false;
    private int majorVersionTarget = 11;
    private int minorVersionTarget = 1;
    private int revisionTarget = 0;
    private int swfVersion = 14;
    private boolean useDirectBlit = false;
    private boolean useGpu = false;
    private boolean swcChecksumEnabled = true;
    private Map<String, VirtualFile> cssArchiveFiles;
    private Map<String, VirtualFile> l10nArchiveFiles;

    public Configuration() {
        this.compilerConfiguration = new CompilerConfiguration(this);
        this.frames = new FramesConfiguration();
        this.metadataConfiguration = new MetadataConfiguration();
        this.licensesConfiguration = new LicensesConfiguration();
        this.rslSettingsConfiguration = new RuntimeSharedLibrarySettingsConfiguration(this);
    }

    public static VirtualFile[] getAllExcludedLibraries(CompilerConfiguration compilerConfig, Configuration configuration) {
        return (VirtualFile[])CompilerConfiguration.merge(compilerConfig.getExternalLibraryPath(), configuration == null ? null : configuration.getRslExcludedLibraries(), VirtualFile.class);
    }

    public static String getOutputPath(ConfigurationValue cv, String fileName) {
        File file;
        String result = fileName;
        if (fileName != null && !FileUtils.isAbsolute(file = new File(fileName))) {
            String directory = cv.getBuffer().getToken("com.adobe.flex.default.output.directory");
            if (directory == null) {
                directory = cv.getContext();
            }
            if (directory != null) {
                result = FileUtils.addPathComponents(directory, fileName, File.separatorChar);
            }
        }
        return result;
    }

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
        this.compilerConfiguration.setConfigPathResolver(resolver);
        this.rslSettingsConfiguration.setConfigPathResolver(resolver);
    }

    public static Map<String, String> getAliases() {
        if (aliases == null) {
            aliases = new HashMap<String, String>();
            aliases.put("l", "compiler.library-path");
            aliases.put("el", "compiler.external-library-path");
            aliases.put("sp", "compiler.source-path");
            aliases.put("rsl", "runtime-shared-libraries");
            aliases.put("keep", "compiler.keep-generated-actionscript");
            aliases.put("o", "output");
            aliases.put("rslp", "runtime-shared-library-path");
            aliases.put("static-rsls", "static-link-runtime-shared-libraries");
            aliases.put("rsl-domain", "runtime-shared-library-settings.application-domain");
        }
        return aliases;
    }

    @Override
    public String width() {
        return this.width;
    }

    @Override
    public String widthPercent() {
        return this.widthPercent;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setWidthPercent(String widthPercent) {
        this.widthPercent = widthPercent;
    }

    @Override
    public String height() {
        return this.height;
    }

    @Override
    public String heightPercent() {
        return this.heightPercent;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setHeightPercent(String heightPercent) {
        this.heightPercent = heightPercent;
    }

    @Override
    public String pageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String title) {
        this.pageTitle = title;
    }

    @Override
    public String getRootClassName() {
        return this.rootClassName != null ? this.rootClassName : this.mainDefinition;
    }

    @Override
    public void setRootClassName(String rootClassName) {
        this.rootClassName = rootClassName;
    }

    @Override
    public String getMainDefinition() {
        return this.mainDefinition;
    }

    @Override
    public void setMainDefinition(String mainDefinition) {
        this.mainDefinition = mainDefinition;
    }

    @Override
    public SortedSet<String> getResourceBundles() {
        return this.resourceBundles;
    }

    @Override
    public Set<String> getUnresolved() {
        return this.unresolved;
    }

    public String getFramework() {
        return this.framework;
    }

    public void cfgFramework(ConfigurationValue cv, String s) {
        this.framework = s;
    }

    public boolean benchmark() {
        return this.benchmark;
    }

    public void cfgBenchmark(ConfigurationValue cv, boolean b2) {
        this.benchmark = b2;
    }

    public static ConfigurationInfo getBenchmarkInfo() {
        return new ConfigurationInfo(){

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public int getBenchmarkCompilerDetails() {
        return this.benchmarkCompilerDetails;
    }

    public void cfgBenchmarkCompilerDetails(ConfigurationValue cv, int details) {
        this.benchmarkCompilerDetails = details;
    }

    public static ConfigurationInfo getBenchmarkCompilerDetailsInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public long getBenchmarkTimeFilter() {
        return this.benchmarkTimeFilter;
    }

    public void cfgBenchmarkTimeFilter(ConfigurationValue cv, long timeFilter) {
        this.benchmarkTimeFilter = timeFilter;
    }

    public static ConfigurationInfo getBenchmarkTimeFilterInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public CompilerConfiguration getCompilerConfiguration() {
        return this.compilerConfiguration;
    }

    @Override
    public boolean debug() {
        return this.compilerConfiguration.debug();
    }

    public void setDebug(boolean debug) {
        this.compilerConfiguration.setDebug(debug);
    }

    @Override
    public boolean verboseStacktraces() {
        return this.compilerConfiguration.verboseStacktraces();
    }

    @Override
    public boolean optimize() {
        return this.compilerConfiguration.optimize();
    }

    public void setOptimize(boolean optimize) {
        this.compilerConfiguration.setOptimize(optimize);
    }

    @Override
    public String[] getMetadataToKeep() {
        return this.getCompilerConfiguration().getKeepAs3Metadata();
    }

    @Override
    public String debugPassword() {
        return this.debugPassword;
    }

    public void setDebugPassword(String debugPassword) {
        this.debugPassword = debugPassword;
    }

    public void cfgDebugPassword(ConfigurationValue cv, String debugPassword) {
        this.debugPassword = debugPassword;
    }

    public static ConfigurationInfo getDebugPasswordInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public int backgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void cfgDefaultBackgroundColor(ConfigurationValue cv, int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static ConfigurationInfo getDefaultBackgroundColorInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int rate) {
        this.frameRate = rate;
    }

    public void cfgDefaultFrameRate(ConfigurationValue cv, int rate) throws ConfigurationException {
        if (rate <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.frameRate = rate;
    }

    public static ConfigurationInfo getDefaultFrameRateInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public int getScriptTimeLimit() {
        return this.scriptLimit;
    }

    @Override
    public int getScriptRecursionLimit() {
        return this.scriptRecursionLimit;
    }

    public void setScriptTimeLimit(int scriptLimit) {
        this.scriptLimitsSet = true;
        this.scriptLimit = scriptLimit;
    }

    public void setScriptRecursionLimit(int recursionLimit) {
        this.scriptLimitsSet = true;
        this.scriptRecursionLimit = recursionLimit;
    }

    @Override
    public boolean scriptLimitsSet() {
        return this.scriptLimitsSet;
    }

    public void cfgDefaultScriptLimits(ConfigurationValue cv, int maxRecursionDepth, int maxExecutionTime) throws ConfigurationException {
        if (maxRecursionDepth <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        if (maxExecutionTime <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.scriptLimitsSet = true;
        this.scriptLimit = maxExecutionTime;
        this.scriptRecursionLimit = maxRecursionDepth;
    }

    public static ConfigurationInfo getDefaultScriptLimitsInfo() {
        return new ConfigurationInfo(new String[]{"max-recursion-depth", "max-execution-time"}){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    @Override
    public int defaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public int defaultHeight() {
        return this.defaultHeight;
    }

    public void cfgDefaultSize(ConfigurationValue cv, int width, int height) throws ConfigurationException {
        if (width < 1 || width > 4096 || height < 1 || height > 4096) {
            throw new ConfigurationException.IllegalDimensions(width, height, cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.defaultWidth = width;
        this.defaultHeight = height;
    }

    public static ConfigurationInfo getDefaultSizeInfo() {
        return new ConfigurationInfo(new String[]{"width", "height"}){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    @Override
    public Set<String> getExterns() {
        Set<String> compilerExterns = this.compilerConfiguration.getExterns();
        if (compilerExterns != null) {
            this.externs.addAll(compilerExterns);
        }
        return this.externs;
    }

    public void addExterns(Collection<String> externs) {
        this.externs.addAll(externs);
    }

    public void addExterns(QName[] qNames) {
        int len;
        int n = len = qNames == null ? 0 : qNames.length;
        for (int i = 0; i < len; ++i) {
            this.externs.add(qNames[i].toString());
        }
    }

    public void cfgExterns(ConfigurationValue cfgval, List<String> vals) {
        this.externs.addAll(this.toQNameString(vals));
    }

    public static ConfigurationInfo getExternsInfo() {
        return new ConfigurationInfo(-1, "symbol"){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public void removeExterns(Collection<String> externs) {
        this.externs.removeAll(externs);
    }

    protected List<String> toQNameString(List<String> vals) {
        int size;
        int n = size = vals == null ? 0 : vals.size();
        for (int i = 0; i < size; ++i) {
            String name = vals.get(i);
            if (name.indexOf(58) == -1 && name.indexOf(46) != -1) {
                int dot = name.lastIndexOf(46);
                name = name.substring(0, dot) + ':' + name.substring(dot + 1);
            }
            vals.set(i, name);
        }
        return vals;
    }

    public FramesConfiguration getFramesConfiguration() {
        return this.frames;
    }

    @Override
    public List<FramesConfiguration.FrameInfo> getFrameList() {
        return this.frames.getFrameList();
    }

    public void cfgGenerateFrameLoader(ConfigurationValue cv, boolean value) {
        this.generateFrameLoader = value;
    }

    public static ConfigurationInfo getGenerateFrameLoaderInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public Set<String> getIncludes() {
        return this.includes;
    }

    public void addIncludes(Collection<String> includes) {
        this.includes.addAll(includes);
    }

    public void cfgIncludes(ConfigurationValue cfgval, List<String> vals) {
        this.includes.addAll(this.toQNameString(vals));
    }

    public static ConfigurationInfo getIncludesInfo() {
        return new ConfigurationInfo(-1, "symbol"){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    @Override
    public boolean lazyInit() {
        return this.lazyInit;
    }

    public void cfgLazyInit(ConfigurationValue cv, boolean b2) {
        this.lazyInit = b2;
    }

    public static ConfigurationInfo getLazyInitInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public String getLinkReportFileName() {
        return this.linkReportFileName;
    }

    @Override
    public boolean generateLinkReport() {
        return this.linkReportFileName != null;
    }

    public void cfgLinkReport(ConfigurationValue cv, String filename) {
        this.linkReportFileName = Configuration.getOutputPath(cv, filename);
    }

    public static ConfigurationInfo getLinkReportInfo() {
        return new ConfigurationInfo(new String[]{"filename"}){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    @Override
    public String getSizeReportFileName() {
        return this.sizeReportFileName;
    }

    @Override
    public boolean generateSizeReport() {
        return this.sizeReportFileName != null;
    }

    public void cfgSizeReport(ConfigurationValue cv, String filename) {
        this.sizeReportFileName = Configuration.getOutputPath(cv, filename);
    }

    public static ConfigurationInfo getSizeReportInfo() {
        return new ConfigurationInfo(new String[]{"filename"}){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgLoadExterns(ConfigurationValue cfgval, String filename) throws ConfigurationException {
        VirtualFile f2 = ConfigurationPathResolver.getVirtualFile(filename, this.configResolver, cfgval);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(f2.getInputStream(), new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("def".equals(qName) || "pre".equals(qName) || "ext".equals(qName)) {
                        String id = attributes.getValue("id");
                        Configuration.this.externs.add(id);
                    }
                }
            });
        }
        catch (Exception e2) {
            throw new ConfigurationException.ConfigurationIOError(filename, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
    }

    public static ConfigurationInfo getLoadExternsInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public MetadataConfiguration getMetadataConfiguration() {
        return this.metadataConfiguration;
    }

    public LicensesConfiguration getLicensesConfiguration() {
        return this.licensesConfiguration;
    }

    public RuntimeSharedLibrarySettingsConfiguration getRuntimeSharedLibrarySettingsConfiguration() {
        return this.rslSettingsConfiguration;
    }

    @Override
    public String getMetadata() {
        return this.metadata == null ? this.getMetadataConfiguration().toString() : this.metadata;
    }

    public void cfgRawMetadata(ConfigurationValue cv, String xml) throws ConfigurationException {
        if (this.metadata != null) {
            throw new ConfigurationException.BadMetadataCombo(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.metadata = xml;
    }

    public static ConfigurationInfo getRawMetadataInfo() {
        return new ConfigurationInfo(1, "text"){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    @Override
    public String getRBListFileName() {
        return this.rbListFileName;
    }

    @Override
    public boolean generateRBList() {
        return this.rbListFileName != null;
    }

    public void cfgResourceBundleList(ConfigurationValue cv, String filename) {
        this.rbListFileName = Configuration.getOutputPath(cv, filename);
    }

    public static ConfigurationInfo getResourceBundleListInfo() {
        return new ConfigurationInfo(new String[]{"filename"}){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public List<String> getRuntimeSharedLibraries() {
        return this.rslList;
    }

    public void cfgRuntimeSharedLibraries(ConfigurationValue cfgval, String[] urls) throws ConfigurationException {
        for (int i = 0; i < urls.length; ++i) {
            this.rslList.add(urls[i]);
        }
    }

    public static ConfigurationInfo getRuntimeSharedLibrariesInfo() {
        return new ConfigurationInfo(-1, new String[]{"url"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    @Override
    public boolean useNetwork() {
        return this.useNetwork;
    }

    public void cfgUseNetwork(ConfigurationValue cv, boolean b2) {
        this.useNetwork = b2;
    }

    public List<RslPathInfo> getRslPathInfo() {
        return this.rslPathInfoList == null ? Collections.emptyList() : this.rslPathInfoList;
    }

    public VirtualFile[] getRslExcludedLibraries() {
        if (this.rslPathInfoList == null || this.getStaticLinkRsl()) {
            return new VirtualFile[0];
        }
        ArrayList<VirtualFile> libraries = new ArrayList<VirtualFile>();
        for (RslPathInfo info : this.rslPathInfoList) {
            libraries.add(info.getSwcVirtualFile());
        }
        return libraries.toArray(new VirtualFile[0]);
    }

    public void cfgRuntimeSharedLibraryPath(ConfigurationValue cfgval, String[] urls) throws ConfigurationException {
        if (urls.length == 0) {
            return;
        }
        if ("command line".equals(cfgval.getSource())) {
            this.setOverrideStaticLinkRsl(false);
        }
        if (this.getStaticLinkRsl()) {
            return;
        }
        if (urls.length < 2) {
            throw new ConfigurationException.MissingArgument("rsl-url", "runtime-shared-library-path", cfgval.getSource(), cfgval.getLine());
        }
        RslPathInfo info = new RslPathInfo();
        VirtualFile include = ConfigurationPathResolver.getVirtualFile(urls[0], this.configResolver, cfgval);
        info.setSwcPath(urls[0]);
        info.setSwcVf(include);
        for (int i = 1; i < urls.length; ++i) {
            if ((i + 1) % 2 == 0) {
                if (urls[i].length() == 0) {
                    throw new ConfigurationException.MissingArgument("rsl-url", "runtime-shared-library-path", cfgval.getSource(), cfgval.getLine());
                }
                info.addRslUrl(urls[i]);
                continue;
            }
            info.addPolicyFileUrl(urls[i]);
        }
        if (urls.length % 2 == 0) {
            info.addPolicyFileUrl("");
        }
        if (this.rslPathInfoList == null) {
            this.rslPathInfoList = new ArrayList<RslPathInfo>();
        }
        this.rslPathInfoList.add(info);
    }

    public static ConfigurationInfo getRuntimeSharedLibraryPathInfo() {
        return new ConfigurationInfo(){

            public boolean allowMultiple() {
                return true;
            }

            public String[] getSoftPrerequisites() {
                return new String[]{"static-link-runtime-shared-libraries"};
            }

            public String getArgName(int argnum) {
                String argName = null;
                argName = argnum == 0 ? "path-element" : ((argnum = (argnum + 1) % 2) == 0 ? "rsl-url" : "policy-file-url");
                return argName;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public boolean getStaticLinkRsl() {
        return this.staticLinkRsl;
    }

    protected void setOverrideStaticLinkRsl(boolean staticLinkRsl) {
        if ("command line".equals(this.staticLinkRslSource)) {
            return;
        }
        this.staticLinkRsl = staticLinkRsl;
    }

    public void cfgStaticLinkRuntimeSharedLibraries(ConfigurationValue cv, boolean b2) {
        this.staticLinkRsl = b2;
        this.staticLinkRslSource = cv.getSource();
    }

    public boolean getVerifyDigests() {
        return this.verifyDigests;
    }

    public void cfgVerifyDigests(ConfigurationValue cv, boolean b2) {
        this.verifyDigests = b2;
    }

    public static ConfigurationInfo getVerifyDigestsInfo() {
        return new AdvancedConfigurationInfo();
    }

    public boolean getRemoveUnusedRsls() {
        return this.removeUnusedRSLs;
    }

    public void cfgRemoveUnusedRsls(ConfigurationValue cv, boolean b2) {
        this.removeUnusedRSLs = b2;
    }

    public static ConfigurationInfo getRemoveUnusedRslsInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean getIncludeInheritanceDependenciesOnly() {
        return this.includeInheritanceDependenciesOnly;
    }

    public void cfgIncludeInheritanceDependenciesOnly(ConfigurationValue cv, boolean b2) {
        this.includeInheritanceDependenciesOnly = b2;
    }

    public static ConfigurationInfo getIncludeInheritanceDependenciesOnlyInfo() {
        return new AdvancedConfigurationInfo();
    }

    public int getTargetPlayerTargetAVM() {
        return Configuration.getTargetPlayerTargetAVM(this.getTargetPlayerMajorVersion());
    }

    public static int getTargetPlayerTargetAVM(int targetPlayerMajorVersion) {
        return ContextStatics.getTargetAVM(targetPlayerMajorVersion);
    }

    public ObjectList<String> getTargetPlayerRequiredUseNamespaces() {
        return Configuration.getTargetPlayerRequiredUseNamespaces(this.getTargetPlayerMajorVersion());
    }

    public static ObjectList<String> getTargetPlayerRequiredUseNamespaces(int targetPlayerMajorVersion) {
        return ContextStatics.getRequiredUseNamespaces(targetPlayerMajorVersion);
    }

    @Override
    public int getTargetPlayerMajorVersion() {
        return this.majorVersionTarget;
    }

    @Override
    public int getTargetPlayerMinorVersion() {
        return this.minorVersionTarget;
    }

    @Override
    public int getTargetPlayerRevision() {
        return this.revisionTarget;
    }

    public void cfgTargetPlayer(ConfigurationValue cv, String version) throws ConfigurationException {
        if (version == null) {
            return;
        }
        String[] results = version.split("\\.");
        if (results.length == 0) {
            throw new ConfigurationException.BadVersion(version, "target-player");
        }
        for (int i = 0; i < results.length; ++i) {
            int versionNum = 0;
            try {
                versionNum = Integer.parseInt(results[i]);
            }
            catch (NumberFormatException e2) {
                throw new ConfigurationException.BadVersion(version, "target-player");
            }
            if (i == 0) {
                if (versionNum >= 9) {
                    this.majorVersionTarget = versionNum;
                    continue;
                }
                throw new ConfigurationException.BadVersion(version, "target-player");
            }
            if (versionNum >= 0) {
                if (i == 1) {
                    this.minorVersionTarget = versionNum;
                    continue;
                }
                this.revisionTarget = versionNum;
                continue;
            }
            throw new ConfigurationException.BadVersion(version, "target-player");
        }
    }

    public static ConfigurationInfo getTargetPlayerInfo() {
        return new ConfigurationInfo(new String[]{"version"});
    }

    @Override
    public int getSwfVersion() {
        assert (this.swfVersion > 0);
        return this.swfVersion;
    }

    public void setSwfVersion(int version) {
        assert (version > 0);
        this.swfVersion = version;
    }

    public void cfgSwfVersion(ConfigurationValue cv, int version) {
        this.setSwfVersion(version);
    }

    @Override
    public boolean getComputeDigest() {
        throw new InternalError("compute-digest");
    }

    @Override
    public boolean getUseDirectBlit() {
        return this.useDirectBlit;
    }

    public void setUseDirectBlit(boolean value) {
        this.useDirectBlit = value;
    }

    public void cfgUseDirectBlit(ConfigurationValue cv, boolean value) {
        this.setUseDirectBlit(value);
    }

    @Override
    public boolean getUseGpu() {
        return this.useGpu;
    }

    public void setUseGpu(boolean value) {
        this.useGpu = value;
    }

    public void cfgUseGpu(ConfigurationValue cv, boolean value) {
        this.setUseGpu(value);
    }

    public boolean isSwcChecksumEnabled() {
        return this.swcChecksumEnabled;
    }

    public void cfgSwcChecksum(ConfigurationValue cv, boolean b2) {
        this.swcChecksumEnabled = b2;
    }

    public static ConfigurationInfo getSwcChecksumInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public void addCSSArchiveFiles(Map<String, VirtualFile> m) {
        if (this.cssArchiveFiles == null) {
            this.cssArchiveFiles = new HashMap<String, VirtualFile>();
        }
        this.cssArchiveFiles.putAll(m);
    }

    public Map<String, VirtualFile> getCSSArchiveFiles() {
        return this.cssArchiveFiles;
    }

    public void addL10nArchiveFiles(Map<String, VirtualFile> m) {
        if (this.l10nArchiveFiles == null) {
            this.l10nArchiveFiles = new HashMap<String, VirtualFile>();
        }
        this.l10nArchiveFiles.putAll(m);
    }

    public Map<String, VirtualFile> getL10NArchiveFiles() {
        return this.l10nArchiveFiles;
    }

    @Override
    public String getCompatibilityVersionString() {
        return this.compilerConfiguration.getCompatibilityVersionString();
    }

    @Override
    public int getCompatibilityVersion() {
        return this.compilerConfiguration.getCompatibilityVersion();
    }

    @Override
    public String getMinimumSupportedVersionString() {
        return this.compilerConfiguration.getMinimumSupportedVersionString();
    }

    @Override
    public int getMinimumSupportedVersion() {
        return this.compilerConfiguration.getMinimumSupportedVersion();
    }

    public boolean getQualifiedTypeSelectors() {
        return this.compilerConfiguration.getQualifiedTypeSelectors();
    }

    public void cfgToolsLocale(ConfigurationValue cv, String toolsLocale) throws ConfigurationException {
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].toString().equals(toolsLocale)) continue;
            LocalizationManager localizationManager = ThreadLocalToolkit.getLocalizationManager();
            if (localizationManager != null) {
                localizationManager.setLocale(locales[i]);
            } else assert (false) : "LocalizationManager not setup yet.";
            return;
        }
        throw new ConfigurationException.ToolsLocaleNotAvailable(cv.getVar(), cv.getSource(), cv.getLine());
    }

    public Configuration clone() throws CloneNotSupportedException {
        CompilerConfiguration cloneCompilerConfiguration;
        Configuration cloneConfig = (Configuration)super.clone();
        cloneConfig.compilerConfiguration = cloneCompilerConfiguration = (CompilerConfiguration)this.compilerConfiguration.clone();
        return cloneConfig;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RslPathInfo {
        public static final String SIGNED_RSL_URL_EXTENSION = "swz";
        public static final String SIGNED_RSL_URL_DOT_EXTENSION = ".swz";
        private String swcPath;
        private VirtualFile swcVf;
        private List<String> rslUrls = new ArrayList<String>();
        private List<String> policyFileUrls;
        private List<Boolean> isSignedList;

        public boolean isRslUrlSigned(String url) {
            if (url == null) {
                return false;
            }
            return url.endsWith(SIGNED_RSL_URL_DOT_EXTENSION);
        }

        public void setSwcPath(String swcPath) {
            this.swcPath = swcPath;
        }

        public String getSwcPath() {
            return this.swcPath;
        }

        public void setSwcVf(VirtualFile vf) {
            this.swcVf = vf;
        }

        public VirtualFile getSwcVirtualFile() {
            return this.swcVf;
        }

        public void addRslUrl(String url) {
            if (url == null) {
                throw new NullPointerException("url may not be null");
            }
            this.rslUrls.add(url);
            this.addSignedFlag(this.isRslUrlSigned(url));
        }

        public List<String> getRslUrls() {
            return this.rslUrls;
        }

        public void addPolicyFileUrl(String url) {
            if (this.policyFileUrls == null) {
                this.policyFileUrls = new ArrayList<String>();
            }
            this.policyFileUrls.add(url == null ? "" : url);
        }

        public List<String> getPolicyFileUrls() {
            return this.policyFileUrls == null ? Collections.emptyList() : this.policyFileUrls;
        }

        public List<Boolean> getSignedFlags() {
            return this.isSignedList;
        }

        private void addSignedFlag(boolean isSigned) {
            if (this.isSignedList == null) {
                this.isSignedList = new ArrayList<Boolean>();
            }
            this.isSignedList.add(isSigned);
        }
    }
}

