/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.util.Trace;
import flex2.compiler.Logger;
import flex2.compiler.util.PerformanceData;

public class CompilerBenchmarkHelper {
    public static final int PREPROCESS = 0;
    public static final int PARSE1 = 1;
    public static final int PARSE2 = 2;
    public static final int ANALYZE1 = 3;
    public static final int ANALYZE2 = 4;
    public static final int ANALYZE3 = 5;
    public static final int ANALYZE4 = 6;
    public static final int GENERATE = 7;
    public static final int POSTPROCESS = 8;
    private PerformanceData[] compileTimes;
    private long startTime;
    private String compilerName;

    public CompilerBenchmarkHelper(String compilerName) {
        this.compilerName = compilerName;
    }

    public void initBenchmarks() {
        if (this.compileTimes == null) {
            this.compileTimes = new PerformanceData[9];
        }
        for (int j = 0; j <= 8; ++j) {
            if (this.compileTimes[j] == null) {
                this.compileTimes[j] = new PerformanceData();
                continue;
            }
            this.compileTimes[j].invocationCount = 0L;
            this.compileTimes[j].totalTime = 0L;
        }
    }

    public PerformanceData[] getBenchmarks() {
        return this.compileTimes;
    }

    public void startPhase(int phase, String source) {
        String name;
        boolean isabc;
        if (Trace.phase && (!(isabc = (name = this.compilerName == null ? "unknown" : this.compilerName).equals("abc")) || Trace.phaseabc)) {
            Trace.trace("Start compiler " + name + " phase[" + CompilerBenchmarkHelper.getPhaseName(phase) + "] with: " + source);
        }
        this.startTime = System.currentTimeMillis();
    }

    public void endPhase(int phase) {
        if (this.compileTimes != null && phase >= 0 && phase <= 8) {
            ++this.compileTimes[phase].invocationCount;
            this.compileTimes[phase].totalTime += System.currentTimeMillis() - this.startTime;
        }
    }

    public void logBenchmarks(Logger logger) {
        logger.logInfo("Compiler: " + this.compilerName);
        long totalTime = 0L;
        for (int i = 0; i < this.compileTimes.length; ++i) {
            logger.logInfo(CompilerBenchmarkHelper.getPhaseName(i) + ": " + this.compileTimes[i].totalTime);
            totalTime += this.compileTimes[i].totalTime;
        }
        logger.logInfo("Total: " + totalTime);
    }

    public PerformanceData[] subtract(CompilerBenchmarkHelper other) {
        PerformanceData[] ret = new PerformanceData[9];
        try {
            for (int i = 0; i <= 8; ++i) {
                ret[i] = new PerformanceData();
                ret[i].invocationCount = this.compileTimes[i].invocationCount;
                ret[i].totalTime = this.compileTimes[i].totalTime - other.compileTimes[i].totalTime;
            }
        }
        catch (Exception e2) {
            System.err.println("error " + e2.getMessage());
        }
        return ret;
    }

    private static String getPhaseName(int phase) {
        String result = null;
        switch (phase) {
            case 0: {
                result = "preprocess";
                break;
            }
            case 1: {
                result = "parse1";
                break;
            }
            case 2: {
                result = "parse2";
                break;
            }
            case 3: {
                result = "analyze1";
                break;
            }
            case 4: {
                result = "analyze2";
                break;
            }
            case 5: {
                result = "analyze3";
                break;
            }
            case 6: {
                result = "analyze4";
                break;
            }
            case 7: {
                result = "generate";
                break;
            }
            case 8: {
                result = "postprocess";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

