/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.log;

import flex.messaging.config.ConfigMap;
import flex.messaging.log.AbstractTarget;
import flex.messaging.log.LogEvent;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LineFormattedTarget
extends AbstractTarget {
    protected boolean includeDate;
    protected boolean includeTime;
    protected boolean includeLevel;
    protected boolean includeCategory;
    protected String prefix = null;
    protected DateFormat dateFormater = new SimpleDateFormat("MM/dd/yyyy");
    protected DateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");

    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        this.includeTime = properties.getPropertyAsBoolean("includeTime", false);
        this.includeDate = properties.getPropertyAsBoolean("includeDate", false);
        this.includeCategory = properties.getPropertyAsBoolean("includeCategory", false);
        this.includeLevel = properties.getPropertyAsBoolean("includeLevel", false);
        this.prefix = properties.getPropertyAsString("prefix", null);
    }

    public boolean isIncludeCategory() {
        return this.includeCategory;
    }

    public void setIncludeCategory(boolean includeCategory) {
        this.includeCategory = includeCategory;
    }

    public boolean isIncludeDate() {
        return this.includeDate;
    }

    public void setIncludeDate(boolean includeDate) {
        this.includeDate = includeDate;
    }

    public boolean isIncludeLevel() {
        return this.includeLevel;
    }

    public void setIncludeLevel(boolean includeLevel) {
        this.includeLevel = includeLevel;
    }

    public boolean isIncludeTime() {
        return this.includeTime;
    }

    public void setIncludeTime(boolean includeTime) {
        this.includeTime = includeTime;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void logEvent(LogEvent event) {
        String pre = "";
        if (this.prefix != null) {
            pre = this.prefix + " ";
        }
        String date = "";
        if (this.includeDate || this.includeTime) {
            StringBuffer buffer = new StringBuffer();
            Date d2 = new Date();
            if (this.includeDate) {
                buffer.append(this.dateFormater.format(d2));
                buffer.append(" ");
            }
            if (this.includeTime) {
                buffer.append(this.timeFormatter.format(d2));
                buffer.append(" ");
            }
            date = buffer.toString();
        }
        String cat = this.includeCategory ? "[" + event.logger.getCategory() + "] " : "";
        String level = "";
        if (this.includeLevel) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            buffer.append(LogEvent.getLevelString(event.level));
            buffer.append("]");
            buffer.append(" ");
            level = buffer.toString();
        }
        StringBuffer result = new StringBuffer(pre);
        result.append(date).append(level).append(cat).append(event.message);
        if (event.throwable != null) {
            result.append(StringUtils.NEWLINE).append(ExceptionUtil.toString(event.throwable));
        }
        this.internalLog(result.toString());
    }

    protected void internalLog(String message) {
    }
}

