/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.util.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TokenReplacer {
    private static final String TOKEN_FILE = "token.file";
    private static final Pattern pattern = Pattern.compile("\\{(.*?)\\}");
    private final Map replacedTokens = new LinkedHashMap();
    private Properties tokenProperties;
    private String tokenPropertiesFilename;

    public TokenReplacer() {
        this.loadTokenProperties();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceToken(Node node, String sourceFileName) {
        Node replacementNode;
        if ("ip-address-pattern".equals(node.getNodeName())) {
            return;
        }
        if (node.getNodeValue() == null) {
            if (node.getChildNodes().getLength() != 1 || !(node.getFirstChild() instanceof Text)) return;
            replacementNode = node.getFirstChild();
        } else {
            replacementNode = node;
        }
        String nodeValue = replacementNode.getNodeValue();
        Matcher matcher = pattern.matcher(nodeValue);
        while (matcher.find()) {
            String tokenWithCurlyBraces = matcher.group();
            String tokenWithoutCurlyBraces = matcher.group(1);
            String propertyValue = this.getPropertyValue(tokenWithoutCurlyBraces);
            if (propertyValue != null) {
                nodeValue = StringUtils.substitute(nodeValue, tokenWithCurlyBraces, propertyValue);
                this.replacedTokens.put(tokenWithCurlyBraces, propertyValue);
                continue;
            }
            if ("{context.root}".equals(tokenWithCurlyBraces) || "{context-root}".equals(tokenWithCurlyBraces) || "{server.name}".equals(tokenWithCurlyBraces) || "{server.port}".equals(tokenWithCurlyBraces)) continue;
            ConfigurationException ex = new ConfigurationException();
            Object[] args = new Object[]{tokenWithCurlyBraces, sourceFileName};
            ex.setMessage(11125, args);
            throw ex;
        }
        replacementNode.setNodeValue(nodeValue);
    }

    private String getPropertyValue(String tokenWithoutCurlyBraces) {
        String propertyValue = System.getProperty(tokenWithoutCurlyBraces);
        if (propertyValue != null) {
            return propertyValue;
        }
        if (this.tokenProperties != null) {
            propertyValue = this.tokenProperties.getProperty(tokenWithoutCurlyBraces);
        }
        return propertyValue;
    }

    public void reportTokens() {
        if (Log.isWarn()) {
            if (this.tokenProperties != null && Log.isDebug()) {
                Log.getLogger("Configuration").debug("Token replacer is using the token file '" + this.tokenPropertiesFilename + "'");
            }
            Iterator iter = this.replacedTokens.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String tokenWithParanthesis = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if ("{context.root}".equals(tokenWithParanthesis) || "{context-root}".equals(tokenWithParanthesis)) {
                    Log.getLogger("Configuration").warn("Token '{0}' was replaced with '{1}'. Note that this will apply to all applications on the JVM", new Object[]{tokenWithParanthesis, propertyValue});
                    continue;
                }
                if (!Log.isDebug()) continue;
                Log.getLogger("Configuration").debug("Token '{0}' was replaced with '{1}'", new Object[]{tokenWithParanthesis, propertyValue});
            }
        }
    }

    public static boolean containsTokens(String value) {
        return value != null && value.length() > 0 ? pattern.matcher(value).find() : false;
    }

    private void loadTokenProperties() {
        this.tokenPropertiesFilename = System.getProperty(TOKEN_FILE);
        if (this.tokenPropertiesFilename == null) {
            return;
        }
        this.tokenProperties = new Properties();
        try {
            this.tokenProperties.load(new FileInputStream(this.tokenPropertiesFilename));
        }
        catch (FileNotFoundException e2) {
            this.tokenProperties = null;
        }
        catch (IOException e3) {
            this.tokenProperties = null;
        }
    }
}

