/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.AdapterSettings;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.PropertiesSettings;
import flex.messaging.config.SecurityConstraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceSettings
extends PropertiesSettings {
    private final String id;
    private String sourceFile;
    private String className;
    private AdapterSettings defaultAdapterSettings;
    private final Map adapterSettings;
    private final List defaultChannels;
    private final Map destinationSettings;
    private SecurityConstraint securityConstraint;

    public ServiceSettings(String id) {
        this.id = id;
        this.destinationSettings = new HashMap();
        this.adapterSettings = new HashMap(2);
        this.defaultChannels = new ArrayList(4);
    }

    public String getId() {
        return this.id;
    }

    String getSourceFile() {
        return this.sourceFile;
    }

    void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public AdapterSettings getDefaultAdapter() {
        return this.defaultAdapterSettings;
    }

    public AdapterSettings getAdapterSettings(String id) {
        return (AdapterSettings)this.adapterSettings.get(id);
    }

    public Map getAllAdapterSettings() {
        return this.adapterSettings;
    }

    public void addAdapterSettings(AdapterSettings a2) {
        this.adapterSettings.put(a2.getId(), a2);
        if (a2.isDefault()) {
            this.defaultAdapterSettings = a2;
        }
    }

    public void addDefaultChannel(ChannelSettings c2) {
        this.defaultChannels.add(c2);
    }

    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    public SecurityConstraint getConstraint() {
        return this.securityConstraint;
    }

    public void setConstraint(SecurityConstraint sc) {
        this.securityConstraint = sc;
    }

    public Map getDestinationSettings() {
        return this.destinationSettings;
    }

    public void addDestinationSettings(DestinationSettings dest) {
        this.destinationSettings.put(dest.getId(), dest);
    }
}

