/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class LocalFileResolver
implements ConfigurationFileResolver {
    public static final int CLIENT = 0;
    public static final int SERVER = 1;
    public static final int LIVECYCLE = 2;
    private static final int ERR_MSG_INVALID_PATH_CLIENT = 11106;
    private static final int ERR_MSG_INVALID_PATH_SERVER = 11108;
    private static final int ERR_MSG_INVALID_PATH_LIVECYCLE = 11122;
    private Stack configurationPathStack = new Stack();
    int version = 0;

    public LocalFileResolver() {
    }

    public LocalFileResolver(int version) {
        this.version = version;
    }

    public void setErrorMessage(ConfigurationException e2, String path) {
        if (this.version == 2) {
            e2.setMessage(11122, new Object[]{path});
        } else if (this.version == 1) {
            e2.setMessage(11108, new Object[]{path});
        } else {
            e2.setMessage(11106);
        }
    }

    public InputStream getConfigurationFile(String path) {
        File f2 = new File(path);
        try {
            if (f2 != null && f2.exists() && f2.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f2);
                this.pushConfigurationFile(f2.getParent());
                return fin;
            }
            ConfigurationException e2 = new ConfigurationException();
            this.setErrorMessage(e2, path);
            throw e2;
        }
        catch (FileNotFoundException ex) {
            ConfigurationException e3 = new ConfigurationException();
            this.setErrorMessage(e3, path);
            e3.setRootCause(ex);
            throw e3;
        }
        catch (SecurityException se) {
            ConfigurationException e4 = new ConfigurationException();
            this.setErrorMessage(e4, path);
            e4.setRootCause(se);
            throw e4;
        }
    }

    public InputStream getIncludedFile(String src) {
        String path = this.configurationPathStack.peek() + File.separator + src;
        File f2 = new File(path);
        try {
            if (f2 != null && f2.exists() && f2.isAbsolute()) {
                FileInputStream fin = new FileInputStream(f2);
                this.pushConfigurationFile(f2.getParent());
                return fin;
            }
            ConfigurationException e2 = new ConfigurationException();
            e2.setMessage(11107, new Object[]{path});
            throw e2;
        }
        catch (FileNotFoundException ex) {
            ConfigurationException e3 = new ConfigurationException();
            e3.setMessage(11107, new Object[]{path});
            e3.setRootCause(ex);
            throw e3;
        }
        catch (SecurityException se) {
            ConfigurationException e4 = new ConfigurationException();
            e4.setMessage(11107, new Object[]{path});
            e4.setRootCause(se);
            throw e4;
        }
    }

    public void popIncludedFile() {
        this.configurationPathStack.pop();
    }

    public List getFiles(String dir) {
        ArrayList<String> result = new ArrayList<String>();
        File f2 = new File(this.configurationPathStack.peek().toString(), dir);
        if (f2.exists() && f2.isDirectory()) {
            String[] xmlFiles = f2.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            for (int i = 0; i < xmlFiles.length; ++i) {
                String file = xmlFiles[i];
                result.add(dir + File.separator + file);
            }
            return result;
        }
        ConfigurationException e2 = new ConfigurationException();
        e2.setMessage(11113, new Object[]{dir});
        throw e2;
    }

    private void pushConfigurationFile(String topLevelPath) {
        this.configurationPathStack.push(topLevelPath);
    }

    public String getIncludedPath(String src) {
        return this.configurationPathStack.peek() + File.separator + src;
    }

    public long getIncludedLastModified(String src) {
        String path = this.configurationPathStack.peek() + File.separator + src;
        File f2 = new File(path);
        return f2.lastModified();
    }
}

