/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import java.io.IOException;
import java.io.OutputStream;

public class SwfImageUtils {
    public static void jpegDebugSegments(byte[] data) {
        JPEGIterator it = new JPEGIterator(data);
        while (it.valid()) {
            System.out.print("offset " + it.offset() + ": ");
            System.out.print(Integer.toHexString(it.code() & 0xFF) + " (");
            switch (it.code()) {
                case -64: {
                    System.out.print("SOF0");
                    break;
                }
                case -63: {
                    System.out.print("SOF1");
                    break;
                }
                case -62: {
                    System.out.print("SOF2");
                    break;
                }
                case -61: {
                    System.out.print("SOF3");
                    break;
                }
                case -60: {
                    System.out.print("DHT");
                    break;
                }
                case -59: {
                    System.out.print("SOF5");
                    break;
                }
                case -58: {
                    System.out.print("SOF6");
                    break;
                }
                case -57: {
                    System.out.print("SOF7");
                    break;
                }
                case -56: {
                    System.out.print("JPGext");
                    break;
                }
                case -55: {
                    System.out.print("SOF9");
                    break;
                }
                case -54: {
                    System.out.print("SOF10");
                    break;
                }
                case -53: {
                    System.out.print("SOF11");
                    break;
                }
                case -52: {
                    System.out.print("DAC");
                    break;
                }
                case -51: {
                    System.out.print("SOF13");
                    break;
                }
                case -50: {
                    System.out.print("SOF14");
                    break;
                }
                case -49: {
                    System.out.print("SOF15");
                    break;
                }
                case -48: {
                    System.out.print("RST0");
                    break;
                }
                case -47: {
                    System.out.print("RST1");
                    break;
                }
                case -46: {
                    System.out.print("RST2");
                    break;
                }
                case -45: {
                    System.out.print("RST3");
                    break;
                }
                case -44: {
                    System.out.print("RST4");
                    break;
                }
                case -43: {
                    System.out.print("RST5");
                    break;
                }
                case -42: {
                    System.out.print("RST6");
                    break;
                }
                case -41: {
                    System.out.print("RST7");
                    break;
                }
                case -40: {
                    System.out.print("SOI");
                    break;
                }
                case -39: {
                    System.out.print("EOI");
                    break;
                }
                case -38: {
                    System.out.print("SOS");
                    break;
                }
                case -37: {
                    System.out.print("DQT");
                    break;
                }
                case -36: {
                    System.out.print("DNL");
                    break;
                }
                case -35: {
                    System.out.print("DRI");
                    break;
                }
                case -34: {
                    System.out.print("DHP");
                    break;
                }
                case -33: {
                    System.out.print("EXP");
                    break;
                }
                case -32: {
                    System.out.print("APP0");
                    break;
                }
                case -31: {
                    System.out.print("APP1");
                    break;
                }
                case -30: {
                    System.out.print("APP2");
                    break;
                }
                case -29: {
                    System.out.print("APP3");
                    break;
                }
                case -28: {
                    System.out.print("APP4");
                    break;
                }
                case -27: {
                    System.out.print("APP5");
                    break;
                }
                case -26: {
                    System.out.print("APP6");
                    break;
                }
                case -25: {
                    System.out.print("APP7");
                    break;
                }
                case -24: {
                    System.out.print("APP8");
                    break;
                }
                case -23: {
                    System.out.print("APP9");
                    break;
                }
                case -22: {
                    System.out.print("APP10");
                    break;
                }
                case -21: {
                    System.out.print("APP11");
                    break;
                }
                case -20: {
                    System.out.print("APP12");
                    break;
                }
                case -19: {
                    System.out.print("APP13");
                    break;
                }
                case -18: {
                    System.out.print("APP14");
                    break;
                }
                case -17: {
                    System.out.print("APP15");
                    break;
                }
                case -16: {
                    System.out.print("JPG0");
                    break;
                }
                case -15: {
                    System.out.print("JPG1");
                    break;
                }
                case -14: {
                    System.out.print("JPG2");
                    break;
                }
                case -13: {
                    System.out.print("JPG3");
                    break;
                }
                case -12: {
                    System.out.print("JPG4");
                    break;
                }
                case -11: {
                    System.out.print("JPG5");
                    break;
                }
                case -10: {
                    System.out.print("JPG6");
                    break;
                }
                case -9: {
                    System.out.print("JPG7");
                    break;
                }
                case -8: {
                    System.out.print("JPG8");
                    break;
                }
                case -7: {
                    System.out.print("JPG9");
                    break;
                }
                case -6: {
                    System.out.print("JPG10");
                    break;
                }
                case -5: {
                    System.out.print("JPG11");
                    break;
                }
                case -4: {
                    System.out.print("JPG12");
                    break;
                }
                case -3: {
                    System.out.print("JPG13");
                    break;
                }
                case -2: {
                    System.out.print("COM");
                    break;
                }
                case 0: {
                    System.out.print("00?");
                    break;
                }
                case 1: {
                    System.out.print("TEM");
                    break;
                }
                default: {
                    System.out.print("???");
                }
            }
            System.out.print(") ");
            if (it.code() == 0 || it.code() == 1 || it.code() >= -48 && it.code() <= -39) {
                System.out.print("len=0");
            } else {
                System.out.print("len=" + it.length());
            }
            System.out.print(" size=" + it.size());
            int i = it.offset();
            if (it.code() == -2) {
                byte[] comment = new byte[it.length() + 1];
                for (int c2 = 0; c2 < it.length(); ++c2) {
                    comment[c2] = data[i + 2 + c2];
                }
                System.out.print(" COMMENT='" + comment + "'");
            }
            if (it.code() == -32 && data[i + 4] == 74 && data[i + 5] == 70 && data[i + 6] == 73 && data[i + 7] == 70 && data[i + 8] == 0) {
                System.out.print(" JFIF");
            }
            if (it.code() == -64 || it.code() == -63 || it.code() == -62 || it.code() == -61 || it.code() == -59 || it.code() == -58 || it.code() == -57 || it.code() == -56 || it.code() == -55 || it.code() == -54 || it.code() == -53 || it.code() == -51 || it.code() == -50 || it.code() == -49) {
                System.out.print(" precision = " + data[i + 4]);
                int y = (data[i + 5] & 0xFF) << 8 | data[i + 6] & 0xFF;
                int x = (data[i + 7] & 0xFF) << 8 | data[i + 8] & 0xFF;
                System.out.print(" dimensions = " + x + "," + y);
            }
            System.out.println(".");
            it.next();
        }
    }

    public static class JPEG {
        public byte[] table;
        public byte[] data;
        private int width;
        private int height;

        public JPEG(byte[] table, byte[] data) {
            this.table = table;
            this.data = data;
            this.validate();
        }

        public JPEG(byte[] jpeg, boolean doSplit) {
            if (doSplit) {
                this.split(jpeg);
            } else {
                this.data = jpeg;
            }
            this.validate();
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static boolean markerIsSOF(byte code) {
            return code >= -64 && code <= -49 && code != -60 && code != -52;
        }

        public boolean validate() {
            JPEGIterator it;
            if (this.table != null) {
                it = new JPEGIterator(this.table);
                if (!it.valid()) {
                    return false;
                }
                it.next();
                while (it.valid() && it.code() != -39) {
                    if (it.code() != -60 && it.code() != -37) {
                        return false;
                    }
                    it.next();
                }
                if (it.offset() != this.table.length - 2) {
                    return false;
                }
            }
            if (this.data == null) {
                return false;
            }
            it = new JPEGIterator(this.data);
            if (!it.valid()) {
                return false;
            }
            boolean foundSOS = false;
            boolean foundSOF = false;
            while (it.valid()) {
                if (it.code() == -38) {
                    foundSOS = true;
                }
                if (!foundSOF && JPEG.markerIsSOF(it.code())) {
                    foundSOF = true;
                    this.height = (this.data[it.offset() + 5] & 0xFF) << 8 | this.data[it.offset() + 6] & 0xFF;
                    this.width = (this.data[it.offset() + 7] & 0xFF) << 8 | this.data[it.offset() + 8] & 0xFF;
                    if (this.width == 0 || this.height == 0) {
                        return false;
                    }
                }
                it.next();
            }
            return foundSOS && foundSOF && it.offset() == this.data.length;
        }

        private void split(byte[] jpeg) throws IllegalStateException {
            JPEGIterator it = new JPEGIterator(jpeg);
            int tablesize = 4;
            while (it.valid()) {
                if (it.code() == -37 || it.code() == -60) {
                    tablesize += it.length() + 2;
                }
                it.next();
            }
            this.table = new byte[tablesize];
            int tableoffset = 0;
            this.table[tableoffset++] = -1;
            this.table[tableoffset++] = -40;
            int datasize = 4 + (jpeg.length - tablesize);
            int dataoffset = 0;
            this.data = new byte[datasize];
            it.reset();
            while (it.valid()) {
                if (it.code() == -37 || it.code() == -60) {
                    System.arraycopy(jpeg, it.offset(), this.table, tableoffset, it.size());
                    tableoffset += it.size();
                } else {
                    System.arraycopy(jpeg, it.offset(), this.data, dataoffset, it.size());
                    dataoffset += it.size();
                }
                it.next();
            }
            this.table[tableoffset++] = -1;
            this.table[tableoffset++] = -39;
            if (tableoffset < this.table.length || dataoffset < this.data.length) {
                throw new IllegalStateException("JPEG data is corrupt!");
            }
        }

        public void write(OutputStream out) throws IOException {
            if (this.table == null) {
                out.write(this.data);
                return;
            }
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] != -1) {
                    ++i;
                    continue;
                }
                if (i + 1 >= this.data.length) {
                    return;
                }
                byte marker = this.data[i + 1];
                if (marker == -1) {
                    ++i;
                    continue;
                }
                if (marker == 0 || marker == 1 || marker >= -48 && marker <= -39) {
                    i += 2;
                    continue;
                }
                if (marker == -38) {
                    out.write(this.data, 0, i);
                    out.write(this.table, 2, this.table.length - 4);
                    out.write(this.data, i, this.data.length - i);
                    return;
                }
                if (i + 3 >= this.data.length) {
                    return;
                }
                int length = ((this.data[i + 2] & 0xFF) << 8) + (this.data[i + 3] & 0xFF);
                i += length;
            }
        }
    }

    private static class JPEGIterator {
        private byte[] jpeg = null;
        private int offset = 0;
        private int length = 0;
        private int nextOffset = -1;
        private boolean valid = false;
        private byte code;

        public JPEGIterator(byte[] jpeg) {
            this.jpeg = jpeg;
            this.reset();
        }

        public boolean valid() {
            return this.valid;
        }

        public byte code() {
            return this.code;
        }

        public int length() {
            return this.length;
        }

        public int size() {
            if (!this.valid) {
                return -1;
            }
            if (this.nextOffset == -1) {
                return this.jpeg.length - this.offset;
            }
            return this.nextOffset - this.offset;
        }

        public int offset() {
            return this.offset;
        }

        public boolean reset() {
            this.valid = this.jpeg.length >= 4 && this.jpeg[0] == -1 && this.jpeg[1] == -40 && this.jpeg[this.jpeg.length - 2] == -1 && this.jpeg[this.jpeg.length - 1] == -39;
            this.offset = 0;
            this.nextOffset = this.offsetOfNextBlock();
            this.code = this.jpeg[1];
            this.length = 0;
            return this.valid;
        }

        public int offsetOfNextBlock() {
            int i = this.offset + 2 + this.length;
            while (i < this.jpeg.length) {
                if (this.code == -38 && this.jpeg[i] != -1) {
                    ++i;
                    continue;
                }
                if (i + 1 >= this.jpeg.length) {
                    return -1;
                }
                if (this.jpeg[i + 1] == -1) {
                    ++i;
                    continue;
                }
                if (this.code != -38 || this.jpeg[i + 1] != 0) break;
                i += 2;
            }
            return i;
        }

        public boolean next() {
            if (!this.valid) {
                return false;
            }
            this.offset = this.nextOffset;
            if (this.offset >= this.jpeg.length || this.offset == -1) {
                this.valid = false;
                this.offset = this.jpeg.length;
                return false;
            }
            this.code = this.jpeg[this.offset + 1];
            if (this.code == 0 || this.code == 1 || this.code >= -48 && this.code <= -39) {
                this.length = 0;
            } else if (this.offset + 3 >= this.jpeg.length) {
                this.valid = false;
            } else {
                this.length = ((this.jpeg[this.offset + 2] & 0xFF) << 8) + (this.jpeg[this.offset + 3] & 0xFF);
            }
            this.nextOffset = this.offsetOfNextBlock();
            return this.valid;
        }
    }
}

