/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class StringJoiner {
    public static String join(Object[] array, String separator, ItemStringer itemStringer) {
        StringBuilder sb = new StringBuilder();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            Object itemObj = array[i];
            String itemStr = itemStringer != null ? itemStringer.itemToString(itemObj) : itemObj.toString();
            sb.append(itemStr);
            if (separator == null || i >= n - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String join(Object[] array, String separator) {
        return StringJoiner.join(array, separator, null);
    }

    public static String join(Collection collection, String separator, ItemStringer itemStringer) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object itemObj = iter.next();
            String itemStr = itemStringer != null ? itemStringer.itemToString(itemObj) : itemObj.toString();
            sb.append(itemStr);
            if (separator == null || !iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String join(Collection collection, String separator) {
        return StringJoiner.join(collection, separator, null);
    }

    public static class MapEntryItemWithEquals
    implements ItemStringer {
        public String itemToString(Object obj) {
            Map.Entry e2 = (Map.Entry)obj;
            String key = e2.getKey().toString();
            String value = e2.getValue().toString();
            return key + "=\"" + value + "\"";
        }
    }

    public static class MapEntryItemWithColon
    implements ItemStringer {
        public String itemToString(Object obj) {
            Map.Entry e2 = (Map.Entry)obj;
            String key = e2.getKey().toString();
            String value = e2.getValue().toString();
            return key + ": " + value;
        }
    }

    public static class ItemQuoter
    implements ItemStringer {
        public String itemToString(Object obj) {
            return "\"" + obj.toString() + "\"";
        }
    }

    public static interface ItemStringer {
        public String itemToString(Object var1);
    }
}

