/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.tools;

import flash.swf.Action;
import flash.swf.ActionHandler;
import flash.swf.actions.Branch;
import flash.swf.actions.ConstantPool;
import flash.swf.actions.DefineFunction;
import flash.swf.actions.GetURL;
import flash.swf.actions.GetURL2;
import flash.swf.actions.GotoFrame;
import flash.swf.actions.GotoFrame2;
import flash.swf.actions.GotoLabel;
import flash.swf.actions.Label;
import flash.swf.actions.Push;
import flash.swf.actions.SetTarget;
import flash.swf.actions.StoreRegister;
import flash.swf.actions.StrictMode;
import flash.swf.actions.Try;
import flash.swf.actions.Unknown;
import flash.swf.actions.WaitForFrame;
import flash.swf.actions.With;
import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.ActionList;
import flash.util.FieldFormat;
import java.io.PrintWriter;
import java.util.HashMap;

public class Disassembler
extends ActionHandler {
    protected ConstantPool cpool;
    protected int start;
    protected int offset;
    protected final PrintWriter out;
    private boolean showOffset = false;
    private boolean showDebugSource = false;
    private boolean showLineRecord = true;
    private RegisterRecord registerRecord = null;
    private int indent;
    private int initialIndent;
    private String comment;
    private String format;
    private LabelMap labels = new LabelMap();
    int labelCount = 0;
    public static final String[] actionNames = new String[]{"0x00", "0x01", "0x02", "0x03", "next", "prev", "play", "stop", "toggle", "stopsound", "add", "sub", "mul", "div", "eq", "lt", "and", "or", "not", "seq", "slen", "substr", "0x16", "pop", "toint", "0x19", "0x1A", "0x1B", "get", "set", "0x1E", "0x1F", "settarget2", "sadd", "getprop", "setprop", "csprite", "rsprite", "trace", "sdrag", "edrag", "slt", "0x2A", "0x2B", "0x2C", "0x2D", "0x2E", "0x2F", "rand", "wslen", "c2a", "a2c", "time", "wsubstr", "wc2a", "wa2c", "0x38", "0x39", "del", "del2", "var", "callfun", "return", "mod", "newobj", "var2", "initarr", "initobj", "typeof", "target", "enum", "add2", "lt2", "eq2", "tonum", "tostr", "dup", "swap", "getmem", "setmem", "inc", "dec", "callmethod", "newmethod", "instanceof", "enum2", "0x56", "0x57", "0x58", "0x59", "0x5A", "0x5B", "0x5C", "0x5D", "0x5E", "halt", "band", "bor", "bxor", "bls", "brs", "burs", "eqs", "gt", "sgt", "extends", "0x6A", "0x6B", "0x6C", "0x6D", "0x6E", "0x6F", "0x70", "0x71", "0x72", "0x73", "0x74", "0x75", "0x76", "nop", "0x78", "0x79", "0x7A", "0x7B", "0x7C", "0x7D", "0x7E", "0x7F", "0x80", "gotoframe", "0x82", "geturl", "0x84", "0x85", "0x86", "store", "cpool", "strict", "wait", "settarget", "gotolabel", "wait2", "function2", "try", "0x90", "0x91", "0x92", "0x93", "with", "0x95", "push", "0x97", "0x98", "jump", "geturl2", "function", "0x9C", "if", "call", "gotof2", "0xA0", "0xA1", "0xA2", "0xA3", "0xA4", "0xA5", "0xA6", "0xA7", "0xA8", "0xA9", "quicktime", "0xAB", "0xAC", "0xAD", "0xAE", "0xAF", "0xB0", "0xB1", "0xB2", "0xB3", "0xB4", "0xB5", "0xB6", "0xB7", "0xB8", "0xB9", "0xBA", "0xBB", "0xBC", "0xBD", "0xBE", "0xBF", "0xC0", "0xC1", "0xC2", "0xC3", "0xC4", "0xC5", "0xC6", "0xC7", "0xC8", "0xC9", "0xCA", "0xCB", "0xCC", "0xCD", "0xCE", "0xCF", "0xD0", "0xD1", "0xD2", "0xD3", "0xD4", "0xD5", "0xD6", "0xD7", "0xD8", "0xD9", "0xDA", "0xDB", "0xDC", "0xDD", "0xDE", "0xDF", "0xE0", "0xE1", "0xE2", "0xE3", "0xE4", "0xE5", "0xE6", "0xE7", "0xE8", "0xE9", "0xEA", "0xEB", "0xEC", "0xED", "0xEE", "0xEF", "0xF0", "0xF1", "0xF2", "0xF3", "0xF4", "0xF5", "0xF6", "0xF7", "0xF8", "0xF9", "0xFA", "0xFB", "0xFC", "0xFD", "0xFE", "0xFF", "label", "line"};

    public Disassembler(PrintWriter out, ConstantPool cpool, String comment) {
        this(out, false, 0);
        this.cpool = cpool;
        this.comment = comment;
    }

    public Disassembler(PrintWriter out, boolean showOffset, int indent) {
        this.out = out;
        this.showOffset = showOffset;
        this.indent = indent;
        this.initialIndent = indent;
        this.comment = "";
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setShowDebugSource(boolean b2) {
        this.showDebugSource = b2;
    }

    public void setShowLineRecord(boolean b2) {
        this.showLineRecord = b2;
    }

    public static void disassemble(ActionList list, ConstantPool pool, int startIndex, int endIndex, PrintWriter out) {
        Disassembler d2 = new Disassembler(out, pool, "    ");
        d2.setFormat("    0x%08O  %a");
        d2.setShowLineRecord(false);
        int at = list.lastIndexOf(258, startIndex);
        if (at > -1) {
            d2.registerRecord = (RegisterRecord)list.getAction(at);
        }
        list.visit(d2, startIndex, endIndex);
        out.flush();
    }

    protected void print(Action action) {
        this.start(action);
        this.out.println();
    }

    public void setActionOffset(int offset, Action a2) {
        if (this.offset == 0) {
            this.start = offset;
        }
        this.offset = offset;
    }

    protected void indent() {
        int i;
        for (i = 0; i < this.initialIndent; ++i) {
            this.out.print("  ");
        }
        this.out.print(this.comment);
        for (i = this.initialIndent; i < this.indent; ++i) {
            this.out.print("  ");
        }
    }

    public void registerRecord(RegisterRecord record) {
        this.registerRecord = record;
    }

    protected String variableNameForRegister(int regNbr) {
        int at;
        int n = at = this.registerRecord == null ? -1 : this.registerRecord.indexOf(regNbr);
        if (at > -1) {
            return this.registerRecord.variableNames[at];
        }
        return null;
    }

    public void lineRecord(LineRecord line) {
        if (this.showLineRecord) {
            if (this.showDebugSource) {
                this.printLines(line, this.out);
            } else {
                this.start(line);
                this.out.println(" " + line.module.name + ":" + line.lineno);
            }
        }
    }

    public void printLines(LineRecord lr, PrintWriter out) {
        int lineno;
        DebugModule script = lr.module;
        if (script != null && (lineno = lr.lineno) > 0) {
            while (lineno - 1 > 0 && script.offsets[lineno - 1] == 0) {
                --lineno;
            }
            if (lineno == 1) {
                this.indent();
                out.println(script.name);
            }
            int off = script.index[lineno - 1];
            int len = script.index[lr.lineno] - off;
            out.write(script.text, off, len);
        }
    }

    protected void start(Action action) {
        String actionName = action.code < 0 || action.code > actionNames.length ? "Unknown" : actionNames[action.code];
        if (this.showOffset) {
            this.indent();
            this.out.print("absolute=" + this.offset + ",relative=" + (this.offset - this.start) + ",code=" + action.code + "\t" + actionName);
        } else if (this.format == null) {
            this.indent();
            this.out.print(actionName);
        } else {
            this.startFormatted(actionName);
        }
    }

    protected void startFormatted(String action) {
        StringBuilder sb = new StringBuilder();
        boolean leadingZeros = false;
        int width = -1;
        for (int i = 0; i < this.format.length(); ++i) {
            char c2 = this.format.charAt(i);
            if (c2 == '%') {
                if (Character.isDigit(c2 = this.format.charAt(++i))) {
                    if (c2 == '0') {
                        leadingZeros = true;
                        c2 = this.format.charAt(++i);
                    }
                    StringBuilder number = new StringBuilder();
                    while (Character.isDigit(c2)) {
                        number.append(c2);
                        c2 = this.format.charAt(++i);
                    }
                    try {
                        width = Integer.parseInt(number.toString());
                    }
                    catch (NumberFormatException nfe) {
                        width = -1;
                    }
                }
                if (c2 == 'O') {
                    FieldFormat.formatLongToHex(sb, this.offset, width, leadingZeros);
                    continue;
                }
                if (c2 == 'o') {
                    FieldFormat.formatLong(sb, this.offset, width, leadingZeros);
                    continue;
                }
                if (c2 != 'a') continue;
                sb.append(action);
                continue;
            }
            sb.append(c2);
        }
        this.out.print(sb.toString());
    }

    public void nextFrame(Action action) {
        this.print(action);
    }

    public void prevFrame(Action action) {
        this.print(action);
    }

    public void play(Action action) {
        this.print(action);
    }

    public void stop(Action action) {
        this.print(action);
    }

    public void toggleQuality(Action action) {
        this.print(action);
    }

    public void stopSounds(Action action) {
        this.print(action);
    }

    public void add(Action action) {
        this.print(action);
    }

    public void subtract(Action action) {
        this.print(action);
    }

    public void multiply(Action action) {
        this.print(action);
    }

    public void divide(Action action) {
        this.print(action);
    }

    public void equals(Action action) {
        this.print(action);
    }

    public void less(Action action) {
        this.print(action);
    }

    public void and(Action action) {
        this.print(action);
    }

    public void or(Action action) {
        this.print(action);
    }

    public void not(Action action) {
        this.print(action);
    }

    public void stringEquals(Action action) {
        this.print(action);
    }

    public void stringLength(Action action) {
        this.print(action);
    }

    public void stringExtract(Action action) {
        this.print(action);
    }

    public void pop(Action action) {
        this.print(action);
    }

    public void toInteger(Action action) {
        this.print(action);
    }

    public void getVariable(Action action) {
        this.print(action);
    }

    public void setVariable(Action action) {
        this.print(action);
    }

    public void setTarget2(Action action) {
        this.print(action);
    }

    public void stringAdd(Action action) {
        this.print(action);
    }

    public void getProperty(Action action) {
        this.print(action);
    }

    public void setProperty(Action action) {
        this.print(action);
    }

    public void cloneSprite(Action action) {
        this.print(action);
    }

    public void removeSprite(Action action) {
        this.print(action);
    }

    public void trace(Action action) {
        this.print(action);
    }

    public void startDrag(Action action) {
        this.print(action);
    }

    public void endDrag(Action action) {
        this.print(action);
    }

    public void stringLess(Action action) {
        this.print(action);
    }

    public void randomNumber(Action action) {
        this.print(action);
    }

    public void mbStringLength(Action action) {
        this.print(action);
    }

    public void charToASCII(Action action) {
        this.print(action);
    }

    public void asciiToChar(Action action) {
        this.print(action);
    }

    public void getTime(Action action) {
        this.print(action);
    }

    public void mbStringExtract(Action action) {
        this.print(action);
    }

    public void mbCharToASCII(Action action) {
        this.print(action);
    }

    public void mbASCIIToChar(Action action) {
        this.print(action);
    }

    public void delete(Action action) {
        this.print(action);
    }

    public void delete2(Action action) {
        this.print(action);
    }

    public void defineLocal(Action action) {
        this.print(action);
    }

    public void callFunction(Action action) {
        this.print(action);
    }

    public void returnAction(Action action) {
        this.print(action);
    }

    public void modulo(Action action) {
        this.print(action);
    }

    public void newObject(Action action) {
        this.print(action);
    }

    public void defineLocal2(Action action) {
        this.print(action);
    }

    public void initArray(Action action) {
        this.print(action);
    }

    public void initObject(Action action) {
        this.print(action);
    }

    public void typeOf(Action action) {
        this.print(action);
    }

    public void targetPath(Action action) {
        this.print(action);
    }

    public void enumerate(Action action) {
        this.print(action);
    }

    public void add2(Action action) {
        this.print(action);
    }

    public void less2(Action action) {
        this.print(action);
    }

    public void equals2(Action action) {
        this.print(action);
    }

    public void toNumber(Action action) {
        this.print(action);
    }

    public void toString(Action action) {
        this.print(action);
    }

    public void pushDuplicate(Action action) {
        this.print(action);
    }

    public void stackSwap(Action action) {
        this.print(action);
    }

    public void getMember(Action action) {
        this.print(action);
    }

    public void setMember(Action action) {
        this.print(action);
    }

    public void increment(Action action) {
        this.print(action);
    }

    public void decrement(Action action) {
        this.print(action);
    }

    public void callMethod(Action action) {
        this.print(action);
    }

    public void newMethod(Action action) {
        this.print(action);
    }

    public void instanceOf(Action action) {
        this.print(action);
    }

    public void enumerate2(Action action) {
        this.print(action);
    }

    public void bitAnd(Action action) {
        this.print(action);
    }

    public void bitOr(Action action) {
        this.print(action);
    }

    public void bitXor(Action action) {
        this.print(action);
    }

    public void bitLShift(Action action) {
        this.print(action);
    }

    public void bitRShift(Action action) {
        this.print(action);
    }

    public void bitURShift(Action action) {
        this.print(action);
    }

    public void strictEquals(Action action) {
        this.print(action);
    }

    public void greater(Action action) {
        this.print(action);
    }

    public void stringGreater(Action action) {
        this.print(action);
    }

    public void gotoFrame(GotoFrame action) {
        this.start(action);
        this.out.println(" " + action.frame);
    }

    public void getURL(GetURL action) {
        this.start(action);
        this.out.println(" " + action.url + " " + action.target);
    }

    public void storeRegister(StoreRegister action) {
        this.start(action);
        String variableName = this.variableNameForRegister(action.register);
        this.out.println(" $" + action.register + (variableName == null ? "" : "   \t\t; " + variableName));
    }

    public void constantPool(ConstantPool action) {
        this.cpool = action;
        this.start(action);
        this.out.println(" [" + action.pool.length + "]");
    }

    public void strictMode(StrictMode action) {
        this.print(action);
    }

    public void waitForFrame(WaitForFrame action) {
        this.start(action);
        this.out.println(" " + action.frame + " {");
        ++this.indent;
        this.labels.getLabelEntry((Label)action.skipTarget).source = action;
    }

    public void setTarget(SetTarget action) {
        this.start(action);
        this.out.println(" " + action.targetName);
    }

    public void gotoLabel(GotoLabel action) {
        this.start(action);
        this.out.println(" " + action.label);
    }

    public void waitForFrame2(WaitForFrame action) {
        this.start(action);
        this.out.println(" {");
        ++this.indent;
        this.labels.getLabelEntry((Label)action.skipTarget).source = action;
    }

    public void with(With action) {
        this.start(action);
        this.out.println(" {");
        ++this.indent;
        this.labels.getLabelEntry((Label)action.endWith).source = action;
    }

    public void tryAction(Try action) {
        this.start(action);
        this.out.println(" {");
        ++this.indent;
        this.labels.getLabelEntry((Label)action.endTry).source = action;
        if (action.hasCatch()) {
            this.labels.getLabelEntry((Label)action.endCatch).source = action;
        }
        if (action.hasFinally()) {
            this.labels.getLabelEntry((Label)action.endFinally).source = action;
        }
    }

    public void throwAction(Action action) {
        this.print(action);
    }

    public void castOp(Action action) {
        this.print(action);
    }

    public void implementsOp(Action action) {
        this.print(action);
    }

    public void extendsOp(Action action) {
        this.print(action);
    }

    public void nop(Action action) {
        this.print(action);
    }

    public void halt(Action action) {
        this.print(action);
    }

    public void push(Push action) {
        this.start(action);
        this.out.print(" ");
        Object value = action.value;
        int type = Push.getTypeCode(value);
        switch (type) {
            case 0: {
                this.out.print(Disassembler.quoteString(value.toString(), '\"'));
                break;
            }
            case 2: {
                this.out.print("null");
                break;
            }
            case 3: {
                this.out.print("undefined");
                break;
            }
            case 4: {
                String variableName = this.variableNameForRegister(((Byte)value).intValue() & 0xFF);
                this.out.print("$" + (((Byte)value).intValue() & 0xFF) + (variableName == null ? "" : "   \t\t; " + variableName));
                break;
            }
            case 8: 
            case 9: {
                int index = ((Number)value).intValue() & 0xFFFF;
                this.out.print(this.cpool == null ? Integer.toString(index) : Disassembler.quoteString(this.cpool.pool[index], '\''));
                break;
            }
            case 1: {
                this.out.print(value + "F");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.out.print(value);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.out.println();
    }

    public void getURL2(GetURL2 action) {
        this.start(action);
        this.out.println(" " + action.method);
    }

    public void defineFunction(DefineFunction action) {
        this.start(action);
        this.out.print(" " + action.name + "(");
        for (int i = 0; i < action.params.length; ++i) {
            this.out.print(action.params[i]);
            if (i + 1 >= action.params.length) continue;
            this.out.print(", ");
        }
        this.out.println(") {");
        ++this.indent;
        action.actionList.visitAll(this);
        --this.indent;
        this.indent();
        this.out.println("} " + action.name);
    }

    public void defineFunction2(DefineFunction action) {
        this.start(action);
        this.out.print(" " + action.name + "(");
        for (int i = 0; i < action.params.length; ++i) {
            this.out.print("$" + action.paramReg[i] + "=" + action.params[i]);
            if (i + 1 >= action.params.length) continue;
            this.out.print(", ");
        }
        this.out.print(")");
        int regno = 1;
        if ((action.flags & 1) != 0) {
            this.out.print(" $" + regno++ + "=this");
        }
        if ((action.flags & 4) != 0) {
            this.out.print(" $" + regno++ + "=arguments");
        }
        if ((action.flags & 0x10) != 0) {
            this.out.print(" $" + regno++ + "=super");
        }
        if ((action.flags & 0x40) != 0) {
            this.out.print(" $" + regno++ + "=_root");
        }
        if ((action.flags & 0x80) != 0) {
            this.out.print(" $" + regno++ + "=_parent");
        }
        if ((action.flags & 0x100) != 0) {
            this.out.print(" $" + regno + "=_global");
        }
        this.out.println(" {");
        ++this.indent;
        action.actionList.visitAll(this);
        --this.indent;
        this.indent();
        this.out.println("} " + action.name);
    }

    public void ifAction(Branch action) {
        this.printBranch(action);
    }

    public void jump(Branch action) {
        this.printBranch(action);
    }

    protected void printBranch(Branch action) {
        this.start(action);
        LabelEntry entry = this.labels.getLabelEntry(action.target);
        if (entry.name == null) {
            entry.name = "L" + String.valueOf(this.labelCount++);
        }
        entry.source = action;
        this.out.println(" " + entry.name);
    }

    public void label(Label label) {
        LabelEntry entry = this.labels.getLabelEntry(label);
        if (entry.source == null) {
            entry.name = "L" + String.valueOf(this.labelCount++);
            this.indent();
            this.out.println(entry.name + ":");
        } else {
            switch (entry.source.code) {
                case 143: {
                    Try t = (Try)entry.source;
                    --this.indent;
                    this.indent();
                    this.out.println("}");
                    this.indent();
                    if (label == t.endTry && t.hasCatch()) {
                        this.out.println("catch(" + (t.hasRegister() ? "$" + t.catchReg : t.catchName) + ") {");
                        ++this.indent;
                        break;
                    }
                    if (label != t.endTry && label != t.endCatch || !t.hasFinally()) break;
                    this.out.println("finally {");
                    ++this.indent;
                    break;
                }
                case 138: 
                case 141: 
                case 148: {
                    --this.indent;
                    this.indent();
                    this.out.println("}");
                    break;
                }
                case 153: 
                case 157: {
                    this.indent();
                    this.out.println(entry.name + ":");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    public void call(Action action) {
        this.print(action);
    }

    public void gotoFrame2(GotoFrame2 action) {
        this.start(action);
        this.out.println(" " + action.playFlag);
    }

    public void quickTime(Action action) {
        this.print(action);
    }

    public void unknown(Unknown action) {
        this.print(action);
    }

    public static String quoteString(String s, char qc) {
        StringBuilder b2 = new StringBuilder(s.length() + 2);
        b2.append(qc);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            switch (c2) {
                case '\b': {
                    b2.append("\\v");
                    continue block9;
                }
                case '\f': {
                    b2.append("\\f");
                    continue block9;
                }
                case '\r': {
                    b2.append("\\r");
                    continue block9;
                }
                case '\t': {
                    b2.append("\\t");
                    continue block9;
                }
                case '\n': {
                    b2.append("\\n");
                    continue block9;
                }
                case '\"': {
                    b2.append("\\\"");
                    continue block9;
                }
                case '\'': {
                    b2.append("\\'");
                    continue block9;
                }
                default: {
                    b2.append(c2);
                }
            }
        }
        b2.append(qc);
        return b2.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelMap
    extends HashMap<Label, LabelEntry> {
        private static final long serialVersionUID = -7907644739362458461L;

        private LabelMap() {
        }

        LabelEntry getLabelEntry(Label l) {
            LabelEntry entry = (LabelEntry)this.get(l);
            if (entry == null) {
                entry = new LabelEntry(null, null);
                this.put(l, entry);
            }
            return entry;
        }
    }

    private static class LabelEntry {
        String name;
        Action source;

        public LabelEntry(String name, Action source) {
            this.name = name;
            this.source = source;
        }
    }
}

