/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;

public class AbcPrinter {
    private byte[] abc;
    private PrintWriter out;
    private boolean showOffset;
    private boolean showByteCode;
    private int indent;
    private int offset = 0;
    private int[] intConstants;
    private long[] uintConstants;
    private double[] floatConstants;
    private String[] stringConstants;
    private String[] namespaceConstants;
    private String[][] namespaceSetConstants;
    private MultiName[] multiNameConstants;
    private MethodInfo[] methods;
    private String[] instanceNames;
    private String indentString;
    final int TRAIT_Slot = 0;
    final int TRAIT_Method = 1;
    final int TRAIT_Getter = 2;
    final int TRAIT_Setter = 3;
    final int TRAIT_Class = 4;
    final int TRAIT_Function = 5;
    final int TRAIT_Const = 6;
    final String[] traitKinds = new String[]{"var", "function", "function get", "function set", "class", "function", "const"};
    char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final int OP_bkpt = 1;
    final int OP_nop = 2;
    final int OP_throw = 3;
    final int OP_getsuper = 4;
    final int OP_setsuper = 5;
    final int OP_dxns = 6;
    final int OP_dxnslate = 7;
    final int OP_kill = 8;
    final int OP_label = 9;
    final int OP_ifnlt = 12;
    final int OP_ifnle = 13;
    final int OP_ifngt = 14;
    final int OP_ifnge = 15;
    final int OP_jump = 16;
    final int OP_iftrue = 17;
    final int OP_iffalse = 18;
    final int OP_ifeq = 19;
    final int OP_ifne = 20;
    final int OP_iflt = 21;
    final int OP_ifle = 22;
    final int OP_ifgt = 23;
    final int OP_ifge = 24;
    final int OP_ifstricteq = 25;
    final int OP_ifstrictne = 26;
    final int OP_lookupswitch = 27;
    final int OP_pushwith = 28;
    final int OP_popscope = 29;
    final int OP_nextname = 30;
    final int OP_hasnext = 31;
    final int OP_pushnull = 32;
    final int OP_pushundefined = 33;
    final int OP_pushintant = 34;
    final int OP_nextvalue = 35;
    final int OP_pushbyte = 36;
    final int OP_pushshort = 37;
    final int OP_pushtrue = 38;
    final int OP_pushfalse = 39;
    final int OP_pushnan = 40;
    final int OP_pop = 41;
    final int OP_dup = 42;
    final int OP_swap = 43;
    final int OP_pushstring = 44;
    final int OP_pushint = 45;
    final int OP_pushuint = 46;
    final int OP_pushdouble = 47;
    final int OP_pushscope = 48;
    final int OP_pushnamespace = 49;
    final int OP_hasnext2 = 50;
    final int OP_newfunction = 64;
    final int OP_call = 65;
    final int OP_construct = 66;
    final int OP_callmethod = 67;
    final int OP_callstatic = 68;
    final int OP_callsuper = 69;
    final int OP_callproperty = 70;
    final int OP_returnvoid = 71;
    final int OP_returnvalue = 72;
    final int OP_constructsuper = 73;
    final int OP_constructprop = 74;
    final int OP_callsuperid = 75;
    final int OP_callproplex = 76;
    final int OP_callinterface = 77;
    final int OP_callsupervoid = 78;
    final int OP_callpropvoid = 79;
    final int OP_newobject = 85;
    final int OP_newarray = 86;
    final int OP_newactivation = 87;
    final int OP_newclass = 88;
    final int OP_getdescendants = 89;
    final int OP_newcatch = 90;
    final int OP_findpropstrict = 93;
    final int OP_findproperty = 94;
    final int OP_finddef = 95;
    final int OP_getlex = 96;
    final int OP_setproperty = 97;
    final int OP_getlocal = 98;
    final int OP_setlocal = 99;
    final int OP_getglobalscope = 100;
    final int OP_getscopeobject = 101;
    final int OP_getproperty = 102;
    final int OP_getpropertylate = 103;
    final int OP_initproperty = 104;
    final int OP_setpropertylate = 105;
    final int OP_deleteproperty = 106;
    final int OP_deletepropertylate = 107;
    final int OP_getslot = 108;
    final int OP_setslot = 109;
    final int OP_getglobalslot = 110;
    final int OP_setglobalslot = 111;
    final int OP_convert_s = 112;
    final int OP_esc_xelem = 113;
    final int OP_esc_xattr = 114;
    final int OP_convert_i = 115;
    final int OP_convert_u = 116;
    final int OP_convert_d = 117;
    final int OP_convert_b = 118;
    final int OP_convert_o = 119;
    final int OP_coerce = 128;
    final int OP_coerce_b = 129;
    final int OP_coerce_a = 130;
    final int OP_coerce_i = 131;
    final int OP_coerce_d = 132;
    final int OP_coerce_s = 133;
    final int OP_astype = 134;
    final int OP_astypelate = 135;
    final int OP_coerce_u = 136;
    final int OP_coerce_o = 137;
    final int OP_negate = 144;
    final int OP_increment = 145;
    final int OP_inclocal = 146;
    final int OP_decrement = 147;
    final int OP_declocal = 148;
    final int OP_typeof = 149;
    final int OP_not = 150;
    final int OP_bitnot = 151;
    final int OP_concat = 154;
    final int OP_add_d = 155;
    final int OP_add = 160;
    final int OP_subtract = 161;
    final int OP_multiply = 162;
    final int OP_divide = 163;
    final int OP_modulo = 164;
    final int OP_lshift = 165;
    final int OP_rshift = 166;
    final int OP_urshift = 167;
    final int OP_bitand = 168;
    final int OP_bitor = 169;
    final int OP_bitxor = 170;
    final int OP_equals = 171;
    final int OP_strictequals = 172;
    final int OP_lessthan = 173;
    final int OP_lessequals = 174;
    final int OP_greaterthan = 175;
    final int OP_greaterequals = 176;
    final int OP_instanceof = 177;
    final int OP_istype = 178;
    final int OP_istypelate = 179;
    final int OP_in = 180;
    final int OP_increment_i = 192;
    final int OP_decrement_i = 193;
    final int OP_inclocal_i = 194;
    final int OP_declocal_i = 195;
    final int OP_negate_i = 196;
    final int OP_add_i = 197;
    final int OP_subtract_i = 198;
    final int OP_multiply_i = 199;
    final int OP_getlocal0 = 208;
    final int OP_getlocal1 = 209;
    final int OP_getlocal2 = 210;
    final int OP_getlocal3 = 211;
    final int OP_setlocal0 = 212;
    final int OP_setlocal1 = 213;
    final int OP_setlocal2 = 214;
    final int OP_setlocal3 = 215;
    final int OP_debug = 239;
    final int OP_debugline = 240;
    final int OP_debugfile = 241;
    final int OP_bkptline = 242;
    String[] opNames = new String[]{"OP_0x00       ", "bkpt          ", "nop           ", "throw         ", "getsuper      ", "setsuper      ", "dxns          ", "dxnslate      ", "kill          ", "label         ", "OP_0x0A       ", "OP_0x0B       ", "ifnlt         ", "ifnle         ", "ifngt         ", "ifnge         ", "jump          ", "iftrue        ", "iffalse       ", "ifeq          ", "ifne          ", "iflt          ", "ifle          ", "ifgt          ", "ifge          ", "ifstricteq    ", "ifstrictne    ", "lookupswitch  ", "pushwith      ", "popscope      ", "nextname      ", "hasnext       ", "pushnull      ", "pushundefined ", "pushconstant  ", "nextvalue     ", "pushbyte      ", "pushshort     ", "pushtrue      ", "pushfalse     ", "pushnan       ", "pop           ", "dup           ", "swap          ", "pushstring    ", "pushint       ", "pushuint      ", "pushdouble    ", "pushscope     ", "pushnamespace ", "hasnext2      ", "OP_0x33       ", "OP_0x34       ", "OP_0x35       ", "OP_0x36       ", "OP_0x37       ", "OP_0x38       ", "OP_0x39       ", "OP_0x3A       ", "OP_0x3B       ", "OP_0x3C       ", "OP_0x3D       ", "OP_0x3E       ", "OP_0x3F       ", "newfunction   ", "call          ", "construct     ", "callmethod    ", "callstatic    ", "callsuper     ", "callproperty  ", "returnvoid    ", "returnvalue   ", "constructsuper", "constructprop ", "callsuperid   ", "callproplex   ", "callinterface ", "callsupervoid ", "callpropvoid  ", "OP_0x50       ", "OP_0x51       ", "OP_0x52       ", "OP_0x53       ", "OP_0x54       ", "newobject     ", "newarray      ", "newactivation ", "newclass      ", "getdescendants", "newcatch      ", "OP_0x5B       ", "OP_0x5C       ", "findpropstrict", "findproperty  ", "finddef       ", "getlex        ", "setproperty   ", "getlocal      ", "setlocal      ", "getglobalscope", "getscopeobject", "getproperty   ", "OP_0x67       ", "initproperty  ", "OP_0x69       ", "deleteproperty", "OP_0x6A       ", "getslot       ", "setslot       ", "getglobalslot ", "setglobalslot ", "convert_s     ", "esc_xelem     ", "esc_xattr     ", "convert_i     ", "convert_u     ", "convert_d     ", "convert_b     ", "convert_o     ", "checkfilter   ", "OP_0x79       ", "OP_0x7A       ", "OP_0x7B       ", "OP_0x7C       ", "OP_0x7D       ", "OP_0x7E       ", "OP_0x7F       ", "coerce        ", "coerce_b      ", "coerce_a      ", "coerce_i      ", "coerce_d      ", "coerce_s      ", "astype        ", "astypelate    ", "coerce_u      ", "coerce_o      ", "OP_0x8A       ", "OP_0x8B       ", "OP_0x8C       ", "OP_0x8D       ", "OP_0x8E       ", "OP_0x8F       ", "negate        ", "increment     ", "inclocal      ", "decrement     ", "declocal      ", "typeof        ", "not           ", "bitnot        ", "OP_0x98       ", "OP_0x99       ", "concat        ", "add_d         ", "OP_0x9C       ", "OP_0x9D       ", "OP_0x9E       ", "OP_0x9F       ", "add           ", "subtract      ", "multiply      ", "divide        ", "modulo        ", "lshift        ", "rshift        ", "urshift       ", "bitand        ", "bitor         ", "bitxor        ", "equals        ", "strictequals  ", "lessthan      ", "lessequals    ", "greaterthan   ", "greaterequals ", "instanceof    ", "istype        ", "istypelate    ", "in            ", "OP_0xB5       ", "OP_0xB6       ", "OP_0xB7       ", "OP_0xB8       ", "OP_0xB9       ", "OP_0xBA       ", "OP_0xBB       ", "OP_0xBC       ", "OP_0xBD       ", "OP_0xBE       ", "OP_0xBF       ", "increment_i   ", "decrement_i   ", "inclocal_i    ", "declocal_i    ", "negate_i      ", "add_i         ", "subtract_i    ", "multiply_i    ", "OP_0xC8       ", "OP_0xC9       ", "OP_0xCA       ", "OP_0xCB       ", "OP_0xCC       ", "OP_0xCD       ", "OP_0xCE       ", "OP_0xCF       ", "getlocal0     ", "getlocal1     ", "getlocal2     ", "getlocal3     ", "setlocal0     ", "setlocal1     ", "setlocal2     ", "setlocal3     ", "OP_0xD8       ", "OP_0xD9       ", "OP_0xDA       ", "OP_0xDB       ", "OP_0xDC       ", "OP_0xDD       ", "OP_0xDE       ", "OP_0xDF       ", "OP_0xE0       ", "OP_0xE1       ", "OP_0xE2       ", "OP_0xE3       ", "OP_0xE4       ", "OP_0xE5       ", "OP_0xE6       ", "OP_0xE7       ", "OP_0xE8       ", "OP_0xE9       ", "OP_0xEA       ", "OP_0xEB       ", "OP_0xEC       ", "OP_0xED       ", "OP_0xEE       ", "debug         ", "debugline     ", "debugfile     ", "bkptline      ", "timestamp     ", "OP_0xF4       ", "verifypass    ", "alloc         ", "mark          ", "wb            ", "prologue      ", "sendenter     ", "doubletoatom  ", "sweep         ", "codegenop     ", "verifyop      ", "decode        "};

    public AbcPrinter(byte[] abc, PrintWriter out, boolean showOffset, int indent, boolean showByteCode) {
        this.abc = abc;
        this.out = out;
        this.showOffset = showOffset;
        this.showByteCode = showByteCode;
        this.indent = indent;
        char[] spaces = new char[indent * 2 + 1];
        for (int i = 0; i < indent * 2; ++i) {
            spaces[i] = 32;
        }
        this.indentString = new String(spaces, 0, indent * 2);
    }

    public void print() {
        this.printOffset();
        this.out.println(this.abc[this.offset++] + " " + this.abc[this.offset++] + " minor version");
        this.printOffset();
        this.out.println(this.abc[this.offset++] + " " + this.abc[this.offset++] + " major version");
        this.printIntConstantPool();
        this.printUintConstantPool();
        this.printDoubleConstantPool();
        this.printStringConstantPool();
        this.printNamespaceConstantPool();
        this.printNamespaceSetsConstantPool();
        this.printMultiNameConstantPool();
        this.printMethods();
        this.printMetaData();
        this.printClasses();
        this.printScripts();
        this.printBodies();
    }

    String hex(byte b2) {
        return "" + this.hexChars[b2 >> 4 & 0xF] + this.hexChars[b2 & 0xF];
    }

    void printOffset() {
        if (this.showOffset) {
            this.out.print(this.indentString + "offset " + this.offset + ": ");
        } else {
            this.out.print(this.indentString);
        }
    }

    int readS24() {
        int b2 = this.abc[this.offset++];
        b2 &= 0xFF;
        b2 |= this.abc[this.offset++] << 8;
        b2 &= 0xFFFF;
        return b2 |= this.abc[this.offset++] << 16;
    }

    long readU32() {
        long b2 = this.abc[this.offset++];
        long u32 = b2 &= 0xFFL;
        if ((u32 & 0x80L) != 128L) {
            return u32;
        }
        b2 = this.abc[this.offset++];
        if (((u32 = u32 & 0x7FL | (b2 &= 0xFFL) << 7) & 0x4000L) != 16384L) {
            return u32;
        }
        b2 = this.abc[this.offset++];
        if (((u32 = u32 & 0x3FFFL | (b2 &= 0xFFL) << 14) & 0x200000L) != 0x200000L) {
            return u32;
        }
        b2 = this.abc[this.offset++];
        if (((u32 = u32 & 0x1FFFFFL | (b2 &= 0xFFL) << 21) & 0x10000000L) != 0x10000000L) {
            return u32;
        }
        b2 = this.abc[this.offset++];
        u32 = u32 & 0xFFFFFFFL | (b2 &= 0xFFL) << 28;
        return u32;
    }

    String readUTFBytes(long n) {
        StringWriter sw = new StringWriter();
        int i = 0;
        while ((long)i < n) {
            sw.write(this.abc[this.offset++]);
            ++i;
        }
        return sw.toString();
    }

    void printIntConstantPool() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Integer Constant Pool Entries");
        this.intConstants = new int[n > 0L ? (int)n : 1];
        this.intConstants[0] = 0;
        int i = 1;
        while ((long)i < n) {
            long val = this.readU32();
            this.intConstants[i] = (int)val;
            this.printOffset();
            this.out.println(val);
            ++i;
        }
    }

    void printUintConstantPool() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Unsigned Integer Constant Pool Entries");
        this.uintConstants = new long[n > 0L ? (int)n : 1];
        this.uintConstants[0] = 0L;
        int i = 1;
        while ((long)i < n) {
            long val = this.readU32();
            this.uintConstants[i] = (int)val;
            this.printOffset();
            this.out.println(val);
            ++i;
        }
    }

    void printDoubleConstantPool() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Floating Point Constant Pool Entries");
        if (n > 0L) {
            this.offset = (int)((long)this.offset + (n - 1L) * 8L);
        }
    }

    void printStringConstantPool() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " String Constant Pool Entries");
        this.stringConstants = new String[n > 0L ? (int)n : 1];
        this.stringConstants[0] = "";
        int i = 1;
        while ((long)i < n) {
            String s;
            this.printOffset();
            this.stringConstants[i] = s = this.readUTFBytes(this.readU32());
            this.out.println(" " + s);
            ++i;
        }
    }

    void printNamespaceConstantPool() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Namespace Constant Pool Entries");
        this.namespaceConstants = new String[n > 0L ? (int)n : 1];
        this.namespaceConstants[0] = "public";
        int i = 1;
        while ((long)i < n) {
            String s;
            this.printOffset();
            byte b2 = this.abc[this.offset++];
            if (b2 == 5) {
                this.readU32();
                s = "private";
            } else {
                s = this.stringConstants[(int)this.readU32()];
            }
            this.namespaceConstants[i] = s;
            this.out.println(" " + s);
            ++i;
        }
    }

    void printNamespaceSetsConstantPool() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Namespace Set Constant Pool Entries");
        this.namespaceSetConstants = new String[n > 0L ? (int)n : 1][];
        this.namespaceSetConstants[0] = new String[0];
        int i = 1;
        while ((long)i < n) {
            long val = this.readU32();
            String[] nsset = new String[(int)val];
            this.namespaceSetConstants[i] = nsset;
            int j = 0;
            while ((long)j < val) {
                nsset[j] = this.namespaceConstants[(int)this.readU32()];
                ++j;
            }
            ++i;
        }
    }

    void printMultiNameConstantPool() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " MultiName Constant Pool Entries");
        this.multiNameConstants = new MultiName[n > 0L ? (int)n : 1];
        this.multiNameConstants[0] = new MultiName();
        int i = 1;
        while ((long)i < n) {
            this.printOffset();
            int b2 = this.abc[this.offset++];
            this.multiNameConstants[i] = new MultiName();
            this.multiNameConstants[i].kind = b2;
            switch (b2) {
                case 7: 
                case 13: {
                    this.multiNameConstants[i].long1 = (int)this.readU32();
                    this.multiNameConstants[i].long2 = (int)this.readU32();
                    break;
                }
                case 15: 
                case 16: {
                    this.multiNameConstants[i].long1 = (int)this.readU32();
                    break;
                }
                case 17: 
                case 18: {
                    break;
                }
                case 19: 
                case 20: {
                    break;
                }
                case 9: 
                case 14: {
                    this.multiNameConstants[i].long1 = (int)this.readU32();
                    this.multiNameConstants[i].long2 = (int)this.readU32();
                    break;
                }
                case 27: 
                case 28: {
                    this.multiNameConstants[i].long1 = (int)this.readU32();
                    break;
                }
                case 29: {
                    int nameIndex = (int)this.readU32();
                    MultiName mn = this.multiNameConstants[nameIndex];
                    int count = (int)this.readU32();
                    MultiName[] types = new MultiName[count];
                    for (int t = 0; t < count; ++t) {
                        int typeIndex = (int)this.readU32();
                        types[t] = this.multiNameConstants[typeIndex];
                    }
                    this.multiNameConstants[i].typeName = mn;
                    this.multiNameConstants[i].types = types;
                }
            }
            this.out.println(this.multiNameConstants[i]);
            ++i;
        }
    }

    void printMethods() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Method Entries");
        this.methods = new MethodInfo[(int)n];
        int i = 0;
        while ((long)i < n) {
            int x;
            int k;
            int start = this.offset;
            this.printOffset();
            MethodInfo m = this.methods[i] = new MethodInfo();
            m.paramCount = (int)this.readU32();
            m.returnType = (int)this.readU32();
            m.params = new int[m.paramCount];
            for (int j = 0; j < m.paramCount; ++j) {
                m.params[j] = (int)this.readU32();
            }
            int nameIndex = (int)this.readU32();
            m.name = nameIndex > 0 ? this.stringConstants[nameIndex] : "no name";
            m.flags = this.abc[this.offset++];
            if ((m.flags & 8) == 8) {
                m.optionCount = (int)this.readU32();
                m.optionIndex = new int[m.optionCount];
                m.optionKinds = new int[m.optionCount];
                for (k = 0; k < m.optionCount; ++k) {
                    m.optionIndex[k] = (int)this.readU32();
                    m.optionKinds[k] = this.abc[this.offset++];
                }
            }
            if ((m.flags & 0x80) == 128) {
                m.paramNames = new int[m.paramCount];
                for (k = 0; k < m.paramCount; ++k) {
                    m.paramNames[k] = (int)this.readU32();
                }
            }
            if (this.showByteCode) {
                for (x = start; x < this.offset; ++x) {
                    this.out.print(this.hex(this.abc[x]) + " ");
                }
            }
            this.out.print(m.name + "(");
            for (x = 0; x < m.paramCount; ++x) {
                this.out.print(this.multiNameConstants[m.params[x]]);
                if (x >= m.paramCount - 1) continue;
                this.out.print(",");
            }
            this.out.print("):");
            this.out.println(this.multiNameConstants[m.returnType] + " ");
            ++i;
        }
    }

    void printMetaData() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Metadata Entries");
        int i = 0;
        while ((long)i < n) {
            int start = this.offset;
            this.printOffset();
            String s = this.stringConstants[(int)this.readU32()];
            long val = this.readU32();
            int j = 0;
            while ((long)j < val) {
                s = s + " " + this.stringConstants[(int)this.readU32()];
                ++j;
            }
            j = 0;
            while ((long)j < val) {
                s = s + " " + this.stringConstants[(int)this.readU32()];
                ++j;
            }
            if (this.showByteCode) {
                for (int x = start; x < this.offset; ++x) {
                    this.out.print(this.hex(this.abc[x]) + " ");
                }
            }
            this.out.println(s);
            ++i;
        }
    }

    void printClasses() {
        int x;
        String s;
        int start;
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Instance Entries");
        this.instanceNames = new String[(int)n];
        int i = 0;
        while ((long)i < n) {
            String name;
            start = this.offset;
            this.printOffset();
            this.instanceNames[i] = name = this.multiNameConstants[(int)this.readU32()].toString();
            String base = this.multiNameConstants[(int)this.readU32()].toString();
            byte b2 = this.abc[this.offset++];
            if ((b2 & 8) == 8) {
                this.readU32();
            }
            long val = this.readU32();
            s = "";
            int j = 0;
            while ((long)j < val) {
                s = s + " " + this.multiNameConstants[(int)this.readU32()].toString();
                ++j;
            }
            int init = (int)this.readU32();
            MethodInfo mi = this.methods[init];
            mi.name = name;
            mi.className = name;
            mi.kind = 1;
            if (this.showByteCode) {
                for (x = start; x < this.offset; ++x) {
                    this.out.print(this.hex(this.abc[x]) + " ");
                }
            }
            this.out.print(name + " ");
            if (base.length() > 0) {
                this.out.print("extends " + base + " ");
            }
            if (s.length() > 0) {
                this.out.print("implements " + s);
            }
            this.out.println("");
            int numTraits = (int)this.readU32();
            this.printOffset();
            this.out.println(numTraits + " Traits Entries");
            for (int j2 = 0; j2 < numTraits; ++j2) {
                this.printOffset();
                start = this.offset;
                s = this.multiNameConstants[(int)this.readU32()].toString();
                b2 = this.abc[this.offset++];
                int kind = b2 & 0xF;
                switch (kind) {
                    case 0: 
                    case 6: {
                        this.readU32();
                        this.readU32();
                        int index = (int)this.readU32();
                        if (index == 0) break;
                        ++this.offset;
                        break;
                    }
                    case 4: {
                        this.readU32();
                        this.readU32();
                        break;
                    }
                    default: {
                        this.readU32();
                        mi = this.methods[(int)this.readU32()];
                        mi.name = s;
                        mi.className = name;
                        mi.kind = kind;
                    }
                }
                if ((b2 >> 4 & 4) == 4) {
                    val = this.readU32();
                    int k = 0;
                    while ((long)k < val) {
                        this.readU32();
                        ++k;
                    }
                }
                if (this.showByteCode) {
                    for (int x2 = start; x2 < this.offset; ++x2) {
                        this.out.print(this.hex(this.abc[x2]) + " ");
                    }
                }
                this.out.println(s);
            }
            ++i;
        }
        this.printOffset();
        this.out.println(n + " Class Entries");
        i = 0;
        while ((long)i < n) {
            start = this.offset;
            this.printOffset();
            MethodInfo mi = this.methods[(int)this.readU32()];
            String name = this.instanceNames[i];
            mi.name = name + "$cinit";
            mi.className = name;
            mi.kind = 1;
            String base = "Class";
            if (this.showByteCode) {
                for (int x3 = start; x3 < this.offset; ++x3) {
                    this.out.print(this.hex(this.abc[x3]) + " ");
                }
            }
            this.out.print(name + " ");
            if (base.length() > 0) {
                this.out.print("extends " + base + " ");
            }
            this.out.println("");
            int numTraits = (int)this.readU32();
            this.printOffset();
            this.out.println(numTraits + " Traits Entries");
            for (int j = 0; j < numTraits; ++j) {
                this.printOffset();
                start = this.offset;
                s = this.multiNameConstants[(int)this.readU32()].toString();
                byte b3 = this.abc[this.offset++];
                int kind = b3 & 0xF;
                switch (kind) {
                    case 0: 
                    case 6: {
                        this.readU32();
                        this.readU32();
                        int index = (int)this.readU32();
                        if (index == 0) break;
                        ++this.offset;
                        break;
                    }
                    case 4: {
                        this.readU32();
                        this.readU32();
                        break;
                    }
                    default: {
                        this.readU32();
                        mi = this.methods[(int)this.readU32()];
                        mi.name = s;
                        mi.className = name;
                        mi.kind = kind;
                    }
                }
                if ((b3 >> 4 & 4) == 4) {
                    int val = (int)this.readU32();
                    for (int k = 0; k < val; ++k) {
                        this.readU32();
                    }
                }
                if (this.showByteCode) {
                    for (x = start; x < this.offset; ++x) {
                        this.out.print(this.hex(this.abc[x]) + " ");
                    }
                }
                this.out.println(s);
            }
            ++i;
        }
    }

    void printScripts() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Script Entries");
        int i = 0;
        while ((long)i < n) {
            int start = this.offset;
            this.printOffset();
            String name = "script" + Integer.toString(i);
            int init = (int)this.readU32();
            MethodInfo mi = this.methods[init];
            mi.name = name + "$init";
            mi.className = name;
            mi.kind = 1;
            if (this.showByteCode) {
                for (int x = start; x < this.offset; ++x) {
                    this.out.print(this.hex(this.abc[x]) + " ");
                }
            }
            this.out.println(name + " ");
            int numTraits = (int)this.readU32();
            this.printOffset();
            this.out.println(numTraits + " Traits Entries");
            for (int j = 0; j < numTraits; ++j) {
                this.printOffset();
                start = this.offset;
                String s = this.multiNameConstants[(int)this.readU32()].toString();
                byte b2 = this.abc[this.offset++];
                int kind = b2 & 0xF;
                switch (kind) {
                    case 0: 
                    case 6: {
                        this.readU32();
                        this.readU32();
                        int index = (int)this.readU32();
                        if (index == 0) break;
                        ++this.offset;
                        break;
                    }
                    case 4: {
                        this.readU32();
                        this.readU32();
                        break;
                    }
                    default: {
                        this.readU32();
                        mi = this.methods[(int)this.readU32()];
                        mi.name = s;
                        mi.className = name;
                        mi.kind = kind;
                    }
                }
                if ((b2 >> 4 & 4) == 4) {
                    int val = (int)this.readU32();
                    for (int k = 0; k < val; ++k) {
                        this.readU32();
                    }
                }
                if (this.showByteCode) {
                    for (int x = start; x < this.offset; ++x) {
                        this.out.print(this.hex(this.abc[x]) + " ");
                    }
                }
                this.out.println(s);
            }
            ++i;
        }
    }

    void printBodies() {
        long n = this.readU32();
        this.printOffset();
        this.out.println(n + " Method Bodies");
        int i = 0;
        while ((long)i < n) {
            this.printOffset();
            int start = this.offset;
            int methodIndex = (int)this.readU32();
            int maxStack = (int)this.readU32();
            int localCount = (int)this.readU32();
            int initScopeDepth = (int)this.readU32();
            int maxScopeDepth = (int)this.readU32();
            int codeLength = (int)this.readU32();
            if (this.showByteCode) {
                int x;
                for (x = start; x < this.offset; ++x) {
                    this.out.print(this.hex(this.abc[x]) + " ");
                }
                for (x = this.offset - start; x < 7; ++x) {
                    this.out.print("   ");
                }
            }
            MethodInfo mi = this.methods[methodIndex];
            this.out.print(this.traitKinds[mi.kind] + " ");
            this.out.print(mi.className + "::" + mi.name + "(");
            for (int x = 0; x < mi.paramCount - 1; ++x) {
                this.out.print(this.multiNameConstants[mi.params[x]].toString() + ", ");
            }
            if (mi.paramCount > 0) {
                this.out.print(this.multiNameConstants[mi.params[mi.paramCount - 1]].toString());
            }
            this.out.print("):");
            this.out.println(this.multiNameConstants[mi.returnType].toString());
            this.printOffset();
            this.out.print("maxStack:" + maxStack + " localCount:" + localCount + " ");
            this.out.println("initScopeDepth:" + initScopeDepth + " maxScopeDepth:" + maxScopeDepth);
            LabelMgr labels = new LabelMgr();
            int stopAt = codeLength + this.offset;
            while (this.offset < stopAt) {
                String s = "";
                start = this.offset;
                this.printOffset();
                int opcode = this.abc[this.offset++] & 0xFF;
                if (opcode == 9 || labels.hasLabelAt(this.offset - 1)) {
                    s = labels.getLabelAt(this.offset - 1) + ":";
                    while (s.length() < 4) {
                        s = s + " ";
                    }
                } else {
                    s = "    ";
                }
                s = s + this.opNames[opcode];
                s = s + (this.opNames[opcode].length() < 8 ? "\t\t" : "\t");
                switch (opcode) {
                    case 44: 
                    case 241: {
                        s = s + '\"' + this.stringConstants[(int)this.readU32()].replaceAll("\n", "\\n").replaceAll("\t", "\\t") + '\"';
                        break;
                    }
                    case 49: {
                        s = s + this.namespaceConstants[(int)this.readU32()];
                        break;
                    }
                    case 45: {
                        int k = this.intConstants[(int)this.readU32()];
                        s = s + k + "\t// 0x" + Integer.toHexString(k);
                        break;
                    }
                    case 46: {
                        long u = this.uintConstants[(int)this.readU32()];
                        s = s + u + "\t// 0x" + Long.toHexString(u);
                        break;
                    }
                    case 47: {
                        int f2 = (int)this.readU32();
                        s = s + "floatConstant" + f2;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 89: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 102: 
                    case 104: 
                    case 106: 
                    case 128: 
                    case 134: 
                    case 178: {
                        s = s + this.multiNameConstants[(int)this.readU32()];
                        break;
                    }
                    case 69: 
                    case 70: 
                    case 74: 
                    case 76: 
                    case 78: 
                    case 79: {
                        s = s + this.multiNameConstants[(int)this.readU32()];
                        s = s + " (" + this.readU32() + ")";
                        break;
                    }
                    case 64: {
                        int method_id = (int)this.readU32();
                        s = s + this.methods[method_id].name;
                        break;
                    }
                    case 68: {
                        s = s + this.methods[(int)this.readU32()].name;
                        s = s + " (" + this.readU32() + ")";
                        break;
                    }
                    case 88: {
                        s = s + this.instanceNames[(int)this.readU32()];
                        break;
                    }
                    case 27: {
                        int pos = this.offset - 1;
                        int target = pos + this.readS24();
                        int maxindex = (int)this.readU32();
                        s = s + "default:" + labels.getLabelAt(target);
                        s = s + " maxcase:" + Integer.toString(maxindex);
                        for (int m = 0; m <= maxindex; ++m) {
                            target = pos + this.readS24();
                            s = s + " " + labels.getLabelAt(target);
                        }
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        int delta = this.readS24();
                        int targ = this.offset + delta;
                        s = s + labels.getLabelAt(targ);
                        if (labels.hasLabelAt(this.offset)) break;
                        s = s + "\n";
                        break;
                    }
                    case 8: 
                    case 37: 
                    case 90: 
                    case 98: 
                    case 99: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 146: 
                    case 148: 
                    case 194: 
                    case 195: 
                    case 240: {
                        s = s + this.readU32();
                        break;
                    }
                    case 239: {
                        s = s + Integer.toString(this.abc[this.offset++] & 0xFF);
                        s = s + " " + this.readU32();
                        s = s + " " + Integer.toString(this.abc[this.offset++] & 0xFF);
                        s = s + " " + this.readU32();
                        break;
                    }
                    case 85: {
                        s = s + "{" + this.readU32() + "}";
                        break;
                    }
                    case 86: {
                        s = s + "[" + this.readU32() + "]";
                        break;
                    }
                    case 65: 
                    case 66: 
                    case 73: {
                        s = s + "(" + this.readU32() + ")";
                        break;
                    }
                    case 36: 
                    case 101: {
                        s = s + this.abc[this.offset++];
                        break;
                    }
                    case 50: {
                        s = s + this.readU32() + " " + this.readU32();
                    }
                }
                if (this.showByteCode) {
                    int x;
                    for (x = start; x < this.offset; ++x) {
                        this.out.print(this.hex(this.abc[x]) + " ");
                    }
                    for (x = this.offset - start; x < 7; ++x) {
                        this.out.print("   ");
                    }
                }
                this.out.println(s);
            }
            int exCount = (int)this.readU32();
            this.printOffset();
            this.out.println(exCount + " Extras");
            for (int j = 0; j < exCount; ++j) {
                start = this.offset;
                this.printOffset();
                int from = (int)this.readU32();
                int to = (int)this.readU32();
                int target = (int)this.readU32();
                int typeIndex = (int)this.readU32();
                int nameIndex = (int)this.readU32();
                if (this.showByteCode) {
                    for (int x = start; x < this.offset; ++x) {
                        this.out.print(this.hex(this.abc[x]) + " ");
                    }
                }
                this.out.print(this.multiNameConstants[nameIndex] + " ");
                this.out.print("type:" + this.multiNameConstants[typeIndex] + " from:" + from + " ");
                this.out.println("to:" + to + " target:" + target);
            }
            int numTraits = (int)this.readU32();
            this.printOffset();
            this.out.println(numTraits + " Traits Entries");
            for (int j = 0; j < numTraits; ++j) {
                this.printOffset();
                start = this.offset;
                String s = this.multiNameConstants[(int)this.readU32()].toString();
                byte b2 = this.abc[this.offset++];
                int kind = b2 & 0xF;
                switch (kind) {
                    case 0: 
                    case 6: {
                        this.readU32();
                        this.readU32();
                        int index = (int)this.readU32();
                        if (index == 0) break;
                        ++this.offset;
                        break;
                    }
                    case 4: {
                        this.readU32();
                        this.readU32();
                        break;
                    }
                    default: {
                        this.readU32();
                        this.readU32();
                    }
                }
                if ((b2 >> 4 & 4) == 4) {
                    int val = (int)this.readU32();
                    for (int k = 0; k < val; ++k) {
                        this.readU32();
                    }
                }
                if (this.showByteCode) {
                    for (int x = start; x < this.offset; ++x) {
                        this.out.print(this.hex(this.abc[x]) + " ");
                    }
                }
                this.out.println(s);
            }
            this.out.println("");
            ++i;
        }
    }

    class LabelMgr {
        int index = 0;
        HashMap<String, Integer> labels = new HashMap();

        public String getLabelAt(int offset) {
            String key = Integer.toString(offset);
            if (!this.labels.containsKey(key)) {
                this.labels.put(key, new Integer(this.index++));
            }
            return "L" + this.labels.get(key).toString();
        }

        public boolean hasLabelAt(int offset) {
            String key = Integer.toString(offset);
            return this.labels.containsKey(key);
        }
    }

    class MethodInfo {
        int paramCount;
        int returnType;
        int[] params;
        String name;
        int kind;
        int flags;
        int optionCount;
        int[] optionKinds;
        int[] optionIndex;
        int[] paramNames;
        String className;

        MethodInfo() {
        }
    }

    class MultiName {
        public int kind;
        public int long1;
        public int long2;
        public MultiName typeName;
        public MultiName[] types;

        public String toString() {
            String s = "";
            switch (this.kind) {
                case 7: 
                case 13: {
                    s = AbcPrinter.this.namespaceConstants[this.long1] + ":";
                    s = s + AbcPrinter.this.stringConstants[this.long2];
                    break;
                }
                case 15: 
                case 16: {
                    s = AbcPrinter.this.stringConstants[this.long1];
                    break;
                }
                case 17: 
                case 18: {
                    s = "RTQNameL";
                    break;
                }
                case 19: 
                case 20: {
                    s = "NameL";
                    break;
                }
                case 9: 
                case 14: {
                    String[] nsSet = AbcPrinter.this.namespaceSetConstants[this.long2];
                    int len = nsSet.length;
                    for (int j = 0; j < len - 1; ++j) {
                        s = s + nsSet[j] + ",";
                    }
                    if (len > 0) {
                        s = s + nsSet[len - 1] + ":";
                    }
                    s = s + AbcPrinter.this.stringConstants[this.long1];
                    break;
                }
                case 27: 
                case 28: {
                    String[] nsSet = AbcPrinter.this.namespaceSetConstants[this.long1];
                    int len = nsSet.length;
                    for (int j = 0; j < len - 1; ++j) {
                        s = s + nsSet[j] + ",";
                    }
                    if (len > 0) {
                        s = s + nsSet[len - 1] + ":";
                    }
                    s = s + "null";
                    break;
                }
                case 29: {
                    s = s + this.typeName.toString();
                    for (int t = 0; t < this.types.length; ++t) {
                        s = s + this.types[t].toString();
                    }
                    break;
                }
            }
            return s;
        }
    }
}

