/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.builder.types;

import flash.swf.builder.types.Point;
import flash.swf.builder.types.ShapeIterator;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.Shape;
import flash.swf.types.ShapeRecord;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.util.Trace;
import java.util.ArrayList;

public final class ShapeBuilder {
    private boolean convertToTwips = true;
    private Shape shape = new Shape();
    private Point pen;
    private Point lastMoveTo;
    private Point start;
    private int dxSumTwips = 0;
    private int dySumTwips = 0;
    private int lineStyle = -1;
    private int fillStyle0 = -1;
    private int fillStyle1 = -1;
    private boolean useFillStyle1 = true;
    private boolean useFillStyle0 = true;
    private boolean lineStyleHasChanged;
    private boolean fillStyle1HasChanged;
    private boolean fillStyle0HasChanged;
    private boolean closed;

    public ShapeBuilder() {
        this(new Point());
    }

    public ShapeBuilder(boolean useTwips) {
        this();
        this.convertToTwips = useTwips;
    }

    public ShapeBuilder(Point origin) {
        this.shape.shapeRecords = new ArrayList<ShapeRecord>();
        if (origin == null) {
            origin = new Point();
        }
        this.start = new Point(origin.x, origin.y);
        this.lastMoveTo = new Point(origin.x, origin.y);
        this.pen = new Point(this.lastMoveTo.x, this.lastMoveTo.y);
    }

    public Shape build() {
        return this.shape;
    }

    public void processShape(ShapeIterator si) {
        while (!si.isDone()) {
            double[] coords = new double[6];
            short code = si.currentSegment(coords);
            switch (code) {
                case 0: {
                    this.correctRoundingErrors();
                    this.move(coords[0], coords[1]);
                    this.closed = false;
                    break;
                }
                case 1: {
                    this.straight(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.curved(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.approximateCubicBezier(new Point(this.pen.x, this.pen.y), new Point(coords[0], coords[1]), new Point(coords[2], coords[3]), new Point(coords[4], coords[5]));
                    break;
                }
                case 4: {
                    this.closed = true;
                    this.close();
                }
            }
            si.next();
        }
        this.correctRoundingErrors();
    }

    public void correctRoundingErrors() {
        if (!(this.dxSumTwips == 0 && this.dySumTwips == 0 || !this.closed && this.fillStyle0 <= 0 && this.fillStyle1 <= 0)) {
            this.addLineSubdivideAware(-this.dxSumTwips, -this.dySumTwips);
            this.dxSumTwips = 0;
            this.dySumTwips = 0;
        }
    }

    public void move(double x, double y) {
        double dx = x - this.start.x;
        double dy = y - this.start.y;
        if (this.convertToTwips) {
            dx *= 20.0;
            dy *= 20.0;
        }
        StyleChangeRecord scr = new StyleChangeRecord();
        scr.setMove((int)Math.rint(dx), (int)Math.rint(dy));
        this.dxSumTwips = 0;
        this.dySumTwips = 0;
        if (this.lineStyleHasChanged) {
            scr.setLinestyle(this.lineStyle);
            this.lineStyleHasChanged = false;
        }
        if (this.fillStyle0HasChanged && this.useFillStyle0) {
            scr.setFillStyle0(this.fillStyle0);
            this.fillStyle0HasChanged = false;
        }
        if (this.fillStyle1HasChanged && this.useFillStyle1) {
            scr.setFillStyle1(this.fillStyle1);
            this.fillStyle1HasChanged = false;
        }
        this.lastMoveTo.x = x;
        this.lastMoveTo.y = y;
        this.pen.x = x;
        this.pen.y = y;
        this.shape.shapeRecords.add(scr);
    }

    public void straight(double x, double y) {
        double dx = x - this.pen.x;
        double dy = y - this.pen.y;
        if (this.convertToTwips) {
            dx *= 20.0;
            dy *= 20.0;
        }
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        int intdx = (int)Math.rint(dx);
        int intdy = (int)Math.rint(dy);
        this.addLineSubdivideAware(intdx, intdy);
        this.pen.x = x;
        this.pen.y = y;
        this.dxSumTwips += intdx;
        this.dySumTwips += intdy;
    }

    public void curved(double cx, double cy, double ax, double ay) {
        double[] points = new double[]{this.pen.x, this.pen.y, cx, cy, ax, ay};
        int[] deltas = this.addCurveSubdivideAware(points);
        this.pen.x = ax;
        this.pen.y = ay;
        this.dxSumTwips += deltas[2] + deltas[0];
        this.dySumTwips += deltas[3] + deltas[1];
    }

    public void close() {
        double dx = this.lastMoveTo.x - this.pen.x;
        double dy = this.lastMoveTo.y - this.pen.y;
        if (this.convertToTwips) {
            dx *= 20.0;
            dy *= 20.0;
        }
        this.pen.x = this.lastMoveTo.x;
        this.pen.y = this.lastMoveTo.y;
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        int intdx = (int)Math.rint(dx);
        int intdy = (int)Math.rint(dy);
        this.addLineSubdivideAware(intdx, intdy);
        this.dxSumTwips += intdx;
        this.dySumTwips += intdy;
    }

    private void addLineSubdivideAware(int x, int y) {
        int limit = 65535;
        if (Math.abs(x) > limit || Math.abs(y) > limit) {
            int midXLeft = (int)Math.rint(Math.floor((double)x / 2.0));
            int midYLeft = (int)Math.rint(Math.floor((double)y / 2.0));
            int midXRight = (int)Math.rint(Math.ceil((double)x / 2.0));
            int midYRight = (int)Math.rint(Math.ceil((double)y / 2.0));
            if (Math.abs(midXLeft) > limit || Math.abs(midYLeft) > limit) {
                this.addLineSubdivideAware(midXLeft, midYLeft);
            } else {
                this.shape.shapeRecords.add(new StraightEdgeRecord(midXLeft, midYLeft));
            }
            if (Math.abs(midXRight) > limit || Math.abs(midYRight) > limit) {
                this.addLineSubdivideAware(midXRight, midYRight);
            } else {
                this.shape.shapeRecords.add(new StraightEdgeRecord(midXRight, midYRight));
            }
        } else {
            this.shape.shapeRecords.add(new StraightEdgeRecord(x, y));
        }
    }

    private int[] addCurveSubdivideAware(double[] curve) {
        int[] delta = this.curveDeltas(curve);
        if (this.exceedsEdgeRecordLimit(delta)) {
            double[] left = new double[6];
            double[] right = new double[6];
            ShapeBuilder.divideQuad(curve, 0, left, 0, right, 0);
            int[] deltaLeft = this.curveDeltas(left);
            int[] deltaRight = this.curveDeltas(right);
            if (this.exceedsEdgeRecordLimit(deltaLeft)) {
                this.addCurveSubdivideAware(left);
            } else {
                this.curveRecord(deltaLeft);
            }
            if (this.exceedsEdgeRecordLimit(deltaRight)) {
                this.addCurveSubdivideAware(right);
            } else {
                this.curveRecord(deltaRight);
            }
        } else {
            this.curveRecord(delta);
        }
        return delta;
    }

    public static void divideQuad(double[] src, int srcoff, double[] left, int loff, double[] right, int roff) {
        double x1 = src[srcoff + 0];
        double y1 = src[srcoff + 1];
        double ctrlx = src[srcoff + 2];
        double ctrly = src[srcoff + 3];
        double x2 = src[srcoff + 4];
        double y2 = src[srcoff + 5];
        if (left != null) {
            left[loff + 0] = x1;
            left[loff + 1] = y1;
        }
        if (right != null) {
            right[roff + 4] = x2;
            right[roff + 5] = y2;
        }
        x1 = (x1 + ctrlx) / 2.0;
        y1 = (y1 + ctrly) / 2.0;
        x2 = (x2 + ctrlx) / 2.0;
        y2 = (y2 + ctrly) / 2.0;
        ctrlx = (x1 + x2) / 2.0;
        ctrly = (y1 + y2) / 2.0;
        if (left != null) {
            left[loff + 2] = x1;
            left[loff + 3] = y1;
            left[loff + 4] = ctrlx;
            left[loff + 5] = ctrly;
        }
        if (right != null) {
            right[roff + 0] = ctrlx;
            right[roff + 1] = ctrly;
            right[roff + 2] = x2;
            right[roff + 3] = y2;
        }
    }

    private void curveRecord(int[] delta) {
        CurvedEdgeRecord cer = new CurvedEdgeRecord();
        cer.controlDeltaX = delta[0];
        cer.controlDeltaY = delta[1];
        cer.anchorDeltaX = delta[2];
        cer.anchorDeltaY = delta[3];
        this.shape.shapeRecords.add(cer);
    }

    private int[] curveDeltas(double[] curve) {
        int[] deltas = new int[4];
        double dcx = curve[2] - curve[0];
        double dcy = curve[3] - curve[1];
        double dax = curve[4] - curve[2];
        double day = curve[5] - curve[3];
        if (this.convertToTwips) {
            dcx *= 20.0;
            dcy *= 20.0;
            dax *= 20.0;
            day *= 20.0;
        }
        deltas[0] = (int)Math.rint(dcx);
        deltas[1] = (int)Math.rint(dcy);
        deltas[2] = (int)Math.rint(dax);
        deltas[3] = (int)Math.rint(day);
        return deltas;
    }

    private boolean exceedsEdgeRecordLimit(int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (Math.abs(values[i]) <= 65535) continue;
            return true;
        }
        return false;
    }

    public int getCurrentLineStyle() {
        return this.lineStyle;
    }

    public void setCurrentLineStyle(int index) {
        if (index != this.lineStyle) {
            this.lineStyleHasChanged = true;
            this.lineStyle = index;
        }
    }

    public int getCurrentFillStyle0() {
        return this.fillStyle0;
    }

    public void setCurrentFillStyle0(int index) {
        if (index != this.fillStyle0) {
            this.fillStyle0HasChanged = true;
            this.fillStyle0 = index;
        }
    }

    public int getCurrentFillStyle1() {
        return this.fillStyle1;
    }

    public void setCurrentFillStyle1(int index) {
        if (index != this.fillStyle1) {
            this.fillStyle1HasChanged = true;
            this.fillStyle1 = index;
        }
    }

    public boolean getUseFillStyle1() {
        return this.useFillStyle1;
    }

    public void setUseFillStyle1(boolean b2) {
        this.useFillStyle1 = b2;
    }

    public void setUseFillStyle0(boolean b2) {
        this.useFillStyle0 = b2;
    }

    public static Point getPointOnSegment(Point P0, Point P1, double ratio) {
        return new Point(P0.x + (P1.x - P0.x) * ratio, P0.y + (P1.y - P0.y) * ratio);
    }

    private void approximateCubicBezier(Point P0, Point P1, Point P2, Point P3) {
        Point PA = ShapeBuilder.getPointOnSegment(P0, P1, 0.75);
        Point PB = ShapeBuilder.getPointOnSegment(P3, P2, 0.75);
        double dx = (P3.x - P0.x) / 16.0;
        double dy = (P3.y - P0.y) / 16.0;
        Point c1 = ShapeBuilder.getPointOnSegment(P0, P1, 0.375);
        Point c2 = ShapeBuilder.getPointOnSegment(PA, PB, 0.375);
        c2.x -= dx;
        c2.y -= dy;
        Point c3 = ShapeBuilder.getPointOnSegment(PB, PA, 0.375);
        c3.x += dx;
        c3.y += dy;
        Point c4 = ShapeBuilder.getPointOnSegment(P3, P2, 0.375);
        Point a1 = new Point((c1.x + c2.x) / 2.0, (c1.y + c2.y) / 2.0);
        Point a2 = new Point((PA.x + PB.x) / 2.0, (PA.y + PB.y) / 2.0);
        Point a3 = new Point((c3.x + c4.x) / 2.0, (c3.y + c4.y) / 2.0);
        this.curved(c1.x, c1.y, a1.x, a1.y);
        this.curved(c2.x, c2.y, a2.x, a2.y);
        this.curved(c3.x, c3.y, a3.x, a3.y);
        this.curved(c4.x, c4.y, P3.x, P3.y);
        if (Trace.font_cubic) {
            Trace.trace("Cubic Curve\n");
            Trace.trace("P0:\t" + P0.x + "\t" + P0.y);
            Trace.trace("c1:\t" + c1.x + "\t" + c1.y + "\t\tP1:\t" + P1.x + "\t" + P1.y);
            Trace.trace("a1:\t" + a1.x + "\t" + a1.y);
            Trace.trace("c2:\t" + c2.x + "\t" + c2.y);
            Trace.trace("a2:\t" + a2.x + "\t" + a2.y);
            Trace.trace("c3:\t" + c3.x + "\t" + c3.y);
            Trace.trace("a3:\t" + a3.x + "\t" + a3.y);
            Trace.trace("c4:\t" + c4.x + "\t" + c4.y + "\t\tP2:\t" + P2.x + "\t" + P2.y);
            Trace.trace("P3:\t" + P3.x + "\t" + P3.y);
        }
    }
}

