/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.builder.tags;

import flash.swf.SwfUtils;
import flash.swf.builder.tags.FontBuilder;
import flash.swf.builder.tags.TagBuilder;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.swf.types.GlyphEntry;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.TextRecord;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class TextBuilder
implements TagBuilder {
    private DefineText tag;
    private List<FontBuilder> fontBuilders;

    public TextBuilder(int code) {
        this.tag = new DefineText(code);
        this.fontBuilders = new ArrayList<FontBuilder>();
    }

    public DefineTag build() {
        if (this.tag.matrix == null) {
            this.tag.matrix = new Matrix();
        }
        return this.tag;
    }

    public void add(FontBuilder fontBuilder, double height, String text, Color color, int xOffset, int yOffset) throws IOException {
        String line;
        this.fontBuilders.add(fontBuilder);
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int yCount = 0;
        double t_width = 0.0;
        double t_height = 0.0;
        while ((line = reader.readLine()) != null && line.length() != 0) {
            TextRecord tr = this.getStyleRecord(fontBuilder, height, color, xOffset, (int)((double)yOffset + (double)yCount * height * 20.0));
            char[] chars = line.toCharArray();
            tr.entries = new GlyphEntry[chars.length];
            double w = 0.0;
            for (int i = 0; i < chars.length; ++i) {
                char c2 = chars[i];
                GlyphEntry ge = (GlyphEntry)fontBuilder.getGlyph(c2).clone();
                ge.advance = (int)((float)ge.advance / 1024.0f * (float)tr.height);
                tr.entries[i] = ge;
                w += (double)ge.advance;
            }
            if (w > t_width) {
                t_width = w;
            }
            this.tag.records.add(tr);
            ++yCount;
        }
        t_height = (double)yCount * height;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = x1 + t_width;
        double y2 = y1 + t_height;
        x1 *= 20.0;
        x2 *= 20.0;
        y1 *= 20.0;
        y2 *= 20.0;
        if (x1 > 2.147483647E9) {
            x1 = 0.0;
        }
        if (x2 > 2.147483647E9) {
            x2 = 0.0;
        }
        if (y1 > 2.147483647E9) {
            y1 = 0.0;
        }
        if (y2 > 2.147483647E9) {
            y2 = 0.0;
        }
        this.tag.bounds = new Rect((int)x1, (int)x2, (int)y1, (int)y2);
    }

    public void addWithLayout(FontBuilder fontBuilder, double height, String text, Color color, int xOffset, int yOffset, Rectangle2D bounds) throws IOException {
        String line;
        this.fontBuilders.add(fontBuilder);
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int yCount = 0;
        while ((line = reader.readLine()) != null && line.length() != 0) {
            TextRecord tr = this.getStyleRecord(fontBuilder, height, color, xOffset, (int)((double)yOffset + (double)yCount * height * 20.0));
            char[] chars = line.toCharArray();
            tr.entries = new GlyphEntry[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                char c2 = chars[i];
                GlyphEntry ge = (GlyphEntry)fontBuilder.getGlyph(c2).clone();
                ge.advance = (int)((float)ge.advance / 1024.0f * (float)tr.height);
                tr.entries[i] = ge;
            }
            this.tag.records.add(tr);
            ++yCount;
        }
        double x1 = bounds.getX();
        double y1 = bounds.getY();
        double rect_width = bounds.getWidth();
        double rect_height = bounds.getHeight();
        double x2 = x1 + rect_width;
        double y2 = y1 + rect_height;
        x1 *= 20.0;
        x2 *= 20.0;
        y1 *= 20.0;
        y2 *= 20.0;
        if (x1 > 2.147483647E9) {
            x1 = 0.0;
        }
        if (x2 > 2.147483647E9) {
            x2 = 0.0;
        }
        if (y1 > 2.147483647E9) {
            y1 = 0.0;
        }
        if (y2 > 2.147483647E9) {
            y2 = 0.0;
        }
        this.tag.bounds = new Rect((int)x1, (int)x2, (int)y1, (int)y2);
    }

    private TextRecord getStyleRecord(FontBuilder fontBuilder, double height, Color color, int xOffset, int yOffset) {
        TextRecord tr = new TextRecord();
        if (fontBuilder != null) {
            tr.setFont(fontBuilder.tag);
            tr.setHeight(SwfUtils.toTwips(height));
        }
        if (color != null) {
            int c2 = SwfUtils.colorToInt(color);
            tr.setColor(c2);
        }
        if (xOffset > 0) {
            tr.setX(xOffset);
        }
        if (yOffset > 0) {
            tr.setY(yOffset);
        }
        return tr;
    }
}

