/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.builder.tags;

import flash.swf.SwfUtils;
import flash.swf.builder.tags.FontBuilder;
import flash.swf.builder.tags.TagBuilder;
import flash.swf.tags.DefineEditText;
import flash.swf.tags.DefineTag;
import flash.swf.types.Rect;
import java.awt.Color;
import java.io.IOException;

public class EditTextBuilder
implements TagBuilder {
    private DefineEditText tag = new DefineEditText();
    private FontBuilder fontBuilder;

    public EditTextBuilder(FontBuilder builder, float height, boolean useOutlines, boolean readOnly, boolean noSelect) {
        this.tag.height = (int)Math.rint(height * 20.0f);
        if (builder != null) {
            this.fontBuilder = builder;
            this.tag.hasFont = true;
        }
        this.tag.useOutlines = useOutlines;
        this.tag.readOnly = readOnly;
        this.tag.noSelect = noSelect;
    }

    public DefineTag build() {
        this.tag.font = this.fontBuilder.tag;
        if (this.tag.varName == null) {
            this.tag.varName = "";
        }
        if (this.tag.initialText == null) {
            this.tag.initialText = "";
        }
        if (this.tag.bounds == null) {
            this.tag.bounds = new Rect();
        }
        return this.tag;
    }

    public void setAutoSize(boolean b2) {
        this.tag.autoSize = b2;
    }

    public void setBorder(boolean b2) {
        this.tag.border = b2;
    }

    public void setVarName(String var) {
        this.tag.varName = var;
    }

    public void setMaxLength(int max) {
        this.tag.hasMaxLength = true;
        this.tag.maxLength = max;
    }

    public void setHtml(boolean b2) {
        this.tag.html = b2;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.tag.hasTextColor = true;
            this.tag.color = SwfUtils.colorToInt(color);
        }
    }

    public void setLayout(int align, int leftMargin, int rightMargin, int indent, int leading) {
        this.tag.hasLayout = true;
        if (align < 0 || align > 3) {
            throw new RuntimeException("Invalid alignment.");
        }
        this.tag.align = align;
        this.tag.leftMargin = leftMargin;
        this.tag.rightMargin = rightMargin;
        this.tag.ident = indent;
        this.tag.leading = leading;
    }

    public void setBounds(Rect r) {
        this.tag.bounds = r;
    }

    public void setInitialText(String text) throws IOException {
        if (text != null) {
            this.tag.hasText = true;
            this.tag.initialText = text;
            if (this.tag.bounds == null) {
                this.tag.bounds.yMax *= 3;
                this.tag.bounds.xMax *= 2;
            }
        }
    }
}

