/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.DebugDecoder;
import flash.swf.DebugHandler;
import flash.swf.SwfEncoder;
import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.FlashUUID;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DebugEncoder
implements DebugHandler {
    private int version;
    private byte[] debugID;
    private List<DebugScript> debugScripts = new ArrayList<DebugScript>();
    private int bytesWritten = 0;
    private HashMap<String, DebugScript> debugScriptsByName = new HashMap();
    private List<DebugBreakpoint> debugBreakpoints = new ArrayList<DebugBreakpoint>();
    private List<DebugRegisters> debugRegisters = new ArrayList<DebugRegisters>();
    private String mainDebugScriptName;
    public int adjust;

    public void header(int version) {
        this.version = version;
    }

    public void uuid(FlashUUID uuid) {
        this.debugID = uuid.bytes;
    }

    void updateUUID(byte[] uuid) {
        this.debugID = uuid;
    }

    public void offset(int offset, LineRecord lr) {
        if (lr.module.corrupt) {
            return;
        }
        String name = lr.module.name;
        if (!this.debugScriptsByName.containsKey(name)) {
            this.module(lr.module);
        }
        DebugScript script = this.debugScriptsByName.get(name);
        DebugOffset debugOffset = new DebugOffset(lr.lineno, offset + this.adjust);
        script.debugOffsets.add(debugOffset);
    }

    public void module(DebugModule m) {
        if (m.corrupt) {
            return;
        }
        DebugScript script = new DebugScript(m.name, m.text);
        this.debugScripts.add(script);
        this.debugScriptsByName.put(script.name, script);
    }

    public void breakpoint(int offset) {
        this.debugBreakpoints.add(new DebugBreakpoint(offset));
    }

    public void registers(int offset, RegisterRecord r) {
        DebugRegisters debug = new DebugRegisters(offset + this.adjust, r);
        this.debugRegisters.add(debug);
    }

    public void setMainDebugScript(String path) {
        this.mainDebugScriptName = path;
    }

    private static String generateShortName(String name) {
        String s = name;
        int dotAt = name.lastIndexOf(46);
        if (dotAt != -1) {
            int lastSlashAt = name.lastIndexOf(File.separatorChar, dotAt);
            if (lastSlashAt == -1 && File.separatorChar == '\\') {
                lastSlashAt = name.lastIndexOf(47, dotAt);
            }
            s = name.substring(lastSlashAt + 1);
        } else {
            s = name;
        }
        return s.trim();
    }

    private void fixNamesAndBitmaps() {
        String synthetic = "synthetic: ";
        String actions2 = "Actions for ";
        for (DebugScript debugScript : this.debugScripts) {
            if (this.isFrameworkClass(debugScript.name)) {
                debugScript.bitmap = 3;
            } else if (debugScript.name.startsWith(synthetic)) {
                String componentName;
                debugScript.bitmap = 4;
                String lookFor = "synthetic: Object.registerClass() for ";
                if (debugScript.name.startsWith(lookFor)) {
                    componentName = debugScript.name.substring(lookFor.length());
                    debugScript.name = "<" + componentName + ".2>";
                } else {
                    componentName = debugScript.name.substring(synthetic.length());
                    debugScript.name = "<" + componentName + ".1>";
                }
            } else if (debugScript.name.startsWith(actions2)) {
                debugScript.bitmap = 5;
            } else if (debugScript.name.equals(this.mainDebugScriptName)) {
                debugScript.bitmap = 1;
            } else {
                debugScript.name = DebugDecoder.adjustModuleName(debugScript.name);
                debugScript.bitmap = 2;
            }
            debugScript.comparableName = new Integer(debugScript.bitmap).toString() + DebugEncoder.generateShortName(debugScript.name);
        }
    }

    private void encodeSwdData(SwfEncoder buffer) {
        buffer.write32(0x445746 | this.version << 24);
        buffer.write32(3);
        buffer.write(this.debugID);
        Collections.sort(this.debugScripts);
        int id = 0;
        for (DebugScript debugScript : this.debugScripts) {
            buffer.write32(0);
            buffer.write32(++id);
            buffer.write32(debugScript.bitmap);
            buffer.writeString(debugScript.name);
            buffer.writeString(debugScript.text);
            Collections.sort(debugScript.debugOffsets);
            for (DebugOffset debugOffset : debugScript.debugOffsets) {
                buffer.write32(1);
                buffer.write32(id);
                buffer.write32(debugOffset.lineNumber);
                buffer.write32(debugOffset.byteOffset);
            }
        }
        Collections.sort(this.debugRegisters);
        for (DebugRegisters debug : this.debugRegisters) {
            int size = debug.registerNumbers.length;
            buffer.write32(5);
            buffer.write32(debug.offset);
            buffer.writeUI8(size);
            for (int i = 0; i < debug.registerNumbers.length; ++i) {
                buffer.writeUI8(debug.registerNumbers[i]);
                buffer.writeString(debug.variableNames[i]);
            }
        }
        Collections.sort(this.debugBreakpoints);
        for (DebugBreakpoint debugBreakpoint : this.debugBreakpoints) {
            buffer.write32(2);
            buffer.write32(debugBreakpoint.offset);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        SwfEncoder buffer = new SwfEncoder(this.version);
        this.fixNamesAndBitmaps();
        this.encodeSwdData(buffer);
        buffer.writeTo(out);
        this.bytesWritten = buffer.getBytesWritten();
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public void error(String msg) {
    }

    private boolean isFrameworkClass(String name) {
        boolean isIt = name.startsWith("mx.") && name.indexOf(":") != -1 && name.endsWith(".as") || name.indexOf("/mx/") > -1;
        return isIt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DebugRegisters
    implements Comparable<DebugRegisters> {
        int offset;
        int[] registerNumbers;
        String[] variableNames;

        DebugRegisters(int offset, RegisterRecord r) {
            this.offset = offset;
            this.registerNumbers = r.registerNumbers;
            this.variableNames = r.variableNames;
        }

        @Override
        public int compareTo(DebugRegisters other) {
            return new Integer(this.offset).compareTo(other.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DebugBreakpoint
    implements Comparable<DebugBreakpoint> {
        int offset;

        DebugBreakpoint(int offset) {
            this.offset = offset;
        }

        @Override
        public int compareTo(DebugBreakpoint other) {
            return new Integer(this.offset).compareTo(other.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DebugOffset
    implements Comparable<DebugOffset> {
        int lineNumber;
        int byteOffset;

        DebugOffset(int lineNumber, int byteOffset) {
            this.lineNumber = lineNumber;
            this.byteOffset = byteOffset;
        }

        @Override
        public int compareTo(DebugOffset other) {
            long a2 = (long)this.lineNumber << 32 | (long)this.byteOffset;
            long b2 = (long)other.lineNumber << 32 | (long)other.byteOffset;
            if (a2 < b2) {
                return -1;
            }
            if (a2 > b2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DebugScript
    implements Comparable<DebugScript> {
        int bitmap = 0;
        String name;
        String text;
        List<DebugOffset> debugOffsets;
        String comparableName;

        DebugScript(String name, String text) {
            this.name = name;
            this.text = text;
            this.debugOffsets = new ArrayList<DebugOffset>();
        }

        @Override
        public int compareTo(DebugScript other) {
            return this.comparableName.compareTo(other.comparableName);
        }
    }
}

