/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.DebugHandler;
import flash.swf.SwfDecoder;
import flash.swf.SwfFormatException;
import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.FlashUUID;
import flash.util.FileUtils;
import flash.util.IntMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugDecoder {
    public static final int kDebugScript = 0;
    public static final int kDebugOffset = 1;
    public static final int kDebugBreakpoint = 2;
    public static final int kDebugID = 3;
    public static final int kDebugRegisters = 5;
    private SwfDecoder in;
    private IntMap modules = new IntMap();

    public DebugDecoder(byte[] b2) {
        this(new ByteArrayInputStream(b2));
    }

    public DebugDecoder(InputStream in) {
        this.in = new SwfDecoder(in, 0);
    }

    public void readSwd(DebugHandler h2) throws IOException {
        this.readHeader(h2);
        this.readTags(h2);
    }

    void readHeader(DebugHandler handler) throws IOException {
        byte[] sig = new byte[4];
        this.in.readFully(sig);
        if (sig[0] != 70 || sig[1] != 87 || sig[2] != 68 || sig[3] < 6) {
            throw new SwfFormatException("not a Flash 6 or later SWD file");
        }
        this.in.swfVersion = sig[3];
        handler.header(this.in.swfVersion);
    }

    public void setTagData(byte[] b2) throws IOException {
        this.in = new SwfDecoder(b2, 0);
    }

    public void readTags(DebugHandler handler) throws IOException {
        int id;
        int tag;
        ArrayList<Object> lineRecords = new ArrayList<Object>();
        do {
            tag = (int)this.in.readUI32();
            switch (tag) {
                case 0: {
                    DebugModule m2;
                    DebugModule m = new DebugModule();
                    id = (int)this.in.readUI32();
                    m.id = id;
                    m.bitmap = (int)this.in.readUI32();
                    m.name = this.in.readString();
                    m.setText(this.in.readString());
                    DebugDecoder.adjustModuleName(m);
                    if (this.modules.contains(id) && !m.equals(m2 = (DebugModule)this.modules.get(id))) {
                        handler.error("Module '" + m2.name + "' has the same ID as Module '" + m.name + "'");
                        handler.error("Let's check for kDebugOffset that came before Module '" + m2.name + "'");
                        handler.error("Before: Number of accumulated line records: " + lineRecords.size());
                        lineRecords = this.purgeLineRecords(lineRecords, id, handler);
                        handler.error("After: Number of accumulated line records: " + lineRecords.size());
                    }
                    this.modules.put(id, m);
                    handler.module(m);
                    break;
                }
                case 1: {
                    id = (int)this.in.readUI32();
                    int lineno = (int)this.in.readUI32();
                    DebugModule module = (DebugModule)this.modules.get(id);
                    LineRecord lr = new LineRecord(lineno, module);
                    int offset = (int)this.in.readUI32();
                    if (module != null) {
                        boolean wasCorrupt = module.corrupt;
                        if (!module.addOffset(lr, offset) && !wasCorrupt) {
                            handler.error(module.name + ":" + lineno + " does not exist for offset " + offset + ", module marked for exclusion from debugging");
                        }
                        handler.offset(offset, lr);
                        break;
                    }
                    lineRecords.add(new Integer(id));
                    lineRecords.add(lr);
                    lineRecords.add(new Integer(offset));
                    break;
                }
                case 2: {
                    handler.breakpoint((int)this.in.readUI32());
                    break;
                }
                case 5: {
                    int offset = (int)this.in.readUI32();
                    int size = this.in.readUI8();
                    RegisterRecord r = new RegisterRecord(offset, size);
                    for (int i = 0; i < size; ++i) {
                        int nbr = this.in.readUI8();
                        String name = this.in.readString();
                        r.addRegister(nbr, name);
                    }
                    handler.registers(offset, r);
                    break;
                }
                case 3: {
                    FlashUUID uuid = new FlashUUID();
                    this.in.readFully(uuid.bytes);
                    handler.uuid(uuid);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new SwfFormatException("Unexpected tag id " + tag);
                }
            }
        } while (tag != -1);
        int size = lineRecords.size();
        for (int i = 0; i < size; i += 3) {
            id = (Integer)lineRecords.get(i);
            LineRecord lr = (LineRecord)lineRecords.get(i + 1);
            int offset = (Integer)lineRecords.get(i + 2);
            lr.module = (DebugModule)this.modules.get(id);
            if (lr.module != null) {
                boolean wasCorrupt = lr.module.corrupt;
                if (!lr.module.addOffset(lr, offset) && !wasCorrupt) {
                    handler.error(lr.module.name + ":" + lr.lineno + " does not exist for offset " + offset + ", module marked for exclusion from debugging");
                }
                handler.offset(offset, lr);
                continue;
            }
            handler.error("Could not find debug module (id = " + id + ") for offset = " + offset);
        }
    }

    private ArrayList<Object> purgeLineRecords(ArrayList<Object> lineRecords, int moduleId, DebugHandler handler) {
        ArrayList<Object> newLineRecords = new ArrayList<Object>();
        DebugModule module = (DebugModule)this.modules.get(moduleId);
        int size = lineRecords.size();
        for (int i = 0; i < size; i += 3) {
            Integer id = (Integer)lineRecords.get(i);
            LineRecord lr = (LineRecord)lineRecords.get(i + 1);
            Integer offset = (Integer)lineRecords.get(i + 2);
            if (id == moduleId) {
                lr.module = module;
                if (lr.module != null) {
                    lr.module.addOffset(lr, offset);
                    handler.offset(offset, lr);
                    continue;
                }
                handler.error("Could not find kDebugScript with module ID = " + id);
                continue;
            }
            newLineRecords.add(id);
            newLineRecords.add(lr);
            newLineRecords.add(offset);
        }
        return newLineRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            FileInputStream in = new FileInputStream(args[i]);
            try {
                new DebugDecoder(in).readSwd(new DebugHandler(){

                    public void header(int version) {
                        System.out.println("FWD" + version);
                    }

                    public void uuid(FlashUUID id) {
                        System.out.println("DebugID " + id);
                    }

                    public void module(DebugModule dm) {
                        System.out.println("DebugScript #" + dm.id + " " + dm.bitmap + " " + dm.name + " (nlines = " + (dm.offsets.length - 1) + ")");
                    }

                    public void offset(int offset, LineRecord lr) {
                        System.out.println("DebugOffset #" + lr.module.id + ":" + lr.lineno + " " + offset);
                    }

                    public void breakpoint(int offset) {
                        System.out.println("DebugBreakpoint " + offset);
                    }

                    public void registers(int offset, RegisterRecord r) {
                        System.out.println("DebugRegisters " + r.toString());
                    }

                    public void error(String msg) {
                        System.err.println("***ERROR: " + msg);
                    }
                });
                System.out.println();
                continue;
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    protected static final void adjustModuleName(DebugModule d2) {
        d2.name = DebugDecoder.adjustModuleName(d2.name);
    }

    public static final String adjustModuleName(String name) {
        if (name.startsWith("<") && name.endsWith(">")) {
            return name;
        }
        try {
            URL u = new URL(name);
            return name;
        }
        catch (MalformedURLException ex) {
            String token2;
            String token1;
            File f2;
            try {
                f2 = new File(name);
            }
            catch (Error nf) {
                f2 = null;
            }
            if (f2 == null || !f2.isFile()) {
                int colon = name.indexOf(58);
                if (colon != -1) {
                    token1 = name.substring(0, colon).trim();
                    token2 = name.substring(colon + 1).trim();
                } else {
                    token1 = "";
                    token2 = name;
                }
            } else {
                token1 = "";
                token2 = name;
            }
            try {
                f2 = new File(token2);
            }
            catch (Error nf) {
                f2 = null;
            }
            if (f2 != null && f2.isFile()) {
                try {
                    if (token2.indexOf("..") != -1 || token2.indexOf(".") != -1) {
                        f2 = FileUtils.getCanonicalFile(f2);
                    }
                    token2 = FileUtils.toURL(f2).toString();
                }
                catch (IOException ex2) {
                    // empty catch block
                }
            }
            name = token1.length() == 0 ? token2 : token1.trim() + ": " + token2.trim();
            return name;
        }
    }
}

