/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Action;
import flash.swf.ActionConstants;
import flash.swf.ActionFactory;
import flash.swf.SwfDecoder;
import flash.swf.SwfFormatException;
import flash.swf.actions.Branch;
import flash.swf.actions.ConstantPool;
import flash.swf.actions.DefineFunction;
import flash.swf.actions.GetURL;
import flash.swf.actions.GetURL2;
import flash.swf.actions.GotoFrame;
import flash.swf.actions.GotoFrame2;
import flash.swf.actions.GotoLabel;
import flash.swf.actions.Push;
import flash.swf.actions.SetTarget;
import flash.swf.actions.StoreRegister;
import flash.swf.actions.StrictMode;
import flash.swf.actions.Try;
import flash.swf.actions.Unknown;
import flash.swf.actions.WaitForFrame;
import flash.swf.actions.With;
import flash.swf.debug.DebugTable;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.ActionList;
import flash.swf.types.ClipActionRecord;
import flash.swf.types.ClipActions;
import java.io.IOException;
import java.util.ArrayList;

public class ActionDecoder
implements ActionConstants {
    private SwfDecoder reader;
    private DebugTable debug;
    private boolean keepOffsets;
    private int actionCount;

    public ActionDecoder(SwfDecoder reader) {
        this(reader, null);
    }

    public ActionDecoder(SwfDecoder reader, DebugTable debug) {
        this.reader = reader;
        this.debug = debug;
    }

    public void setKeepOffsets(boolean b2) {
        this.keepOffsets = b2;
    }

    public ActionList decode(int length) throws IOException {
        return this.decode(length, true);
    }

    public ActionList decode(int length, boolean throwExceptions) throws IOException {
        ActionFactory factory;
        block8: {
            int startOffset = this.reader.getOffset();
            int end = startOffset + length;
            boolean ending = false;
            factory = new ActionFactory(length, startOffset, this.actionCount);
            try {
                int offset = startOffset;
                while (offset < end) {
                    int opcode = this.reader.readUI8();
                    if (opcode > 0) {
                        if (ending) {
                            throw new SwfFormatException("unexpected bytes after sactionEnd: " + opcode);
                        }
                        factory.setActionOffset(this.actionCount, offset);
                        this.decodeAction(opcode, offset, factory);
                        ++this.actionCount;
                    } else {
                        if (opcode != 0) break;
                        ending = true;
                    }
                    offset = this.reader.getOffset();
                }
                factory.setActionOffset(this.actionCount, this.reader.getOffset());
            }
            catch (ArrayIndexOutOfBoundsException aio) {
                if (throwExceptions) {
                    throw aio;
                }
            }
            catch (SwfFormatException swf) {
                if (!throwExceptions) break block8;
                throw swf;
            }
        }
        return factory.createActionList(this.keepOffsets);
    }

    public ClipActions decodeClipActions(int length) throws IOException {
        ClipActions a2 = new ClipActions();
        this.reader.readUI16();
        a2.allEventFlags = this.decodeClipEventFlags(this.reader);
        ArrayList<ClipActionRecord> list = new ArrayList<ClipActionRecord>();
        ClipActionRecord record = this.decodeClipActionRecord();
        while (record != null) {
            list.add(record);
            record = this.decodeClipActionRecord();
        }
        a2.clipActionRecords = list;
        return a2;
    }

    private ClipActionRecord decodeClipActionRecord() throws IOException {
        int flags = this.decodeClipEventFlags(this.reader);
        if (flags != 0) {
            ClipActionRecord c2 = new ClipActionRecord();
            c2.eventFlags = flags;
            int size = (int)this.reader.readUI32();
            if ((flags & 0x20000) != 0) {
                --size;
                c2.keyCode = this.reader.readUI8();
            }
            c2.actionList = this.decode(size);
            return c2;
        }
        return null;
    }

    private int decodeClipEventFlags(SwfDecoder r) throws IOException {
        int flags = r.swfVersion >= 6 ? (int)r.readUI32() : r.readUI16();
        return flags;
    }

    private void decodeAction(int opcode, int offset, ActionFactory factory) throws IOException {
        Action a22;
        RegisterRecord record;
        LineRecord line;
        LineRecord lineRecord = line = this.debug != null ? this.debug.getLine(offset) : null;
        if (line != null) {
            factory.setLine(offset, line);
        }
        RegisterRecord registerRecord = record = this.debug != null ? this.debug.getRegisters(offset) : null;
        if (record != null) {
            factory.setRegister(offset, record);
        }
        if (opcode < 128) {
            Action a3 = ActionFactory.createAction(opcode);
            factory.setAction(offset, a3);
            return;
        }
        int len = this.reader.readUI16();
        int pos = offset + 3;
        switch (opcode) {
            case 155: {
                DefineFunction a22 = this.decodeDefineFunction(pos, len);
                factory.setAction(offset, a22);
                return;
            }
            case 142: {
                DefineFunction a22 = this.decodeDefineFunction2(pos, len);
                factory.setAction(offset, a22);
                return;
            }
            case 148: {
                a22 = this.decodeWith(factory);
                break;
            }
            case 143: {
                a22 = this.decodeTry(factory);
                break;
            }
            case 150: {
                Push p = this.decodePush(offset, pos + len, factory);
                this.checkConsumed(pos, len, p);
                return;
            }
            case 137: {
                a22 = this.decodeStrictMode();
                break;
            }
            case 158: {
                a22 = ActionFactory.createCall();
                break;
            }
            case 129: {
                a22 = this.decodeGotoFrame();
                break;
            }
            case 131: {
                a22 = this.decodeGetURL();
                break;
            }
            case 135: {
                a22 = this.decodeStoreRegister();
                break;
            }
            case 136: {
                a22 = this.decodeConstantPool();
                break;
            }
            case 138: {
                a22 = this.decodeWaitForFrame(opcode, factory);
                break;
            }
            case 139: {
                a22 = this.decodeSetTarget();
                break;
            }
            case 140: {
                a22 = this.decodeGotoLabel();
                break;
            }
            case 141: {
                a22 = this.decodeWaitForFrame(opcode, factory);
                break;
            }
            case 154: {
                a22 = this.decodeGetURL2();
                break;
            }
            case 153: 
            case 157: {
                a22 = this.decodeBranch(opcode, factory);
                break;
            }
            case 159: {
                a22 = this.decodeGotoFrame2();
                break;
            }
            default: {
                a22 = this.decodeUnknown(opcode, len);
            }
        }
        this.checkConsumed(pos, len, a22);
        factory.setAction(offset, a22);
    }

    private Try decodeTry(ActionFactory factory) throws IOException {
        Try a2 = new Try();
        a2.flags = this.reader.readUI8();
        int trySize = this.reader.readUI16();
        int catchSize = this.reader.readUI16();
        int finallySize = this.reader.readUI16();
        if (a2.hasRegister()) {
            a2.catchReg = this.reader.readUI8();
        } else {
            a2.catchName = this.reader.readString();
        }
        int tryEnd = this.reader.getOffset() + trySize;
        a2.endTry = factory.getLabel(tryEnd);
        if (a2.hasCatch()) {
            a2.endCatch = factory.getLabel(tryEnd + catchSize);
        }
        if (a2.hasFinally()) {
            a2.endFinally = factory.getLabel(tryEnd + finallySize + (a2.hasCatch() ? catchSize : 0));
        }
        return a2;
    }

    private GotoFrame2 decodeGotoFrame2() throws IOException {
        GotoFrame2 a2 = new GotoFrame2();
        a2.playFlag = this.reader.readUI8();
        return a2;
    }

    private Branch decodeBranch(int code, ActionFactory factory) throws IOException {
        Branch a2 = new Branch(code);
        int offset = this.reader.readSI16();
        int target = offset + this.reader.getOffset();
        a2.target = factory.getLabel(target);
        return a2;
    }

    private WaitForFrame decodeWaitForFrame(int opcode, ActionFactory factory) throws IOException {
        WaitForFrame a2 = new WaitForFrame(opcode);
        if (opcode == 138) {
            a2.frame = this.reader.readUI16();
        }
        int skipCount = this.reader.readUI8();
        int skipTarget = this.actionCount + 1 + skipCount;
        factory.addSkipEntry(a2, skipTarget);
        return a2;
    }

    private GetURL2 decodeGetURL2() throws IOException {
        GetURL2 a2 = new GetURL2();
        a2.method = this.reader.readUI8();
        return a2;
    }

    private GotoLabel decodeGotoLabel() throws IOException {
        GotoLabel a2 = new GotoLabel();
        a2.label = this.reader.readString();
        return a2;
    }

    private SetTarget decodeSetTarget() throws IOException {
        SetTarget a2 = new SetTarget();
        a2.targetName = this.reader.readString();
        return a2;
    }

    private ConstantPool decodeConstantPool() throws IOException {
        ConstantPool cpool = new ConstantPool();
        int count = this.reader.readUI16();
        cpool.pool = new String[count];
        for (int i = 0; i < count; ++i) {
            cpool.pool[i] = this.reader.readString();
        }
        return cpool;
    }

    private StoreRegister decodeStoreRegister() throws IOException {
        int register = this.reader.readUI8();
        return ActionFactory.createStoreRegister(register);
    }

    private GetURL decodeGetURL() throws IOException {
        GetURL a2 = new GetURL();
        a2.url = this.reader.readString();
        a2.target = this.reader.readString();
        return a2;
    }

    private GotoFrame decodeGotoFrame() throws IOException {
        GotoFrame a2 = new GotoFrame();
        a2.frame = this.reader.readUI16();
        return a2;
    }

    private Unknown decodeUnknown(int opcode, int length) throws IOException {
        Unknown a2 = new Unknown(opcode);
        a2.data = new byte[length];
        this.reader.readFully(a2.data);
        return a2;
    }

    private StrictMode decodeStrictMode() throws IOException {
        boolean mode = this.reader.readUI8() != 0;
        return ActionFactory.createStrictMode(mode);
    }

    private Push decodePush(int offset, int end, ActionFactory factory) throws IOException {
        Push p;
        do {
            int pushType = this.reader.readUI8();
            switch (pushType) {
                case 0: {
                    p = ActionFactory.createPush(this.reader.readString());
                    break;
                }
                case 1: {
                    float fvalue = Float.intBitsToFloat((int)this.reader.readUI32());
                    p = ActionFactory.createPush(fvalue);
                    break;
                }
                case 2: {
                    p = ActionFactory.createPushNull();
                    break;
                }
                case 3: {
                    p = ActionFactory.createPushUndefined();
                    break;
                }
                case 4: {
                    p = ActionFactory.createPushRegister(this.reader.readUI8());
                    break;
                }
                case 5: {
                    p = ActionFactory.createPush(this.reader.readUI8() != 0);
                    break;
                }
                case 6: {
                    long hx = this.reader.readUI32();
                    long lx = this.reader.readUI32();
                    p = ActionFactory.createPush(Double.longBitsToDouble(hx << 32 | lx & 0xFFFFFFFFL));
                    break;
                }
                case 7: {
                    p = ActionFactory.createPush((int)this.reader.readUI32());
                    break;
                }
                case 8: {
                    p = ActionFactory.createPushCpool(this.reader.readUI8());
                    break;
                }
                case 9: {
                    p = ActionFactory.createPushCpool(this.reader.readUI16());
                    break;
                }
                default: {
                    throw new SwfFormatException("Unknown push data type " + pushType);
                }
            }
            factory.setAction(offset, p);
        } while ((offset = this.reader.getOffset()) < end);
        return p;
    }

    private DefineFunction decodeDefineFunction(int pos, int len) throws IOException {
        DefineFunction a2 = new DefineFunction(155);
        a2.name = this.reader.readString();
        int number = this.reader.readUI16();
        a2.params = new String[number];
        for (int i = 0; i < number; ++i) {
            a2.params[i] = this.reader.readString();
        }
        a2.codeSize = this.reader.readUI16();
        this.checkConsumed(pos, len, a2);
        a2.actionList = this.decode(a2.codeSize);
        return a2;
    }

    private DefineFunction decodeDefineFunction2(int pos, int len) throws IOException {
        DefineFunction a2 = new DefineFunction(142);
        a2.name = this.reader.readString();
        int number = this.reader.readUI16();
        a2.params = new String[number];
        a2.paramReg = new int[number];
        a2.regCount = this.reader.readUI8();
        a2.flags = this.reader.readUI16();
        for (int i = 0; i < number; ++i) {
            a2.paramReg[i] = this.reader.readUI8();
            a2.params[i] = this.reader.readString();
        }
        a2.codeSize = this.reader.readUI16();
        this.checkConsumed(pos, len, a2);
        a2.actionList = this.decode(a2.codeSize);
        return a2;
    }

    private void checkConsumed(int pos, int len, Action a2) throws IOException {
        int consumed = this.reader.getOffset() - pos;
        if (consumed != len) {
            throw new SwfFormatException(a2.getClass().getName() + ": " + consumed + " was read. " + len + " was required.");
        }
    }

    private With decodeWith(ActionFactory factory) throws IOException {
        With a2 = new With();
        int size = this.reader.readUI16();
        int target = size + this.reader.getOffset();
        a2.endWith = factory.getLabel(target);
        return a2;
    }
}

